"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const predefined_permissions_1 = require("../../predefined/predefined.permissions");
const predefined_roles_1 = require("../../predefined/predefined.roles");
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const readSelfReportPremission = '"' + predefined_permissions_1.Permissions.identity.getIdentityReportRead() + '"';
    for (const organization of organizationList.rows) {
        const existingRoles = await client.query(`
        	SELECT id, permissions, "isOrganizationWide", "typeId" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" WHERE "deletedAt" IS NULL
        `);
        for (const role of existingRoles.rows) {
            if (role.isOrganizationWide === false) {
                continue;
            }
            let permissionsArray = role.permissions.replace(new RegExp("[\\[\\]]", "g"), "").split(",");
            if (permissionsArray.length === 1 && permissionsArray[0] === "") {
                permissionsArray = [];
            }
            let updateNeeded = false;
            if (!permissionsArray.includes(readSelfReportPremission)) {
                updateNeeded = true;
                permissionsArray.push(readSelfReportPremission);
            }
            if (updateNeeded) {
                const newPermissions = "[" + permissionsArray.join(",") + "]";
                await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
                SET permissions = $1
                WHERE id = $2
                `, [newPermissions, role.id]);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const unknownUserAccessPermissionRegex = '(("' + predefined_permissions_1.Permissions.identity.getIdentityReportRead() + '"),?)|(,?("' + predefined_permissions_1.Permissions.identity.getIdentityReportRead() + '"))';
    for (const organization of organizationList.rows) {
        await client.query(`
			UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
			SET permissions = regexp_replace(permissions, $1::text, '', 'g')
			WHERE "typeId" = ANY($2)
			`, [
            unknownUserAccessPermissionRegex,
            [predefined_roles_1.PredefinedRoles.SystemAdministrator.id, predefined_roles_1.PredefinedRoles.StandartUserOrganization.id, predefined_roles_1.PredefinedRoles.OrganizationWideHumanResourcesManager.id],
        ]);
    }
}
exports.down = down;
