"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const SMSBalanceNotification = 50;
async function up(client, dbuser, dbsuperuser) {
    const query = `
        CREATE OR REPLACE FUNCTION notify_sms_balance() 
        RETURNS TRIGGER AS $$
        BEGIN
            IF NEW."smsBalance" < 100 AND OLD."smsBalance" >= 100 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 100)::text);
            ELSIF NEW."smsBalance" < 50 AND OLD."smsBalance" >= 50 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 50)::text);
            END IF;
            
            RETURN NEW;
        END;
        $$ LANGUAGE plpgsql;

        CREATE TRIGGER sms_balance_trigger
        BEFORE UPDATE OF "smsBalance" ON "___ORGANIZATION_ID___".organizations
        FOR EACH ROW
        WHEN (OLD."smsBalance" IS DISTINCT FROM NEW."smsBalance")
        EXECUTE FUNCTION notify_sms_balance();

        UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = jsonb_insert(settings, '{notification, enabledTypes, -1}', '${SMSBalanceNotification}')
        WHERE jsonb_path_exists(
            settings,
            '$.notification.availableMediums.sms ? (@ == true)'
        );

        INSERT INTO "___ORGANIZATION_ID___".notification
        (id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification") 
        VALUES (uuid_generate_v4(), now(), NULL, ${SMSBalanceNotification}, NULL, NULL, TRUE, FALSE, TRUE, TRUE); 
    
        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;

        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
        ADD CONSTRAINT notification_unsubscribe_type_check 
        CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,999}'::smallint[]));      
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        DROP TRIGGER sms_balance_trigger ON "___ORGANIZATION_ID___".organizations;
        
        DROP FUNCTION IF EXISTS notify_sms_balance();
        
        UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = jsonb_set(settings, '{notification, enabledTypes}',(
            SELECT
                array_to_json(array_agg("enabledTypes")::int[])::jsonb
            FROM 
            (
                SELECT
                jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                FROM "___ORGANIZATION_ID___".organizations 
                ORDER BY jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
            ) as T 
            WHERE ("enabledTypes" != '${SMSBalanceNotification}'))
        );

        DELETE FROM "___AUTHORITY_ID___".notification
        WHERE type = ${SMSBalanceNotification};  

        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;

        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
        ADD CONSTRAINT notification_unsubscribe_type_check 
        CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,999}'::smallint[]));
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
