"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const publicQuery = `
		CREATE TABLE "___ORGANIZATION_ID___"."shift_templates" (
			"id" uuid NOT NULL,
			"name" varchar(255) NOT NULL,
			"defaultWorkplanId" uuid,
			"createdAt" timestamp with time zone NOT NULL,
			CONSTRAINT "shift_templates_pkey" PRIMARY KEY (id),
			CONSTRAINT "workplans_defaultWorkplanId_fkey" FOREIGN KEY ("defaultWorkplanId")
			REFERENCES "___ORGANIZATION_ID___"."workPlans" (id)
			ON DELETE CASCADE
		);

		CREATE TABLE "___ORGANIZATION_ID___"."workplan_import_rules" (
			"id" uuid NOT NULL,
			"workplanId" uuid NOT NULL,
			"shiftTemplateId" uuid NOT NULL,
			keyword varchar(255),
			"createdAt" timestamp with time zone NOT NULL,
			"membershipRange" jsonb,
			CONSTRAINT "workPlans_workplanId_fkey" FOREIGN KEY ("workplanId")
			REFERENCES "___ORGANIZATION_ID___"."workPlans" (id)
			ON DELETE CASCADE,
			CONSTRAINT "shift_templates_shiftTemplateId_fkey" FOREIGN KEY ("shiftTemplateId")
			REFERENCES "___ORGANIZATION_ID___"."shift_templates" (id)
			ON DELETE CASCADE
		);
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, publicQuery, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const publicQuery = `
		DROP TABLE "___ORGANIZATION_ID___"."shift_templates";

		DROP TABLE "___ORGANIZATION_ID___"."workplan_import_rules";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, publicQuery, "___ORGANIZATION_ID___");
}
exports.down = down;
