"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
        DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".fauthorizeuserfor(uuid, uuid, uuid[], uuid[], uuid[], uuid[]);
        
        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[], region_ids uuid[])
        RETURNS json
        LANGUAGE plpgsql
        AS $function$
        DECLARE 
            authorized_organization_unit_ids uuid[];
            authorized_access_control_point_ids uuid[];
            authorized_user_ids uuid[];
            authorized_user_group_ids uuid[];
            authorized_region_ids uuid[];
            tmp_uuid uuid;
            is_admin bool;
            user_organization_id uuid;
        BEGIN

        SELECT "id" into user_organization_id FROM "___ORGANIZATION_ID___"."userOrganizations" 
            WHERE "organizationId" = organization_id AND "userId" = user_id AND "deletedAt" IS NULL AND "isDisabled" = false;
            
        SELECT CASE WHEN count(*) > 0 THEN true ELSE false END into is_admin 
        FROM "___ORGANIZATION_ID___"."userOrganizations"  as uo
        INNER JOIN "___ORGANIZATION_ID___"."roles" as r
        ON r.id = uo."roleId"
        WHERE uo."organizationId" = organization_id AND uo."userId" = user_id AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
        and r."typeId" = '52a088f3-4b54-4c60-b204-b8ec3dfe794a';

        IF array_length(region_ids, 1) > 0 THEN
            SELECT array_agg(r.id) INTO authorized_region_ids FROM "___ORGANIZATION_ID___".regions r
            LEFT JOIN "___ORGANIZATION_ID___".region_administrators ra 
                ON ra."regionId" = r.id 
            WHERE ra."userId" = user_id OR ra."userId" IS NULL;

            IF authorized_region_ids IS NULL OR arraycontained(region_ids, authorized_region_ids) = FALSE THEN    	    
                RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'region_ids');                	            
            END IF;
        END IF;
            
        IF is_admin THEN
            RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
        END IF;

        IF array_length(organization_unit_ids, 1) > 0 OR array_length(user_ids, 1) > 0 OR array_length(user_group_ids, 1) > 0 THEN
            SELECT array_agg(uoou."organizationUnitId") INTO authorized_organization_unit_ids 
            FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" AS uoou    
            WHERE uoou."userOrganizationId" = user_organization_id AND uoou."deletedAt" IS NULL;

            SELECT array_agg(ou.id) INTO authorized_organization_unit_ids FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou WHERE 
            ou."deletedAt" IS NULL AND
            (ou.id = ANY(authorized_organization_unit_ids) OR
            ou."ancestorIds" ~ ANY(authorized_organization_unit_ids::text[]));

            RAISE NOTICE 'Authorized unit_ids: %', authorized_organization_unit_ids;
            IF array_length(organization_unit_ids, 1) > 0 AND (authorized_organization_unit_ids IS NULL OR arraycontained(organization_unit_ids, authorized_organization_unit_ids) = FALSE) THEN    	
                RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'organization_unit_ids');        
            END IF;    
            
            IF array_length(user_ids, 1) > 0 THEN
                SELECT array_agg(uo."userId") INTO authorized_user_ids FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" AS uoou
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."id" = uoou."userOrganizationId" AND uo."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
                WHERE uoou."organizationUnitId" = ANY(authorized_organization_unit_ids) AND uo."userId" = ANY(user_ids);
                RAISE NOTICE 'Authorized user_ids: %', authorized_user_ids;
                IF authorized_user_ids IS NULL OR arraycontained(user_ids, authorized_user_ids) = FALSE THEN
                    RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_ids');                	
                END IF;
            END IF;

            IF array_length(user_group_ids, 1) > 0 THEN	
                SELECT array_agg(ug.id) INTO authorized_user_group_ids FROM "___ORGANIZATION_ID___"."userGroups" AS ug
                WHERE ug."organizationId" = organization_id AND ug."deletedAt" IS NULL AND (ug."organizationUnitId" IS NULL OR ug."organizationUnitId" = ANY(authorized_organization_unit_ids));
                IF authorized_user_group_ids IS NULL OR arraycontained(user_group_ids, authorized_user_group_ids) = FALSE THEN    	    
                    RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_group_ids');                	            
                END IF;
            END IF;
        END IF;

        IF array_length(access_control_point_ids, 1) > 0 THEN
            SELECT array_agg(uar."accessControlPointId") INTO authorized_access_control_point_ids FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar WHERE uar."userId" = user_id;
            IF authorized_access_control_point_ids IS NULL OR arraycontained(access_control_point_ids, authorized_access_control_point_ids) = FALSE THEN
                RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'access_control_point_ids');                	                    
            END IF;   
        END IF;

        RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
        END;

        $function$
        ;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".fauthorizeuserfor(uuid, uuid, uuid[], uuid[], uuid[], uuid[], uuid[]);

        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[])
        RETURNS json
        LANGUAGE plpgsql
        AS $function$
        DECLARE 
            authorized_organization_unit_ids uuid[];
            authorized_access_control_point_ids uuid[];
            authorized_user_ids uuid[];
            authorized_user_group_ids uuid[];
            tmp_uuid uuid;
            is_admin bool;
            user_organization_id uuid;
        BEGIN

        SELECT "id" into user_organization_id FROM "___ORGANIZATION_ID___"."userOrganizations" 
            WHERE "organizationId" = organization_id AND "userId" = user_id AND "deletedAt" IS NULL AND "isDisabled" = false;
            
        SELECT CASE WHEN count(*) > 0 THEN true ELSE false END into is_admin 
        FROM "___ORGANIZATION_ID___"."userOrganizations"  as uo
        INNER JOIN "___ORGANIZATION_ID___"."roles" as r
        ON r.id = uo."roleId"
        WHERE uo."organizationId" = organization_id AND uo."userId" = user_id AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
        and r."typeId" = '52a088f3-4b54-4c60-b204-b8ec3dfe794a';
            
        IF is_admin THEN
            RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
        END IF;

        IF array_length(organization_unit_ids, 1) > 0 OR array_length(user_ids, 1) > 0 OR array_length(user_group_ids, 1) > 0 THEN
            SELECT array_agg(uoou."organizationUnitId") INTO authorized_organization_unit_ids 
            FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" AS uoou    
            WHERE uoou."userOrganizationId" = user_organization_id AND uoou."deletedAt" IS NULL;

            SELECT array_agg(ou.id) INTO authorized_organization_unit_ids FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou WHERE 
            ou."deletedAt" IS NULL AND
            (ou.id = ANY(authorized_organization_unit_ids) OR
            ou."ancestorIds" ~ ANY(authorized_organization_unit_ids::text[]));

            RAISE NOTICE 'Authorized unit_ids: %', authorized_organization_unit_ids;
            IF array_length(organization_unit_ids, 1) > 0 AND (authorized_organization_unit_ids IS NULL OR arraycontained(organization_unit_ids, authorized_organization_unit_ids) = FALSE) THEN    	
                RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'organization_unit_ids');        
            END IF;    
            
            IF array_length(user_ids, 1) > 0 THEN
                SELECT array_agg(uo."userId") INTO authorized_user_ids FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" AS uoou
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."id" = uoou."userOrganizationId" AND uo."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
                WHERE uoou."organizationUnitId" = ANY(authorized_organization_unit_ids) AND uo."userId" = ANY(user_ids);
                RAISE NOTICE 'Authorized user_ids: %', authorized_user_ids;
                IF authorized_user_ids IS NULL OR arraycontained(user_ids, authorized_user_ids) = FALSE THEN
                    RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_ids');                	
                END IF;
            END IF;

            IF array_length(user_group_ids, 1) > 0 THEN	
                SELECT array_agg(ug.id) INTO authorized_user_group_ids FROM "___ORGANIZATION_ID___"."userGroups" AS ug
                WHERE ug."organizationId" = organization_id AND ug."deletedAt" IS NULL AND (ug."organizationUnitId" IS NULL OR ug."organizationUnitId" = ANY(authorized_organization_unit_ids));
                IF authorized_user_group_ids IS NULL OR arraycontained(user_group_ids, authorized_user_group_ids) = FALSE THEN    	    
                    RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_group_ids');                	            
                END IF;
            END IF;
        END IF;

        IF array_length(access_control_point_ids, 1) > 0 THEN
            SELECT array_agg(uar."accessControlPointId") INTO authorized_access_control_point_ids FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar WHERE uar."userId" = user_id;
            IF authorized_access_control_point_ids IS NULL OR arraycontained(access_control_point_ids, authorized_access_control_point_ids) = FALSE THEN
                RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'access_control_point_ids');                	                    
            END IF;   
        END IF;

        RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
        END;

        $function$
        ;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
