"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;

        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
        ADD CONSTRAINT notification_unsubscribe_type_check 
        CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,999}'::smallint[]));      
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;

        ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
        ADD CONSTRAINT notification_unsubscribe_type_check 
        CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,999}'::smallint[]));
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
