"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const PPermissionApprovementToHrOrElse = 9;
const PACSSelfOverworkedEmployee = 49;
async function up(client, dbuser, dbsuperuser) {
    const removePPermissionApprovementToHrOrElseNotificationQuery = `
        UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = jsonb_set(settings, '{notification, enabledTypes}',(
            SELECT
                array_to_json(array_agg("enabledTypes")::int[])::jsonb
            FROM 
            (
                SELECT
                jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                FROM "___ORGANIZATION_ID___".organizations 
                ORDER BY jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
            ) as T 
            WHERE ("enabledTypes" != '${PPermissionApprovementToHrOrElse}'))
        );

        DELETE FROM "___ORGANIZATION_ID___".notification_instance ne 
        WHERE ne."notificationId" = any((
            SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni
            WHERE "type" = ${PPermissionApprovementToHrOrElse}
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".notification_event ne 
        WHERE ne."notificationId" = any((
            SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni
            WHERE "type" = ${PPermissionApprovementToHrOrElse}
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".notification
        WHERE type = ${PPermissionApprovementToHrOrElse};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, removePPermissionApprovementToHrOrElseNotificationQuery, "___ORGANIZATION_ID___");
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    for (const organizationId of organizationIds) {
        const orgModules = await client.query(`SELECT * FROM "${organizationId}"."organizationModules"`);
        const pacsModule = orgModules.rows.find((m) => (m.disableUtc === null && m.module === 3 && m.status === 1));
        if (!pacsModule) {
            continue;
        }
        const isThereEnabledType = await client.query(`
            SELECT
                *
            FROM 
            (
                SELECT
                jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                FROM "${organizationId}".organizations 
                ORDER BY jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
            ) as T 
            WHERE ("enabledTypes" = '${PACSSelfOverworkedEmployee}')
        `);
        if (isThereEnabledType.rows.length > 0) {
            continue;
        }
        await client.query(`
            UPDATE  "${organizationId}".organizations
            SET settings = jsonb_insert(settings, '{notification, enabledTypes, -1}', '${PACSSelfOverworkedEmployee}');
        `);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const removePACSSelfOverworkedEmployeeQuery = `
        UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = jsonb_set(settings, '{notification, enabledTypes}',(
            SELECT
                array_to_json(array_agg("enabledTypes")::int[])::jsonb
            FROM 
            (
                SELECT
                jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                FROM "___ORGANIZATION_ID___".organizations 
                ORDER BY jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
            ) as T 
            WHERE ("enabledTypes" != '${PACSSelfOverworkedEmployee}'))
        );
        
        DELETE FROM "___ORGANIZATION_ID___".notification_instance ne 
        WHERE ne."notificationId" = ANY((
            SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni
            WHERE "type" = ${PACSSelfOverworkedEmployee}
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".notification_event ne 
        WHERE ne."notificationId" = ANY((
            SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni
            WHERE "type" = ${PACSSelfOverworkedEmployee}
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".user_filter uf
        WHERE uf.id = ANY((
            SELECT ARRAY_AGG(ni."receiverFilterId")FROM "___ORGANIZATION_ID___".notification ni WHERE "type" = ${PACSSelfOverworkedEmployee}
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".user_filter uf
        WHERE uf.id = ANY((
            SELECT ARRAY_AGG(pnsj."subjectedEmployeesFilterId")  FROM "___ORGANIZATION_ID___".pacs_notification_scheduled_job pnsj 
            WHERE pnsj.id = ANY((
                SELECT ARRAY_AGG(sj.id)  FROM public.scheduled_job sj
                WHERE sj."notificationId" = ANY((
                    SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni WHERE "type" = ${PACSSelfOverworkedEmployee}
                )::uuid[])
            )::uuid[])
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".pacs_notification_scheduled_job pnsj 
        WHERE pnsj.id = ANY((
            SELECT ARRAY_AGG(sj.id)  FROM public.scheduled_job sj
            WHERE sj."notificationId" = ANY((
                SELECT ARRAY_AGG(id) FROM "___ORGANIZATION_ID___".notification ni WHERE "type" = ${PACSSelfOverworkedEmployee}
            )::uuid[])
        )::uuid[]);

        DELETE FROM "___ORGANIZATION_ID___".notification
        WHERE type = ${PACSSelfOverworkedEmployee};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, removePACSSelfOverworkedEmployeeQuery, "___ORGANIZATION_ID___");
}
exports.down = down;
