"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const app_logs_1 = require("../../../../app.logs");
async function up(client, dbuser, dbsuperuser) {
    const checkRows = await client.query(`
		SELECT COUNT(*)::INTEGER AS c
		FROM public."userAuthenticationMethods"
	`);
    if (checkRows.rows[0].c > 0) {
        app_logs_1.logger.error(`There are entries in table public."userAuthenticationMethods". Migration is aborted! Please get in touch with development team!`);
        app_logs_1.logger.error(`====================================IMPORTANT===================================`);
        throw new Error(`There are entries in table public."userAuthenticationMethods". Migration is aborted! Please get in touch with development team!`);
    }
    const publicQuery = `
		DROP TABLE IF EXISTS public."userAuthenticationMethods";
	`;
    await client.query(publicQuery);
    const orgQuery = `
		DROP TABLE IF EXISTS "___ORGANIZATION_ID___".employee_day_segments CASCADE;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, orgQuery, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
	CREATE TABLE IF NOT EXISTS public."userAuthenticationMethods"
	(
		"userId" uuid NOT NULL,
		"authenticationMethodId" uuid,
		CONSTRAINT "userAuthenticationMethods_organizationAuthenticationMethodsId_f" FOREIGN KEY ("authenticationMethodId")
			REFERENCES public."organizationAuthenticationMethods" (id) MATCH SIMPLE
			ON UPDATE NO ACTION
			ON DELETE CASCADE,
		CONSTRAINT "userAuthenticationMethods_userListId_fkey" FOREIGN KEY ("userId")
			REFERENCES public."userList" (id) MATCH SIMPLE
			ON UPDATE NO ACTION
			ON DELETE CASCADE
	)
	
	TABLESPACE pg_default;
	ALTER TABLE IF EXISTS public."userAuthenticationMethods"
		OWNER to ${dbsuperuser};
	GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE public."userAuthenticationMethods" TO ${dbuser};
	GRANT ALL ON TABLE public."userAuthenticationMethods" TO ${dbsuperuser};
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
