"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
	CREATE TABLE "___ORGANIZATION_ID___"."integration_idmap"
	(
		"armonId" uuid NOT NULL,
		type integer NOT NULL,
		"extId" text COLLATE pg_catalog."default" NOT NULL,
		CONSTRAINT "integration_idmap_pkey" PRIMARY KEY ("armonId"),
		CONSTRAINT "integration_idmap_type_remoteId_key" UNIQUE (type, "extId")
	) TABLESPACE pg_default;
	
	ALTER TABLE "___ORGANIZATION_ID___"."integration_idmap" OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."integration_idmap" TO ${dbuser};
	

	CREATE TABLE "___ORGANIZATION_ID___"."integration_ops"
	(
		"id" uuid NOT NULL,
		"taskCount" integer NOT NULL,
		status integer NOT NULL,
		"createdAt" timestamp with time zone NOT NULL,
		"startedAt" timestamp with time zone,
		"finishedAt" timestamp with time zone,
		CONSTRAINT "integration_ops_pkey" PRIMARY KEY ("id")
	) TABLESPACE pg_default;
	
	ALTER TABLE "___ORGANIZATION_ID___"."integration_ops" OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."integration_ops" TO ${dbuser};
	

	CREATE TABLE "___ORGANIZATION_ID___"."integration_tasks"
	(
		"id" uuid NOT NULL,
		"operationId" uuid NOT NULL,
		index integer NOT NULL,
		"typeId" uuid NOT NULL,
		data jsonb,
		status integer NOT NULL,
		"createdAt" timestamp with time zone NOT NULL,
		"startedAt" timestamp with time zone,
		"finishedAt" timestamp with time zone,
		CONSTRAINT "integration_tasks_pkey" PRIMARY KEY ("id"),
		CONSTRAINT operation_id FOREIGN KEY ("operationId")
        	REFERENCES "___ORGANIZATION_ID___".integration_ops (id) MATCH SIMPLE
        	ON UPDATE CASCADE
        	ON DELETE CASCADE
	) TABLESPACE pg_default;
	
	ALTER TABLE "___ORGANIZATION_ID___"."integration_tasks" OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."integration_tasks" TO ${dbuser};
	
	CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".secrets
	(
		id uuid NOT NULL,
		secret jsonb NOT NULL,
		description text COLLATE pg_catalog."default",
		CONSTRAINT secrets_pkey PRIMARY KEY (id)
	);

	ALTER TABLE "___ORGANIZATION_ID___"."secrets" OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."secrets" TO ${dbuser};`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
	DROP TABLE "___ORGANIZATION_ID___"."integration_tasks";
	DROP TABLE "___ORGANIZATION_ID___"."integration_ops";
	DROP TABLE "___ORGANIZATION_ID___"."integration_idmap";`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
