"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const luxon_1 = require("luxon");
const appliedAutoShifts = [
    {
        organizationId: "7faf6dc2-f317-4d71-ae71-931e45eceab5",
        name: "Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: true,
        ruleSetId: "e20c30b3-3047-43a8-859f-d9861a94da7c",
        groupId: "ac8bbffa-0fcc-4db8-90b2-00cbcad11350",
        regionId: "5677b97f-a6ff-4c34-ac79-7b9af1ae759d",
        rules: [
            {
                checkRange: {
                    from: { hours: 3 },
                    to: { hours: 8, minutes: 15 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "916e577a-8154-4161-8d8a-c18c48889b43",
            },
            {
                checkRange: {
                    from: { hours: 9, minutes: 45 },
                    to: { hours: 10, minutes: 15 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "6b096302-d1c1-480d-8e11-a18f2fbe22f1",
            },
            {
                checkRange: {
                    from: { hours: 8, minutes: 15 },
                    to: { hours: 9, minutes: 45 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "9f21e471-9ef7-46ce-8ae2-33fec26f651b",
            },
        ],
    },
    {
        organizationId: "4a5c591e-c303-43a7-968d-0378a2fc0c0d",
        name: "TK SÜT ESKİŞEHİR OTOMATİK VARDİYA",
        supportMobileCheckin: false,
        useOnlyFirstAccess: true,
        ruleSetId: "79af7c32-5b16-4451-9c59-2c25c144a852",
        groupId: "de3bf45e-a6bb-4dbf-a8d4-bfd545e9cb5b",
        regionId: "61d57d5a-3b56-45ac-b2d0-94ae11ecf65a",
        rules: [
            {
                checkRange: {
                    from: { hours: 6, minutes: 30 },
                    to: { hours: 7, minutes: 30 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "25ab0b2d-d1d5-4e40-9ae8-7e7a28b86fa5",
            },
            {
                checkRange: {
                    from: { hours: 7, minutes: 30 },
                    to: { hours: 8, minutes: 30 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "96b9d90e-a2db-423d-bace-f804e320e7ca",
            },
            {
                checkRange: {
                    from: { hours: 21 },
                    to: { hours: 23 },
                },
                membershipRange: {
                    from: { hours: 21 },
                    to: { days: 1, hours: 21 },
                },
                workPlanId: "e1088aae-830c-4bda-99f9-5f0e87f970ca",
            },
            {
                checkRange: {
                    from: { hours: 2 },
                    to: { hours: 4 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "06aa1ef0-c7fc-4f04-a40b-1b37ea954cf3",
            },
        ],
    },
    {
        organizationId: "4a5c591e-c303-43a7-968d-0378a2fc0c0d",
        name: "TK SÜT DENİZLİ OTOMATİK VARDİYA",
        supportMobileCheckin: false,
        useOnlyFirstAccess: true,
        ruleSetId: "1c78aeb0-2c52-4b92-a0b5-5d1485012acf",
        groupId: "e97ceab0-18eb-401d-a3ae-0f03274fd8ed",
        regionId: "a7cd23eb-f419-4f20-bbf1-20a08454f847",
        rules: [
            {
                checkRange: {
                    from: { hours: 8 },
                    to: { hours: 9 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "5e3e265c-0135-4fed-9766-2c4bf0f1e7e6",
            },
            {
                checkRange: {
                    from: { hours: 16 },
                    to: { hours: 17 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1, hours: 2 },
                },
                workPlanId: "d7dfe1d2-6f27-4ed3-8a31-f0d63deef76c",
            },
            {
                checkRange: {
                    from: {},
                    to: { hours: 1 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "16c5bfdf-03e2-41a1-8c1b-6fa3346fd451",
            },
        ],
    },
    {
        organizationId: "9e6561e0-b3ad-4547-a440-c57d33711bfb",
        name: "GDZ 8-16-24 Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "a0f449c8-efcc-4342-9ca4-48d158f19c9c",
        groupId: "9362960a-396f-429d-974a-f6c43ec3319e",
        regionId: "2dfe576c-6890-4107-81e0-bec236e362de",
        rules: [
            {
                checkRange: {
                    from: { hours: 23 },
                    to: { days: 1 },
                },
                membershipRange: {
                    from: { hours: 23 },
                    to: { days: 1, hours: 23 },
                },
                workPlanId: "e5e5fb22-ab55-4298-8aff-e6709960c804",
            },
            {
                checkRange: {
                    from: {},
                    to: { hours: 1 },
                },
                membershipRange: {
                    from: { days: -1, hours: 23 },
                    to: { hours: 23 },
                },
                workPlanId: "e5e5fb22-ab55-4298-8aff-e6709960c804",
            },
            {
                checkRange: {
                    from: { hours: 7 },
                    to: { hours: 9 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "10e9e18b-065a-4eef-ac73-c0b46d0f28ec",
            },
            {
                checkRange: {
                    from: { hours: 15 },
                    to: { hours: 17 },
                },
                membershipRange: {
                    from: { hours: 1 },
                    to: { days: 1, hours: 1 },
                },
                workPlanId: "152fe18d-3049-4897-8e02-2b9b991e39bb",
            },
        ],
    },
    {
        organizationId: "9e6561e0-b3ad-4547-a440-c57d33711bfb",
        name: "GDZ 07-15-23 Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "7279ca15-bb2b-48ef-86eb-725109812d58",
        groupId: "a2c3a952-f499-40b5-9e05-fadc8b6b69f6",
        regionId: "2dfe576c-6890-4107-81e0-bec236e362de",
        rules: [
            {
                checkRange: {
                    from: { hours: 22 },
                    to: { days: 1 },
                },
                membershipRange: {
                    from: { hours: 22 },
                    to: { days: 1, hours: 22 },
                },
                workPlanId: "7ad8baba-2b04-4c0d-9789-ce42e9ccb0cc",
            },
            {
                checkRange: {
                    from: { hours: 6 },
                    to: { hours: 8 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "a59da5c2-0f55-4e53-88ee-a0b2ef3060d9",
            },
            {
                checkRange: {
                    from: { hours: 14 },
                    to: { hours: 16 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "1d5bb0cf-9b90-4753-8e03-9cba5fc07d50",
            },
        ],
    },
    {
        organizationId: "1593b82d-b0bf-49c6-a487-8cbd49e365ea",
        name: "KNAUF IZMIT OTOMATİK VARDİYA",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "3817040d-1c2a-4fb7-808a-94440a6929af",
        groupId: "c8162aa2-ce7a-49b1-8f93-8d9eb3c479db",
        regionId: "9b8fc3e3-a210-469e-a988-c7cf49a71d29",
        rules: [
            {
                checkRange: {
                    from: { hours: 23 },
                    to: { days: 1 },
                },
                membershipRange: {
                    from: { hours: 23 },
                    to: { days: 1, hours: 23 },
                },
                workPlanId: "ecf70a70-08e4-4f3e-b300-5058418062ae",
            },
            {
                checkRange: {
                    from: {},
                    to: { hours: 1 },
                },
                membershipRange: {
                    from: { days: -1, hours: 23 },
                    to: { hours: 23 },
                },
                workPlanId: "ecf70a70-08e4-4f3e-b300-5058418062ae",
            },
            {
                checkRange: {
                    from: { hours: 7 },
                    to: { hours: 9 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "45e605d5-ffd7-4129-b37b-23978986b588",
            },
            {
                checkRange: {
                    from: { hours: 15 },
                    to: { hours: 17 },
                },
                membershipRange: {
                    from: { hours: 1 },
                    to: { days: 1, hours: 1 },
                },
                workPlanId: "d73e8d79-e6a1-4517-9844-5de596b3621d",
            },
        ],
    },
    {
        organizationId: "1593b82d-b0bf-49c6-a487-8cbd49e365ea",
        name: "KNAUF AHİBOZ OTOMATİK VARDİYA",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "230ee8bc-a4b1-4ca3-a661-01758d9e53e7",
        groupId: "c8162aa2-ce7a-49b1-8f93-8d9eb3c479db",
        regionId: "deb8fc82-46e7-457c-88dc-09f98883042a",
        rules: [
            {
                checkRange: {
                    from: { hours: 23 },
                    to: { days: 1 },
                },
                membershipRange: {
                    from: { hours: 23 },
                    to: { days: 1, hours: 23 },
                },
                workPlanId: "940e4dca-9d06-4149-8f0e-eff11bf2a3a9",
            },
            {
                checkRange: {
                    from: {},
                    to: { hours: 1 },
                },
                membershipRange: {
                    from: { days: -1, hours: 23 },
                    to: { hours: 23 },
                },
                workPlanId: "940e4dca-9d06-4149-8f0e-eff11bf2a3a9",
            },
            {
                checkRange: {
                    from: { hours: 7 },
                    to: { hours: 9 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "2893467f-251c-454b-9b6d-3d72c0e979e9",
            },
            {
                checkRange: {
                    from: { hours: 15 },
                    to: { hours: 17 },
                },
                membershipRange: {
                    from: { hours: 1 },
                    to: { days: 1, hours: 1 },
                },
                workPlanId: "36d776c1-1e26-4b1b-acd1-c62ab91bb3b7",
            },
        ],
    },
    {
        organizationId: "c78457f9-d717-4cdb-9f56-ee3185334d5d",
        name: "Avery Denisson Genel Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "bd191fd2-3198-44f4-abc8-c6f4654ba527",
        groupId: "b5a8cc36-0956-4643-94d3-6fa48450ad38",
        regionId: "87c65e35-da16-4a04-9cce-b56eb453767c",
        rules: [
            {
                checkRange: {
                    from: { hours: 5, minutes: 30 },
                    to: { hours: 8 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "475bcfe1-0e3d-485f-92b0-e93e5917d446",
            },
            {
                checkRange: {
                    from: { hours: 14, minutes: 30 },
                    to: { hours: 17 },
                },
                membershipRange: {
                    from: { hours: 12 },
                    to: { days: 1, hours: 12 },
                },
                workPlanId: "25009cc4-fcb4-4dba-8f96-2140ca042970",
            },
        ],
    },
    {
        organizationId: "1325e507-3b10-4047-b439-cf50d6fe1358",
        name: "Pelsan Genel Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "3a8d9733-69d3-4e37-bec0-bb9afe5ea736",
        groupId: "f6bd0ac4-e511-4fc4-94ad-6e022fc375e3",
        regionId: "8b7fc833-8066-4d1e-860d-fbc1c194314a",
        rules: [
            {
                checkRange: {
                    from: { hours: 23 },
                    to: { days: 1 },
                },
                membershipRange: {
                    from: { hours: 23 },
                    to: { days: 1, hours: 10 },
                },
                workPlanId: "0d8b1cdb-eaab-4a8b-acff-e6dea71cea16",
            },
            {
                checkRange: {
                    from: {},
                    to: { hours: 7 },
                },
                membershipRange: {
                    from: { hours: -1 },
                    to: { hours: 10 },
                },
                workPlanId: "0d8b1cdb-eaab-4a8b-acff-e6dea71cea16",
            },
            {
                checkRange: {
                    from: { hours: 7 },
                    to: { hours: 15 },
                },
                membershipRange: {
                    from: { hours: 7 },
                    to: { hours: 18 },
                },
                workPlanId: "00c731d7-07d1-4cb8-98a1-fc752044123b",
            },
            {
                checkRange: {
                    from: { hours: 19 },
                    to: { hours: 23 },
                },
                membershipRange: {
                    from: { hours: 19 },
                    to: { days: 1, hours: 10 },
                },
                workPlanId: "3c3ba740-7af0-4288-b8ab-31afc568f86b",
            },
            {
                checkRange: {
                    from: { hours: 15 },
                    to: { hours: 19 },
                },
                membershipRange: {
                    from: { hours: 15 },
                    to: { days: 1, hours: 2 },
                },
                workPlanId: "d0027192-e54d-4c7b-adb5-b81974df10d6",
            },
        ],
    },
    {
        organizationId: "392cf6af-0c91-4a42-a5fc-249044cd851f",
        name: "ŞAP Güvenlik Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "b58a9e26-ad2e-4dbf-b1d7-c6a43bf44ea5",
        groupId: "230e6e61-a66b-4cb4-95f6-63f1cfb8dc9d",
        regionId: "4a8c1b4c-082d-435b-a43f-2f78166b0039",
        rules: [
            {
                checkRange: {
                    from: { hours: 6, minutes: 30 },
                    to: { hours: 8, minutes: 30 },
                },
                membershipRange: {
                    from: {},
                    to: { days: 1 },
                },
                workPlanId: "d85d3877-6c94-4bb8-9564-ee1323bc66af",
            },
            {
                checkRange: {
                    from: { hours: 18, minutes: 30 },
                    to: { hours: 20, minutes: 30 },
                },
                membershipRange: {
                    from: { hours: 18, minutes: 30 },
                    to: { days: 1, hours: 18, minutes: 30 },
                },
                workPlanId: "7fadb010-b7c5-4c36-9ac7-9337e5028bec",
            },
        ],
    },
    {
        organizationId: "eec6c4b4-b540-4bfb-8720-ca8457c5de39",
        name: "Gübretas Samsun Güvenlik Otomatik Vardiya",
        supportMobileCheckin: false,
        useOnlyFirstAccess: false,
        ruleSetId: "b7ed93d2-46ba-41a3-a5e3-766fb894a1ad",
        groupId: "e8c9cce8-c0b2-41ff-aa69-e967d041462d",
        regionId: "a6462aee-1382-4564-83b9-76b8761a7cdf",
        rules: [
            {
                checkRange: { from: { hours: 7 }, to: { hours: 9 } },
                membershipRange: { from: { hours: 7 }, to: { hours: 22 } },
                workPlanId: "beb78877-c507-412b-b30d-78f89d3530ec",
            },
            {
                checkRange: { from: { hours: 19 }, to: { hours: 21 } },
                membershipRange: { from: { hours: 19 }, to: { days: 1, hours: 10 } },
                workPlanId: "957e47ea-f4a9-4f25-ba52-98a808b9557b",
            },
        ],
    },
];
async function up(client, dbuser, dbsuperuser) {
    const query = `
    CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".auto_shift_rule_set
	(
        id uuid NOT NULL,
		name character varying(255) NOT NULL,
        "supportMobileCheckin" boolean DEFAULT false,
        "supportManualLog" boolean DEFAULT false,
		"useOnlyFirstAccess" boolean DEFAULT true,
        "rules" jsonb[],
        "deletedAt" timestamp with time zone,
        "startDateTime" timestamp with time zone NOT NULL,
        "endDateTime" timestamp with time zone,
        CONSTRAINT shift_id_pkey PRIMARY KEY (id)
    );

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".auto_shift_rule_set_update_cache()
	RETURNS TRIGGER AS $$
	DECLARE row_count integer;
	BEGIN
		PERFORM pg_notify('auto_shift_rule_change_event','{"organizationId": "___ORGANIZATION_ID___"}');	
		RETURN NULL;
	END;
	$$ LANGUAGE plpgsql;
		
	--------------------- AUTO SHIFT RULE -------------------
	CREATE TRIGGER trg_auto_shift_rule_set_update_cache
	AFTER UPDATE OR INSERT OR DELETE
	ON "___ORGANIZATION_ID___".auto_shift_rule_set
	FOR EACH ROW EXECUTE FUNCTION "___ORGANIZATION_ID___".auto_shift_rule_set_update_cache();


	CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".auto_shift_rule_set_group
	(
		id uuid NOT NULL,
		"ruleSetId" uuid NOT NULL,
		"groupId" uuid NOT NULL,
		PRIMARY KEY (id),
		CONSTRAINT auto_shift_rule_set_group_fk
		FOREIGN KEY ("ruleSetId")
			REFERENCES "___ORGANIZATION_ID___".auto_shift_rule_set (id)
			ON DELETE CASCADE
			ON UPDATE CASCADE,
		CONSTRAINT group_id_fkey 
		FOREIGN KEY ("groupId")
            REFERENCES "___ORGANIZATION_ID___"."userGroups" (id) MATCH SIMPLE
            ON UPDATE CASCADE
            ON DELETE CASCADE,
		CONSTRAINT rule_set_group UNIQUE("ruleSetId", "groupId")
	);

	CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".auto_shift_rule_set_region
	(
		id uuid NOT NULL,
		"ruleSetId" uuid NOT NULL,
		"regionId" uuid NOT NULL,
		PRIMARY KEY (id),
		CONSTRAINT auto_shift_rule_set_region_fk
		FOREIGN KEY ("ruleSetId")
			REFERENCES "___ORGANIZATION_ID___".auto_shift_rule_set (id)
			ON DELETE CASCADE
			ON UPDATE CASCADE,
		CONSTRAINT region_id_fkey 
		FOREIGN KEY ("regionId")
            REFERENCES "___ORGANIZATION_ID___".regions (id) MATCH SIMPLE
            ON UPDATE CASCADE
            ON DELETE CASCADE,
		CONSTRAINT rule_set_region UNIQUE("ruleSetId", "regionId")
	);
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    for (const appliedAutoShift of appliedAutoShifts) {
        const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
        if (organizationIds.find((elem) => elem === appliedAutoShift.organizationId)) {
            await client.query(`
				INSERT INTO "${appliedAutoShift.organizationId}"."auto_shift_rule_set"(
					id, name, "supportMobileCheckin", "useOnlyFirstAccess", rules, "deletedAt", "startDateTime", "endDateTime")
					VALUES ($1, $2, $3, $4, $5, $6, $7, $8);
					`, [
                appliedAutoShift.ruleSetId,
                appliedAutoShift.name,
                appliedAutoShift.supportMobileCheckin,
                appliedAutoShift.useOnlyFirstAccess,
                appliedAutoShift.rules,
                null,
                luxon_1.DateTime.now().toISO(),
                null,
            ]);
            await client.query(`
				INSERT INTO "${appliedAutoShift.organizationId}"."auto_shift_rule_set_group"(
					id, "ruleSetId", "groupId")
					VALUES (gen_random_uuid(), $1, $2);
				`, [appliedAutoShift.ruleSetId, appliedAutoShift.groupId]);
            await client.query(`
				INSERT INTO "${appliedAutoShift.organizationId}"."auto_shift_rule_set_region"(
					id, "ruleSetId", "regionId")
					VALUES (gen_random_uuid(), $1, $2);
				`, [appliedAutoShift.ruleSetId, appliedAutoShift.regionId]);
        }
    }
    const assignAutoShiftFunctionQuery = `
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".assign_auto_shift("param_user_id" uuid, 
                                                                        "param_rule_id" uuid,
                                                                        "log_id" uuid,                                                                  
                                                                        "start_date" date,
                                                                        "end_date" date) 
    RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE al record;
            at_now timestamp with time zone;
            exclusive_lock record;
            users_to_be_assigned uuid[] := ARRAY[]::uuid[];
            users_to_be_updated uuid[] := ARRAY[]::uuid[];
    BEGIN

        IF ("param_rule_id" IS NOT NULL) THEN
            SELECT ARRAY_AGG(DISTINCT(uo."userId")) into users_to_be_assigned
            FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" AS asrs
            INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" AS asrsg
                ON asrs.id = asrsg."ruleSetId"
            INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                ON uguo."userGroupId" = asrsg."groupId"
            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                ON uguo."userOrganizationId" = uo.id AND uo."isDisabled" IS FALSE
            WHERE asrs.id = "param_rule_id";
        END IF;

        FOR al IN
            SELECT  sq2.wp_id, logs."id" as "logId", 
                    arrsg."groupId", arrsr."regionId", logs."userId",
                    logs."actionUtc" = MIN(logs."actionUtc") OVER ( PARTITION BY logs."userId", logs."actionUtc"::date, sq2.id) as is_first,
                    sq2."useOnlyFirstAccess",
                    (logs."actionUtc"::date + membership_from_date)::timestamp with time zone as mem_start,
                    (logs."actionUtc"::date + membership_to_date)::timestamp with time zone as mem_end
            FROM
            (
                SELECT
                    id,
                    sq.wp_id,
                    sq."useOnlyFirstAccess",
                    sq."supportMobileCheckin",
					sq."supportManualLog",
                    sq."startDateTime",
                    sq."endDateTime",
                    '00:00:00'::interval
                        + (INTERVAL '1 days' * COALESCE((_from->'days')::integer, 0))
                        + (INTERVAL '1 hours' * COALESCE((_from->'hours')::integer, 0))
                        + (INTERVAL '1 minutes' * COALESCE((_from->'minutes')::integer, 0)) as from_time,
                    '00:00:00'::interval
                        + (INTERVAL '1 days' * COALESCE((_to->'days')::integer, 0))
                        + (INTERVAL '1 hours' * COALESCE((_to->'hours')::integer, 0))
                        + (INTERVAL '1 minutes' * COALESCE((_to->'minutes')::integer, 0)) as to_time,
                    '00:00:00'::interval
                        + (INTERVAL '1 days' * COALESCE((_membership_from->'days')::integer, 0))
                        + (INTERVAL '1 hours' * COALESCE((_membership_from->'hours')::integer, 0))
                        + (INTERVAL '1 minutes' * COALESCE((_membership_from->'minutes')::integer, 0)) as membership_from_date,
                    '00:00:00'::interval
                        + (INTERVAL '1 days' * COALESCE((_membership_to->'days')::integer, 0))
                        + (INTERVAL '1 hours' * COALESCE((_membership_to->'hours')::integer, 0))
                        + (INTERVAL '1 minutes' * COALESCE((_membership_to->'minutes')::integer, 0)) as membership_to_date
                FROM
                (
                    SELECT
                        arrs.id,
                        "useOnlyFirstAccess",
                        "supportMobileCheckin",
                        "supportManualLog",
                        "startDateTime",
                        "endDateTime",
                        (rrr->>'workPlanId')::uuid as wp_id,
                        rrr->'checkRange'->'from' as _from,
                        rrr->'checkRange'->'to' as _to,
                        rrr->'membershipRange'->'from' as _membership_from,
                        rrr->'membershipRange'->'to' as _membership_to
                    FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" arrs, unnest(rules) as rrr
                    WHERE ((id = "param_rule_id" OR "param_rule_id" IS NULL) AND (arrs."deletedAt" IS NULL))
                ) sq
            ) sq2
            INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" arrsg
                ON arrsg."ruleSetId" = sq2.id
            LEFT JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_region" arrsr
                ON arrsr."ruleSetId" = sq2.id
            INNER JOIN (
                SELECT
                    alo.id,
                    (alo.log->>'o')::uuid as "userId",
                    alo."actionUtc",
                    alo.log->>'a' = '06ba5170-d827-4ced-b356-f2e99afd3971' as "isMobileCheckin",
                    alo.log->>'rm' as "logMethod",
                    (alo.log->>'ir')::boolean as "isRemote",
					alo.log->>'cid' IS NOT NULL as "isDevice",
                    (alo.log->>'iq')::boolean as "isQrTriggered",
                    array_agg((rg->>'i')::uuid) FILTER (WHERE rg->>'i' IS NOT NULL) as regions
                FROM "___ORGANIZATION_ID___".access_logs AS alo
                LEFT JOIN jsonb_array_elements(COALESCE(alo.log->>'rg', '[]')::jsonb) rg
                    ON 1=1
                WHERE   alo.log->>'d' = '1'
                        AND "start_date" < alo."actionUtc" 
                        AND (alo."actionUtc" < "end_date" OR "end_date" IS NULL) 
                        AND ( (alo.log->>'o')::uuid = "param_user_id" OR (alo.log->>'o')::uuid = ANY(users_to_be_assigned))
                GROUP BY alo.id, alo.log->>'o', alo."actionUtc"
            ) logs
                ON
                    sq2.from_time <= (logs."actionUtc")::time AND (logs."actionUtc")::time < sq2.to_time
                    AND ("param_user_id" IS NULL OR (logs."actionUtc" >= sq2."startDateTime" AND (logs."actionUtc" <= sq2."endDateTime" OR sq2."endDateTime" IS NULL)))
                    AND (
                        (logs."logMethod" = '5' AND sq2."supportManualLog")
                        OR (logs."logMethod" = '4' AND ( sq2."supportMobileCheckin" OR NOT logs."isMobileCheckin"))
                        OR (logs."isRemote" IS NULL AND (NOT logs."isDevice" OR arrsr."regionId" = ANY(logs.regions)))
                        OR (logs."isRemote" AND logs."isQrTriggered" AND arrsr."regionId" = ANY(logs.regions))
                    )
            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                ON uo."userId" = logs."userId"
            INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                ON uguo."userOrganizationId" = uo.id AND uguo."userGroupId" = arrsg."groupId"
            WHERE   (logs."actionUtc" <= uguo."deletedAt" OR uguo."deletedAt" IS NULL) 
                    AND logs."actionUtc" >= uguo."createdAt" 
                    AND uo."deletedAt" IS NULL
            ORDER BY logs."userId", logs."actionUtc" ASC
        LOOP 
            IF ( (log_id = al."logId" OR log_id IS NULL) AND (NOT al."useOnlyFirstAccess" OR al.is_first) )  THEN
                    at_now :=clock_timestamp();
                    SELECT * into exclusive_lock
                    FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                    WHERE al."userId" = uwp."userId" FOR UPDATE;

                    SELECT al."userId" || users_to_be_updated into users_to_be_updated
                    WHERE  al."userId" != ALL(users_to_be_updated);

                    INSERT INTO "___ORGANIZATION_ID___"."userWorkPlans"
                    (id, "userId", "workPlanId", "startDateTime", "endDateTime", "createdAt")
                    SELECT gen_random_uuid(), al."userId", subbed_tbl."workPlanId", LOWER(subbed_tbl.subbed), UPPER(subbed_tbl.subbed), at_now
                    FROM (
                        SELECT uwp."workPlanId", tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(al.mem_start, null) as subbed
                        FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                        WHERE uwp."userId" = al."userId" AND tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(al.mem_start, al.mem_end)
                        UNION ALL
                        SELECT uwp."workPlanId", tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(null, al.mem_end) as subbed
                        FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                        WHERE uwp."userId" = al."userId" AND tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(al.mem_start, al.mem_end)
                    ) subbed_tbl
                    WHERE NOT isEmpty(subbed_tbl.subbed)
                    UNION ALL
                    SELECT gen_random_uuid(), al."userId", al.wp_id, al.mem_start, al.mem_end, at_now;

                    DELETE FROM  "___ORGANIZATION_ID___"."userWorkPlans"
                    WHERE "userId" = al."userId"
                    AND tstzrange("startDateTime", "endDateTime") && tstzrange(al.mem_start, al.mem_end)
                    AND "createdAt" < at_now;
            END IF;
        END LOOP;
        INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
            (id, "userId", "organizationId", reason, "startDate")
            SELECT gen_random_uuid(), u, '___ORGANIZATION_ID___', 32, start_date
            FROM unnest(users_to_be_updated) u;
        UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld
            SET "updateRequiredReason" = "updateRequiredReason" | 32, "updateRequiredRaisedAt" = now()
            WHERE eld."userId" = ANY(users_to_be_updated);
    END;
    $$;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, assignAutoShiftFunctionQuery, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const dropTables = `
		DROP FUNCTION "___ORGANIZATION_ID___".assign_auto_shift;
		DROP TRIGGER trg_auto_shift_rule_set_update_cache ON "___ORGANIZATION_ID___".auto_shift_rule_set;
		DROP FUNCTION "___ORGANIZATION_ID___".auto_shift_rule_set_update_cache;

		DROP TABLE "___ORGANIZATION_ID___".auto_shift_rule_set_region;
        DROP TABLE "___ORGANIZATION_ID___".auto_shift_rule_set_group;
		DROP TABLE "___ORGANIZATION_ID___".auto_shift_rule_set;		
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropTables, "___ORGANIZATION_ID___");
}
exports.down = down;
