"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
		DELETE FROM "___ORGANIZATION_ID___"."notification"
		WHERE type = 9;`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((elem) => elem.id);
    for (const organizationId of organizationIds) {
        await client.query(`
			INSERT INTO "${organizationId}"."notification"
			id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification")
			VALUES
			(gen_random_uuid(), now(), null, 9, null, null, true, false, true, true);`);
    }
}
exports.down = down;
