"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
	ALTER TABLE "___ORGANIZATION_ID___"."zz_notification"
		ALTER COLUMN "createdT" DROP NOT NULL,
		ALTER COLUMN "type" DROP NOT NULL,
		ALTER COLUMN "email" DROP NOT NULL,
		ALTER COLUMN "sms" DROP NOT NULL,
		ALTER COLUMN "web" DROP NOT NULL,
		ALTER COLUMN "pushNotification" DROP NOT NULL;

	ALTER TABLE "___ORGANIZATION_ID___"."zz_notification_event"
		ALTER COLUMN "receiverFilterId" DROP NOT NULL,
		ALTER COLUMN "createdT" DROP NOT NULL;

	ALTER TABLE "___ORGANIZATION_ID___"."zz_notification_access"
		ALTER COLUMN "regionId" DROP NOT NULL,
		ALTER COLUMN "options" DROP NOT NULL;
		
	ALTER TABLE "___ORGANIZATION_ID___"."zz_notification_instance"
		ALTER COLUMN "createdT" DROP NOT NULL,
		ALTER COLUMN "mediumGroupId" DROP NOT NULL,
		ALTER COLUMN "medium" DROP NOT NULL,
		ALTER COLUMN "notificationId" DROP NOT NULL,
		ALTER COLUMN "receiverUserId" DROP NOT NULL,
		ALTER COLUMN "eventId" DROP NOT NULL;
		
		
	ALTER TABLE "___ORGANIZATION_ID___"."zz_notification_sensor"
		ALTER COLUMN "accessControlPointId" DROP NOT NULL,
		ALTER COLUMN "sensorType" DROP NOT NULL,
		ALTER COLUMN "deviceDryContactInputId" DROP NOT NULL,
		ALTER COLUMN "options" DROP NOT NULL;		
		
	ALTER TABLE "___ORGANIZATION_ID___"."zz_pacs_notification_scheduled_job"
		ALTER COLUMN "subjectedEmployeesFilterId" DROP NOT NULL;		
		
	ALTER TABLE "___ORGANIZATION_ID___"."zz_user_organization_forbiddances"
		ALTER COLUMN "userId" DROP NOT NULL,
		ALTER COLUMN "createdAt" DROP NOT NULL;		
		
	ALTER TABLE "___ORGANIZATION_ID___"."zz_visitor_scheduled_job"
		ALTER COLUMN "visitId" DROP NOT NULL,
		ALTER COLUMN "scheduledJobId" DROP NOT NULL;`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
