"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((row) => row.id);
    for (const organizationId of organizationIds) {
        await client.query(`ALTER TABLE "${organizationId}".notification_event
			ALTER COLUMN "receiverFilterId" DROP NOT NULL; `);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((row) => row.id);
    for (const organizationId of organizationIds) {
        await client.query(`ALTER TABLE "${organizationId}".notification_event
				 ALTER COLUMN "receiverFilterId" SET NOT NULL; `);
    }
}
exports.down = down;
