"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.oAuthTokens}"
    ADD COLUMN "reason" character varying(255) COLLATE pg_catalog."default",
    ADD COLUMN "mobileInstallId" uuid;
    
    UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.oAuthTokens}" oa
    SET reason = oart.reason
    FROM public."oAuthRevokedTokens" oart
    WHERE oa."id" = oart."tokenId";
    
    UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizations}"
	SET settings = settings || '{"checkMobileDeviceMismatchOnLogin": false}'::jsonb;`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    await client.query(`DROP TABLE public."oAuthRevokedTokens"`);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    client.query(`
    CREATE TABLE IF NOT EXISTS public."oAuthRevokedTokens"
    (
        id uuid NOT NULL,
        "userId" uuid NOT NULL,
        reason character varying(255) COLLATE pg_catalog."default",
        "tokenId" uuid,
        CONSTRAINT "oAuthRevokedTokens_pkey" PRIMARY KEY (id),
        CONSTRAINT "oAuthRevokedTokens_userListId_fkey" FOREIGN KEY ("userId")
            REFERENCES public."${dal_db_armon_schema_1.ArmonSchema.tableNames.userList}" (id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE CASCADE
    ) TABLESPACE pg_default;

    ALTER TABLE public."oAuthRevokedTokens" OWNER to ${dbsuperuser};
    GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE public."oAuthRevokedTokens" TO ${dbuser};
    GRANT ALL ON TABLE public."oAuthRevokedTokens" TO ${dbsuperuser};`);
    const query = `
    UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizations}"
	SET settings = settings - 'checkMobileDeviceMismatchOnLogin';

    INSERT INTO public."oAuthRevokedTokens"
    ("id", "userId", "reason", "tokenId")
    SELECT uuid_generate_v4(), "userId", reason, id
    FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.oAuthTokens}"
    ON CONFLICT DO NOTHING;

    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.oAuthTokens}"
    DROP COLUMN "mobileInstallId", DROP COLUMN "reason";`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
