"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const luxon_1 = require("luxon");
const dal_utils_1 = require("../../../dal.utils");
const currentPartitionName = luxon_1.DateTime.now().toFormat("yLL");
const currentPartitionStart = luxon_1.DateTime.now().startOf("month").toFormat("y-LL") + "-01 00:00:00";
const currentPartitionEnd = luxon_1.DateTime.now().startOf("month").plus({ months: 1 }).toFormat("y-LL") + "-01 00:00:00";
async function up(client, dbuser, dbsuperuser) {
    const query = `

        CREATE INDEX IF NOT EXISTS notification_instance_id_idx
            ON "___ORGANIZATION_ID___".notification_instance USING btree
            (id ASC NULLS LAST);
        ALTER TABLE "___ORGANIZATION_ID___"."notification_instance"
            ADD COLUMN IF NOT EXISTS state smallint,
            ADD COLUMN IF NOT EXISTS note jsonb,
            DROP CONSTRAINT "notification_instance_id_fk";

        UPDATE "___ORGANIZATION_ID___"."notification_instance" sni
            SET state = pni.state, note = pni.note
        FROM public."notification_instance" pni
        WHERE pni.id = sni.id;

        ALTER TABLE "___ORGANIZATION_ID___"."notification_instance"
            ALTER COLUMN state SET NOT NULL;


        CREATE OR REPLACE FUNCTION public.fpartitioncreator(
            org_id text,
            table_name text,
            partition_key text)
            RETURNS void
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE PARALLEL UNSAFE
            AS $BODY$
            DECLARE 
                def_partition	text;
                i	timestamp with time zone;
                partition_to_create	text;
                previous_partition	text;
                next_partition	text;
                start_of_partition 	timestamp with time zone;
                end_of_partition 	timestamp with time zone;
            BEGIN
                EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DISABLE TRIGGER ALL;';
                IF (table_name = 'notification_event') THEN
                    PERFORM public.fpartitioncretor_for_schema_notification_event(org_id, table_name, partition_key);
                    EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ENABLE TRIGGER ALL;';
                    RETURN;
                ELSE
                    def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
            
                    EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DETACH PARTITION ' || def_partition || ';';
                        FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
                            SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
                            ' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || def_partition || ') AS T WHERE T.row_num = 1;'
                    LOOP
                        partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
                        previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
                        next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
        
                        IF NOT EXISTS(
                            SELECT relname FROM pg_class 
                            WHERE relname = previous_partition AND 
                            relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                            start_of_partition := date_trunc('month', i);
                        ELSE
                            start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                                from pg_class c
                                where relname = previous_partition and 
                                (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
                        END IF;
        
                        IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
                            relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                            end_of_partition := date_trunc('month', i) + interval '1 month';
                        ELSE
                            end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                                from pg_class c
                                where relname = next_partition and 
                                (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
                        END IF;
        
                        IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
                            relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                            EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                                || ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
                                || ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
                        END IF;
        
                        EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                            || ' SELECT * FROM '|| def_partition ||' WHERE '|| 
                            quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                            quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
        
                        EXECUTE 'DELETE FROM ' || def_partition || ' WHERE '|| 
                            quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                            quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
        
                    END LOOP;
        
                    EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ATTACH PARTITION ' || def_partition || ' DEFAULT;';
                    EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ENABLE TRIGGER ALL;';
                    RETURN;
                END IF;
            END;
        $BODY$;

        DROP FUNCTION IF EXISTS public.fpartitioncretor_for_public_notification_instance(text, text, text);

        CREATE TRIGGER after_insert_notification_instance_default 
            AFTER INSERT 
                ON "___ORGANIZATION_ID___".notification_instance_default
            FOR EACH ROW 
                EXECUTE FUNCTION public.after_insert_default();

        CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".zz_notification_instance_state (
            id uuid NOT NULL,
            action smallint NOT NULL,
            "actionT" timestamp without time zone NOT NULL,
            "transactionId" bigint NOT NULL,
            state smallint,
            note jsonb
        ) PARTITION BY RANGE ("actionT");

        CREATE TABLE "___ORGANIZATION_ID___".zz_notification_instance_state_default PARTITION OF "___ORGANIZATION_ID___".zz_notification_instance_state DEFAULT;	
        CREATE TABLE "___ORGANIZATION_ID___".zz_notification_instance_state_p${currentPartitionName} PARTITION OF "___ORGANIZATION_ID___".zz_notification_instance_state
            FOR VALUES FROM ('${currentPartitionStart}') TO ('${currentPartitionEnd}');

        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification_instance()
            RETURNS trigger
            LANGUAGE 'plpgsql'
            COST 100
            VOLATILE NOT LEAKPROOF
        AS $BODY$
            DECLARE
                _now timestamp without time zone;
            BEGIN   
                _now := now();
                IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification_instance WHERE id = NEW.id)) THEN
                    INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance (
                        id, action, "actionT", "transactionId", "createdT", "mediumGroupId", medium, "notificationId", "receiverUserId", content, "eventId")
                    VALUES(NEW.id, 1, _now, txid_current(), NEW."createdT", NEW."mediumGroupId", NEW.medium, NEW."notificationId", NEW."receiverUserId", NEW.content, NEW."eventId");
                
                    INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance_state(
                        id, action, "actionT", "transactionId", state, note)
                    VALUES (NEW.id, 1, _now, txid_current(), NEW.state, NEW.note);

                ELSIF (TG_OP = 'UPDATE') THEN
                 
                    IF (
                        NEW.id IS DISTINCT FROM OLD.id OR
                        NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
                        NEW."mediumGroupId" IS DISTINCT FROM OLD."mediumGroupId" OR
                        NEW.medium IS DISTINCT FROM OLD.medium OR
                        NEW."notificationId" IS DISTINCT FROM OLD."notificationId" OR
                        NEW."receiverUserId" IS DISTINCT FROM OLD."receiverUserId" OR
                        NEW.content::text IS DISTINCT FROM OLD.content::text OR
                        NEW."eventId" IS DISTINCT FROM OLD."eventId"
                    ) THEN
                        INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance(
                            id,action,"actionT","transactionId","createdT","mediumGroupId",medium,"notificationId","receiverUserId",content,"eventId")
                        VALUES( NEW.id,2,_now,txid_current(),NEW."createdT",NEW."mediumGroupId",NEW.medium,NEW."notificationId",NEW."receiverUserId",NEW.content,NEW."eventId");
                    END IF;
                    
                    IF (NEW.state IS DISTINCT FROM OLD.state) THEN
                        INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance_state (
                            id, action, "actionT", "transactionId", state, note)
                        VALUES (NEW.id, 2, _now, txid_current(), NEW.state, NEW.note);       
                    END IF;   
                ELSIF (TG_OP = 'DELETE') THEN
                    INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance( 
                        id,action,"actionT","transactionId","createdT","mediumGroupId",medium,"notificationId","receiverUserId",content,"eventId")
                    VALUES(OLD.id, 3, _now, txid_current(), OLD."createdT", OLD."mediumGroupId", OLD.medium, OLD."notificationId", OLD."receiverUserId", OLD.content, OLD."eventId");
                    
                    INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance_state (
                        id, action, "actionT", "transactionId", state, note)
                    VALUES ( OLD.id, 3, _now, txid_current(), OLD.state, OLD.note);     
                    
                END IF;    
                RETURN NULL;
                END;
        $BODY$;            

        DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".delete_public_notification_instance() CASCADE;
        DROP TRIGGER IF EXISTS trg_delete_public_notification_instance ON "___ORGANIZATION_ID___".notification_instance;

            `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const oldEntriesPartitionName = luxon_1.DateTime.now().startOf("month").minus({ years: 1 }).toFormat("yLL");
    const oldEntriesPartitionStart = luxon_1.DateTime.now().startOf("month").minus({ years: 1 }).toFormat("y-LL") + "-01 00:00:00";
    let query = `
        DROP TABLE "___ORGANIZATION_ID___".zz_notification_instance_state;
        DROP TRIGGER IF EXISTS trg_99_zz_notification_instance_state ON "___ORGANIZATION_ID___".notification_instance;
        DROP FUNCTION "___ORGANIZATION_ID___".zz_notification_instance_state;
        DROP TRIGGER IF EXISTS after_insert_notification_instance_default ON "___ORGANIZATION_ID___".notification_instance_default;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    await client.query(`
        --- add  fpartitioncretor_for_public_notification_instance
        CREATE OR REPLACE FUNCTION public.fpartitioncretor_for_public_notification_instance(
                org_id text,
                table_name text,
                partition_key text)
            RETURNS void
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE PARALLEL UNSAFE
            AS $BODY$
            DECLARE 
                def_partition	text;
                i	timestamp without time zone;
                partition_to_create	text;
                previous_partition	text;
                next_partition	text;
                start_of_partition 	timestamp without time zone;
                end_of_partition 	timestamp without time zone;
                schema_name_to_process 	uuid;
            BEGIN
                def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
                    
                EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
                    || def_partition || ';';
                        
                FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || def_partition || ' GROUP BY "organizationId";'
                LOOP
                    EXECUTE 'CREATE TEMPORARY TABLE "' || schema_name_to_process || '" ON COMMIT DROP AS SELECT * FROM "'
                    || schema_name_to_process || '".notification_instance WHERE id IN (SELECT id FROM '|| 
                    quote_ident('temp_' || table_name || '_default') ||');';
                END LOOP;
                    
                EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
                    
                FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
                    SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
                    ' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
                LOOP
                    partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
                    previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
                    next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
                
                    IF NOT EXISTS(
                        SELECT relname FROM pg_class 
                        WHERE relname = previous_partition AND 
                        relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                        start_of_partition := date_trunc('month', i);
                    ELSE
                        start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                            from pg_class c
                            where relname = previous_partition and 
                            (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\((.+)\)');
                    END IF;
                        
                    IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
                        relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                        end_of_partition := date_trunc('month', i) + interval '1 month';
                    ELSE
                        end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                            from pg_class c
                            where relname = next_partition and 
                            (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\((.+)\)');
                    END IF;
                        
                    IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
                        relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                        EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                            || ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
                            || ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
                    END IF;
                        
                    EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                    || ' SELECT * FROM '|| quote_ident('temp_' || table_name || '_default') ||' WHERE '|| 
                    quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                    quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
                        
                END LOOP;
                    
                FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || 
                    quote_ident('temp_' || table_name || '_default') || ' GROUP BY "organizationId";'
                LOOP
                    EXECUTE 'INSERT INTO "' || schema_name_to_process || '".notification_instance SELECT * FROM "'
                    || schema_name_to_process || '" ON CONFLICT DO NOTHING;';
                END LOOP;
                    
            RETURN;
            END;
        $BODY$;
        
        ALTER FUNCTION public.fpartitioncretor_for_public_notification_instance(text, text, text)
            OWNER TO ${dbsuperuser};
        
        GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_public_notification_instance(text, text, text) TO PUBLIC;
        GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_public_notification_instance(text, text, text) TO ${dbuser};
        GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_public_notification_instance(text, text, text) TO ${dbsuperuser};
        

        -- Update fpartitioncreator
        CREATE OR REPLACE FUNCTION public.fpartitioncreator(
                org_id text,
                table_name text,
                partition_key text)
			RETURNS void
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE PARALLEL UNSAFE
            AS $BODY$
            DECLARE 
                def_partition	text;
                i	timestamp with time zone;
                partition_to_create	text;
                previous_partition	text;
                next_partition	text;
                start_of_partition 	timestamp with time zone;
                end_of_partition 	timestamp with time zone;
            BEGIN
                IF (org_id = 'public' AND table_name = 'notification_instance') THEN
                    PERFORM public.fpartitioncretor_for_public_notification_instance(org_id, table_name, partition_key);
                    RETURN;
                ELSIF (table_name = 'notification_event') THEN
                    PERFORM public.fpartitioncretor_for_schema_notification_event(org_id, table_name, partition_key);
                    RETURN;
                ELSE
                    def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
						
                    EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DETACH PARTITION ' || def_partition || ';';
                    FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
                        SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
                        ' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || def_partition || ') AS T WHERE T.row_num = 1;'
                    LOOP
                        partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
                        previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
                        next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
    
                    IF NOT EXISTS(
                        SELECT relname FROM pg_class 
                        WHERE relname = previous_partition AND 
                        relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                        start_of_partition := date_trunc('month', i);
                    ELSE
                        start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                            from pg_class c
                            where relname = previous_partition and 
                            (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
                    END IF;
			
                    IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
                        relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                        end_of_partition := date_trunc('month', i) + interval '1 month';
                    ELSE
                        end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                            from pg_class c
                            where relname = next_partition and 
                            (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
                    END IF;
    
                        IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
                            relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                            EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                                || ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
                                || ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
                        END IF;
    
                        EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                        || ' SELECT * FROM '|| def_partition ||' WHERE '|| 
                        quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                        quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
    
                        EXECUTE 'DELETE FROM ' || def_partition || ' WHERE '|| 
                        quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                        quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
    
                    END LOOP;
			
							EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ATTACH PARTITION ' || def_partition || ' DEFAULT;';
							RETURN;
						END IF;
					END;
		$BODY$;

        
    CREATE OR REPLACE FUNCTION public.zz_notification_instance()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
    AS $BODY$
        DECLARE
            _now timestamp without time zone;
        BEGIN   
            _now := now();
            IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "public".notification_instance WHERE id = NEW.id)) THEN 
                INSERT INTO public.zz_notification_instance
                    (id, action, "actionT", "transactionId", "createdT", "organizationId", state, note)
                    VALUES ( NEW.id, 1, _now, txid_current(), NEW."createdT", NEW."organizationId", NEW.state, NEW.note);
            ELSIF (TG_OP = 'UPDATE' AND 
                    (NEW.id IS DISTINCT FROM OLD.id OR
                    NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
                    NEW."organizationId" IS DISTINCT FROM OLD."organizationId" OR
                    NEW.state IS DISTINCT FROM OLD.state OR
                    NEW.note::text IS DISTINCT FROM OLD.note::text)) THEN
                INSERT INTO public.zz_notification_instance
                (id, action, "actionT", "transactionId", "createdT", "organizationId", state, note)
                VALUES (NEW.id, 2, _now, txid_current(), NEW."createdT", NEW."organizationId", NEW.state, NEW.note);
            ELSIF (TG_OP = 'DELETE') THEN
                INSERT INTO public.zz_notification_instance
                (id, action, "actionT", "transactionId", "createdT", "organizationId", state, note)
                VALUES (OLD.id, 3, _now, txid_current(), OLD."createdT", OLD."organizationId", OLD.state, OLD.note);       
            END IF;    
            RETURN NULL;
        END;

    $BODY$;
    
    ALTER FUNCTION public.zz_notification_instance()
        OWNER TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO PUBLIC;
    
    GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO ${dbuser};

   
       

        CREATE TABLE IF NOT EXISTS public.notification_instance
        (
            id uuid NOT NULL,
            "createdT" timestamp without time zone NOT NULL,
            "organizationId" uuid NOT NULL,
            state smallint NOT NULL,
            note jsonb,
            CONSTRAINT notification_instance_pkey PRIMARY KEY (id, "createdT"),
            CONSTRAINT "notification_instance_organizationId_fkey" FOREIGN KEY ("organizationId")
                REFERENCES public."organizationList" (id) MATCH SIMPLE
                ON UPDATE CASCADE
                ON DELETE CASCADE,
            CONSTRAINT notification_instance_state_check CHECK (state = ANY ('{1,2,3,4,5,6,7,8}'::smallint[]))
        ) PARTITION BY RANGE ("createdT");
        
        ALTER TABLE IF EXISTS public.notification_instance
            OWNER to ${dbsuperuser};
        
        GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE public.notification_instance TO ${dbuser};
        
        GRANT ALL ON TABLE public.notification_instance TO ${dbsuperuser};

        CREATE TABLE IF NOT EXISTS public.notification_instance_default PARTITION OF public.notification_instance DEFAULT;
        CREATE TABLE IF NOT EXISTS public.notification_instance_p${oldEntriesPartitionName} PARTITION OF public.notification_instance
            FOR VALUES FROM ('${oldEntriesPartitionStart}') TO ('${currentPartitionStart}');		
        CREATE TABLE IF NOT EXISTS public.notification_instance_p${currentPartitionName} PARTITION OF public.notification_instance
            FOR VALUES FROM ('${currentPartitionStart}') TO ('${currentPartitionEnd}');		`);
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList"`)).rows.map((r) => r.id);
    for (const organizationId of organizationIds) {
        await client.query(`INSERT INTO public."notification_instance"(
                id, "createdT", "organizationId", "state", note)
            SELECT id, "createdT", '${organizationId}', state, note
            FROM "${organizationId}"."notification_instance" sni`);
    }
    const dropColumns = `
        ALTER TABLE "___ORGANIZATION_ID___"."notification_instance"
            ADD CONSTRAINT notification_instance_id_fk FOREIGN KEY ("createdT", id)
                REFERENCES public.notification_instance ("createdT", id) MATCH SIMPLE
                ON UPDATE CASCADE
                ON DELETE CASCADE,
            DROP COLUMN IF EXISTS state,
            DROP COLUMN IF EXISTS note;
            
        DROP TABLE "___ORGANIZATION_ID___".zz_notification_instance_state
        
                
        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        DECLARE
            _now timestamp without time zone;
        BEGIN   
            _now := now();
            IF (TG_OP = 'DELETE') THEN
                    DELETE FROM public.notification_instance
                    WHERE id = OLD.id;
            END IF;    
            RETURN NULL;
            END;

        $BODY$;

        ALTER FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance()
        OWNER TO ${dbsuperuser};

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance() TO ${dbsuperuser};

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance() TO PUBLIC;

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance() TO ${dbuser};

        
        CREATE TRIGGER trg_delete_public_notification_instance
        AFTER DELETE
            ON "___ORGANIZATION_ID___".notification_instance
        FOR EACH ROW
         EXECUTE FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance();
        
        
        `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropColumns, "___ORGANIZATION_ID___");
    await client.query(`
        DROP TRIGGER IF EXISTS trg_99_zz_notification_instance ON public.notification_instance;
        CREATE TRIGGER trg_99_zz_notification_instance
            AFTER INSERT OR DELETE OR UPDATE ON public.notification_instance
        FOR EACH ROW
            EXECUTE FUNCTION public.zz_notification_instance();
        `);
}
exports.down = down;
