"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        DECLARE
    BEGIN
        IF (TG_OP = 'DELETE' OR (TG_OP = 'UPDATE' AND ( NEW."name" IS DISTINCT FROM OLD."name" ))) THEN
            PERFORM PG_NOTIFY('organization_unit_delete_update', JSON_BUILD_OBJECT('organizationUnitId', OLD.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units()
    OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units() TO ${dbuser};
    
    CREATE TRIGGER after_up_del_organization_units
        AFTER UPDATE OR DELETE
        ON "___ORGANIZATION_ID___"."organizationUnits"
        FOR EACH ROW
        EXECUTE FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units();



    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        DECLARE
          _user_id uuid;
    BEGIN
        IF (TG_OP = 'DELETE' OR TG_OP = 'INSERT' OR (TG_OP = 'UPDATE' AND ( NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt"))) THEN
            SELECT "userId" into _user_id FROM "___ORGANIZATION_ID___"."userOrganizations" 
                WHERE id = COALESCE(NEW."userOrganizationId", OLD."userOrganizationId");
            PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', _user_id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units()
    OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units() TO ${dbuser};
        
    CREATE TRIGGER after_in_up_del_user_organization_organization_units
        AFTER INSERT OR UPDATE OR DELETE
        ON "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
        FOR EACH ROW
        EXECUTE FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units();
   `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        DROP TRIGGER after_up_del_organization_units ON "___ORGANIZATION_ID___"."organizationUnits";
        DROP FUNCTION "___ORGANIZATION_ID___".after_up_del_organization_units();
        
        DROP TRIGGER after_in_up_del_user_organization_organization_units ON "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits";
        DROP FUNCTION "___ORGANIZATION_ID___".after_in_up_del_user_organization_organization_units();
   `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
