"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationPACSModuleSettings}"
    ADD COLUMN "middayHour" character varying(5) UNIQUE NOT NULL DEFAULT '12:00';

    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlanPeriods}"
    ADD COLUMN "offset" integer DEFAULT NULL;

    DROP VIEW "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}";

    CREATE VIEW "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}"
    AS
        SELECT
            "workPlanPeriods".id,
            "workPlanPeriods"."workPlanId",
            "workPlanPeriods".details,
            "workPlanPeriods"."offset",
            tstzrange("workPlanPeriods"."periodStartDateTime", lead("workPlanPeriods"."periodStartDateTime") OVER (PARTITION BY "workPlanPeriods"."workPlanId" ORDER BY "workPlanPeriods"."periodStartDateTime")) AS range,
            "workPlans"."organizationId"
        FROM "___ORGANIZATION_ID___"."workPlanPeriods"
        JOIN "___ORGANIZATION_ID___"."workPlans"
            ON "workPlans".id = "workPlanPeriods"."workPlanId"
        WHERE "workPlanPeriods"."deletedAt" IS NULL AND "workPlans"."deletedAt" IS NULL;`;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    DROP VIEW "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}";

    CREATE VIEW "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}"
    AS
        SELECT
            "workPlanPeriods".id,
            "workPlanPeriods"."workPlanId",
            "workPlanPeriods".details,
            tstzrange("workPlanPeriods"."periodStartDateTime", lead("workPlanPeriods"."periodStartDateTime") OVER (PARTITION BY "workPlanPeriods"."workPlanId" ORDER BY "workPlanPeriods"."periodStartDateTime")) AS range,
            "workPlans"."organizationId"
        FROM "___ORGANIZATION_ID___"."workPlanPeriods"
        JOIN "___ORGANIZATION_ID___"."workPlans"
            ON "workPlans".id = "workPlanPeriods"."workPlanId"
        WHERE "workPlanPeriods"."deletedAt" IS NULL AND "workPlans"."deletedAt" IS NULL;

    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlanPeriods}"
    DROP COLUMN "offset";
    
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationPACSModuleSettings}"
    DROP COLUMN "middayHour";`;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
