"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const app_enums_1 = require("../../../../app.enums");
async function up(client, dbuser, dbsuperuser) {
    const MKEOrganizationId = "8837fe51-6e89-4d67-abcd-2a576adae750";
    const hasOrganization = (await client.query(`SELECT COUNT(id) > 0 as "hasOrganization" FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}" WHERE id = $1`, [MKEOrganizationId]))
        .rows[0].hasOrganization;
    if (hasOrganization) {
        await client.query(`
        CREATE TABLE IF NOT EXISTS "${MKEOrganizationId}".access_log_sync
        (
            id uuid NOT NULL,
            insertion timestamp with time zone NOT NULL,
            "timestamp" timestamp with time zone NOT NULL,
            log jsonb NOT NULL,
            "userId" uuid,
            "accessPointId" uuid NOT NULL,
            direction smallint NOT NULL,
            CONSTRAINT access_log_sync_pkey PRIMARY KEY (id),
            CONSTRAINT fk_accesslogsync_accesspointidid FOREIGN KEY ("accessPointId")
                REFERENCES "${MKEOrganizationId}"."accessControlPoints" (id) MATCH SIMPLE
                ON UPDATE CASCADE
                ON DELETE CASCADE,
            CONSTRAINT fk_accesslogsync_userid FOREIGN KEY ("userId")
                REFERENCES "${MKEOrganizationId}".users (id) MATCH SIMPLE
                ON UPDATE CASCADE
                ON DELETE CASCADE
        ) TABLESPACE pg_default;
        ALTER TABLE "${MKEOrganizationId}".access_log_sync OWNER to ${dbsuperuser};
        GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "${MKEOrganizationId}".access_log_sync TO ${dbuser};
        GRANT ALL ON TABLE "${MKEOrganizationId}".access_log_sync TO ${dbsuperuser};


        CREATE TABLE IF NOT EXISTS "${MKEOrganizationId}".access_log_sync_operations
        (
            id uuid NOT NULL,
            "timestamp" timestamp with time zone NOT NULL,
            operation integer
        ) TABLESPACE pg_default;
        ALTER TABLE "${MKEOrganizationId}".access_log_sync_operations OWNER to ${dbsuperuser};
        GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "${MKEOrganizationId}".access_log_sync_operations TO ${dbuser};
        GRANT ALL ON TABLE "${MKEOrganizationId}".access_log_sync_operations TO ${dbsuperuser};


        CREATE OR REPLACE FUNCTION "${MKEOrganizationId}".access_log_add_to_sync()
            RETURNS trigger
            LANGUAGE 'plpgsql'
            COST 100
            VOLATILE NOT LEAKPROOF
        AS $BODY$
        BEGIN
            INSERT INTO "${MKEOrganizationId}"."access_log_sync"
            (id, insertion, "timestamp", log, "userId", "accessPointId", "direction")
            VALUES
            (NEW.id, NEW."actionUtc", (NEW.log->>'u')::timestamp with time zone, NEW.log, (NEW.log->>'o')::uuid, (NEW.log->>'a')::uuid, (NEW.log->>'d')::smallint);

            INSERT INTO "${MKEOrganizationId}"."access_log_sync_operations"
            (id, timestamp, operation)
            VALUES
            (NEW.id, now(), ${app_enums_1.enums.MKESyncOperation.Added});
            RETURN NULL;
        END;
        $BODY$;

        ALTER FUNCTION "${MKEOrganizationId}".before_up_in_user_rule_history() OWNER TO ${dbsuperuser};
        GRANT EXECUTE ON FUNCTION "${MKEOrganizationId}".before_up_in_user_rule_history() TO ${dbsuperuser};
        GRANT EXECUTE ON FUNCTION "${MKEOrganizationId}".before_up_in_user_rule_history() TO PUBLIC;
        GRANT EXECUTE ON FUNCTION "${MKEOrganizationId}".before_up_in_user_rule_history() TO ${dbuser};

        CREATE TRIGGER trg_after_ins_access_log_add_to_sync
            AFTER INSERT
            ON "${MKEOrganizationId}"."access_logs"
            FOR EACH ROW
            EXECUTE FUNCTION "${MKEOrganizationId}".access_log_add_to_sync();
    `);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
