"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    -- FUNCTION: "___ORGANIZATION_ID___".before_up_del_regions()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_del_regions();
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            device_id_list	uuid[];
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    
                    SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL AND
                        racp."regionId" = OLD."id"
                    INTO device_id_list;
                    
                    IF (device_id_list IS NOT NULL) THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionT", "type", "data")
                        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                    END IF;
                    RETURN OLD;
                ELSE
                    IF (OLD."organizationId" != NEW."organizationId") THEN
                        RAISE EXCEPTION 'Organization ID of region cannot be changed!';
                    END IF;
                    IF (NEW.name IS DISTINCT FROM OLD.name OR
                       NEW."antiPassback" IS DISTINCT FROM OLD."antiPassback" OR
                       NEW."antiPassbackLockDuration" IS DISTINCT FROM OLD."antiPassbackLockDuration" OR
                       NEW."capacity" IS DISTINCT FROM OLD."capacity") THEN
                        SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        WHERE acp."deletedAt" IS NULL AND
                            racp."regionId" = OLD."id"
                        INTO device_id_list;
    
                        IF (device_id_list IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                        END IF;
                    END IF;
                    RETURN NEW;
                END IF;
    
            END;
    $BODY$;
    
    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        OWNER TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO PUBLIC;
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbuser};
    
    
    
    
  `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
    -- FUNCTION: "___ORGANIZATION_ID___".before_up_del_regions()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_del_regions();
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            device_id_list	uuid[];
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    
                    SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL AND
                        racp."regionId" = OLD."id"
                    INTO device_id_list;
                    
                    IF (device_id_list IS NOT NULL) THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionT", "type", "data")
                        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                    END IF;
                    RETURN OLD;
                ELSE
                    IF (OLD."organizationId" != NEW."organizationId") THEN
                        RAISE EXCEPTION 'Organization ID of region cannot be changed!';
                    END IF;
                    IF (NEW.name IS DISTINCT FROM OLD.name OR
                       NEW."antiPassback" IS DISTINCT FROM OLD."antiPassback" OR
                       NEW."antiPassbackLockDuration" IS DISTINCT FROM OLD."antiPassbackLockDuration" OR
                       NEW."capacity" IS DISTINCT FROM OLD."capacity") THEN
                        SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        WHERE acp."deletedAt" IS NULL AND
                            racp."regionId" = OLD."id"
                        INTO device_id_list;
    
                        IF (device_id_list IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                        END IF;
                    END IF;
                    RETURN NEW;
                END IF;
    
            END;
    $BODY$;
    
    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        OWNER TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO PUBLIC;
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbuser};
    
    

  `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
