"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    let query = `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"()
      RETURNS trigger
      LANGUAGE 'plpgsql'
      COST 100
      VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
      IF (TG_OP = 'UPDATE' AND NEW."parentId" IS DISTINCT FROM OLD."parentId") THEN
      WITH RECURSIVE c AS
      (
        SELECT id AS leaf, "parentId" AS parent, 0 AS n
        FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" t
        WHERE t."deletedAt" IS NULL
        UNION ALL
        SELECT leaf, t."parentId", c.n + 1
        FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" AS t
        INNER JOIN c ON c.parent = t.id
      )
      UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou
      SET "ancestorIds" = array_to_string(squ.ancestors, ',')
      FROM
      (
        SELECT * FROM
        (
          SELECT
            leaf AS id,
            array_agg(parent ORDER BY n DESC) FILTER (WHERE parent IS NOT NULL) as ancestors
          FROM c
          GROUP BY leaf
        ) sq
        WHERE NEW.id = ANY(sq.ancestors) OR NEW.id = sq.id
      ) squ
      WHERE ou.id = squ.id;
      END IF;
      RETURN NULL;
    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"()
      OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"() TO ${dbsuperuser};
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"() TO PUBLIC;
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"() TO ${dbuser};

    DROP TRIGGER IF EXISTS "update_ancestorIds_on_orgunit_parent_update_trigger" on "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}";

    CREATE TRIGGER "update_ancestorIds_on_orgunit_parent_update_trigger"
    AFTER UPDATE
    ON "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}"
    FOR EACH ROW
    EXECUTE FUNCTION "___ORGANIZATION_ID___"."update_ancestorIds_on_orgunit_parent_update"();
`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
