"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
        SELECT id FROM public."organizationList"
    `);
    const selfIdentityAccessNotification = 45;
    await Promise.all(organizationList.rows.map(async (organization) => await client.query(`
            UPDATE "${organization.id}".organizations
            SET settings = jsonb_insert(settings, '{notification, enabledTypes, -1}', '${selfIdentityAccessNotification}');

            ALTER TABLE "${organization.id}".notification_unsubscribe 
            DROP CONSTRAINT notification_unsubscribe_type_check;

            ALTER TABLE "${organization.id}".notification_unsubscribe
            ADD CONSTRAINT notification_unsubscribe_type_check CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,34,35,36,37,38,39,40,41,42,43,44,45,999}'::smallint[]));

        `)));
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    SELECT id FROM public."organizationList"
    `);
    const selfIdentityAccessNotification = 45;
    await Promise.all(organizationList.rows.map(async (organization) => await client.query(`
            UPDATE "${organization.id}".organizations
            SET settings = jsonb_set(settings, '{notification, enabledTypes}',(
                SELECT
                    array_to_json(array_agg("enabledTypes")::int[])::jsonb
                FROM 
                  (
                    select 
                      jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                    from "${organization.id}".organizations 
                    order by  jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
                  ) as T 
                WHERE 
                  "enabledTypes" != '${selfIdentityAccessNotification}')
            )
            
            ALTER TABLE "${organization.id}".notification_unsubscribe 
            DROP CONSTRAINT notification_unsubscribe_type_check;

            ALTER TABLE "${organization.id}".notification_unsubscribe
            ADD CONSTRAINT notification_unsubscribe_type_check CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,34,35,36,37,38,39,40,41,42,43,44,999}'::smallint[]));
    
            
            `)));
}
exports.down = down;
