"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    UPDATE "___ORGANIZATION_ID___".regions
    SET "visitorAccess" = true
    WHERE id = ANY(
        SELECT r.id FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationModules}" as om
        INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regions}" as r
            ON r."organizationId" = om."organizationId"
        WHERE om.module = 1 AND om."disableUtc" IS NULL AND om."status" = 1);
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
