"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
        CREATE OR REPLACE VIEW "___ORGANIZATION_ID___"."mVW_SearchUsers"
        AS
        SELECT uo.id,
            uo."isDisabled" AS "isDisabledForUserOrganization",
            uo."userId",
            uo."organizationId",
            COALESCE(string_agg(DISTINCT uop.name::text, ' '::text)) AS "userOrganizationProfileNameForOrder",
            COALESCE(string_agg(DISTINCT uop.surname::text, ' '::text)) AS "userOrganizationProfileSurnameForOrder",
            COALESCE(string_agg(DISTINCT uop."uniqueId"::text, ' '::text)) AS "userOrganizationProfileUniqueIdForOrder",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                FROM ( SELECT u.username) x)) FILTER (WHERE u.id IS NOT NULL), '[]'::json) AS "user",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                FROM ( SELECT uop."uniqueId",
                uop.name,
                uop.surname,
                uop.email) x)) FILTER (WHERE uop.id IS NOT NULL), '[]'::json) AS "userOrganizationProfile",
            COALESCE(string_agg(DISTINCT ug.id::character varying::text, ' '::text)) AS "userGroupIds",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                FROM ( SELECT ug.id,
                ug.name,
                ug."colorCode") x)) FILTER (WHERE ug.id IS NOT NULL), '[]'::json) AS "userGroups",
            COALESCE(string_agg(DISTINCT ou.id::character varying::text, ' '::text)) AS "organizationUnitIds",
            COALESCE(string_agg(( CASE WHEN ou."ancestorIds" IS NOT NULL THEN ou."ancestorIds"::text || ','::text ELSE '' END) || ou.id, ' '::text)) AS "organizationUnitHierarchies",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                FROM ( SELECT ou.id,
                ou.name,
                ou."typeId",
                ou."ancestorIds") x)) FILTER (WHERE ou.id IS NOT NULL), '[]'::json) AS "organizationUnits",
                (((((((setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(uop.name::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text))), 'A'::"char") || setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(uop.surname::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text))), 'A'::"char")) || setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(uop.address::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text))), 'D'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg(uop."phoneNumber"::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text)), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg(uop.email::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text)), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg(uop."uniqueId"::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text)), 'A'::"char")) || setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(uop."extensionFields"::text, ' '::text) FILTER (WHERE uop.id IS NOT NULL), ''::text))), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(ug.name::text, ' '::text) FILTER (WHERE ug.id IS NOT NULL), ''::text))), 'C'::"char")) || setweight(to_tsvector('simple'::regconfig, unaccent(COALESCE(string_agg(ou.name::text, ' '::text) FILTER (WHERE ou.id IS NOT NULL), ''::text))), 'C'::"char") AS "searchDocument"
        FROM "___ORGANIZATION_ID___"."userOrganizations" uo
            JOIN "___ORGANIZATION_ID___".users u ON uo."userId" = u.id AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
            JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop ON uo.id = uop."userOrganizationId" AND uo."deletedAt" IS NULL AND uop."deletedAt" IS NULL
            LEFT JOIN "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" uoou ON uo.id = uoou."userOrganizationId" AND uo."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
            LEFT JOIN "___ORGANIZATION_ID___"."organizationUnits" ou ON ou.id = uoou."organizationUnitId" AND ou."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
            LEFT JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" uguo ON uo.id = uguo."userOrganizationId" AND uo."deletedAt" IS NULL AND uguo."deletedAt" IS NULL
            LEFT JOIN "___ORGANIZATION_ID___"."userGroups" ug ON ug.id = uguo."userGroupId" AND ug."deletedAt" IS NULL AND uguo."deletedAt" IS NULL
        GROUP BY uo.id;
        
        ALTER TABLE "___ORGANIZATION_ID___"."mVW_SearchUsers"
        OWNER TO ${dbsuperuser};
        
        GRANT ALL ON TABLE "___ORGANIZATION_ID___"."mVW_SearchUsers" TO ${dbsuperuser};
        GRANT INSERT, SELECT, UPDATE, DELETE ON TABLE "___ORGANIZATION_ID___"."mVW_SearchUsers" TO ${dbuser};
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
