"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    INSERT INTO "___ORGANIZATION_ID___"."monthlySummaryReports"
	("id", "organizationId", "runDateTime", "isFinalized", "year", "month")
    SELECT uuid_generate_v4(),subq."organizationId", NULL as "runDateTime", false as "isFinalized", subq.year as year, subq.month as month
    FROM 
	(SELECT mr2.* FROM
		(
			SELECT extract('year' FROM mr.month) as year, extract('month' FROM mr.month) as month, mr."organizationId" FROM 
			(
				SELECT date_trunc('month', generate_series(om."enableUtc", COALESCE(om."disableUtc", date_trunc('month', now())), '1 month'::interval)) as month, om."organizationId" as "organizationId"
				FROM "___ORGANIZATION_ID___"."organizationModules" om WHERE module = 3
			) mr
			WHERE mr.month <> date_trunc('month', now())
		) mr2
	LEFT JOIN "___ORGANIZATION_ID___"."monthlySummaryReports" msr
	ON msr.year = mr2.year AND msr.month = mr2.month
	WHERE msr.id IS NULL
	ORDER BY year ASC, month ASC ) subq;


    INSERT INTO "___ORGANIZATION_ID___"."employeeMonths"
	(id, "date", "userId", "organizationId", "updatedAt", "isChecked", "data", "monthlyReportId")
	SELECT subq.*, msr.id as "monthlyReportId" FROM
		(
			SELECT
					uuid_generate_v4() as id,
			format('%s-%s-1', sq2.year, sq2.month):: date as date,
			sq2."userId", sq2."organizationId",
			now() as "createdAt",
			false as "isChecked",
			json_build_object(
				'p', array_remove(array_agg(DISTINCT sq2.plist), NULL),
				'w', array_to_json(array_agg(DISTINCT sq2.dlist)),
				'ew', SUM((sq2.data -> 's' -> 'ew'):: integer),
				'n', SUM((sq2.data -> 's' -> 'n'):: integer),
				'e', SUM((sq2.data -> 's' -> 'e'):: integer),
				'm', SUM((sq2.data -> 's' -> 'm'):: integer),
				'el', SUM((sq2.data -> 's' -> 'el'):: integer),
				'es', SUM((sq2.data -> 's' -> 'es'):: integer),
				'll', SUM((sq2.data -> 's' -> 'll'):: integer),
				'ls', SUM((sq2.data -> 's' -> 'ls'):: integer),
				'tel', SUM((sq2.data -> 's' -> 'tel'):: integer),
				'tes', SUM((sq2.data -> 's' -> 'tes'):: integer),
				'tll', SUM((sq2.data -> 's' -> 'tll'):: integer),
				'tls', SUM((sq2.data -> 's' -> 'tls'):: integer),
				'ao', SUM((sq2.data -> 's' -> 'ao'):: integer),
				'eo', SUM((sq2.data -> 's' -> 'eo'):: integer),
				'dw', SUM((sq2.data -> 's' -> 'dw'):: integer),
				'iw', SUM((sq2.data -> 's' -> 'iw'):: integer),
				'ufb', SUM((sq2.data -> 's' -> 'ufb'):: float),
				'afb', SUM((sq2.data -> 's' -> 'afb'):: float),
				'efb', SUM((sq2.data -> 's' -> 'efb'):: float),
				'ucb', SUM((sq2.data -> 's' -> 'ucb'):: float),
				'acb', SUM((sq2.data -> 's' -> 'acb'):: float),
				'ecb', SUM((sq2.data -> 's' -> 'ecb'):: float),
				'uh', SUM((sq2.data -> 's' -> 'uh'):: integer),
				'eh', SUM((sq2.data -> 's' -> 'eh'):: integer),
				'pr', SUM((sq2.data -> 's' -> 'pr'):: integer),
				's', SUM(CASE WHEN sq2.data->'s'->'s' is NULL THEN 0 ELSE (sq2.data->'s'->>'s')::integer END) / SUM(1)
			) as "calculatedData"
					FROM 
						(SELECT sq.*, ed."organizationId" as "organizationId", ed.data as data, d.list as dlist, pp.list as plist
						FROM (
							SELECT ed."userId" as "userId", extract(year FROM ed.date) as year, extract(month FROM ed.date) as month
							FROM "___ORGANIZATION_ID___"."employeeDays" ed
							WHERE extract (month from ed.date) <> extract(month from now())
							GROUP BY ed."userId", extract(year FROM ed.date), extract (month from ed.date)
						) sq
						LEFT JOIN "___ORGANIZATION_ID___"."employeeMonths" em
							ON em."userId" = sq."userId" AND extract(year FROM em.date) = sq.year AND extract(month FROM em.date) = sq.month
						INNER JOIN "___ORGANIZATION_ID___"."employeeDays" AS "ed"
							ON ed."userId" = sq."userId" AND extract(year from ed.date) = sq.year AND extract(month from ed.date) = sq.month
						CROSS JOIN LATERAL(
							SELECT string_agg(d.elem:: text, ', ') AS list
									FROM jsonb_array_elements_text(ed.data -> 'w') AS d(elem)
						) d
						LEFT JOIN LATERAL (
							select unnest(array_agg(DISTINCT ppermissions -> 'p'))  as list from jsonb_array_elements(ed.data -> 'p') as x(ppermissions)
						) pp ON TRUE					 
						WHERE em.id IS NULL
						ORDER BY sq."userId", sq.year ASC, sq.month ASC) sq2
					GROUP BY sq2."userId", sq2."organizationId", sq2.year, sq2.month	
		) subq					
		INNER JOIN "___ORGANIZATION_ID___"."monthlySummaryReports" as msr
			ON msr.year = extract(year from subq.date) AND msr.month = extract(month from subq.date);
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
