"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
        SELECT id FROM public."organizationList"
    `);
    await Promise.all(organizationList.rows.map(async (organization) => {
        await client.query(`
            UPDATE "${organization.id}".organizations
            SET "credentialTypes" = COALESCE(T2.credential, "credentialTypes")
            FROM (SELECT json_agg(to_json(element::jsonb || (('{"oneTimeAssignable": false}')::jsonb))) AS credential FROM (
                SELECT json_array_elements("credentialTypes") as element FROM "${organization.id}".organizations
                WHERE "credentialTypes"::text NOT ilike '%oneTimeAssignable%'
                ) AS T1 
            ) AS T2;
        `);
    }));
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
