"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___"."notification_unsubscribe"
	(
		"userId" uuid NOT NULL,
		token character (64) NOT NULL,
        type SMALLINT,
        UNIQUE("userId", type),
        CONSTRAINT notification_unsubscribe_type_check CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,34,35,36,37,38,39,40,41,42,43,44,999}'::smallint[]))
	)
	TABLESPACE pg_default;

    CREATE INDEX notification_unsubscribe_token ON "___ORGANIZATION_ID___".notification_unsubscribe USING HASH (token);

	ALTER TABLE "___ORGANIZATION_ID___"."notification_unsubscribe"
		OWNER to ${dbsuperuser};

	GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."notification_unsubscribe" TO ${dbuser};

	GRANT ALL ON TABLE "___ORGANIZATION_ID___"."notification_unsubscribe" TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
    DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."notification_unsubscribe";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
