"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    let query = `
    -- FUNCTION: "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()

    -- DROP FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change();
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        is_permission_approvements_states_completed boolean;
    BEGIN
    
        IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE' ) THEN
            SELECT bool_and("approvementDate" is not null) INTO is_permission_approvements_states_completed 
            FROM "___ORGANIZATION_ID___"."userPPermissionApprovements"
            WHERE "userId" = NEW."userId" and "ppermissionId" = NEW."ppermissionId";
            
            IF(is_permission_approvements_states_completed ) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                    (id, "userId", "organizationId", reason, "startDate")
                    SELECT uuid_generate_v4(), upp."userId", '"___ORGANIZATION_ID___"', 16,
                        LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
                    FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                    INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
                    INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                    INNER JOIN "___ORGANIZATION_ID___"."ppermissions" pp ON pp."id" = NEW."ppermissionId"
                    INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."ppermissionId" AND uwp."userId" = upp."userId"
                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND uo."deletedAt" IS NULL AND uo."isDisabled" = false;
                    
                   UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
                   FROM "___ORGANIZATION_ID___"."userPPermissions" upp
                   INNER JOIN "___ORGANIZATION_ID___"."ppermissions" pp ON upp."ppermissionId" = pp."id"
                   WHERE upp."ppermissionId" = NEW."ppermissionId" AND pp."id" = NEW."ppermissionId" AND eld."userId" = upp."userId"
                   AND (pp."startDateTime"::date <= now()::date);
                    
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
    $BODY$;
    
    ALTER FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()
        OWNER TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO PUBLIC;
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO ${dbuser};
    


    -- FUNCTION: "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change()

    -- DROP FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
        IF (TG_OP = 'INSERT') THEN
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
                UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
                FROM "___ORGANIZATION_ID___"."userPPermissions" upp
                WHERE upp."ppermissionId" = NEW."id" AND eld."userId" = upp."userId" AND eld."organizationId" = NEW."organizationId"
                AND (NEW."startDateTime"::date <= now()::date OR OLD."startDateTime"::date <= now()::date)
                -- Check if the dates changed
                AND (tstzRange(NEW."startDateTime", NEW."endDateTime") <> tstzRange(OLD."startDateTime", OLD."endDateTime"));

                INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
                INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE
                -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.
                    NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"));

                IF tstzRange(OLD."startDateTime", OLD."endDateTime") <> tstzRange(NEW."startDateTime", NEW."endDateTime") THEN
                    INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                    (id, "userId", "organizationId", reason, "startDate")
                    SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16,
                        LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                    FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                    INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
                    INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                    INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                        AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                    WHERE 
                    -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
                        NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")));
                END IF;
            RETURN NEW;
        ELSIF (TG_OP = 'DELETE') THEN
            UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM "___ORGANIZATION_ID___"."userPPermissions" upp
            WHERE upp."ppermissionId" = OLD."id" AND eld."userId" = upp."userId" AND eld."organizationId" = OLD."organizationId"
            AND OLD."startDateTime"::date <= now()::date;

            INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), upp."userId", OLD."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
            FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
            INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = OLD."id" AND uwp."userId" = upp."userId"
            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE 
            -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
                NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"));

            RETURN OLD;
        END IF;
    END;

    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change() TO ${dbuser};

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
