"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".update_terminaladmins()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        old_permissions		character varying(512);
        new_permissions		character varying(512);
        "roleChangeTriggerIsEnable" boolean;
        "terminalIds" uuid[];
        BEGIN
            IF (TG_OP = 'DELETE') THEN
                DELETE FROM "___ORGANIZATION_ID___"."terminalAdministrators" ta
                USING "___ORGANIZATION_ID___"."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."isDisabled" IS TRUE) THEN
                    DELETE FROM "___ORGANIZATION_ID___"."terminalAdministrators" ta
                    USING "___ORGANIZATION_ID___"."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                ELSIF (NEW."roleId" <> OLD."roleId")
                THEN
                    SELECT r.permissions INTO old_permissions FROM "___ORGANIZATION_ID___".roles r WHERE r.id = OLD."roleId";
                    SELECT r.permissions INTO new_permissions FROM "___ORGANIZATION_ID___".roles r WHERE r.id = NEW."roleId";
                    SELECT COALESCE((settings->'enableTriggerThrowErrorIfUserRoleChangeCauseTerminalHasNoWriteAdmin')::boolean, true) INTO "roleChangeTriggerIsEnable" 
                        FROM "___ORGANIZATION_ID___".organizations;
                    
                    IF ("roleChangeTriggerIsEnable" = TRUE) THEN
                        "terminalIds" := (SELECT array_agg(TA."terminalId") FROM (
							SELECT "terminalId", array_agg("userId") FILTER (WHERE write = true)  FROM "___ORGANIZATION_ID___"."terminalAdministrators"
							GROUP BY "terminalId"
							HAVING array_length(array_agg("userId") FILTER (WHERE write = true), 1) = 1 
							AND NEW."userId" = ANY((array_agg("userId") FILTER (WHERE write = true)))) TA);
                        IF (SELECT  array_length ("terminalIds", 1	) > 0) THEN
                            RAISE EXCEPTION 'prevent_terminal_has_no_write_admin: %', "terminalIds";
                        END IF;
                    END IF;
                    
                    IF(POSITION('s:r' IN old_permissions) > 0 AND POSITION('s:r' IN new_permissions) = 0)
                    THEN
                        DELETE FROM "___ORGANIZATION_ID___"."terminalAdministrators" ta
                        USING "___ORGANIZATION_ID___"."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                    END IF;
                    
                    IF(POSITION('s:w' IN old_permissions) > 0 AND POSITION('s:w' IN new_permissions) = 0)
                    THEN
                        UPDATE "___ORGANIZATION_ID___"."terminalAdministrators" ta SET write = false
                        FROM "___ORGANIZATION_ID___"."devices" d WHERE d.id = ta."terminalId" AND d."organizationId" = NEW."organizationId" AND ta."userId" = NEW."userId";
                    END IF;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $BODY$;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
