"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    let q = `
    -- Iki tablo icin gecici tablo kopyasi ac
    CREATE TEMPORARY TABLE "___ORGANIZATION_ID____tempTerminalChanges" ON COMMIT DROP AS SELECT * FROM "___ORGANIZATION_ID___"."terminalChanges";
    CREATE TEMPORARY TABLE "___ORGANIZATION_ID____tempTerminalChangeTransactions" ON COMMIT DROP AS SELECT * FROM "___ORGANIZATION_ID___"."terminalChangeTransactions";
    
    -- yeni transaction id icin sutun ekle
	ALTER TABLE "___ORGANIZATION_ID____tempTerminalChanges" ADD COLUMN bigintid BIGINT;

    -- yeni transactionId'leri olustur
	UPDATE "___ORGANIZATION_ID____tempTerminalChanges" ttc
	SET bigintid = T.randomint
	FROM (
		SELECT DISTINCT ("transactionId"), floor(random() * 10000000000) AS randomint FROM "___ORGANIZATION_ID____tempTerminalChanges"
	) AS T WHERE T."transactionId" = ttc."transactionId";

	-- eski tablolari bosalt
	TRUNCATE TABLE "___ORGANIZATION_ID___"."terminalChanges" CASCADE;
	TRUNCATE TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" CASCADE;

	-- eski tablolarin sutunlarini duzenle
	ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" RENAME COLUMN "actionDateISO" TO "actionT";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ALTER COLUMN "actionT" TYPE TIMESTAMP WITHOUT TIME ZONE;
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" RENAME COLUMN "sessionExpirationISO" TO "sessionExpirationT";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ALTER COLUMN "sessionExpirationT" TYPE TIMESTAMP WITHOUT TIME ZONE;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" DROP COLUMN "transactionId";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ADD COLUMN "transactionId" BIGINT NOT NULL;
    


    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" RENAME COLUMN "createdAt" TO "actionT";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" ALTER COLUMN "actionT" TYPE TIMESTAMP WITHOUT TIME ZONE;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" DROP COLUMN "transactionId";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" ADD COLUMN "transactionId" BIGINT NOT NULL;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" 
    ADD CONSTRAINT "terminalChangeTransactions_transactionId_actionT_deviceId_key" UNIQUE ("transactionId", "actionT", "deviceId");
	
    -- terminalChanges tablosuna insert etmeden once trigger'i guncellemeliyiz
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
            INSERT INTO "___ORGANIZATION_ID___"."terminalChangeTransactions"
            ("transactionId", "deviceId", "actionT")
            VALUES (NEW."transactionId", NEW."deviceId", NEW."actionT")
            ON CONFLICT ON CONSTRAINT "terminalChangeTransactions_transactionId_actionT_deviceId_key" DO NOTHING;

            RETURN NULL;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO ${dbuser};

	-- yeni transactionId'ler ile insert et
	INSERT INTO "___ORGANIZATION_ID___"."terminalChanges" ("id", "transactionId", "deviceId", "actionT", "type", "data")
	SELECT "id", "bigintid" as "transactionId", "deviceId", "actionDateISO", "type", "data" 
	FROM "___ORGANIZATION_ID____tempTerminalChanges";
	-- terminalChangeTransactions insertleri triggerdan halloluyor
    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id	bigint;
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'UPDATE') THEN
                    IF (NEW.settings->'webRtc' != OLD.settings->'webRtc') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionT", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, T."proxyTerminalId", now(), 3, '{}'::json FROM
                        (SELECT DISTINCT "proxyTerminalId" FROM "___ORGANIZATION_ID___"."cameras") as T;
                        PERFORM PG_NOTIFY('webrtc_ice_servers', JSON_BUILD_OBJECT('id', NEW.id)::text);								  		
                    END IF;	
                END IF;	
                PERFORM PG_NOTIFY('organization_settings_changed', TG_TABLE_SCHEMA);
            RETURN NEW;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbuser};
    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id_list	uuid[];
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                
                SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                WHERE acp."deletedAt" IS NULL AND
                    racp."regionId" = OLD."id"
                INTO device_id_list;
                
                IF (device_id_list IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                END IF;
                RETURN OLD;
            ELSE
                IF (OLD."organizationId" != NEW."organizationId") THEN
                    RAISE EXCEPTION 'Organization ID of region cannot be changed!';
                END IF;
                SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                WHERE acp."deletedAt" IS NULL AND
                    racp."regionId" = OLD."id"
                INTO device_id_list;
                
                IF (device_id_list IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                END IF;
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_user()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			bigint;
        user_id	uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_id:= OLD."id";
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    -- GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE u."id" = user_id
                        --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                    RETURN NEW;
                ELSIF (NEW."publicKey" = OLD."publicKey")
                THEN
                    RETURN NEW;
                ELSE
                        user_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                    FROM
                    (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', u."id",
                        'roleId', uo."roleId",
                        'isDisabled', uo."isDisabled",
                        'publicKey', NEW."publicKey",
                        'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                        OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                    ) AS "data" FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_user()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			bigint;
        user_organization_id	uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."id";
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                    RETURN NEW;
                ELSIF (NEW."roleId" != OLD."roleId" OR NEW."isDisabled" != OLD."isDisabled")
                THEN
                    user_organization_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                    FROM
                    (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', u."id",
                        'roleId', NEW."roleId",
                        'isDisabled', NEW."isDisabled",
                        'publicKey', u."publicKey",
                        'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                        OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                    ) AS "data" FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id			bigint;
                    i 						jsonb;
                    j 						jsonb;
                    l 						jsonb;
                    new_available_factors		jsonb;
                    factors_in_other_acps		jsonb;
                    old_available_factors		jsonb;
                    new_added_factors			jsonb;
                    removed_factors				jsonb;
                    factors_to_send_to_device		jsonb;
                    t1					jsonb;
                BEGIN
            
                    transaction_id := txid_current();
                    new_available_factors := '[]'::jsonb;
                    factors_in_other_acps := '[]'::jsonb;
                    old_available_factors := '[]'::jsonb;
                    new_added_factors := '[]'::jsonb;
                    removed_factors := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    
                    IF (TG_OP = 'DELETE') THEN
                    
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                    
                        IF NEW."organizationId" != OLD."organizationId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                        END IF;
        
                        IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF NEW."deviceId" != OLD."deviceId" THEN
                                RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                        END IF;
        
                        IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                            RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                        END IF;
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                new_available_factors:= new_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                old_available_factors:= old_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = NEW."deviceId"
                            AND acp."id" != NEW."id"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1:= jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                    IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                    THEN
                                        factors_in_other_acps:= factors_in_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
        
                        -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (new_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                            LOOP
                                IF (POSITION (i::text IN old_available_factors::text) < 1)
                                THEN
                                    new_added_factors:= new_added_factors || i;
                                END IF;
                            END LOOP;
                        END IF;
        
                        -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (old_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                            LOOP
                                IF (POSITION (i::text IN new_available_factors::text) < 1)
                                THEN
                                    removed_factors:= removed_factors || i;
                                END IF;
                            END LOOP; 
                        END IF;
        
                        -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                        IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                    AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                            OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                            OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
        
                        )
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        END IF;
        
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                        THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                            LOOP
                                IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionT", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uar."accessControlPointId" = NEW."id"
                            AND uar."deletedAt" IS NULL 
                            AND uoc."deletedAt" IS NULL
                            AND uoc."organizationId" = NEW."organizationId"
                            AND uar."access" = TRUE
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
                    RETURN NEW;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            camera_id 		uuid;
            proxy_terminal_id 		uuid;
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    camera_id:= OLD."id";
                    proxy_terminal_id:= OLD."proxyTerminalId";
                ELSE
                    camera_id:= NEW."id";
                    proxy_terminal_id:= NEW."proxyTerminalId";
                END IF;
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
                FROM "___ORGANIZATION_ID___"."cameras" AS c
                INNER JOIN "___ORGANIZATION_ID___"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, proxy_terminal_id, now(), 3, '{}'::json;
                IF (TG_OP = 'DELETE') THEN
                    RETURN OLD;
                ELSE
                    RETURN NEW;
                END IF;

            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO ${dbuser};
    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        camera_id 		uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                camera_id:= OLD."cameraId";
            ELSE
                camera_id:= NEW."cameraId";
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
            FROM "___ORGANIZATION_ID___"."cameras" AS c
            INNER JOIN "___ORGANIZATION_ID___"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO ${dbuser};
    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            device_id 		uuid;
            main_device_id 		uuid;
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    device_id:= OLD."deviceId";
                ELSE
                    device_id:= NEW."deviceId";
                END IF;
                
                SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
                WHERE h."deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                        
                SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
                WHERE h."deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT "integratedDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."deviceIntegrations" WHERE "integratingDeviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
        
                IF (TG_OP = 'DELETE') THEN
                    RETURN OLD;
                ELSE
                    RETURN NEW;
                END IF;
        
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO ${dbuser};
    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id 	bigint;
                res 			text;
                BEGIN
                    transaction_id := txid_current();
                    IF (TG_OP = 'DELETE') THEN
                        IF (OLD."targetUserId" IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', OLD."id"
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                WHERE uo."userId" = OLD."targetUserId"
                                    AND uo."deletedAt" IS NULL
                                    AND u."deletedAt" IS NULL
                                    AND uar."deletedAt" IS NULL
                                    AND acp."deletedAt" IS NULL
                                    AND racp."regionId" = OLD."regionId"
                            ) AS T
                            WHERE T."row_num" = 1;
                        ELSE
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', OLD."id"
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                                WHERE racp."regionId" = OLD."regionId"
                                    AND  acp."deletedAt" IS NULL
                            ) AS T
                            WHERE T."row_num" = 1;
                        END IF;
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', to_jsonb(row_to_json(OLD)),
                            'new', null
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_access', res);                
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
                        -- access notification for single user
                        IF (NEW."targetUserId" IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', NEW."id",
                                    't', NEW."targetUserId",
                                    'r', NEW."regionId",
                                    's', NEW.options->'success',
                                    'd', NEW.options->'direction'
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                WHERE uo."userId" = NEW."targetUserId"
                                    AND uo."deletedAt" IS NULL
                                    AND u."deletedAt" IS NULL
                                    AND uar."deletedAt" IS NULL
                                    AND acp."deletedAt" IS NULL
                                    AND racp."regionId" = NEW."regionId"
                            ) AS T
                            WHERE T."row_num" = 1;
                        -- access notification all users
                        ELSE
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', NEW."id",
                                    't', NEW."targetUserId",
                                    'r', NEW."regionId",
                                    's', NEW.options->'success',
                                    'd', NEW.options->'direction'
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                                WHERE racp."regionId" = NEW."regionId"
                                    AND  acp."deletedAt" IS NULL
                            ) AS T
                            WHERE T."row_num" = 1;
                        END IF;
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
                            'new', to_jsonb(row_to_json(NEW))
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_access', res);
                        RETURN NEW;
                    END IF;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id	bigint;
                access_control_point_id uuid;
                    res	text;
                BEGIN
                    transaction_id := txid_current();
                    IF (TG_OP = 'DELETE') THEN
                        access_control_point_id:= OLD."accessControlPointId";
                    ELSE
                        access_control_point_id:= NEW."accessControlPointId";
                    END IF;
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;
                    
                    IF (TG_OP = 'DELETE') THEN
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', to_jsonb(row_to_json(OLD)),
                            'new', null
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_sensor', res);
                        RETURN OLD;
                    ELSE
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
                            'new', to_jsonb(row_to_json(NEW))
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_sensor',res);            
                        RETURN NEW;
                    END IF;    
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            credential_exists	boolean;
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                        -- 2 for BLE, 8 for NFC, 12 for QR
                    END IF;
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                    SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
                        "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."deletedAt" IS NULL AND
                                uoc."userId" = NEW."userId" AND
                                (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
                    INTO credential_exists;
                    IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
                    -- delete credentials
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                        RETURN NEW;
                    ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
                        (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR
                        credential_exists = false AND NEW."oAuthClientId" IS NOT NULL AND NEW."deletedAt" IS NULL) THEN
                    -- delete old credentials
                    -- insert new credentials
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
        
                        RETURN NEW;
                    ELSE
        
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    -- check existing credentials
                    SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
                        "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."deletedAt" IS NULL AND
                                uoc."userId" = NEW."userId" AND
                                (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
                    INTO credential_exists;
                    -- if no credentials present, then create 2 credentials for BLE and NFC
                    IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
                    
                    
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
        
                    END IF;
                END IF;
                RETURN NEW;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id		uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                SELECT "deviceId" 
                FROM "___ORGANIZATION_ID___"."accessControlPoints"
                WHERE "deletedAt" IS NULL AND "id" = OLD."accessControlPointId"
                INTO device_id;
            ELSIF (TG_OP = 'UPDATE') THEN
                RAISE EXCEPTION 'Illegal operation to update region/accessControlPoint mapping';
            ELSE
                SELECT "deviceId" 
                FROM "___ORGANIZATION_ID___"."accessControlPoints"
                WHERE "deletedAt" IS NULL AND "id" = NEW."accessControlPointId"
                INTO device_id;
            END IF;
            
            IF (device_id IS NOT NULL) THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
            END IF;
            
            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id				bigint;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                IF (OLD."targetUserId" IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', OLD."id"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE uo."userId" = OLD."targetUserId"
                            AND uo."organizationId" = OLD."organizationId"
                            AND uo."deletedAt" IS NULL
                            AND u."deletedAt" IS NULL
                            AND uar."deletedAt" IS NULL
                            AND acp."deletedAt" IS NULL
                            AND racp."regionId" = OLD."regionId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSE
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', OLD."id"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                        WHERE acp."organizationId" = OLD."organizationId"
                            AND racp."regionId" = OLD."regionId"
                            AND  acp."deletedAt" IS NULL
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
                -- access notification for single user
                IF (NEW."targetUserId" IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', NEW."id",
                            't', NEW."targetUserId",
                            'r', NEW."regionId",
                            's', NEW."success",
                            'd', NEW."direction"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE uo."userId" = NEW."targetUserId"
                            AND uo."organizationId" = NEW."organizationId"
                            AND uo."deletedAt" IS NULL
                            AND u."deletedAt" IS NULL
                            AND uar."deletedAt" IS NULL
                            AND acp."deletedAt" IS NULL
                            AND racp."regionId" = NEW."regionId"
                    ) AS T
                    WHERE T."row_num" = 1;
                -- access notification all users
                ELSE
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', NEW."id",
                            't', NEW."targetUserId",
                            'r', NEW."regionId",
                            's', NEW."success",
                            'd', NEW."direction"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                        WHERE acp."organizationId" = NEW."organizationId"
                            AND racp."regionId" = NEW."regionId"
                            AND  acp."deletedAt" IS NULL
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id		bigint;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := txid_current();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionT', arh."createdDate"
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionT', arh."createdDate"
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id		bigint;
                    user_id				uuid;
                    BEGIN
                        transaction_id := txid_current();
                        IF (TG_OP = 'DELETE') THEN
                            user_id:= OLD."userId";
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                        JSON_BUILD_OBJECT(
                                        'id', OLD."id"
                                    ) AS "data"
                                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            RETURN OLD;
                        ELSIF (TG_OP = 'INSERT') THEN
                            user_id:= NEW."userId";
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                        JSON_BUILD_OBJECT(
                                        'id', NEW."id",
                                        'userId', user_id,
                                        'regionId', NEW."regionId",
                                        'credentialIds', NEW."credentialIds",
                                        'startDateISO', NEW."startUtc",
                                        'endDateISO', NEW."endUtc"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            RETURN NEW;
                        ELSIF (TG_OP = 'UPDATE') THEN
                            user_id:= NEW."userId";
                            IF (NEW."startUtc" != OLD."startUtc" OR 
                                NEW."endUtc" != OLD."endUtc" OR
                                NEW."regionId" != OLD."regionId" OR 
                                (NEW."credentialIds" IS NULL AND OLD."credentialIds" IS NOT NULL) OR
                                (OLD."credentialIds" IS NULL AND NEW."credentialIds" IS NOT NULL) OR
                                (SELECT array_agg(d) !=  (
                                    SELECT array_agg(d) AS list
                                    FROM json_array_elements_text(NEW."credentialIds") AS d
                                ) 
                                FROM json_array_elements_text(OLD."credentialIds") AS d)
                            )
                            THEN
                                --first remove old forbiddance
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                    JSON_BUILD_OBJECT(
                                        'id', OLD."id"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                                --then add new forbiddance
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() + interval '500 milliseconds' , 17, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                    JSON_BUILD_OBJECT(
                                        'id', NEW."id",
                                        'userId', user_id,
                                        'regionId', NEW."regionId",
                                        'credentialIds', NEW."credentialIds",
                                        'startDateISO', NEW."startUtc",
                                        'endDateISO', NEW."endUtc"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            END IF;
                            RETURN NEW;
                        END IF;
                    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			bigint;
        user_organization_id	uuid;
        group_id				uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."userOrganizationId";
                group_id:= OLD."userGroupId";
                IF (OLD."deletedAt" IS NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                            JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                            FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'INSERT') THEN

                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', '[]'::json,
                            'addedUserIds',  ('["' || u."id" || '"]')::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id	bigint;
                    t_factors		text;
                    factors 		text[];
                    credential_one_time_assignable_status boolean;
                    organization_license_settings	jsonb;
                    active_credential_count	integer;
                    base_module_max_count	integer;
                    BEGIN
                        transaction_id := txid_current();
                        IF (TG_OP = 'DELETE') THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                                JSON_BUILD_OBJECT('id', OLD."id")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                            WHERE T."row_num" = 1;
                            RETURN OLD;
                        ELSIF (TG_OP = 'UPDATE') THEN
                            IF NEW."userId" != OLD."userId"
                            OR NEW."organizationId" != OLD."organizationId"
                            OR NEW."type" != OLD."type"
                            OR NEW."data" != OLD."data"
                            OR NEW."specialData" != OLD."specialData"
                            OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
                            THEN
                                RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
                            END IF;

                            ----- One Time Assignable setting, support added for METU UHF credentials!
                            IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
                            THEN
                                credential_one_time_assignable_status := (
                                    SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                                        THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                                    FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                                    WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                                );
                                IF(credential_one_time_assignable_status IS TRUE) THEN
                                        RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                                END IF;
                            END IF;	
                            ----- One Time Assignable setting, support added for METU UHF credentials!
                            
                            ----- License limit control logic!
                            IF (
                                NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                                    INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    ON uo."roleId" = r.id
                                    WHERE uo."deletedAt" IS NULL AND
                                        r."deletedAt" IS NULL AND
                                        NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                AND 
                                (
                                    (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR 
                                    (NEW."expiresOn" IS NULL AND OLD."expiresOn" IS NOT NULL) OR
                                    (NEW."expiresOn" IS NOT NULL AND NEW."expiresOn" > now())
                                ) 
                            )
                            THEN
                                SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                                FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                            
                                IF ((organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 ) THEN
                                    
                                    SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 
                                    COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                        ON uo."userId" = uoc."userId"
                                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                                        ON r."id" = uo."roleId"
                                    WHERE uoc."deletedAt" IS NULL
                                        AND ("expiresOn" IS NULL OR "expiresOn" > now())
                                        AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                        AND uo."deletedAt" IS NULL
                                        AND r."deletedAt" IS NULL
                                        AND uo."isDisabled" = FALSE;
                                    
                                    SELECT "maxCredentialCount" INTO base_module_max_count
                                        FROM "___ORGANIZATION_ID___"."organizationModules"
                                        WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                                    IF (active_credential_count >= 
                                        base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                                        RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                                    END IF;
                                END IF;
                            END IF;
                            ----- License limit control logic!
                                
                            IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
                            THEN							
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                                JSON_BUILD_OBJECT('id', OLD."id")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL  AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                                WHERE T."row_num" = 1;
                            END IF;
                
                            IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
                                OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
                                NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
                                        AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
                                    JSON_BUILD_OBJECT(	'id', OLD."id", 
                                                            'expiresOnISO', NEW."expiresOn",
                                                            'groupNumber', NEW."groupNumber",
                                                            'extensionFields', NEW."extensionFields")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                                WHERE T."row_num" = 1;
                            END IF;
                        ELSIF (TG_OP = 'INSERT') THEN
                            IF (NEW."deletedAt" IS NULL)
                            THEN
                            
                                ----- One Time Assignable setting, support added for METU UHF credentials!
                                credential_one_time_assignable_status := (
                                    SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                                        THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                                    FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                                    WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                                );
                                IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                            WHERE "type" = NEW."type" AND "data" = NEW."data"
                                            AND "organizationId" = NEW."organizationId"
                                            AND "deletedAt" IS NULL
                                            AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
                                                RAISE EXCEPTION '20002'; -- Check appweb ErrorCode enums for detail
                                    ELSIF(credential_one_time_assignable_status IS TRUE AND 
                                        EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
                                            RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                                END IF;
                                
                                ----- One Time Assignable setting, support added for METU UHF credentials!

                                ----- Delete old mobile credentials to prevent duplicates!
                                IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                    WHERE "type" = NEW."type" AND "data" = NEW."data"
                                    AND "organizationId" = NEW."organizationId"
                                    AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
                                    
                                    UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
                                    WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
                                        AND "type" = NEW."type" AND "deletedAt" IS NULL;
                                END IF;
                                ----- Delete old mobile credentials to prevent duplicates!
                                
                                ----- License limit control logic!
                                SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                                FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                            
                                IF (
                                    NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                                    INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    ON uo."roleId" = r.id
                                    WHERE uo."deletedAt" IS NULL AND
                                        r."deletedAt" IS NULL AND
                                        NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                    AND 
                                    (organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 
                                ) THEN
                                    
                                    SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 	-- mobile credentials
                                    COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                        ON uo."userId" = uoc."userId"
                                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                                        ON r."id" = uo."roleId"
                                    WHERE uoc."deletedAt" IS NULL
                                        AND ("expiresOn" IS NULL OR "expiresOn" > now())
                                        AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[]) -- visitor type id's
                                        AND uo."deletedAt" IS NULL
                                        AND r."deletedAt" IS NULL
                                        AND uo."isDisabled" = FALSE;
                                    
                                    SELECT "maxCredentialCount" INTO base_module_max_count
                                        FROM "___ORGANIZATION_ID___"."organizationModules"
                                        WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                                    IF (active_credential_count >= 
                                        base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                                        RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                                    END IF;
                                END IF;
                                ----- License limit control logic!

                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
                                NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
                                FROM
                                    (SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                        FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                        AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
                                        AND NEW."organizationId" = acp."organizationId" AND uar."access" = true
                                        WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
                                        ) AS T2
                                    WHERE T2.row_num=1
                                    ) AS T;
                            END IF;
                        END IF;
                        RETURN NEW;
                    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        access_control_point_id 		uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                access_control_point_id:= OLD."accessControlPointId";
            ELSE
                access_control_point_id:= NEW."accessControlPointId";
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id		bigint;
        user_id				uuid;
        region_ticket_id	uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_id:= OLD."userId";
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', 0
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
                    WHERE
                        rt."deletedAt" IS NULL AND
                        rt."organizationId" = OLD."organizationId" AND
                        uar."userId" = OLD."userId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'INSERT') THEN

                user_id:= NEW."userId";

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', NEW."remainingUnits"
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
                    WHERE
                        rt."deletedAt" IS NULL AND
                        rt."organizationId" = NEW."organizationId" AND
                        uar."userId" = NEW."userId"
                    --FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    --INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    --INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    --INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    --INNER JOIN "___ORGANIZATION_ID___"."regionTickets" AS rt ON rt."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    --WHERE uo."organizationId" = NEW."organizationId" AND u."id" = NEW."userId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (TG_OP = 'UPDATE') THEN
                user_id:= NEW."userId";

                IF (NEW."remainingUnits" != OLD."remainingUnits" AND NOT NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits")
                THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userIds', ('["' || user_id || '"]')::json,
                            'amount', NEW."lastUpdateAmount"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
                        WHERE
                            rt."deletedAt" IS NULL AND
                            rt."organizationId" = NEW."organizationId" AND
                            uar."userId" = NEW."userId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSIF (NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits"
                        AND NEW."lastUpdateAccessControlPointId" IS NOT NULL)
                THEN
                    SELECT rt."id" INTO region_ticket_id
                    FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = NEW."lastUpdateAccessControlPointId"
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id" AND racp."regionId" = rt."regionId"
                    WHERE rt."deletedAt" IS NULL AND acp."deletedAt" IS NULL;

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 13, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userId', user_id,
                            'ticketId', region_ticket_id,
                            'amount', (OLD."remainingUnits" - NEW."remainingUnits")
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
                        WHERE
                            rt."deletedAt" IS NULL AND
                            rt."organizationId" = NEW."organizationId" AND
                            uar."userId" = NEW."userId" AND
                            acp."id" != NEW."lastUpdateAccessControlPointId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id_list  uuid[];
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                SELECT T."deviceId"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = OLD."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = OLD."organizationId"
                            AND OLD."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1
                INTO device_id_list;
            ELSIF (TG_OP = 'UPDATE') THEN
                SELECT ARRAY_AGG(T."deviceId")
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                            WHERE racp."regionId" = NEW."regionId" OR racp."regionId" = OLD."regionId"
                                AND acp."deletedAt" IS NULL
                                AND acp."organizationId" = NEW."organizationId"
                    ) AS T
                    WHERE T."row_num" = 1
                INTO device_id_list;
            ELSE
                SELECT ARRAY_AGG(T."deviceId")
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                            WHERE racp."regionId" = NEW."regionId"
                                AND acp."deletedAt" IS NULL
                                AND acp."organizationId" = NEW."organizationId"
                    ) AS T
                    WHERE T."row_num" = 1
                INTO device_id_list;
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id_list  uuid[];
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                        WHERE acp."deletedAt" IS NULL
                            AND ars."deletedAt" IS NULL
                            AND acp."organizationId" = ars."organizationId"
                            AND OLD."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1
                INTO device_id_list;
            ELSE
                SELECT ARRAY_AGG(T."deviceId")
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                        WHERE acp."deletedAt" IS NULL
                            AND ars."deletedAt" IS NULL
                            AND acp."organizationId" = ars."organizationId"
                    ) AS T
                    WHERE T."row_num" = 1
                INTO device_id_list;
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        device_id_list  uuid[];
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        WHERE acp."deletedAt" IS NULL
                            AND acp."organizationId" = OLD."organizationId"
                            AND racp."regionId" = OLD."regionId"
                            AND OLD."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1
                INTO device_id_list;
            ELSE
                SELECT ARRAY_AGG(T."deviceId")
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                        WHERE acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                            AND racp."regionId" = NEW."regionId"
                    ) AS T
                    WHERE T."row_num" = 1
                INTO device_id_list;
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionT", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	bigint;
            device_id_list  uuid[];
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'DELETE') THEN
                    SELECT ARRAY_AGG(T."deviceId")
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                            INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                            WHERE acp."deletedAt" IS NULL
                                AND ars."deletedAt" IS NULL
                                AND acp."organizationId" = ars."organizationId"
                    ) AS T
                    WHERE T."row_num" = 1
                    INTO device_id_list;
                ELSE
                    IF (TG_OP = 'UPDATE' 
                        AND OLD."id" = NEW."id" 
                        AND OLD."userGroupId" = NEW."userGroupId" 
                        AND OLD."accessRuleSetId" = NEW."accessRuleSetId") THEN
                        RETURN NEW;
                    END IF;
                    SELECT ARRAY_AGG(T."deviceId")
                        FROM
                        (
                            SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                            INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                            WHERE acp."deletedAt" IS NULL
                                AND ars."deletedAt" IS NULL
                                AND acp."organizationId" = ars."organizationId"
                        ) AS T
                        WHERE T."row_num" = 1
                    INTO device_id_list;
                END IF;
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
        
                IF (TG_OP = 'DELETE') THEN
                    RETURN OLD;
                ELSE
                    RETURN NEW;
                END IF;
        
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO ${dbuser};


    `;
    q += `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_update_devices()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        BEGIN
            transaction_id := txid_current();
            IF (NEW."name" != OLD."name" OR NEW."location" != OLD."location")
            THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, NEW."id", now(), 3, '{}'::json);
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_update_devices()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO ${dbuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    let q = `
	-- tablolari bosalt. Iki tablodaki veriler kaybolacak. Manual kontrol gerekiyor
	TRUNCATE TABLE "___ORGANIZATION_ID___"."terminalChanges" CASCADE;
	TRUNCATE TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" CASCADE;

	-- tablolarin sutunlarini duzenle
	ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" RENAME COLUMN "actionT" TO "actionDateISO";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ALTER COLUMN "actionDateISO" TYPE TIMESTAMP WITH TIME ZONE;
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" RENAME COLUMN "sessionExpirationT" TO "sessionExpirationISO";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ALTER COLUMN "sessionExpirationISO" TYPE TIMESTAMP WITH TIME ZONE;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" DROP COLUMN "transactionId";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChanges" ADD COLUMN "transactionId" UUID NOT NULL;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" RENAME COLUMN "actionT" TO "createdAt";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" ALTER COLUMN "createdAt" TYPE TIMESTAMP WITH TIME ZONE;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" DROP COLUMN "transactionId";
    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" ADD COLUMN "transactionId" UUID NOT NULL;

    ALTER TABLE "___ORGANIZATION_ID___"."terminalChangeTransactions" 
    ADD CONSTRAINT "terminalChangeTransactions_pkey" UNIQUE ("transactionId", "deviceId");
    `;
    q += `
        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        BEGIN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChangeTransactions"
                ("transactionId", "deviceId", "actionT")
                VALUES (NEW."transactionId", NEW."deviceId", NEW."actionT")
                ON CONFLICT ON CONSTRAINT "terminalChangeTransactions_pkey" DO NOTHING;

                RETURN NULL;
            END;
        $BODY$;

        ALTER FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change()
            OWNER TO ${dbsuperuser};

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO ${dbsuperuser};

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO PUBLIC;

        GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_insert_terminal_change() TO ${dbuser};
    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.after_up_del_organization()

-- DROP FUNCTION "___ORGANIZATION_ID___".after_up_del_organization();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id	uuid;
            BEGIN
                transaction_id := uuid_generate_v4();
                IF (TG_OP = 'UPDATE') THEN
                    IF (NEW.settings->'webRtc' != OLD.settings->'webRtc') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, T."proxyTerminalId", now(), 3, '{}'::json FROM
                        (SELECT DISTINCT "proxyTerminalId" FROM "___ORGANIZATION_ID___"."cameras") as T;
                        PERFORM PG_NOTIFY('webrtc_ice_servers', JSON_BUILD_OBJECT('id', NEW.id)::text);								  		
                    END IF;	
                END IF;	
                PERFORM PG_NOTIFY('organization_settings_changed', TG_TABLE_SCHEMA);
            RETURN NEW;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbuser};

    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_del_regions()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_del_regions();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        device_id_list	uuid[];
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                
                SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                WHERE acp."deletedAt" IS NULL AND
                    racp."regionId" = OLD."id"
                INTO device_id_list;
                
                IF (device_id_list IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                END IF;
                RETURN OLD;
            ELSE
                IF (OLD."organizationId" != NEW."organizationId") THEN
                    RAISE EXCEPTION 'Organization ID of region cannot be changed!';
                END IF;
                SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                WHERE acp."deletedAt" IS NULL AND
                    racp."regionId" = OLD."id"
                INTO device_id_list;
                
                IF (device_id_list IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
                END IF;
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_regions()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_regions() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_del_user()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_del_user();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_user()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			uuid;
        user_id	uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                user_id:= OLD."id";
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    -- GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE u."id" = user_id
                        --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                    RETURN NEW;
                ELSIF (NEW."publicKey" = OLD."publicKey")
                THEN
                    RETURN NEW;
                ELSE
                        user_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                    FROM
                    (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', u."id",
                        'roleId', uo."roleId",
                        'isDisabled', uo."isDisabled",
                        'publicKey', NEW."publicKey",
                        'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                        OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                    ) AS "data" FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_user()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_del_user_organizations()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			uuid;
        user_organization_id	uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."id";
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT('id', u."id") AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                    RETURN NEW;
                ELSIF (NEW."roleId" != OLD."roleId" OR NEW."isDisabled" != OLD."isDisabled")
                THEN
                    user_organization_id:= NEW."id";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                    FROM
                    (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', u."id",
                        'roleId', NEW."roleId",
                        'isDisabled', NEW."isDisabled",
                        'publicKey', u."publicKey",
                        'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                        OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                    ) AS "data" FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id"
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_del_user_organizations() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_access_control_point()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id			uuid;
                    i 						jsonb;
                    j 						jsonb;
                    l 						jsonb;
                    new_available_factors		jsonb;
                    factors_in_other_acps		jsonb;
                    old_available_factors		jsonb;
                    new_added_factors			jsonb;
                    removed_factors				jsonb;
                    factors_to_send_to_device		jsonb;
                    t1					jsonb;
                BEGIN
            
                    transaction_id := uuid_generate_v4();
                    new_available_factors := '[]'::jsonb;
                    factors_in_other_acps := '[]'::jsonb;
                    old_available_factors := '[]'::jsonb;
                    new_added_factors := '[]'::jsonb;
                    removed_factors := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    
                    IF (TG_OP = 'DELETE') THEN
                    
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                    
                        IF NEW."organizationId" != OLD."organizationId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                        END IF;
        
                        IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF NEW."deviceId" != OLD."deviceId" THEN
                                RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                        END IF;
        
                        IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                            RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                        END IF;
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                new_available_factors:= new_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                old_available_factors:= old_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = NEW."deviceId"
                            AND acp."id" != NEW."id"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1:= jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                    IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                    THEN
                                        factors_in_other_acps:= factors_in_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
        
                        -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (new_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                            LOOP
                                IF (POSITION (i::text IN old_available_factors::text) < 1)
                                THEN
                                    new_added_factors:= new_added_factors || i;
                                END IF;
                            END LOOP;
                        END IF;
        
                        -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (old_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                            LOOP
                                IF (POSITION (i::text IN new_available_factors::text) < 1)
                                THEN
                                    removed_factors:= removed_factors || i;
                                END IF;
                            END LOOP; 
                        END IF;
        
                        -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                        IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                    AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                            OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                            OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
        
                        )
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        END IF;
        
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                        THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                            LOOP
                                IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uar."accessControlPointId" = NEW."id"
                            AND uar."deletedAt" IS NULL 
                            AND uoc."deletedAt" IS NULL
                            AND uoc."organizationId" = NEW."organizationId"
                            AND uar."access" = TRUE
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
                    RETURN NEW;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_camera()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	uuid;
            camera_id 		uuid;
            proxy_terminal_id 		uuid;
            BEGIN
                transaction_id := uuid_generate_v4();
                IF (TG_OP = 'DELETE') THEN
                    camera_id:= OLD."id";
                    proxy_terminal_id:= OLD."proxyTerminalId";
                ELSE
                    camera_id:= NEW."id";
                    proxy_terminal_id:= NEW."proxyTerminalId";
                END IF;
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
                FROM "___ORGANIZATION_ID___"."cameras" AS c
                INNER JOIN "___ORGANIZATION_ID___"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, proxy_terminal_id, now(), 3, '{}'::json;
                IF (TG_OP = 'DELETE') THEN
                    RETURN OLD;
                ELSE
                    RETURN NEW;
                END IF;

            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_camera_actions()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        camera_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                camera_id:= OLD."cameraId";
            ELSE
                camera_id:= NEW."cameraId";
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
            FROM "___ORGANIZATION_ID___"."cameras" AS c
            INNER JOIN "___ORGANIZATION_ID___"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_camera_actions() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_device_dry_contact_inputs()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	uuid;
            device_id 		uuid;
            main_device_id 		uuid;
            BEGIN
                transaction_id := uuid_generate_v4();
                IF (TG_OP = 'DELETE') THEN
                    device_id:= OLD."deviceId";
                ELSE
                    device_id:= NEW."deviceId";
                END IF;
                
                SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
                WHERE h."deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                        
                SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
                WHERE h."deviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                SELECT "integratedDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."deviceIntegrations" WHERE "integratingDeviceId" = device_id;
                IF (main_device_id IS NOT NULL) THEN
                    device_id := main_device_id;
                END IF;
                
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
        
                IF (TG_OP = 'DELETE') THEN
                    RETURN OLD;
                ELSE
                    RETURN NEW;
                END IF;
        
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_dry_contact_inputs() TO ${dbuser};


    `;
    q += `
        -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_device_readers()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_readers() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_device_relays()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM "___ORGANIZATION_ID___"."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            INNER JOIN "___ORGANIZATION_ID___"."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_device_relays() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_notification_access()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id 	uuid;
                res 			text;
                BEGIN
                    transaction_id := uuid_generate_v4();
                    IF (TG_OP = 'DELETE') THEN
                        IF (OLD."targetUserId" IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', OLD."id"
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                WHERE uo."userId" = OLD."targetUserId"
                                    AND uo."deletedAt" IS NULL
                                    AND u."deletedAt" IS NULL
                                    AND uar."deletedAt" IS NULL
                                    AND acp."deletedAt" IS NULL
                                    AND racp."regionId" = OLD."regionId"
                            ) AS T
                            WHERE T."row_num" = 1;
                        ELSE
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', OLD."id"
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                                WHERE racp."regionId" = OLD."regionId"
                                    AND  acp."deletedAt" IS NULL
                            ) AS T
                            WHERE T."row_num" = 1;
                        END IF;
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', to_jsonb(row_to_json(OLD)),
                            'new', null
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_access', res);                
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
                        -- access notification for single user
                        IF (NEW."targetUserId" IS NOT NULL) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', NEW."id",
                                    't', NEW."targetUserId",
                                    'r', NEW."regionId",
                                    's', NEW.options->'success',
                                    'd', NEW.options->'direction'
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                WHERE uo."userId" = NEW."targetUserId"
                                    AND uo."deletedAt" IS NULL
                                    AND u."deletedAt" IS NULL
                                    AND uar."deletedAt" IS NULL
                                    AND acp."deletedAt" IS NULL
                                    AND racp."regionId" = NEW."regionId"
                            ) AS T
                            WHERE T."row_num" = 1;
                        -- access notification all users
                        ELSE
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                            FROM
                            (
                                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                JSON_BUILD_OBJECT(
                                    'id', NEW."id",
                                    't', NEW."targetUserId",
                                    'r', NEW."regionId",
                                    's', NEW.options->'success',
                                    'd', NEW.options->'direction'
                                ) AS "data"
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                                WHERE racp."regionId" = NEW."regionId"
                                    AND  acp."deletedAt" IS NULL
                            ) AS T
                            WHERE T."row_num" = 1;
                        END IF;
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
                            'new', to_jsonb(row_to_json(NEW))
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_access', res);
                        RETURN NEW;
                    END IF;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_access() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_notification_sensor()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id	uuid;
                access_control_point_id uuid;
                    res	text;
                BEGIN
                    transaction_id := uuid_generate_v4();
                    IF (TG_OP = 'DELETE') THEN
                        access_control_point_id:= OLD."accessControlPointId";
                    ELSE
                        access_control_point_id:= NEW."accessControlPointId";
                    END IF;
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;
                    
                    IF (TG_OP = 'DELETE') THEN
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', to_jsonb(row_to_json(OLD)),
                            'new', null
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_sensor', res);
                        RETURN OLD;
                    ELSE
                        res := JSONB_BUILD_OBJECT(
                            'oid', TG_TABLE_SCHEMA::text,
                            'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
                            'new', to_jsonb(row_to_json(NEW))
                        )::text;
                        PERFORM PG_NOTIFY('terminal_notification_sensor',res);            
                        RETURN NEW;
                    END IF;    
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_notification_sensor() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_o_auth_tokens()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id	uuid;
            credential_exists	boolean;
            BEGIN
                transaction_id := uuid_generate_v4();
                IF (TG_OP = 'DELETE') THEN
                    IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                        -- 2 for BLE, 8 for NFC, 12 for QR
                    END IF;
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                    SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
                        "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."deletedAt" IS NULL AND
                                uoc."userId" = NEW."userId" AND
                                (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
                    INTO credential_exists;
                    IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
                    -- delete credentials
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                        RETURN NEW;
                    ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
                        (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR
                        credential_exists = false AND NEW."oAuthClientId" IS NOT NULL AND NEW."deletedAt" IS NULL) THEN
                    -- delete old credentials
                    -- insert new credentials
                        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
        
                        RETURN NEW;
                    ELSE
        
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    -- check existing credentials
                    SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
                        "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        WHERE uoc."deletedAt" IS NULL AND
                                uoc."userId" = NEW."userId" AND
                                (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
                    INTO credential_exists;
                    -- if no credentials present, then create 2 credentials for BLE and NFC
                    IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
        
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
                    
                    
                        INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
        
                    END IF;
                END IF;
                RETURN NEW;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_region_access_control_points()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        device_id		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                SELECT "deviceId" 
                FROM "___ORGANIZATION_ID___"."accessControlPoints"
                WHERE "deletedAt" IS NULL AND "id" = OLD."accessControlPointId"
                INTO device_id;
            ELSIF (TG_OP = 'UPDATE') THEN
                RAISE EXCEPTION 'Illegal operation to update region/accessControlPoint mapping';
            ELSE
                SELECT "deviceId" 
                FROM "___ORGANIZATION_ID___"."accessControlPoints"
                WHERE "deletedAt" IS NULL AND "id" = NEW."accessControlPointId"
                INTO device_id;
            END IF;
            
            IF (device_id IS NOT NULL) THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
            END IF;
            
            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_region_access_control_points() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_access_notification()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
            transaction_id				uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                IF (OLD."targetUserId" IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', OLD."id"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE uo."userId" = OLD."targetUserId"
                            AND uo."organizationId" = OLD."organizationId"
                            AND uo."deletedAt" IS NULL
                            AND u."deletedAt" IS NULL
                            AND uar."deletedAt" IS NULL
                            AND acp."deletedAt" IS NULL
                            AND racp."regionId" = OLD."regionId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSE
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', OLD."id"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                        WHERE acp."organizationId" = OLD."organizationId"
                            AND racp."regionId" = OLD."regionId"
                            AND  acp."deletedAt" IS NULL
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
                -- access notification for single user
                IF (NEW."targetUserId" IS NOT NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', NEW."id",
                            't', NEW."targetUserId",
                            'r', NEW."regionId",
                            's', NEW."success",
                            'd', NEW."direction"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id"
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE uo."userId" = NEW."targetUserId"
                            AND uo."organizationId" = NEW."organizationId"
                            AND uo."deletedAt" IS NULL
                            AND u."deletedAt" IS NULL
                            AND uar."deletedAt" IS NULL
                            AND acp."deletedAt" IS NULL
                            AND racp."regionId" = NEW."regionId"
                    ) AS T
                    WHERE T."row_num" = 1;
                -- access notification all users
                ELSE
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'id', NEW."id",
                            't', NEW."targetUserId",
                            'r', NEW."regionId",
                            's', NEW."success",
                            'd', NEW."direction"
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                        WHERE acp."organizationId" = NEW."organizationId"
                            AND racp."regionId" = NEW."regionId"
                            AND  acp."deletedAt" IS NULL
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_notification() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_access_rights()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                transaction_id		uuid;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := uuid_generate_v4();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" = TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate"
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL  AND uar."access" = TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate"
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_forbiddances()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id		uuid;
                    user_id				uuid;
                    BEGIN
                        transaction_id := uuid_generate_v4();
                        IF (TG_OP = 'DELETE') THEN
                            user_id:= OLD."userId";
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                        JSON_BUILD_OBJECT(
                                        'id', OLD."id"
                                    ) AS "data"
                                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            RETURN OLD;
                        ELSIF (TG_OP = 'INSERT') THEN
                            user_id:= NEW."userId";
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                        JSON_BUILD_OBJECT(
                                        'id', NEW."id",
                                        'userId', user_id,
                                        'regionId', NEW."regionId",
                                        'credentialIds', NEW."credentialIds",
                                        'startDateISO', NEW."startUtc",
                                        'endDateISO', NEW."endUtc"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            RETURN NEW;
                        ELSIF (TG_OP = 'UPDATE') THEN
                            user_id:= NEW."userId";
                            IF (NEW."startUtc" != OLD."startUtc" OR 
                                NEW."endUtc" != OLD."endUtc" OR
                                NEW."regionId" != OLD."regionId" OR 
                                (NEW."credentialIds" IS NULL AND OLD."credentialIds" IS NOT NULL) OR
                                (OLD."credentialIds" IS NULL AND NEW."credentialIds" IS NOT NULL) OR
                                (SELECT array_agg(d) !=  (
                                    SELECT array_agg(d) AS list
                                    FROM json_array_elements_text(NEW."credentialIds") AS d
                                ) 
                                FROM json_array_elements_text(OLD."credentialIds") AS d)
                            )
                            THEN
                                --first remove old forbiddance
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                    JSON_BUILD_OBJECT(
                                        'id', OLD."id"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                                --then add new forbiddance
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() + interval '500 milliseconds' , 17, T."data"
                                FROM
                                (
                                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                                    JSON_BUILD_OBJECT(
                                        'id', NEW."id",
                                        'userId', user_id,
                                        'regionId', NEW."regionId",
                                        'credentialIds', NEW."credentialIds",
                                        'startDateISO', NEW."startUtc",
                                        'endDateISO', NEW."endUtc"
                                    ) AS "data"
                                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                                    -- if region id is null, apply for all regions
                                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                                ) AS T
                                WHERE T."row_num" = 1;
                            END IF;
                            RETURN NEW;
                        END IF;
                    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_group_mapping()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id			uuid;
        user_organization_id	uuid;
        group_id				uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."userOrganizationId";
                group_id:= OLD."userGroupId";
                IF (OLD."deletedAt" IS NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                            JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                            FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'INSERT') THEN

                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', '[]'::json,
                            'addedUserIds',  ('["' || u."id" || '"]')::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
                    transaction_id	uuid;
                    t_factors		text;
                    factors 		text[];
                    credential_one_time_assignable_status boolean;
                    organization_license_settings	jsonb;
                    active_credential_count	integer;
                    base_module_max_count	integer;
                    BEGIN
                        transaction_id := uuid_generate_v4();
                        IF (TG_OP = 'DELETE') THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                                JSON_BUILD_OBJECT('id', OLD."id")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                            WHERE T."row_num" = 1;
                            RETURN OLD;
                        ELSIF (TG_OP = 'UPDATE') THEN
                            IF NEW."userId" != OLD."userId"
                            OR NEW."organizationId" != OLD."organizationId"
                            OR NEW."type" != OLD."type"
                            OR NEW."data" != OLD."data"
                            OR NEW."specialData" != OLD."specialData"
                            OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
                            THEN
                                RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
                            END IF;

                            ----- One Time Assignable setting, support added for METU UHF credentials!
                            IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
                            THEN
                                credential_one_time_assignable_status := (
                                    SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                                        THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                                    FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                                    WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                                );
                                IF(credential_one_time_assignable_status IS TRUE) THEN
                                        RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                                END IF;
                            END IF;	
                            ----- One Time Assignable setting, support added for METU UHF credentials!
                            
                            ----- License limit control logic!
                            IF (
                                NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                                    INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    ON uo."roleId" = r.id
                                    WHERE uo."deletedAt" IS NULL AND
                                        r."deletedAt" IS NULL AND
                                        NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                AND 
                                (
                                    (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR 
                                    (NEW."expiresOn" IS NULL AND OLD."expiresOn" IS NOT NULL) OR
                                    (NEW."expiresOn" IS NOT NULL AND NEW."expiresOn" > now())
                                ) 
                            )
                            THEN
                                SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                                FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                            
                                IF ((organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 ) THEN
                                    
                                    SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 
                                    COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                        ON uo."userId" = uoc."userId"
                                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                                        ON r."id" = uo."roleId"
                                    WHERE uoc."deletedAt" IS NULL
                                        AND ("expiresOn" IS NULL OR "expiresOn" > now())
                                        AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                        AND uo."deletedAt" IS NULL
                                        AND r."deletedAt" IS NULL
                                        AND uo."isDisabled" = FALSE;
                                    
                                    SELECT "maxCredentialCount" INTO base_module_max_count
                                        FROM "___ORGANIZATION_ID___"."organizationModules"
                                        WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                                    IF (active_credential_count >= 
                                        base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                                        RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                                    END IF;
                                END IF;
                            END IF;
                            ----- License limit control logic!
                                
                            IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
                            THEN							
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                                JSON_BUILD_OBJECT('id', OLD."id")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL  AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                                WHERE T."row_num" = 1;
                            END IF;
                
                            IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
                                OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
                                NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
                                        AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
                                    JSON_BUILD_OBJECT(	'id', OLD."id", 
                                                            'expiresOnISO', NEW."expiresOn",
                                                            'groupNumber', NEW."groupNumber",
                                                            'extensionFields', NEW."extensionFields")
                                FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                                    AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                    AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                                    AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                                AS T
                                WHERE T."row_num" = 1;
                            END IF;
                        ELSIF (TG_OP = 'INSERT') THEN
                            IF (NEW."deletedAt" IS NULL)
                            THEN
                            
                                ----- One Time Assignable setting, support added for METU UHF credentials!
                                credential_one_time_assignable_status := (
                                    SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                                        THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                                    FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                                    WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                                );
                                IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                            WHERE "type" = NEW."type" AND "data" = NEW."data"
                                            AND "organizationId" = NEW."organizationId"
                                            AND "deletedAt" IS NULL
                                            AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
                                                RAISE EXCEPTION '20002'; -- Check appweb ErrorCode enums for detail
                                    ELSIF(credential_one_time_assignable_status IS TRUE AND 
                                        EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
                                            RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                                END IF;
                                
                                ----- One Time Assignable setting, support added for METU UHF credentials!

                                ----- Delete old mobile credentials to prevent duplicates!
                                IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                    WHERE "type" = NEW."type" AND "data" = NEW."data"
                                    AND "organizationId" = NEW."organizationId"
                                    AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
                                    
                                    UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
                                    WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
                                        AND "type" = NEW."type" AND "deletedAt" IS NULL;
                                END IF;
                                ----- Delete old mobile credentials to prevent duplicates!
                                
                                ----- License limit control logic!
                                SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                                FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                            
                                IF (
                                    NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                                    INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                    ON uo."roleId" = r.id
                                    WHERE uo."deletedAt" IS NULL AND
                                        r."deletedAt" IS NULL AND
                                        NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                                    AND 
                                    (organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 
                                ) THEN
                                    
                                    SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 	-- mobile credentials
                                    COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                                    FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                                        ON uo."userId" = uoc."userId"
                                    INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                                        ON r."id" = uo."roleId"
                                    WHERE uoc."deletedAt" IS NULL
                                        AND ("expiresOn" IS NULL OR "expiresOn" > now())
                                        AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[]) -- visitor type id's
                                        AND uo."deletedAt" IS NULL
                                        AND r."deletedAt" IS NULL
                                        AND uo."isDisabled" = FALSE;
                                    
                                    SELECT "maxCredentialCount" INTO base_module_max_count
                                        FROM "___ORGANIZATION_ID___"."organizationModules"
                                        WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                                    IF (active_credential_count >= 
                                        base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                                        RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                                    END IF;
                                END IF;
                                ----- License limit control logic!

                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
                                NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
                                FROM
                                    (SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                                        FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                                        AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
                                        AND NEW."organizationId" = acp."organizationId" AND uar."access" = true
                                        WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
                                        ) AS T2
                                    WHERE T2.row_num=1
                                    ) AS T;
                            END IF;
                        END IF;
                        RETURN NEW;
                    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_sensor_notifications()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        access_control_point_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                access_control_point_id:= OLD."accessControlPointId";
            ELSE
                access_control_point_id:= NEW."accessControlPointId";
            END IF;
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
            WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;

            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;

        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_sensor_notifications() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_region_ticket_unit()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id		uuid;
    user_id				uuid;
    region_ticket_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."userId";
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', 0
                ) AS "data"
				FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
				INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = OLD."organizationId" AND
					uar."userId" = OLD."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_id:= NEW."userId";

            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', NEW."remainingUnits"
                ) AS "data"
				FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
				INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = NEW."organizationId" AND
					uar."userId" = NEW."userId"
				--FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                --INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."regionTickets" AS rt ON rt."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --WHERE uo."organizationId" = NEW."organizationId" AND u."id" = NEW."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            user_id:= NEW."userId";

            IF (NEW."remainingUnits" != OLD."remainingUnits" AND NOT NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits")
            THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', NEW."lastUpdateAmount"
                    ) AS "data"
					FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
					INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId"
                ) AS T
            	WHERE T."row_num" = 1;
            ELSIF (NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits"
                    AND NEW."lastUpdateAccessControlPointId" IS NOT NULL)
            THEN
                SELECT rt."id" INTO region_ticket_id
                FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = NEW."lastUpdateAccessControlPointId"
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id" AND racp."regionId" = rt."regionId"
                WHERE rt."deletedAt" IS NULL AND acp."deletedAt" IS NULL;

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 13, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userId', user_id,
                        'ticketId', region_ticket_id,
                        'amount', (OLD."remainingUnits" - NEW."remainingUnits")
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
					INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId" AND
						acp."id" != NEW."lastUpdateAccessControlPointId"
                ) AS T
				WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_delete_access_rule_sets()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT T."deviceId"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE racp."regionId" = OLD."regionId"
                        AND acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSIF (TG_OP = 'UPDATE') THEN
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId" OR racp."regionId" = OLD."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_delete_access_rules()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rules() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_delete_region_tickets()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND racp."regionId" = OLD."regionId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                    INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = NEW."organizationId"
                        AND racp."regionId" = NEW."regionId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_region_tickets() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_delete_user_group_access_rule_sets()

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
		transaction_id	uuid;
		device_id_list  uuid[];
		BEGIN
			transaction_id := uuid_generate_v4();
			IF (TG_OP = 'DELETE') THEN
				SELECT ARRAY_AGG(T."deviceId")
				FROM
				(
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
						INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
						WHERE acp."deletedAt" IS NULL
							AND ars."deletedAt" IS NULL
							AND acp."organizationId" = ars."organizationId"
				) AS T
				WHERE T."row_num" = 1
				INTO device_id_list;
			ELSE
				IF (TG_OP = 'UPDATE' 
					AND OLD."id" = NEW."id" 
					AND OLD."userGroupId" = NEW."userGroupId" 
					AND OLD."accessRuleSetId" = NEW."accessRuleSetId") THEN
					RETURN NEW;
				END IF;
				SELECT ARRAY_AGG(T."deviceId")
					FROM
					(
						SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
						INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
						WHERE acp."deletedAt" IS NULL
							AND ars."deletedAt" IS NULL
							AND acp."organizationId" = ars."organizationId"
					) AS T
					WHERE T."row_num" = 1
				INTO device_id_list;
			END IF;
			INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
			("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
			VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
	
			IF (TG_OP = 'DELETE') THEN
				RETURN OLD;
			ELSE
				RETURN NEW;
			END IF;
	
		END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_user_group_access_rule_sets() TO ${dbuser};


    `;
    q += `
    -- FUNCTION: ___ORGANIZATION_ID___.before_update_devices()

    -- DROP FUNCTION "___ORGANIZATION_ID___".before_update_devices();

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_update_devices()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (NEW."name" != OLD."name" OR NEW."location" != OLD."location")
            THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                VALUES(uuid_generate_v4(), transaction_id, NEW."id", now(), 3, '{}'::json);
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_update_devices()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_update_devices() TO ${dbuser};


    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
