"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    let query = `
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userRegionTicketUnits}" 
    ALTER COLUMN "remainingUnits" TYPE NUMERIC(14,2),
    ALTER COLUMN "lastUpdateAmount" TYPE NUMERIC(14,2),
    ALTER COLUMN "totalSpentUnits" TYPE NUMERIC(14,2);

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionTickets}"
    ALTER COLUMN "requiredUnits" TYPE NUMERIC(14,2); 

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const akvaKomaditOrgId = "2d369e8e-a6b8-41b9-b87f-c98da94bfd7f";
    const updateStartDate = "2021-10-01 00:00:00";
    const hasAkvaKomadit = (await client.query(`SELECT COUNT(id) > 0 as "hasAkva" FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}" WHERE id = $1`, [akvaKomaditOrgId])).rows[0]
        .hasAkva;
    let akvaLogBackUp = "akvaLogBackUp";
    if (hasAkvaKomadit) {
        await client.query(`CREATE TABLE "${akvaKomaditOrgId}"."${akvaLogBackUp}"(
            id uuid,
            "userId" uuid,
            "newLogRg" jsonb,
            "historicalLog" jsonb,
            delta numeric(14,2)
        ) TABLESPACE pg_default;`);
        await client.query(`ALTER TABLE "${akvaKomaditOrgId}"."${akvaLogBackUp}" OWNER to ${dbsuperuser};`);
        await client.query(`
        INSERT INTO "${akvaKomaditOrgId}"."${akvaLogBackUp}" 
        (id,"userId","newLogRg", "historicalLog", delta)
        (SELECT al.id, urc."userId" , json_agg(xyz || ('{"rti":{"c": ' || ((xyz->'rti'->'c')::numeric(14,2)*2.5)::text || ',"i":' || (xyz->'rti'->'i')::text || '}}')::jsonb)::jsonb as "newLogRg", 
        al."log" as "historicalLog", SUM((xyz->'rti'->>'c')::numeric(14,2)*1.5) as delta 
        FROM "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userRegionTicketUnits}" as urc
        INNER JOIN "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" as uo 
        ON uo."userId" = urc."userId"
        INNER JOIN "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessLogs}" as al  
        ON (al."log"->>'o')::uuid = urc."userId" and (al."log"->>'rg') IS NOT NULL
        CROSS JOIN jsonb_array_elements(al."log"->'rg') as xyz
        INNER JOIN "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionTickets}" as rt ON (xyz->'rti'->>'i')::uuid = rt."id"
        WHERE  (al."log"->>'s')::boolean = true AND
        al."actionUtc" >= $1::timestamptz
        GROUP BY al.id, urc."userId", al."log");
    `, [updateStartDate]);
        await client.query(`
        UPDATE "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessLogs}" ual
        SET "log" = JSONB_SET("log",'{rg}',"tempTable"."newLogRg", false)
        FROM "${akvaKomaditOrgId}"."${akvaLogBackUp}" as "tempTable"
        WHERE "tempTable"."id" = ual."id";
        `);
        await client.query(`
            UPDATE "${akvaKomaditOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userRegionTicketUnits}" uurc
            SET "totalSpentUnits" = "totalSpentUnits" + delta, "remainingUnits" = "remainingUnits" - delta 
            FROM (
                SELECT "tempTable"."userId", SUM("tempTable".delta) as delta  
                FROM "${akvaKomaditOrgId}"."${akvaLogBackUp}"as "tempTable" 
                GROUP BY "tempTable"."userId") as tt
            WHERE uurc."userId" = "tt"."userId"
        `);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    let query = `
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userRegionTicketUnits}" 
    ALTER COLUMN "remainingUnits" TYPE INT,
    ALTER COLUMN "lastUpdateAmount" TYPE INT,
    ALTER COLUMN "totalSpentUnits" TYPE INT;

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionTickets}"
    ALTER COLUMN "requiredUnits" TYPE INT; 
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
