"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_constants_1 = require("../../../dal.constants");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const uuid = __importStar(require("uuid"));
const dal_utils_1 = require("../../../dal.utils");
const app_logs_1 = require("../../../../app.logs");
async function up(client, dbuser, dbsuperuser) {
    const kfcOrgId = "69599fe5-b8e1-4606-9294-67ea176cde91";
    const hasKfc = (await client.query(`SELECT COUNT(id) > 0 as "hasKfc" FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}" WHERE id = $1`, [kfcOrgId])).rows[0].hasKfc;
    if (hasKfc) {
        const newAcpId = uuid.v4();
        await client.query(`
        INSERT INTO "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
        (id, "createdAt", "updatedAt", "deletedAt", name, location, "remoteAvailable", "isRemoteDefault", "organizationId", "accessControlPointType", "authenticationFactors", "deviceId", states, "defaultPrivileges", "typedGeoLocation")
        SELECT $1, acp."createdAt", acp."updatedAt", null, acp.name, acp.location, acp."remoteAvailable", acp."isRemoteDefault", acp."organizationId", acp."accessControlPointType", acp."authenticationFactors", acp."deviceId", acp.states, acp."defaultPrivileges", acp."typedGeoLocation"
        FROM "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp WHERE acp.id = $2;
        `, [newAcpId, dal_constants_1.DalConstants.defaultMobileAcpId]);
        await client.query(`
        INSERT INTO "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
        (id, "createdAt", "updatedAt", "deletedAt", "userId", "accessControlPointId", "remoteAccess", "markedAsFavorite", read, access, config, "grant", snapshot)
        SELECT uuid_generate_v4(), uar."createdAt", uar."updatedAt", uar."deletedAt", uar."userId", $1, uar."remoteAccess", uar."markedAsFavorite", uar.read, uar.access, uar.config, uar.grant, uar.snapshot
        FROM "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar WHERE uar."accessControlPointId" = $2;
        `, [newAcpId, dal_constants_1.DalConstants.defaultMobileAcpId]);
        await client.query(`
        UPDATE "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}" SET "accessPointId" = $1
        WHERE "accessPointId" = $2
        `, [newAcpId, dal_constants_1.DalConstants.defaultMobileAcpId]);
        await client.query(`
        UPDATE "${kfcOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" SET name = $1
        WHERE id = $2
        `, ["Mobil Çalışma Varsayılan Erişim Noktası", dal_constants_1.DalConstants.defaultMobileAcpId]);
    }
    let query = `
    DELETE FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
    WHERE uar."accessControlPointId" = '${dal_constants_1.DalConstants.defaultMobileAcpId}' AND NOT read;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizations = (await client.query(`SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"`)).rows.map((r) => r.id);
    for (const org of organizations) {
        let defaultAcpNameResult = await client.query(`SELECT name FROM "${org}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE id = $1`, [dal_constants_1.DalConstants.defaultMobileAcpId]);
        if (defaultAcpNameResult.rowCount === 1) {
            if (defaultAcpNameResult.rows[0].name === "Mobile Check-in Access Point") {
                await client.query(`UPDATE "${org}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" SET name = $1 WHERE id = $2`, [
                    "Mobile Check-in Default Access Point",
                    dal_constants_1.DalConstants.defaultMobileAcpId,
                ]);
            }
            else if (defaultAcpNameResult.rows[0].name === "Mobil Çalışma Erişim Noktası") {
                await client.query(`UPDATE "${org}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" SET name = $1 WHERE id = $2`, [
                    "Mobil Çalışma Varsayılan Erişim Noktası",
                    dal_constants_1.DalConstants.defaultMobileAcpId,
                ]);
            }
            else {
                app_logs_1.logger.info(org + ": name of default ACP seems to be changed, please inspect manually. Name is: " + defaultAcpNameResult.rows[0].name);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
