"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const UHFRfid_CREDENTIAL_TYPE = 5;
    const q = `

	UPDATE "___ORGANIZATION_ID___".organizations
	SET "credentialTypes" = COALESCE(T2.credential, "credentialTypes")
	FROM (SELECT json_agg(to_json(element::jsonb || (('{"oneTimeAssignable": false}')::jsonb))) AS credential FROM (
		SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations
		) AS T1 
	) AS T2;

	-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()

	-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
				transaction_id	uuid;
				t_factors		text;
				factors 		text[];
				"credentialOneTimeAssignableStatus" boolean;
				BEGIN
					transaction_id := uuid_generate_v4();
					IF (TG_OP = 'DELETE') THEN
						INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
							JSON_BUILD_OBJECT('id', OLD."id")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
						WHERE T."row_num" = 1;
						RETURN OLD;
					ELSIF (TG_OP = 'UPDATE') THEN
						IF NEW."userId" != OLD."userId"
						OR NEW."organizationId" != OLD."organizationId"
						OR NEW."type" != OLD."type"
						OR NEW."data" != OLD."data"
						OR NEW."specialData" != OLD."specialData"
						OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
						THEN
							RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
						END IF;

						IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
						THEN
							"credentialOneTimeAssignableStatus" := (SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE false END FROM (
							SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations
								) T1
							WHERE ((element->'type')::JSONB)::INTEGER = NEW.type);
							IF("credentialOneTimeAssignableStatus" IS TRUE) THEN
									RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
							END IF;
						END IF;	
								
						IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
						THEN							
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
							JSON_BUILD_OBJECT('id', OLD."id")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
							WHERE T."row_num" = 1;
						END IF;
			
						IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
							OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
							NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
									AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
						THEN
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
								JSON_BUILD_OBJECT(	'id', OLD."id", 
														'expiresOnISO', NEW."expiresOn",
														'groupNumber', NEW."groupNumber",
														'extensionFields', NEW."extensionFields")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
							WHERE T."row_num" = 1;
						END IF;
					ELSIF (TG_OP = 'INSERT') THEN
						IF (NEW."deletedAt" IS NULL)
						THEN
						
							"credentialOneTimeAssignableStatus" := (SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE false END FROM (
									SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations
									) T1
								WHERE ((element->'type')::JSONB)::INTEGER = NEW.type);
							IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
										WHERE "type" = NEW."type" AND "data" = NEW."data"
										AND "organizationId" = NEW."organizationId"
										AND "deletedAt" IS NULL
										AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
											RAISE EXCEPTION 'Credential is already exists';
								ELSIF("credentialOneTimeAssignableStatus" IS TRUE AND 
									EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
										RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
							END IF;
							
							IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
								WHERE "type" = NEW."type" AND "data" = NEW."data"
								AND "organizationId" = NEW."organizationId"
								AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
								
								UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
								WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
									AND "type" = NEW."type" AND "deletedAt" IS NULL;
							END IF;
			
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
							json_build_object(
								'id', T."id",
								'userId', T."userId",
								'type', T."type",
								'data', T."data",
								'groupNumber', T."groupNumber",
								'specialData', T."specialData",
								'specialDataSecondary', T."specialDataSecondary",
								'expiresOnISO', T."expiresOn",
								'extensionFields', T."extensionFields"
							) AS "data" FROM
							(SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
							NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
							FROM
								(SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
									FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
									INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
									AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
									AND NEW."organizationId" = acp."organizationId"
									WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
									) AS T2
								WHERE T2.row_num=1
								) AS T;
						END IF;
					END IF;
					RETURN NEW;
				END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};


	
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
	UPDATE "___ORGANIZATION_ID___".organizations
		SET "credentialTypes" = T2.credential
	FROM (SELECT json_agg(to_json((element::jsonb - 'oneTimeAssignable')::jsonb )) AS credential FROM (
		SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations
		) AS T1
	) AS T2;

	-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()

	-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			transaction_id	uuid;
			t_factors		text;
			factors 		text[];
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
					("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
					SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
							INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
					WHERE T."row_num" = 1;
					RETURN OLD;
				ELSIF (TG_OP = 'UPDATE') THEN
					IF NEW."userId" != OLD."userId"
					OR NEW."organizationId" != OLD."organizationId"
					OR NEW."type" != OLD."type"
					OR NEW."data" != OLD."data"
					OR NEW."specialData" != OLD."specialData"
					OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
					THEN
						RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
					END IF;
		
					IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
					THEN
						INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
							INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
		
					IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
						OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
						NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
								AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
					THEN
						INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
							JSON_BUILD_OBJECT(	'id', OLD."id", 
													'expiresOnISO', NEW."expiresOn",
													'groupNumber', NEW."groupNumber",
													'extensionFields', NEW."extensionFields")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
							INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
				ELSIF (TG_OP = 'INSERT') THEN
					IF (NEW."deletedAt" IS NULL)
					THEN
						IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL
							AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
							RAISE EXCEPTION 'Credential is already exists';
						END IF;
						
						IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
							UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
							WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
								AND "type" = NEW."type" AND "deletedAt" IS NULL;
						END IF;
		
						INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
						json_build_object(
							'id', T."id",
							'userId', T."userId",
							'type', T."type",
							'data', T."data",
							'groupNumber', T."groupNumber",
							'specialData', T."specialData",
							'specialDataSecondary', T."specialDataSecondary",
							'expiresOnISO', T."expiresOn",
							'extensionFields', T."extensionFields"
						) AS "data" FROM
						(SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
						NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
						FROM
							(SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
								AND NEW."organizationId" = acp."organizationId"
								WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
								) AS T2
							WHERE T2.row_num=1
							) AS T;
					END IF;
				END IF;
				RETURN NEW;
			END;
		$BODY$;

		ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
			OWNER TO ${dbsuperuser};

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};


	
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
