"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const predefined_permissions_1 = require("../../predefined/predefined.permissions");
const predefined_roles_1 = require("../../predefined/predefined.roles");
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const missingPermissions = [
        '"' + predefined_permissions_1.Permissions.scheduled_job.getRead() + '"',
        '"' + predefined_permissions_1.Permissions.scheduled_job.getWrite() + '"',
        '"' + predefined_permissions_1.Permissions.notification_job.getRead() + '"',
        '"' + predefined_permissions_1.Permissions.notification_job.getWrite() + '"',
    ];
    const missingOrganizationWidePermission = '"' + predefined_permissions_1.Permissions.system.getOrganizationWidePassiveUsersView() + '"';
    for (const organization of organizationList.rows) {
        const existingRoles = await client.query(`
        	SELECT id, permissions, "isOrganizationWide", "typeId" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" WHERE "deletedAt" IS NULL
        `);
        for (const role of existingRoles.rows) {
            if (role.typeId === predefined_roles_1.PredefinedRoles.OrganizationUnitVisitor.id ||
                role.typeId === predefined_roles_1.PredefinedRoles.OrganizationVisitor.id ||
                role.typeId === predefined_roles_1.PredefinedRoles.StandartUser.id ||
                role.typeId === predefined_roles_1.PredefinedRoles.StandartUserOrganization.id) {
                continue;
            }
            const permissions = role.permissions.replace(new RegExp("[\\[\\]]", "g"), "");
            const permissionsArray = permissions.indexOf(",") > 0 ? permissions.split(",") : [];
            let updateNeeded = false;
            for (const mp of missingPermissions) {
                if (!permissionsArray.includes(mp)) {
                    updateNeeded = true;
                    permissionsArray.push(mp);
                }
            }
            if (role.isOrganizationWide && !permissionsArray.includes(missingOrganizationWidePermission)) {
                updateNeeded = true;
                permissionsArray.push(missingOrganizationWidePermission);
            }
            if (updateNeeded) {
                const newPermissions = "[" + permissionsArray.join(",") + "]";
                await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
                SET permissions = $1
                WHERE id = $2
                `, [newPermissions, role.id]);
            }
        }
    }
    const regionAdministratorsQuery = `
		
	CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.region_administrators}"
	(
		id uuid NOT NULL,
		"regionId" uuid NOT NULL,
		"userId" uuid NOT NULL,
		read boolean NOT NULL DEFAULT false,
		write boolean NOT NULL DEFAULT false,
		notify boolean NOT NULL DEFAULT false,
		CONSTRAINT "region_administrators_pkey" PRIMARY KEY (id),
		CONSTRAINT "region_administrators_regionId_userId_key" UNIQUE ("regionId", "userId"),
		CONSTRAINT "region_administrators_region_id_fkey" FOREIGN KEY ("regionId")
			REFERENCES "___ORGANIZATION_ID___".regions (id) MATCH SIMPLE
			ON UPDATE CASCADE
			ON DELETE CASCADE,
		CONSTRAINT "region_administrators_userId_fkey" FOREIGN KEY ("userId")
			REFERENCES "___ORGANIZATION_ID___".users (id) MATCH SIMPLE
			ON UPDATE CASCADE
			ON DELETE CASCADE
	)

	TABLESPACE pg_default;

	ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.region_administrators}"
		OWNER to ${dbsuperuser};

	GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.region_administrators}" TO ${dbuser};

	GRANT ALL ON TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.region_administrators}" TO ${dbsuperuser};
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, regionAdministratorsQuery, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
