"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_region()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
        IF (TG_OP = 'UPDATE' AND (
                NEW.name != OLD.name OR 
                NEW."visitorAccess" != OLD."visitorAccess" OR 
                NEW."terminateVisitOnExit" != OLD."terminateVisitOnExit")) THEN
            PERFORM PG_NOTIFY('update_region_info_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        ELSIF (TG_OP = 'DELETE') THEN
            PERFORM PG_NOTIFY('update_region_info_cache', JSON_BUILD_OBJECT('id', OLD.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    $BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_region()
	OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO ${dbuser};
        
    DROP TRIGGER IF EXISTS trg_after_up_del_region ON "___ORGANIZATION_ID___"."regions";
    CREATE TRIGGER trg_after_up_del_region
        AFTER UPDATE OR DELETE
        ON "___ORGANIZATION_ID___"."regions"
        FOR EACH ROW
        EXECUTE FUNCTION "___ORGANIZATION_ID___".after_up_del_region();
        
    ------------------------------------------------- User redis trigger (userOrganizations) --------------------------------------------- 

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
        IF (TG_OP = 'UPDATE' AND (                    
                NEW."deletedAt" != OLD."deletedAt" OR 
                NEW."roleId" != OLD."roleId" OR 
                NEW."isDisabled" != OLD."isDisabled" OR 
                NEW.settings->'settings' != OLD.settings->'settings'
                )) THEN
            PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        ELSIF (TG_OP = 'DELETE') THEN
            PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    $BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
	OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbuser};

    --------------------------- User redis trigger (userProfiles) --------------------------------------------- 

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile()
        RETURNS trigger
    LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        BEGIN
            IF (TG_OP = 'UPDATE' AND (                    
                    NEW."deletedAt" != OLD."deletedAt" OR 
                    NEW."name" != OLD."name" OR 
                    NEW."surname" != OLD."surname" OR 
                    NEW."email" != OLD."email" OR
                    NEW."phoneNumber" != OLD."phoneNumber"
                    )) THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            ELSIF (TG_OP = 'DELETE') THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            END IF;
        RETURN NEW;
        END;
        $BODY$;
		
	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile()
	OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO ${dbuser};

    --------------------------- User redis trigger (userOrganizationProfiles) --------------------------------------------- 

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile()
        RETURNS trigger
    LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
        AS $BODY$
        BEGIN
            IF (TG_OP = 'UPDATE' AND (                    
                    NEW."deletedAt" != OLD."deletedAt" OR 
                    NEW."name" != OLD."name" OR 
                    NEW."surname" != OLD."surname" OR 
                    NEW."email" != OLD."email" OR
                    NEW."phoneNumber" != OLD."phoneNumber" OR
                    NEW."uniqueId" != OLD."uniqueId"
                    )) THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            ELSIF (TG_OP = 'DELETE') THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            END IF;
        RETURN NEW;
        END;
        $BODY$;
				
		ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile()
		OWNER TO ${dbsuperuser};

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO ${dbsuperuser};

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO PUBLIC;

		GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO ${dbuser};
            
            `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
