"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
	ALTER TABLE "___ORGANIZATION_ID___"."regions"
	ADD COLUMN IF NOT EXISTS "deliverDeviceEmergencyToRegionDevices" boolean DEFAULT FALSE;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
	ALTER TABLE "___ORGANIZATION_ID___"."regions"
	DROP COLUMN IF EXISTS "deliverDeviceEmergencyToRegionDevices";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
