"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const palette = [
    "1f77b4",
    "aec7e8",
    "ff7f0e",
    "ffbb78",
    "2ca02c",
    "98df8a",
    "d62728",
    "ff9896",
    "9467bd",
    "c5b0d5",
    "8c564b",
    "c49c94",
    "e377c2",
    "f7b6d2",
    "7f7f7f",
    "c7c7c7",
    "bcbd22",
    "dbdb8d",
    "17becf",
    "9edae5",
];
async function up(client, dbuser, dbsuperuser) {
    let query = `
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" 
    ADD COLUMN IF NOT EXISTS "colorCode" character varying(8) COLLATE pg_catalog."default" NOT NULL DEFAULT 'FF0000';
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationList = await client.query(`
    SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    for (const organization of organizationList.rows) {
        const workPlans = await client.query(`SELECT id, "colorCode" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" ORDER BY name`);
        let index = 0;
        for (const wp of workPlans.rows) {
            await client.query(`
            UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
            SET "colorCode" = $1 WHERE id = $2;
            `, [palette[index], wp.id]);
            index = (index + 1) % palette.length;
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    let query = `
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" 
    DROP COLUMN IF EXISTS "colorCode";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
