"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const predefined_roles_1 = require("../../predefined/predefined.roles");
const predefined_permissions_1 = require("../../predefined/predefined.permissions");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
    ADD COLUMN IF NOT EXISTS "organizationUnitId" uuid;

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
    ADD CONSTRAINT "workplans_organizationUnitId_fkey"
    FOREIGN KEY("organizationUnitId")
    REFERENCES "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" (id) MATCH SIMPLE
    ON UPDATE CASCADE ON DELETE CASCADE;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationList = await client.query(`
    SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const readPermission = '"' + predefined_permissions_1.Permissions.attendancePlan.getRead() + '"';
    const writePermission = '"' + predefined_permissions_1.Permissions.attendancePlan.getWrite() + '"';
    for (const organization of organizationList.rows) {
        const existingUnitAdminRoles = await client.query(`
        SELECT id, permissions FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" WHERE "typeId" = $1
        `, [predefined_roles_1.PredefinedRoles.UnitAdministrator.id]);
        for (const role of existingUnitAdminRoles.rows) {
            const permissions = role.permissions.replace(new RegExp("[\\[\\]]", "g"), "");
            const permissionsArray = permissions.split(",");
            let updateNeeded = false;
            if (!permissionsArray.includes(readPermission)) {
                updateNeeded = true;
                permissionsArray.push(readPermission);
            }
            if (!permissionsArray.includes(writePermission)) {
                updateNeeded = true;
                permissionsArray.push(writePermission);
            }
            if (updateNeeded) {
                const newPermissions = "[" + permissionsArray.join(",") + "]";
                await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
                SET permissions = $1
                WHERE id = $2
                `, [newPermissions, role.id]);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" DROP CONSTRAINT "workplans_organizationUnitId_fkey";

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" DROP COLUMN IF EXISTS "organizationUnitId";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
