"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = ` 
			CREATE TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances
			(
				id uuid NOT NULL,
				action smallint NOT NULL,
				"actionT" timestamp without time zone NOT NULL,
				"transactionId" bigint NOT NULL,
				"userId" uuid NOT NULL,
				"createdAt" timestamp with time zone NOT NULL,
				"updatedAt" timestamp with time zone,
				"deletedAt" timestamp with time zone,
				"startUtc" timestamp with time zone,
				"endUtc" timestamp with time zone,
				"regionId" uuid,
				note character varying(255) COLLATE pg_catalog."default",
				"credentialIds" json
			) PARTITION BY RANGE ("actionT");

			ALTER TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances
			OWNER to ${dbsuperuser};

			GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances TO ${dbuser};

			GRANT ALL ON TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances TO ${dbsuperuser};

			CREATE INDEX bx_zz_user_organization_forbiddances
			ON "___ORGANIZATION_ID___".zz_user_organization_forbiddances USING btree
			(id DESC NULLS LAST);

			CREATE TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances_default PARTITION OF "___ORGANIZATION_ID___".zz_user_organization_forbiddances
   			DEFAULT;

			ALTER TABLE "___ORGANIZATION_ID___".zz_user_organization_forbiddances_default
    		OWNER to ${dbsuperuser};

			
			CREATE TRIGGER after_insert_zz_user_organization_forbiddances_default
			AFTER INSERT
			ON "___ORGANIZATION_ID___".zz_user_organization_forbiddances_default
			FOR EACH ROW
			EXECUTE FUNCTION public.after_insert_default();

			
			CREATE FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() RETURNS trigger
			LANGUAGE plpgsql
			AS $$
			DECLARE
				_now timestamp without time zone;
			BEGIN   
				_now := now();
				IF (TG_OP = 'INSERT') THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						1,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);
				ELSIF (TG_OP = 'UPDATE') THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note ,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						2,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);    
				ELSIF (TG_OP = 'DELETE') THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						OLD.id,
						3,
						_now,
						txid_current(),
						OLD."userId",
						OLD."createdAt",
						OLD."updatedAt",
						OLD."deletedAt",
						OLD."startUtc",
						OLD."endUtc",
						OLD."regionId",
						OLD.note,
						OLD."credentialIds"
					);       
				END IF;    
				RETURN NULL;
				END;
				$$;

				ALTER FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() OWNER TO ${dbsuperuser};

				GRANT ALL ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO ${dbuser};

				DROP TRIGGER IF EXISTS trg_99_zz_user_organization_forbiddances ON "___ORGANIZATION_ID___".zz_user_organization_forbiddances;
    
				CREATE TRIGGER trg_99_zz_user_organization_forbiddances
				AFTER INSERT OR UPDATE OR DELETE
				ON "___ORGANIZATION_ID___"."userOrganizationForbiddances"
				FOR EACH ROW
				EXECUTE FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances();


				CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
				RETURNS trigger
				LANGUAGE 'plpgsql'
				COST 100
				VOLATILE NOT LEAKPROOF
				AS $BODY$
				DECLARE
				transaction_id		uuid;
				user_id				uuid;
				BEGIN
					transaction_id := uuid_generate_v4();
					IF (TG_OP = 'DELETE') THEN
						user_id:= OLD."userId";
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
									JSON_BUILD_OBJECT(
									'id', OLD."id"
								) AS "data"
									FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
								INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						RETURN OLD;
					ELSIF (TG_OP = 'INSERT') THEN
						user_id:= NEW."userId";
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
									JSON_BUILD_OBJECT(
									'id', NEW."id",
									'userId', user_id,
									'regionId', NEW."regionId",
									'credentialIds', NEW."credentialIds",
									'startDateISO', NEW."startUtc",
									'endDateISO', NEW."endUtc"
								) AS "data"
								FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
								INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						RETURN NEW;
					ELSIF (TG_OP = 'UPDATE') THEN
						user_id:= NEW."userId";
						IF (NEW."startUtc" != OLD."startUtc" OR 
							NEW."endUtc" != OLD."endUtc" OR
							NEW."regionId" != OLD."regionId" OR 
							(NEW."credentialIds" IS NULL AND OLD."credentialIds" IS NOT NULL) OR
							(OLD."credentialIds" IS NULL AND NEW."credentialIds" IS NOT NULL) OR
							(SELECT array_agg(d) !=  (
								SELECT array_agg(d) AS list
								FROM json_array_elements_text(NEW."credentialIds") AS d
							) 
							FROM json_array_elements_text(OLD."credentialIds") AS d)
						)
						THEN
							--first remove old forbiddance
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
								JSON_BUILD_OBJECT(
									'id', OLD."id"
								) AS "data"
								FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
								INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
							) AS T
							WHERE T."row_num" = 1;
							--then add new forbiddance
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() + interval '500 milliseconds' , 17, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
								JSON_BUILD_OBJECT(
									'id', NEW."id",
									'userId', user_id,
									'regionId', NEW."regionId",
									'credentialIds', NEW."credentialIds",
									'startDateISO', NEW."startUtc",
									'endDateISO', NEW."endUtc"
								) AS "data"
								FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
								INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						END IF;
						RETURN NEW;
					END IF;
				END;
			$BODY$;

			ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances()
				OWNER TO ${dbsuperuser};

			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbsuperuser};

			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO PUBLIC;

			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_forbiddances() TO ${dbuser};



		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const { rowCount, rows } = await client.query(`SELECT id FROM public."organizationList"`);
    const organizationIds = rowCount > 0 ? rows.map((row) => row.id) : [];
    for (const organizationId of organizationIds) {
        const userOrganizationForbiddances = (await client.query(`SELECT id, "organizationId", "userId", "createdAt", "updatedAt", "deletedAt", "startUtc", "endUtc", "regionId", note, "credentialIds"
		 FROM "${organizationId}"."userOrganizationForbiddances"`)).rows;
        for (const userOrganizationForbiddance of userOrganizationForbiddances) {
            await client.query(`
			INSERT INTO "${organizationId}"."zz_user_organization_forbiddances"
			(id, action, "actionT", "transactionId", "userId", "createdAt", "updatedAt", "deletedAt", "startUtc", "endUtc", "regionId", note, "credentialIds")
			VALUES ($1, $2, $3, txid_current(), $4, $5, $6, $7, $8, $9, $10, $11, $12)
			`, [
                userOrganizationForbiddance.id,
                1,
                userOrganizationForbiddance.createdAt,
                userOrganizationForbiddance.userId,
                userOrganizationForbiddance.createdAt,
                userOrganizationForbiddance.updatedAt,
                null,
                userOrganizationForbiddance.startUtc,
                userOrganizationForbiddance.endUtc,
                userOrganizationForbiddance.regionId,
                userOrganizationForbiddance.note,
                JSON.stringify(userOrganizationForbiddance.credentialIds),
            ]);
            if (userOrganizationForbiddance.deletedAt) {
                await client.query(`
				INSERT INTO "${organizationId}"."zz_user_organization_forbiddances"
				(id, action, "actionT", "transactionId", "userId", "createdAt", "updatedAt", "deletedAt", "startUtc", "endUtc", "regionId", note, "credentialIds")
				VALUES ($1, $2, $3, txid_current(), $4, $5, $6, $7, $8, $9, $10, $11, $12)
				`, [
                    userOrganizationForbiddance.id,
                    3,
                    userOrganizationForbiddance.deletedAt,
                    userOrganizationForbiddance.userId,
                    userOrganizationForbiddance.createdAt,
                    userOrganizationForbiddance.updatedAt,
                    userOrganizationForbiddance.deletedAt,
                    userOrganizationForbiddance.startUtc,
                    userOrganizationForbiddance.endUtc,
                    userOrganizationForbiddance.regionId,
                    userOrganizationForbiddance.note,
                    JSON.stringify(userOrganizationForbiddance.credentialIds),
                ]);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
		DROP TABLE IF EXISTS "___ORGANIZATION_ID___".zz_user_organization_forbiddances CASCADE;
		DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".zz_user_organization_forbiddances() CASCADE;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
