"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_constants_1 = require("../../../dal.constants");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const defaultPrivileges = {
        read: true,
        grant: false,
        config: false,
        access: true,
        remoteAccess: false,
        snapshot: false,
    };
    const organizationList = await client.query(`
        SELECT * FROM public."organizationList";
    `);
    for (const organization of organizationList.rows) {
        const mobileAcp = (await client.query(`
            SELECT id, "createdAt", name FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE "accessControlPointType" = $1;
            `, [dal_constants_1.DalConstants.AccessControlPointType.VirtualMobileCheckin])).rows[0];
        if (mobileAcp) {
            await client.query(`
                INSERT INTO "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
                ("id", "createdAt", "name", "remoteAvailable", "isRemoteDefault", "organizationId", "accessControlPointType", "defaultPrivileges")
                VALUES ($1, $2, $3, $4, $5, $6, $7, $8) RETURNING *;
            `, [
                dal_constants_1.DalConstants.defaultMobileAcpId,
                mobileAcp.createdAt,
                mobileAcp.name,
                false,
                false,
                organization.id,
                dal_constants_1.DalConstants.AccessControlPointType.VirtualMobileCheckin,
                defaultPrivileges,
            ]);
            await client.query(`
                ALTER TABLE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" DISABLE TRIGGER before_up_in_del_user_access_rights;
            `);
            await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" SET "accessControlPointId" = $1 WHERE "accessControlPointId" = $2;
            `, [dal_constants_1.DalConstants.defaultMobileAcpId, mobileAcp.id]);
            await client.query(`
                ALTER TABLE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" ENABLE TRIGGER before_up_in_del_user_access_rights;
            `);
            await client.query(`
                ALTER TABLE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" DISABLE TRIGGER before_up_in_del_region_access_control_points;
            `);
            await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" SET "accessControlPointId" = $1 WHERE "accessControlPointId" = $2;
            `, [dal_constants_1.DalConstants.defaultMobileAcpId, mobileAcp.id]);
            await client.query(`
                ALTER TABLE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" ENABLE TRIGGER before_up_in_del_region_access_control_points;
            `);
            await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnitDefaultAccessControlPoints}" SET "accessControlPointId" = $1 WHERE "accessControlPointId" = $2;
            `, [dal_constants_1.DalConstants.defaultMobileAcpId, mobileAcp.id]);
            await client.query(`
                UPDATE "${organization.id}"."organizationVisitorDefaultAccessControlPoints" SET "accessControlPointId" = $1 WHERE "accessControlPointId" = $2;
            `, [dal_constants_1.DalConstants.defaultMobileAcpId, mobileAcp.id]);
            await client.query(`
                UPDATE "${organization.id}"."access_logs"
                SET log = log || jsonb_build_object('a', $1::text)
                WHERE log->>'a' = $2::text
            `, [dal_constants_1.DalConstants.defaultMobileAcpId, mobileAcp.id]);
            await client.query(`
                DELETE FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE id = $1;
            `, [mobileAcp.id]);
            await client.query(`
                DROP TABLE IF EXISTS "${organization.id}"."attendanceAccessControlPoints";
            `);
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
