"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const got = require("got");
const app_logs_1 = require("../../../../app.logs");
const cli_config_1 = __importDefault(require("../../../../components/cli/cli.config"));
async function up(client, dbuser, dbsuperuser) {
    try {
        await Promise.all([
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/queues/%2f/notification-queue", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/queues/%2f/scheduledqueue", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/exchanges/%2f/server-to-tablet", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
        ]);
    }
    catch (error) {
        app_logs_1.logger.error("rabbitmq migration failed: " + error);
        app_logs_1.logger.info(`Manually remove the following queues and exchanges from Rabbitmq Management interface: 
				- (Queue) notification-queue
				- (Queue) scheduledqueue
				- (Exchange) server-to-tablet 
			`);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    try {
        await Promise.all([
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/queues/%2f/notification-queue", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/queues/%2f/scheduledqueue", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
            got.delete("http://" + cli_config_1.default.AMQP_HOSTNAME + ":" + cli_config_1.default.AMQP_MANAGEMENT_API_PORT + "/api/exchanges/%2f/server-to-tablet", {
                headers: {
                    Authorization: "Basic Z3Vlc3Q6Z3Vlc3Q=",
                },
            }),
        ]);
    }
    catch (error) {
        app_logs_1.logger.error("rabbitmq migration failed but added to migration table!: " + error);
        app_logs_1.logger.info(`Please manually remove the following queues and exchanges from Rabbitmq Management interface: 
			- (Queue) notification-queue
			- (Queue) scheduledqueue
			- (Exchange) server-to-tablet 
		`);
    }
}
exports.down = down;
