"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const luxon_1 = require("luxon");
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const schemaQueries = `
		DROP TRIGGER IF EXISTS after_insert_notification_instance_default ON "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}_default";
		DROP TRIGGER IF EXISTS after_insert_notification_event_default ON "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent}_default";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, schemaQueries, "___ORGANIZATION_ID___");
    const sundayOfPreviousWeek = luxon_1.DateTime.now().minus({ weeks: 1 }).set({ weekday: 7, hour: 0, minute: 30, second: 0, millisecond: 0 }).toFormat("yyyy-MM-dd HH:mm:ss");
    await client.query(`

		INSERT INTO public."${dal_db_armon_schema_1.ArmonSchema.tableNames.scheduled_job}"(
		id, "createdT", "organizationId", type, "createdByUserId", enabled, "interval", "firstExecutionDate", "nextExecutionDate", note, "notificationId")
		VALUES (uuid_generate_v4(), now(), null, 108, null, true, ${3}, '${sundayOfPreviousWeek}', '${sundayOfPreviousWeek}', null, null);

		DROP TRIGGER IF EXISTS after_insert_notification_instance_default ON "public"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}_default";
		-- FUNCTION: public.fpartitioncreator(text, text, text)

		-- DROP FUNCTION public.fpartitioncreator(text, text, text);

		CREATE OR REPLACE FUNCTION public.fpartitioncreator(
			org_id text,
			table_name text,
			partition_key text)
			RETURNS void
			LANGUAGE 'plpgsql'
			COST 100
			VOLATILE PARALLEL UNSAFE
		AS $BODY$
		DECLARE 
						def_partition	text;
						i	timestamp with time zone;
						partition_to_create	text;
						previous_partition	text;
						next_partition	text;
						start_of_partition 	timestamp with time zone;
						end_of_partition 	timestamp with time zone;
					BEGIN
						IF (org_id = 'public' AND table_name = 'notification_instance') THEN
							PERFORM public.fpartitioncretor_for_public_notification_instance(org_id, table_name, partition_key);
							RETURN;
						ELSIF (table_name = 'notification_event') THEN
							PERFORM public.fpartitioncretor_for_schema_notification_event(org_id, table_name, partition_key);
							RETURN;
						ELSE
							def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
						
							EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DETACH PARTITION ' || def_partition || ';';
							FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
								SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
								' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || def_partition || ') AS T WHERE T.row_num = 1;'
							LOOP
								partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
								previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
								next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
			
								IF NOT EXISTS(
									SELECT relname FROM pg_class 
									WHERE relname = previous_partition AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									start_of_partition := date_trunc('month', i);
								ELSE
									start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
										from pg_class c
										where relname = previous_partition and 
										(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
								END IF;
			
								IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									end_of_partition := date_trunc('month', i) + interval '1 month';
								ELSE
									end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
										from pg_class c
										where relname = next_partition and 
										(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
								END IF;
			
								IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
										|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
										|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
								END IF;
			
								EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
								|| ' SELECT * FROM '|| def_partition ||' WHERE '|| 
								quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
								quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
			
								EXECUTE 'DELETE FROM ' || def_partition || ' WHERE '|| 
								quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
								quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
			
							END LOOP;
			
							EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ATTACH PARTITION ' || def_partition || ' DEFAULT;';
							RETURN;
						END IF;
					END;
		$BODY$;

		ALTER FUNCTION public.fpartitioncreator(text, text, text)
			OWNER TO ${dbsuperuser};

		GRANT EXECUTE ON FUNCTION public.fpartitioncreator(text, text, text) TO PUBLIC;

		GRANT EXECUTE ON FUNCTION public.fpartitioncreator(text, text, text) TO ${dbuser};

		GRANT EXECUTE ON FUNCTION public.fpartitioncreator(text, text, text) TO ${dbsuperuser};


		-- FUNCTION: public.fpartitioncretor_for_schema_notification_event(text, text, text)
		-- DROP FUNCTION public.fpartitioncretor_for_schema_notification_event(text, text, text);
		CREATE OR REPLACE FUNCTION public.fpartitioncretor_for_schema_notification_event(
			org_id text,
			table_name text,
			partition_key text)
			RETURNS void
			LANGUAGE 'plpgsql'
			COST 100
			VOLATILE PARALLEL UNSAFE
		AS $BODY$
		DECLARE 
						def_partition	text;
						i	timestamp without time zone;
						partition_to_create	text;
						previous_partition	text;
						next_partition	text;
						start_of_partition 	timestamp without time zone;
						end_of_partition 	timestamp without time zone;
					BEGIN
						def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
						
						EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || org_id || '_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
							|| def_partition || ';';
			
						EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || org_id || '_notification_instance') || ' ON COMMIT DROP AS SELECT * FROM '
							|| quote_ident(org_id) || '.notification_instance'||' WHERE "eventId" IN (SELECT id FROM '|| 
							quote_ident('temp_' || org_id || '_' || table_name || '_default') ||');';
						
						EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
						
						FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
							SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
							' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || org_id || '_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
						LOOP
							partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
							previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
							next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
					
							IF NOT EXISTS(
								SELECT relname FROM pg_class 
								WHERE relname = previous_partition AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								start_of_partition := date_trunc('month', i);
							ELSE
								start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
									from pg_class c
									where relname = previous_partition and 
									(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
							END IF;
							
							IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								end_of_partition := date_trunc('month', i) + interval '1 month';
							ELSE
								end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
									from pg_class c
									where relname = next_partition and 
									(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
							END IF;
							
							IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
									|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
									|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
							END IF;
							
							EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
							|| ' SELECT * FROM '|| quote_ident('temp_' || org_id || '_' || table_name || '_default') ||' WHERE '|| 
							quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
							quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
							
						END LOOP;
			
						EXECUTE 'INSERT INTO ' || quote_ident(org_id) ||'.notification_instance SELECT * FROM '
						|| quote_ident('temp_' || org_id || '_notification_instance') || ' ON CONFLICT DO NOTHING;';
						
					RETURN;
					END;
		$BODY$;
		
		ALTER FUNCTION public.fpartitioncretor_for_schema_notification_event(text, text, text)
			OWNER TO ${dbsuperuser};
		
		GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_schema_notification_event(text, text, text) TO PUBLIC;
		
		GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_schema_notification_event(text, text, text) TO ${dbuser};
		
		GRANT EXECUTE ON FUNCTION public.fpartitioncretor_for_schema_notification_event(text, text, text) TO ${dbsuperuser};
		
		
	`);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
