"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    await client.query(`
    ALTER TABLE public.notification_instance
        DROP CONSTRAINT notification_instance_state_check;

    ALTER TABLE public.notification_instance
        ADD CONSTRAINT notification_instance_state_check CHECK (state = ANY ('{1,2,3,4,5,6,7,8}'::smallint[]))
    `);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await client.query(`
    ALTER TABLE public.notification_instance
        DROP CONSTRAINT notification_instance_state_check;

    UPDATE public.notification_instance
        SET state = 3
    WHERE state = 8;

    ALTER TABLE public.notification_instance
        ADD CONSTRAINT notification_instance_state_check CHECK (state = ANY ('{1,2,3,4,5,6,7}'::smallint[]))
    `);
}
exports.down = down;
