"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_constants_1 = require("../../../dal.constants");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const moment_1 = __importDefault(require("moment"));
async function up(client, dbuser, dbsuperuser) {
    let execDate = (0, moment_1.default)().add(1, "day").set("hour", 4).set("minute", 15).set("second", 0).set("millisecond", 0);
    await client.query(`
    INSERT INTO public."${dal_db_armon_schema_1.ArmonSchema.tableNames.scheduled_job}" 
    (id, "createdT", "organizationId", type, enabled, "createdByUserId", interval, "firstExecutionDate", "nextExecutionDate", note, "notificationId")
    VALUES (uuid_generate_v4(), now(), NULL, $1, true, NULL, $2, $3, $3, NULL, NULL)
    `, [107, 2, execDate.toDate()]);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await client.query(`
    DELETE FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.scheduled_job}" WHERE type = $1;
    `, [107]);
}
exports.down = down;
