"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
	INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
	(id, "userId", "organizationId", reason, "startDate")

	SELECT uuid_generate_v4(), uwp."userId", wp."organizationId", 128,
		lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null))
	FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
	INNER JOIN "___ORGANIZATION_ID___"."workPlanPeriods" wpp ON wpp."workPlanId" = uwp."workPlanId"
	INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp.id = uwp."workPlanId"
	INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uo."userId" = uwp."userId"
	INNER JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop ON uop."userId" = uwp."userId"
	WHERE wpp."deletedAt" IS NULL AND wp."deletedAt" IS NULL AND uop."deletedAt" IS NULL AND uo."deletedAt" IS NULL AND NOT uo."isDisabled"
	AND lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null)) IS NOT NULL
	AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null))
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
