"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const uuid = __importStar(require("uuid"));
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
var OrganizationUnitType;
(function (OrganizationUnitType) {
    OrganizationUnitType[OrganizationUnitType["Company"] = 0] = "Company";
    OrganizationUnitType[OrganizationUnitType["Office"] = 1] = "Office";
    OrganizationUnitType[OrganizationUnitType["Team"] = 2] = "Team";
    OrganizationUnitType[OrganizationUnitType["Campus"] = 3] = "Campus";
    OrganizationUnitType[OrganizationUnitType["Building"] = 4] = "Building";
    OrganizationUnitType[OrganizationUnitType["Region"] = 5] = "Region";
    OrganizationUnitType[OrganizationUnitType["Department"] = 6] = "Department";
})(OrganizationUnitType || (OrganizationUnitType = {}));
const buildingData = {
    caption_tr: "Bina",
    caption_en: "Building",
    color: "#009688",
};
const campusData = {
    caption_tr: "Kampüs",
    caption_en: "Campus",
    color: "#03A9f4",
};
const companyData = {
    caption_tr: "Firma",
    caption_en: "Company",
    color: "#AD1457",
};
const departmentData = {
    caption_tr: "Birim",
    caption_en: "Department",
    color: "#FF5722",
};
const officeData = {
    caption_tr: "Ofis",
    caption_en: "Office",
    color: "#FFA000",
};
const regionData = {
    caption_tr: "Bölge",
    caption_en: "Region",
    color: "#607D8B",
};
const teamData = {
    caption_tr: "Takım",
    caption_en: "Team",
    color: "#BA68C8",
};
var OrganizationUserDefinedListType;
(function (OrganizationUserDefinedListType) {
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["Brand"] = 1] = "Brand";
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["Model"] = 2] = "Model";
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["ColorCode"] = 3] = "ColorCode";
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["VehicleType"] = 4] = "VehicleType";
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["VisitorRegistrationPoint"] = 5] = "VisitorRegistrationPoint";
    OrganizationUserDefinedListType[OrganizationUserDefinedListType["OrganizationUnitType"] = 6] = "OrganizationUnitType";
})(OrganizationUserDefinedListType || (OrganizationUserDefinedListType = {}));
var OrganizationUserDefinedListDataType;
(function (OrganizationUserDefinedListDataType) {
    OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["String"] = 1] = "String";
    OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["Number"] = 2] = "Number";
    OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["Date"] = 3] = "Date";
    OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["KeyValue"] = 4] = "KeyValue";
    OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["JSON"] = 5] = "JSON";
})(OrganizationUserDefinedListDataType || (OrganizationUserDefinedListDataType = {}));
async function up(client, dbuser, dbsuperuser) {
    const organizationUserDefinedListOrganizationUnitTypeId = uuid.v4();
    const query = `
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_OrganizationUnitDetaileds";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_OrganizationUnitSiblingsAncestorss";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_VisitDetaileds";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_SearchUserBasics";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_UserBasics";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_UserBasicsGroupeds";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_UserDetaileds";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_UserOrganizationVisitorProfiles";
			DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."mVW_SearchUsers";
			
			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
			ADD COLUMN IF NOT EXISTS "typeId" uuid;

			`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationIds = (await client.query(` SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}";`)).rows.map((r) => r.id);
    if (organizationIds && organizationIds.length) {
        for (const organizationId of organizationIds) {
            const companyId = uuid.v4();
            const officeId = uuid.v4();
            const teamId = uuid.v4();
            const campusId = uuid.v4();
            const buildingId = uuid.v4();
            const regionId = uuid.v4();
            const departmentId = uuid.v4();
            await client.query(`	INSERT INTO "${organizationId}"."organizationUserDefinedLists"
			(id, "organizationId", type, caption, "valueType")
				VALUES ($1, $2, $3, $4, $5);`, [
                organizationUserDefinedListOrganizationUnitTypeId,
                organizationId,
                OrganizationUserDefinedListType.OrganizationUnitType,
                "Birim Türü",
                OrganizationUserDefinedListDataType.JSON,
            ]);
            await client.query(`				INSERT INTO "${organizationId}"."organizationUserDefinedListValues"
					(id, "userDefinedListId", value)
					VALUES ($1, $2, $3), ($4, $5, $6), ($7, $8, $9), ($10, $11, $12), ($13, $14, $15), ($16, $17, $18), ($19, $20, $21)`, [
                buildingId,
                organizationUserDefinedListOrganizationUnitTypeId,
                buildingData,
                campusId,
                organizationUserDefinedListOrganizationUnitTypeId,
                campusData,
                companyId,
                organizationUserDefinedListOrganizationUnitTypeId,
                companyData,
                departmentId,
                organizationUserDefinedListOrganizationUnitTypeId,
                departmentData,
                officeId,
                organizationUserDefinedListOrganizationUnitTypeId,
                officeData,
                regionId,
                organizationUserDefinedListOrganizationUnitTypeId,
                regionData,
                teamId,
                organizationUserDefinedListOrganizationUnitTypeId,
                teamData,
            ]);
            await client.query(`
			UPDATE "${organizationId}"."organizationUnits"
				SET "typeId" = (CASE WHEN type = 0 THEN '${companyId}'::uuid
								WHEN type = 1 THEN '${officeId}'::uuid
								WHEN type = 2 THEN '${teamId}'::uuid
								WHEN type = 3 THEN '${campusId}'::uuid
								WHEN type = 4 THEN '${buildingId}'::uuid
								WHEN type = 5 THEN '${regionId}'::uuid
								ELSE '${departmentId}'::uuid
							END);`);
        }
    }
    const query2 = `
		ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
		DROP COLUMN IF EXISTS "type";

		ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
			ALTER "typeId" SET NOT NULL;

		ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
			ADD CONSTRAINT orgunit_type_id_orguserdefinedlistvalues_id FOREIGN KEY ("typeId") 
			REFERENCES "___ORGANIZATION_ID___"."organizationUserDefinedListValues" (id);
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query2, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
	ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
	ADD COLUMN IF NOT EXISTS "type" integer;

	UPDATE "___ORGANIZATION_ID___"."organizationUnits"
		SET type = 6;

	--ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
	--DROP COLUMN IF EXISTS "typeId";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
