"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `INSERT INTO "___ORGANIZATION_ID___".notification
		(id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification") 
		VALUES (uuid_generate_v4(), now(), NULL, 42, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		
		ALTER TABLE "___ORGANIZATION_ID___"."workPlans"
		ADD COLUMN IF NOT EXISTS "geoLocations" jsonb;
		
		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `DELETE FROM "___ORGANIZATION_ID___".notification
			WHERE type = 42;
			
			ALTER TABLE "___ORGANIZATION_ID___"."workPlans"
			DROP COLUMN IF EXISTS "geoLocations";
			`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
