"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArmonSchema = void 0;
const moment_1 = __importDefault(require("moment"));
const uuid_1 = __importDefault(require("uuid"));
const app_enums_1 = require("../../../app.enums");
const predefined_roles_1 = require("../predefined/predefined.roles");
var ArmonSchema;
(function (ArmonSchema) {
    ArmonSchema.functionNames = {
        authorizeUserFor: "fauthorizeuserfor",
        collectusersforaccessreportfilter: "fcollectusersforaccessreportfilter",
        getorganizationunitdetailed: "fgetorganizationunitdetailed",
        userfilterresult: "user_filter_result",
    };
    ArmonSchema.viewNames = {
        vW_AccessControlPointDetaileds: "vW_AccessControlPointDetaileds",
        vW_ControlPanelAccessRightCredentials: "vW_ControlPanelAccessRightCredentials",
        vW_AccessControlPointsReaders: "vW_AccessControlPointsReaders",
        vW_ControlPanelConfigurationSettings: "vW_ControlPanelConfigurationSettings",
        vW_CredentialUserProfiles: "vW_CredentialUserProfiles",
        vW_UserOrganizationUnitHierarchys: "vW_UserOrganizationUnitHierarchys",
        vW_UserHierarchys: "vW_UserHierarchys",
        vW_UserRemoteAccessControlPoints: "vW_UserRemoteAccessControlPoints",
        vW_WorkingHoursSchedules: "vW_WorkingHoursSchedules",
        vW_SearchPPermissions: "vW_SearchPPermissions",
        vW_WorkPlanPeriodTstzrange: "vW_WorkPlanPeriodTstzrange",
        vwUserFilter: "vw_user_filter",
        mVW_SearchUsers: "mVW_SearchUsers",
    };
    ArmonSchema.filterColumns = {
        AccessLogs: "actionUtc",
        Notifications: "actionUtc",
        StatusSensorLogs: "actionUtc",
        TamperSwitchLogs: "actionUtc",
        CounterSensorLogs: "actionUtc",
        UploadLogHistory: "actionUtc",
        VisitHistory: "startUtc",
        UserMonthlySummaryHistory: "actionUtc",
        MonthlySummaryHistory: "actionUtc",
        AccessSnapshots: "actionUtc",
        PPermissionHistory: "actionUtc",
        VisitorPreregistrationHistory: "actionUtc",
        UserTicketTransactionHistory: "actionUtc",
        OrganizationFeedbacks: "actionUtc",
        OrganizationFeedbackUpdates: "actionUtc",
        UserActionHistory: "actionUtc",
        AuditLogs: "actionUtc",
        SystemStatusLogs: "actionUtc",
        LogHistory: "insertionUtc",
        LogProcessHistory: "startUtc",
    };
    ArmonSchema.publicSchemaTableNames = {
        AuditLogs: "audit_logs",
        emailTemplates: "emailTemplates",
        migration: "migration",
        organizationAuthenticationMethods: "organizationAuthenticationMethods",
        organizationList: "organizationList",
        rateLimits: "rate_limits",
        scheduledJobHistoryLogs: "scheduledJobHistoryLogs",
        scheduled_job: "scheduled_job",
        things: "things",
        userList: "userList",
        userOrganizationMapping: "userOrganizationMapping",
    };
    ArmonSchema.orgBasedSchemaTableNames = {
        AccessLogs: "access_logs",
        AccessLogsArvento: "access_logs_arvento",
        AccessSnapshots: "access_snapshots",
        CounterSensorLogs: "counter_sensor_logs",
        dynamicForms: "dynamicForms",
        MonthlySummaryHistory: "monthly_summary_history",
        OrganizationFeedbackUpdates: "organization_feedback_updates",
        OrganizationFeedbacks: "organization_feedbacks",
        PPermissionHistory: "ppermission_history",
        StatusSensorLogs: "status_sensor_logs",
        SystemStatusLogs: "system_status_logs",
        TamperSwitchLogs: "tamper_switch_logs",
        UploadLogHistory: "upload_log_history",
        UserActionHistory: "user_action_history",
        UserMonthlySummaryHistory: "user_monthly_summary_history",
        UserTicketTransactionHistory: "user_ticket_transaction_history",
        VisitHistory: "visit_history",
        VisitorPreregistrationHistory: "visitor_preregistration_history",
        LogHistory: "log_history",
        LogProcessHistory: "log_process_history",
        accessControlPoints: "accessControlPoints",
        accessPointQRCode: "access_point_qr_code",
        accessRuleSets: "accessRuleSets",
        accessRules: "accessRules",
        accessRuleHistory: "accessRuleHistory",
        aperioLocks: "aperioLocks",
        antiPassbackStates: "antiPassbackStates",
        cameras: "cameras",
        CheckInTablet: "check_in_tablet",
        employeeDays: "employee_days",
        employeeMonths: "employeeMonths",
        employeeLiveDay: "employeeLiveDay",
        floorPlans: "floorPlans",
        integration_idmap: "integration_idmap",
        integration_ops: "integration_ops",
        integration_tasks: "integration_tasks",
        integrationClients: "integrationClients",
        monthlySummaryReports: "monthlySummaryReports",
        notification: "notification",
        notificationEvent: "notification_event",
        notificationInstance: "notification_instance",
        notificationUnsubscribe: "notification_unsubscribe",
        oAuthClients: "oAuthClients",
        oAuthTokens: "oAuthTokens",
        organizationActiveVisits: "organizationActiveVisits",
        organizationFeedbacks: "organizationFeedbacks",
        organizationForms: "organizationForms",
        organizationModules: "organizationModules",
        organizationPACSModuleSettings: "organizationPACSModuleSettings",
        organizations: "organizations",
        organizationUnitDefaultAccessControlPoints: "organizationUnitDefaultAccessControlPoints",
        organizationUnits: "organizationUnits",
        organizationVisitorModuleSettings: "organizationVisitorModuleSettings",
        organizationVisitorProfiles: "organizationVisitorProfiles",
        organizationVisitorStates: "organizationVisitorStates",
        pacsNotificationScheduledJobs: "pacs_notification_scheduled_job",
        ppermissionAttachments: "ppermissionAttachments",
        ppermissionClaims: "ppermissionClaims",
        ppermissions: "ppermissions",
        ppermissionTypeApprovements: "ppermissionTypeApprovements",
        ppermissionTypes: "ppermissionTypes",
        ppermissionTypeRules: "ppermission_type_rules",
        recalculateWorkQueue: "recalculateWorkQueue",
        regionAccessControlPoints: "regionAccessControlPoints",
        regionTickets: "regionTickets",
        regions: "regions",
        reportScheduledJobs: "report_scheduled_job",
        reportTemplates: "report_templates",
        roles: "roles",
        secrets: "secrets",
        shiftTemplates: "shift_templates",
        userAccessRights: "userAccessRights",
        userGroups: "userGroups",
        userGroupUserOrganizations: "userGroupUserOrganizations",
        userGroupAccessRuleSets: "userGroupAccessRuleSets",
        userOrganizationCredentials: "userOrganizationCredentials",
        userOrganizationDeputies: "userOrganizationDeputies",
        userOrganizationOrganizationUnits: "userOrganizationOrganizationUnits",
        userOrganizationProfilePhotos: "userOrganizationProfilePhotos",
        userOrganizationProfiles: "userOrganizationProfiles",
        userOrganizations: "userOrganizations",
        userOrganizationSettings: "userOrganizationSettings",
        userPPermissionApprovements: "userPPermissionApprovements",
        userPPermissions: "userPPermissions",
        userProfiles: "userProfiles",
        userRegionStates: "user_region_states",
        users: "users",
        userRegionTicketUnits: "userRegionTicketUnits",
        userSelectionSessionActions: "userSelectionSessionActions",
        userSelectionSessions: "userSelectionSessions",
        userWorkPlans: "userWorkPlans",
        vacations: "vacations",
        visitorRegistrationPoints: "visitorRegistrationPoints",
        visitorRegistrationPointAccessControlPoints: "visitorRegistrationPointAccessControlPoints",
        workPlanPeriods: "workPlanPeriods",
        workPlans: "workPlans",
        workPlanImportRules: "workplan_import_rules",
        unhandledDeviceLogs: "unhandled_device_log",
        devices: "devices",
        deviceDryContactInputs: "deviceDryContactInputs",
        deviceWiegandReaders: "deviceWiegandReaders",
        deviceRelays: "deviceRelays",
        adapters: "adapters",
        transaction: "transaction",
        terminalChanges: "terminalChanges",
        terminalChangeTransactions: "terminalChangeTransactions",
        terminalAdministrators: "terminalAdministrators",
        visitorDailySummaries: "visitorDailySummaries",
        visitorScheduledJob: "visitor_scheduled_job",
        controlPanelESeriesSettings: "controlPanelESeriesSettings",
        controlPanelMSeriesSettings: "controlPanelMSeriesSettings",
        controlPanelMSeriesAnalogInputs: "controlPanelMSeriesAnalogInputs",
        organizationUserDefinedLists: "organizationUserDefinedLists",
        organizationUserDefinedListValues: "organizationUserDefinedListValues",
        userOrganizationForbiddances: "userOrganizationForbiddances",
        organizationEmailTemplates: "organizationEmailTemplates",
        deviceCurrentVersions: "deviceCurrentVersions",
        deviceUpdateStatus: "deviceUpdateStatus",
        deviceIntegrations: "deviceIntegrations",
        hikVisionLicencePlateCameraLanes: "hikVisionLicencePlateCameraLanes",
        impinjSpeedWayGateWayAntennas: "impinjSpeedWayGateWayAntennas",
        notificationAttachments: "notificationAttachments",
        deviceReaders: "deviceReaders",
        cameraActions: "cameraActions",
        preregisterDailySummaries: "preregisterDailySummaries",
        customReports: "customReports",
        preparedReports: "preparedReports",
        notificationAccess: "notification_access",
        notificationSensor: "notification_sensor",
        userFilter: "user_filter",
        userFilterUser: "user_filter_user",
        userFilterGroup: "user_filter_group",
        userFilterOrganizationRole: "user_filter_organization_role",
        userFilterWorkPlan: "user_filter_work_plan",
        userFilterUnit: "user_filter_unit",
        userFilterUnitRole: "user_filter_unit_role",
        userFilterAccessControlPoints: "user_filter_access_control_points",
        filterResult: "filter_result",
        zz_user_organization_forbiddances: "zz_user_organization_forbiddances",
        zz_notification: "zz_notification",
        zz_notification_access: "zz_notification_access",
        zz_notification_event: "zz_notification_event",
        zz_notification_instance: "zz_notification_instance",
        zz_notification_instance_state: "zz_notification_instance_state",
        zz_notification_sensor: "zz_notification_sensor",
        zz_pacs_notification_scheduled_job: "zz_pacs_notification_scheduled_job",
        zz_visitor_scheduled_job: "zz_visitor_scheduled_job",
        region_administrators: "region_administrators",
        autoShiftRuleSet: "auto_shift_rule_set",
        autoShiftRuleSetGroup: "auto_shift_rule_set_group",
        autoShiftRuleSetRegion: "auto_shift_rule_set_region",
    };
    ArmonSchema.unknownCredentialOwnerId = "3463d879-f939-404b-9bcb-b00fabd5eb04";
    ArmonSchema.tableNames = { ...ArmonSchema.orgBasedSchemaTableNames, ...ArmonSchema.publicSchemaTableNames };
    ArmonSchema.partitionedTableList = [
        ArmonSchema.tableNames.AccessLogs,
        ArmonSchema.tableNames.AccessSnapshots,
        ArmonSchema.tableNames.CounterSensorLogs,
        ArmonSchema.tableNames.employeeDays,
        ArmonSchema.tableNames.MonthlySummaryHistory,
        ArmonSchema.tableNames.OrganizationFeedbackUpdates,
        ArmonSchema.tableNames.OrganizationFeedbacks,
        ArmonSchema.tableNames.PPermissionHistory,
        ArmonSchema.tableNames.StatusSensorLogs,
        ArmonSchema.tableNames.SystemStatusLogs,
        ArmonSchema.tableNames.TamperSwitchLogs,
        ArmonSchema.tableNames.UploadLogHistory,
        ArmonSchema.tableNames.UserActionHistory,
        ArmonSchema.tableNames.UserMonthlySummaryHistory,
        ArmonSchema.tableNames.UserTicketTransactionHistory,
        ArmonSchema.tableNames.VisitHistory,
        ArmonSchema.tableNames.VisitorPreregistrationHistory,
        ArmonSchema.tableNames.LogHistory,
        ArmonSchema.tableNames.LogProcessHistory,
        ArmonSchema.tableNames.AuditLogs,
        ArmonSchema.tableNames.notificationEvent,
        ArmonSchema.tableNames.notificationInstance,
        ArmonSchema.tableNames.transaction,
        ArmonSchema.tableNames.zz_notification,
        ArmonSchema.tableNames.zz_notification_access,
        ArmonSchema.tableNames.zz_notification_sensor,
        ArmonSchema.tableNames.zz_pacs_notification_scheduled_job,
    ];
    ArmonSchema.tableDropOrderedList = [
        ArmonSchema.tableNames.AccessLogs,
        ArmonSchema.tableNames.TamperSwitchLogs,
        ArmonSchema.tableNames.StatusSensorLogs,
        ArmonSchema.tableNames.CounterSensorLogs,
        ArmonSchema.tableNames.UploadLogHistory,
        ArmonSchema.tableNames.VisitHistory,
        ArmonSchema.tableNames.UserMonthlySummaryHistory,
        ArmonSchema.tableNames.MonthlySummaryHistory,
        ArmonSchema.tableNames.PPermissionHistory,
        ArmonSchema.tableNames.AccessSnapshots,
        ArmonSchema.tableNames.VisitorPreregistrationHistory,
        ArmonSchema.tableNames.UserTicketTransactionHistory,
        ArmonSchema.tableNames.UserActionHistory,
        ArmonSchema.tableNames.OrganizationFeedbacks,
        ArmonSchema.tableNames.OrganizationFeedbackUpdates,
        ArmonSchema.tableNames.AuditLogs,
        ArmonSchema.tableNames.migration,
        ArmonSchema.tableNames.customReports,
        ArmonSchema.tableNames.employeeLiveDay,
        ArmonSchema.tableNames.employeeMonths,
        ArmonSchema.tableNames.employeeDays,
        ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes,
        ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas,
        ArmonSchema.tableNames.notificationAttachments,
        ArmonSchema.tableNames.deviceIntegrations,
        ArmonSchema.tableNames.organizationEmailTemplates,
        ArmonSchema.tableNames.floorPlans,
        ArmonSchema.tableNames.aperioLocks,
        ArmonSchema.tableNames.userOrganizationForbiddances,
        ArmonSchema.tableNames.organizationUserDefinedListValues,
        ArmonSchema.tableNames.organizationUserDefinedLists,
        ArmonSchema.tableNames.visitorDailySummaries,
        ArmonSchema.tableNames.vacations,
        ArmonSchema.tableNames.cameraActions,
        ArmonSchema.tableNames.cameras,
        ArmonSchema.tableNames.floorPlans,
        ArmonSchema.tableNames.organizationFeedbacks,
        ArmonSchema.tableNames.visitorRegistrationPointAccessControlPoints,
        ArmonSchema.tableNames.userSelectionSessionActions,
        ArmonSchema.tableNames.emailTemplates,
        ArmonSchema.tableNames.monthlySummaryReports,
        ArmonSchema.tableNames.userOrganizationDeputies,
        ArmonSchema.tableNames.userWorkPlans,
        ArmonSchema.tableNames.workPlanPeriods,
        ArmonSchema.tableNames.workPlans,
        ArmonSchema.tableNames.scheduledJobHistoryLogs,
        ArmonSchema.tableNames.scheduled_job,
        ArmonSchema.tableNames.userPPermissionApprovements,
        ArmonSchema.tableNames.ppermissionClaims,
        ArmonSchema.tableNames.ppermissionAttachments,
        ArmonSchema.tableNames.userPPermissions,
        ArmonSchema.tableNames.ppermissions,
        ArmonSchema.tableNames.ppermissionTypeApprovements,
        ArmonSchema.tableNames.ppermissionTypes,
        ArmonSchema.tableNames.antiPassbackStates,
        ArmonSchema.tableNames.regionAccessControlPoints,
        ArmonSchema.tableNames.userRegionTicketUnits,
        ArmonSchema.tableNames.regionTickets,
        ArmonSchema.tableNames.organizationActiveVisits,
        ArmonSchema.tableNames.visitorRegistrationPoints,
        ArmonSchema.tableNames.visitorRegistrationPointAccessControlPoints,
        ArmonSchema.tableNames.organizationVisitorStates,
        ArmonSchema.tableNames.organizationVisitorProfiles,
        ArmonSchema.tableNames.organizationVisitorModuleSettings,
        ArmonSchema.tableNames.organizationUnitDefaultAccessControlPoints,
        ArmonSchema.tableNames.userSelectionSessions,
        ArmonSchema.tableNames.userGroupUserOrganizations,
        ArmonSchema.tableNames.userAccessRights,
        ArmonSchema.tableNames.userOrganizationForbiddances,
        ArmonSchema.tableNames.userOrganizationCredentials,
        ArmonSchema.tableNames.userOrganizationOrganizationUnits,
        ArmonSchema.tableNames.userGroupAccessRuleSets,
        ArmonSchema.tableNames.userGroups,
        ArmonSchema.tableNames.accessRuleHistory,
        ArmonSchema.tableNames.accessRules,
        ArmonSchema.tableNames.accessRuleSets,
        ArmonSchema.tableNames.regions,
        ArmonSchema.tableNames.organizationUnits,
        ArmonSchema.tableNames.userOrganizationProfilePhotos,
        ArmonSchema.tableNames.userOrganizationProfiles,
        ArmonSchema.tableNames.reportTemplates,
        ArmonSchema.tableNames.oAuthTokens,
        ArmonSchema.tableNames.oAuthClients,
        ArmonSchema.tableNames.userOrganizationSettings,
        ArmonSchema.tableNames.userOrganizations,
        ArmonSchema.tableNames.userProfiles,
        ArmonSchema.tableNames.recalculateWorkQueue,
        ArmonSchema.tableNames.users,
        ArmonSchema.tableNames.organizationPACSModuleSettings,
        ArmonSchema.tableNames.organizationModules,
        ArmonSchema.tableNames.organizationForms,
        ArmonSchema.tableNames.controlPanelESeriesSettings,
        ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs,
        ArmonSchema.tableNames.controlPanelMSeriesSettings,
        ArmonSchema.tableNames.deviceUpdateStatus,
        ArmonSchema.tableNames.deviceCurrentVersions,
        ArmonSchema.tableNames.deviceDryContactInputs,
        ArmonSchema.tableNames.deviceWiegandReaders,
        ArmonSchema.tableNames.deviceRelays,
        ArmonSchema.tableNames.accessControlPoints,
        ArmonSchema.tableNames.terminalChanges,
        ArmonSchema.tableNames.terminalChangeTransactions,
        ArmonSchema.tableNames.devices,
        ArmonSchema.tableNames.organizationAuthenticationMethods,
        ArmonSchema.tableNames.adapters,
        ArmonSchema.tableNames.roles,
        ArmonSchema.tableNames.things,
        ArmonSchema.tableNames.organizations,
    ];
    ArmonSchema.viewList = [
        ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange,
        ArmonSchema.viewNames.vW_AccessControlPointDetaileds,
        ArmonSchema.viewNames.vW_AccessControlPointsReaders,
        ArmonSchema.viewNames.vW_ControlPanelAccessRightCredentials,
        ArmonSchema.viewNames.vW_ControlPanelConfigurationSettings,
        ArmonSchema.viewNames.vW_CredentialUserProfiles,
        ArmonSchema.viewNames.vW_UserHierarchys,
        ArmonSchema.viewNames.vW_UserOrganizationUnitHierarchys,
        ArmonSchema.viewNames.vW_UserRemoteAccessControlPoints,
        ArmonSchema.viewNames.vW_WorkingHoursSchedules,
    ];
    ArmonSchema.functionList = [
        ArmonSchema.functionNames.authorizeUserFor,
        ArmonSchema.functionNames.collectusersforaccessreportfilter,
        ArmonSchema.functionNames.getorganizationunitdetailed,
    ];
    function isVisitor(v) {
        return v == predefined_roles_1.PredefinedRoles.OrganizationVisitor.id || v == predefined_roles_1.PredefinedRoles.OrganizationUnitVisitor.id;
    }
    let Models;
    (function (Models) {
        function generatePSQLNoSqlAccessLogForDevice(organizationId, m) {
            return {
                id: m.id || uuid_1.default.v4(),
                rm: m.rm || app_enums_1.enums.LogReceiveMethod.Instant,
                u: m.u,
                oId: organizationId,
                a: m.a,
                r: m.r,
                o: m.o || ArmonSchema.unknownCredentialOwnerId,
                i: m.i || null,
                ci: m.ci || null,
                re: m.re || null,
                rx: m.rx || null,
                cid: m.cid || null,
                d: m.d ?? null,
                an: m.an || null,
                on: m.on || null,
                c: m.c || null,
                di: m.di || null,
                ir: m.ir || null,
                iq: m.iq || null,
                m: m.m || null,
                ul: m.ul || null,
                rg: m.rg || null,
                sid: m.sid || null,
                s: m.s || null,
                v: m.v || null,
                cx: m.cx || null,
                mp: m.mp || null,
                ss: m.ss || null,
                cs: m.cs || null,
                lt: m.lt || null,
                ln: m.ln || null,
                lr: m.lr !== undefined ? m.lr : null,
                ma: m.ma || false,
            };
        }
        Models.generatePSQLNoSqlAccessLogForDevice = generatePSQLNoSqlAccessLogForDevice;
        function generatePSQLNoSqlStatusSensorLogsFrom(organizationId, logs) {
            return logs.map((log) => {
                return {
                    u: log.u,
                    oId: organizationId,
                    ai: log.a,
                    n: log.n,
                    ci: log.ci,
                    s: log.s,
                    t: log.t || null,
                    o: log.o || null,
                    w: log.w,
                    i: log.i,
                    r: log.r,
                };
            });
        }
        Models.generatePSQLNoSqlStatusSensorLogsFrom = generatePSQLNoSqlStatusSensorLogsFrom;
        function generatePSQLUploadLogHistory(organizationId, controlPanelId, uploadId, count) {
            return {
                u: new Date().toISOString(),
                oId: organizationId,
                cid: controlPanelId,
                uid: uploadId,
                c: count,
            };
        }
        Models.generatePSQLUploadLogHistory = generatePSQLUploadLogHistory;
        class MongoDate {
            constructor(date) {
                this.local_time = (0, moment_1.default)(date).toDate();
                this.time_diff = (0, moment_1.default)(date).utcOffset() * 60;
                this.utc_date = (0, moment_1.default)(date).unix() - this.time_diff;
            }
        }
        Models.MongoDate = MongoDate;
        let OAuthClientProfile;
        (function (OAuthClientProfile) {
            OAuthClientProfile[OAuthClientProfile["WebApplication"] = 0] = "WebApplication";
            OAuthClientProfile[OAuthClientProfile["UserAgent"] = 1] = "UserAgent";
            OAuthClientProfile[OAuthClientProfile["Native"] = 2] = "Native";
        })(OAuthClientProfile = Models.OAuthClientProfile || (Models.OAuthClientProfile = {}));
    })(Models = ArmonSchema.Models || (ArmonSchema.Models = {}));
    let OAuthClientProfile;
    (function (OAuthClientProfile) {
        OAuthClientProfile[OAuthClientProfile["WebApplication"] = 0] = "WebApplication";
        OAuthClientProfile[OAuthClientProfile["UserAgent"] = 1] = "UserAgent";
        OAuthClientProfile[OAuthClientProfile["Native"] = 2] = "Native";
    })(OAuthClientProfile = ArmonSchema.OAuthClientProfile || (ArmonSchema.OAuthClientProfile = {}));
})(ArmonSchema = exports.ArmonSchema || (exports.ArmonSchema = {}));
