"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const redis_1 = require("redis");
const app_logs_1 = require("../../../app.logs");
class Redis {
    async connect(params) {
        if (this._client) {
            return this._client;
        }
        this._client = await new Promise((resolve, reject) => {
            const isSecure = params.url.startsWith("rediss");
            const client = (0, redis_1.createClient)({
                url: params.url,
                socket: {
                    ca: isSecure ? [Buffer.from(params.ca)] : undefined,
                    cert: isSecure ? Buffer.from(params.cert) : undefined,
                    key: isSecure ? Buffer.from(params.key) : undefined,
                    tls: isSecure,
                },
            });
            client.once("ready", () => {
                app_logs_1.logger.info("Redis connected");
                resolve(client);
            });
            client.once("err", (err) => {
                reject(err);
            });
            client.connect();
        });
        if (!this._client.isReady) {
            throw new Error("Redis is not connected!");
        }
        return this._client;
    }
    get client() {
        return this._client;
    }
}
const redisClient = new Redis();
exports.default = redisClient;
