"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PSQLDalAccessDevice = void 0;
const libModels = __importStar(require("../../../lib/access-model"));
const enums_1 = require("../../../lib/access-model/v2/enums");
const crypto_1 = __importDefault(require("crypto"));
const lodash_1 = __importDefault(require("lodash"));
const moment_1 = __importDefault(require("moment"));
const api_error_1 = require("../../../api/api.error");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const business_device_1 = require("../../../business/business.device");
const restapi_1 = require("../../../lib/es/models/restapi");
const dal_constants_1 = require("../../dal.constants");
const dal_manager_1 = require("../../dal.manager");
const dal_utils_1 = require("../../dal.utils");
const dal_db_armon_schema_1 = require("../../db/armon/dal.db.armon.schema");
const predefined_roles_1 = require("../../db/predefined/predefined.roles");
const dal_access_error_1 = require("../dal.access.error");
const dal_access_rdb_device_1 = require("../rdb/dal.access.rdb.device");
const uuid = require("uuid");
const cli_queries_1 = require("./cli-queries");
const dal_access_psql_common_1 = require("./dal.access.psql.common");
const Cursor = require("pg-cursor");
class PSQLDalAccessDevice extends dal_access_rdb_device_1.RDBDalAccessDevice {
    constructor(knex, pgPool) {
        super(knex, pgPool);
    }
    async reportSensorInformation(params) {
        let result = {
            paginationResponse: {
                take: params.filter.pagination.take,
                skip: params.filter.pagination.skip,
                total: 0,
            },
            items: [],
        };
        const dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
            const items = [];
            let filterResult;
            let filterQParamsIndex = 1;
            const filterQParams = [];
            const filterQWheres = [];
            let filterQ = `
					SELECT dry.* FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs}" AS dry
					INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
						ON d.id = dry."deviceId"
				`;
            filterQWheres.push(`
					dry."deviceId" IN (
						SELECT cpess."deviceId"  FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}" AS cpess
							ON di.id = cpess."mainControlPanelId"
						LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
							ON ta."terminalId" = cpess."mainControlPanelId"
						WHERE di."deletedAt" IS NULL AND
							(ta."terminalId" IS NULL OR ta."userId" =  $${filterQParamsIndex})

						UNION ALL 
						SELECT di2."id" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di2
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings}" AS cpmss
							ON di2.id = cpmss."deviceId"
						LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
							ON ta."terminalId" = di2."id"
						WHERE di2."deletedAt" IS NULL AND
							(ta."userId" = $${filterQParamsIndex} OR ta."terminalId" IS NULL)

						UNION ALL 
						SELECT al."lockDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di3
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}" AS al
							ON di3.id = al."hubDeviceId"
						LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
							ON ta."terminalId" = di3."id"
						WHERE di3."deletedAt" IS NULL AND
							(ta."userId" = $${filterQParamsIndex} OR ta."terminalId" IS NULL)

						UNION ALL 
						SELECT di4."id" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di4
						LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
							ON ta."terminalId" = di4."id"
						WHERE di4."deletedAt" IS NULL AND
							(ta."userId" = $${filterQParamsIndex++} OR ta."terminalId" IS NULL)
					)
				`);
            filterQWheres.push(`dry."deletedAt" IS NULL`);
            filterQWheres.push(`d."deletedAt" IS NULL`);
            filterQParams.push(params.requesterUserId);
            if (params.filter.terminalDeviceIds?.length) {
                filterQWheres.push(`(
						dry."deviceId" = ANY ($${filterQParamsIndex}::UUID[])
						OR dry."deviceId" IN ( SELECT "lockDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}"
							WHERE "hubDeviceId" = ANY ($${filterQParamsIndex}::UUID[]) )
						OR dry."deviceId" IN ( SELECT "deviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}"
							WHERE "mainControlPanelId" = ANY ($${filterQParamsIndex}::UUID[]) )
						OR dry."deviceId" IN ( SELECT "integratingDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations}"
							WHERE "integratedDeviceId" = ANY ($${filterQParamsIndex}::UUID[]) )
					)`);
                filterQParams.push(params.filter.terminalDeviceIds);
                filterQParamsIndex++;
            }
            if (params.filter.sensorIds?.length) {
                filterQWheres.push(`dry."id" = ANY ($${filterQParamsIndex++}::UUID[])`);
                filterQParams.push(params.filter.sensorIds);
            }
            if (params.filter.type) {
                filterQWheres.push(`dry."type" = $${filterQParamsIndex++}`);
                filterQParams.push(params.filter.type);
            }
            else {
                filterQWheres.push(`dry."type" = ANY ($${filterQParamsIndex++}::INTEGER[])`);
                filterQParams.push([dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor, dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch]);
            }
            if (params.filter.regionIds) {
                filterQ += `
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON d.id = acp."deviceId"
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
					`;
                filterQWheres.push(`racp."regionId" = ANY ($${filterQParamsIndex++}::UUID[])`);
                filterQParams.push(params.filter.sensorIds);
                filterQWheres.push(`acp."deletedAt" IS NULL`);
            }
            filterQ += " WHERE " + filterQWheres.join(" AND ") + " ORDER BY dry.id";
            filterResult = (await trx.query(filterQ, filterQParams)).rows;
            if (filterResult.length == 0) {
                return Promise.resolve([]);
            }
            const dryContactInfos = await this.getDryContactsInfo(params.organizationId, filterResult, trx);
            const accessLogIds = dryContactInfos
                .filter((dci) => dci.item.input.type === dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor && dci.lastLog && dci.lastLog.l)
                .map((dci) => dci.lastLog.l);
            const accessLogsOfSensorLogs = await dal_manager_1.dbManager.accessLog.getAccessLogsForSensorReport({
                organizationId: params.organizationId,
                ids: accessLogIds,
                dateRange: {
                    startDateTime: (0, moment_1.default)(new Date()).add(-30, "days").toDate(),
                    endDateTime: (0, moment_1.default)(new Date()).endOf("day").toDate(),
                },
                trx: trx,
            });
            for (const dryContact of filterResult) {
                let item = {
                    terminal: null,
                    accessControlPoint: null,
                    input: null,
                    lastAction: null,
                };
                let dryContactInfo = dryContactInfos.find((dcil) => dcil.id === dryContact.id);
                if (!dryContactInfo) {
                    continue;
                }
                else if (dryContactInfo.item && dryContactInfo.item.terminal) {
                    item.terminal = dryContactInfo.item.terminal;
                    item.accessControlPoint = dryContactInfo.item.accessControlPoint;
                    item.input = dryContactInfo.item.input;
                }
                if (dryContact.type == dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor) {
                    const statusSensorLog = dryContactInfo.lastLog;
                    if (params.filter.reason !== null && params.filter.reason !== undefined) {
                        if (!statusSensorLog || params.filter.reason !== statusSensorLog.r)
                            continue;
                    }
                    if (params.filter.state !== null && params.filter.state !== undefined) {
                        if (!statusSensorLog || params.filter.state !== statusSensorLog.s)
                            continue;
                    }
                    if (statusSensorLog && statusSensorLog.l) {
                        let accessLog = accessLogsOfSensorLogs.find((alosl) => alosl.id === statusSensorLog.l);
                        item.lastAction = await this.createLastActionForSensorReport(accessLog != null && accessLog[0] != null ? accessLog[0] : null, statusSensorLog, params.organizationId);
                    }
                }
                else if (dryContact.type == dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor) {
                    const counterSensorLog = dryContactInfo.lastLog;
                    if (params.filter.reason !== null && params.filter.reason !== undefined) {
                        if (!counterSensorLog || params.filter.reason !== counterSensorLog.r)
                            continue;
                    }
                }
                else if (dryContact.type == dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch) {
                    const tamperSwitchLog = dryContactInfo.lastLog;
                    if (params.filter.state !== null && params.filter.state !== undefined) {
                        if (!tamperSwitchLog || params.filter.state !== tamperSwitchLog.s)
                            continue;
                    }
                    item.lastAction = {
                        accessLog: null,
                        actionDateTime: tamperSwitchLog && tamperSwitchLog.u ? tamperSwitchLog.u : null,
                        reason: null,
                        state: tamperSwitchLog && tamperSwitchLog.s !== null ? tamperSwitchLog.s : null,
                        stateBeforeAction: tamperSwitchLog &&
                            tamperSwitchLog.s !== null &&
                            tamperSwitchLog.s === dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Secure
                            ? dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Tampered
                            : dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Secure,
                    };
                }
                if (item != null && item.terminal != null) {
                    items.push(item);
                }
            }
            return items;
        }, params.requesterUserId, params.organizationId);
        result.paginationResponse.total = dbResult.length;
        result.items = dbResult.slice(params.filter.pagination?.skip || 0, (params.filter.pagination?.skip || 0) + (params.filter.pagination?.take || 30));
        return Promise.resolve(result);
    }
    async reportStatusSensorPendingTimeoutLogs(params) {
        const trxx = params.trx ?? this._pgPool;
        const queryParams = [];
        let query = `SELECT s."dryContactId", s."acpId", s."actionUtc" 
					 FROM ( SELECT DISTINCT ON(log->>'i') log->>'i' as "dryContactId", log->>'a' as "acpId", "actionUtc", log->>'s' as status
							FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.StatusSensorLogs}"
							WHERE ("actionUtc" <= $1 AND "actionUtc" >= $2)
							ORDER BY log->>'i', "actionUtc" DESC ) s
					 WHERE (s.status)::integer = 2`;
        const oneDaySubstract = params.filter.dateTime.minus({ days: 1 }).toString();
        queryParams.push(params.filter.dateTime, oneDaySubstract);
        const acpIds = [];
        const { rows } = await trxx.query(query, queryParams);
        rows.forEach((elem) => {
            acpIds.push(elem.acpId);
        });
        const acpIdNamePairs = await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointIdName(params.organizationId, acpIds);
        const result = rows.map((elem) => {
            return {
                acpName: acpIdNamePairs.find((idName) => idName.id === elem.acpId).name,
                actionUtc: elem.actionUtc,
            };
        });
        return result;
    }
    async reportSensorsPg(params) {
        const result = {
            paginationResponse: {
                take: params.filter.pagination?.take,
                skip: params.filter.pagination?.skip,
                total: 0,
            },
            items: [],
        };
        const trxx = params.trx ?? this._pgPool;
        let filterResult;
        let filterQParamsIndex = 1;
        const filterQParams = [];
        const filterQWheres = [];
        let filterQ = `
			SELECT dry.* FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs}" AS dry
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
				ON d.id = dry."deviceId"
		`;
        filterQWheres.push(`
			dry."deviceId" IN (
				SELECT cpess."deviceId"  FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}" AS cpess
					ON di.id = cpess."mainControlPanelId"
				LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
					ON ta."terminalId" = cpess."mainControlPanelId"
				WHERE di."deletedAt" IS NULL AND
					(ta."terminalId" IS NULL OR ta."userId" =  $${filterQParamsIndex})

				UNION ALL 
				SELECT di2."id" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di2
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings}" AS cpmss
					ON di2.id = cpmss."deviceId"
				LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
					ON ta."terminalId" = di2."id"
				WHERE di2."deletedAt" IS NULL AND
					(ta."userId" = $${filterQParamsIndex} OR ta."terminalId" IS NULL)

				UNION ALL 
				SELECT al."lockDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di3
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}" AS al
					ON di3.id = al."hubDeviceId"
				LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
					ON ta."terminalId" = di3."id"
				WHERE di3."deletedAt" IS NULL AND
					(ta."userId" = $${filterQParamsIndex} OR ta."terminalId" IS NULL)

				UNION ALL 
				SELECT di4."id" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS di4
				LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
					ON ta."terminalId" = di4."id"
				WHERE di4."deletedAt" IS NULL AND
					(ta."userId" = $${filterQParamsIndex++} OR ta."terminalId" IS NULL)
			)
		`);
        filterQWheres.push(`dry."deletedAt" IS NULL`);
        filterQWheres.push(`d."deletedAt" IS NULL`);
        filterQParams.push(params.requesterUserId);
        if (params.filter.terminalDeviceIds?.length) {
            filterQWheres.push(`(
				dry."deviceId" = ANY ($${filterQParamsIndex}::UUID[])
				OR dry."deviceId" IN ( SELECT "lockDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}"
					WHERE "hubDeviceId" = ANY ($${filterQParamsIndex}::UUID[]) )
				OR dry."deviceId" IN ( SELECT "deviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}"
					WHERE "mainControlPanelId" = ANY ($${filterQParamsIndex}::UUID[]) )
				OR dry."deviceId" IN ( SELECT "integratingDeviceId" FROM  "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations}"
					WHERE "integratedDeviceId" = ANY ($${filterQParamsIndex}::UUID[]) )
			)`);
            filterQParams.push(params.filter.terminalDeviceIds);
            filterQParamsIndex++;
        }
        if (params.filter.sensorIds?.length) {
            filterQWheres.push(`dry."id" = ANY ($${filterQParamsIndex++}::UUID[])`);
            filterQParams.push(params.filter.sensorIds);
        }
        if (params.filter.type) {
            filterQWheres.push(`dry."type" = $${filterQParamsIndex++}`);
            filterQParams.push(params.filter.type);
        }
        else {
            filterQWheres.push(`dry."type" = ANY ($${filterQParamsIndex++}::INTEGER[])`);
            filterQParams.push([dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor, dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch, dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor]);
        }
        filterQ += " WHERE " + filterQWheres.join(" AND ");
        filterResult = (await trxx.query(filterQ, filterQParams)).rows;
        if (filterResult.length == 0) {
            return Promise.resolve(result);
        }
        let dryContactStatusLogsQ = null;
        let dryContactCounterLogsQ = null;
        let dryContactTamperLogsQ = null;
        let logQParamIndex = 1;
        const logQParams = [];
        if (params.filter.type === undefined || params.filter.type === null || params.filter.type === dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor) {
            dryContactStatusLogsQ = `(
				SELECT ${dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor} AS type, "actionUtc", log
				FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.StatusSensorLogs}"
				WHERE "log"->>'i' = ANY ($${logQParamIndex++}) AND
					"actionUtc" >= $${logQParamIndex++} AND "actionUtc" <= $${logQParamIndex++}
			`;
            logQParams.push(filterResult.filter((fr) => fr.type === dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor).map((fr) => fr.id));
            logQParams.push(params.filter.dateRange.startDateTime);
            logQParams.push(params.filter.dateRange.endDateTime);
            const reason = params.filter.reason;
            if (reason !== null && reason !== undefined) {
                dryContactStatusLogsQ += `
					AND "log"->>'r' = $${logQParamIndex++}
				`;
                logQParams.push(reason);
            }
            const state = params.filter.state;
            if (state !== null && state !== undefined) {
                dryContactStatusLogsQ += `
					AND "log"->>'s' = $${logQParamIndex++}
				`;
                logQParams.push(state);
            }
            dryContactStatusLogsQ += `
			)
			`;
        }
        if (params.filter.type === undefined || params.filter.type === null || params.filter.type === dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor) {
            dryContactCounterLogsQ = `(
				SELECT ${dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor} AS type, "actionUtc", log
				FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.CounterSensorLogs}"
				WHERE "log"->>'i' = ANY ($${logQParamIndex++}) AND
					"actionUtc" >= $${logQParamIndex++} AND "actionUtc" <= $${logQParamIndex++}
			`;
            logQParams.push(filterResult.filter((fr) => fr.type === dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor).map((fr) => fr.id));
            logQParams.push(params.filter.dateRange.startDateTime);
            logQParams.push(params.filter.dateRange.endDateTime);
            const reason = params.filter.reason;
            if (reason !== null && reason !== undefined) {
                dryContactCounterLogsQ += `
					AND "log"->>'r' = $${logQParamIndex++}
				`;
                logQParams.push(reason);
            }
            dryContactCounterLogsQ += `
			)
			`;
        }
        if (params.filter.type === undefined || params.filter.type === null || params.filter.type === dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch) {
            dryContactTamperLogsQ = `(
				SELECT ${dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch} AS type, "actionUtc", log
				FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.TamperSwitchLogs}"
				WHERE "log"->>'ci' = ANY ($${logQParamIndex++}) AND
					"actionUtc" >= $${logQParamIndex++} AND "actionUtc" <= $${logQParamIndex++}
			`;
            logQParams.push(filterResult.filter((fr) => fr.type === dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch).map((fr) => fr.deviceId));
            logQParams.push(params.filter.dateRange.startDateTime);
            logQParams.push(params.filter.dateRange.endDateTime);
            const state = params.filter.state;
            if (state !== null && state !== undefined) {
                dryContactTamperLogsQ += `
					AND "log"->>'s' = $${logQParamIndex++}
				`;
                logQParams.push(state);
            }
            dryContactTamperLogsQ += `
			)
			`;
        }
        const countQ = `
			SELECT COUNT(T.*) AS c FROM (
				${dryContactStatusLogsQ ? dryContactStatusLogsQ : ""}
				${dryContactCounterLogsQ ? (dryContactStatusLogsQ ? " UNION ALL " + dryContactCounterLogsQ : dryContactCounterLogsQ) : ""}
				${dryContactTamperLogsQ ? (dryContactCounterLogsQ || dryContactStatusLogsQ ? " UNION ALL " + dryContactTamperLogsQ : dryContactTamperLogsQ) : ""}
			) AS T
		`;
        const countResult = parseInt((await trxx.query(countQ, logQParams)).rows[0].c);
        let finalQ = `
			SELECT T.* FROM (
				${dryContactStatusLogsQ ? dryContactStatusLogsQ : ""}
				${dryContactCounterLogsQ ? (dryContactStatusLogsQ ? " UNION ALL " + dryContactCounterLogsQ : dryContactCounterLogsQ) : ""}
				${dryContactTamperLogsQ ? (dryContactCounterLogsQ || dryContactStatusLogsQ ? " UNION ALL " + dryContactTamperLogsQ : dryContactTamperLogsQ) : ""}
			) AS T
			ORDER BY T."actionUtc" DESC
		`;
        if (params.filter.pagination) {
            finalQ += `		
				OFFSET $${logQParamIndex++} LIMIT $${logQParamIndex++}
			`;
            logQParams.push(params.filter.pagination.skip ?? 0);
            logQParams.push(params.filter.pagination.take ?? 100);
        }
        const logResult = (await trxx.query(finalQ, logQParams)).rows;
        const finalDryContactToReturn = lodash_1.default.uniqBy(logResult.map((r) => {
            if (r.type === dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch) {
                const tamperSwitch = filterResult.find((fr) => fr.deviceId === r.log.ci);
                return tamperSwitch;
            }
            else {
                const sensor = filterResult.find((fr) => fr.id === r.log.i);
                return sensor;
            }
        }), (i) => i.id);
        let accessLogIds = logResult
            .filter((sl) => sl.type === dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor && sl.log.l)
            .map((i) => i.log.l);
        const dryContactInfoList = await this.getDryContactsInfo(params.organizationId, finalDryContactToReturn, trxx);
        const accessLogsOfSensorLogs = await dal_manager_1.dbManager.accessLog.getAccessLogsForSensorReport({
            organizationId: params.organizationId,
            ids: accessLogIds,
            dateRange: params.filter.dateRange,
            trx: trxx,
        });
        for (const iterator of logResult) {
            if (iterator.type === dal_constants_1.DalConstants.DryContactTypeV2.StatusSensor) {
                let dryContactOfLog = finalDryContactToReturn.find((f) => f.id == iterator.log.i);
                let item = {
                    terminal: null,
                    accessControlPoint: null,
                    input: null,
                    lastAction: null,
                };
                if (dryContactOfLog != null) {
                    let dryContactInfo = dryContactInfoList.find((dcil) => dcil.id === dryContactOfLog.id);
                    if (dryContactInfo) {
                        item.terminal = dryContactInfo.item.terminal;
                        item.accessControlPoint = dryContactInfo.item.accessControlPoint;
                        item.input = dryContactInfo.item.input;
                    }
                    let accessLog;
                    if (iterator.log != null && iterator.log.l != null) {
                        accessLog = accessLogsOfSensorLogs.find((al) => (al.id = iterator.log.l));
                    }
                    item.lastAction = await this.createLastActionForSensorReport(accessLog, iterator.log, params.organizationId);
                    if (item != null) {
                        result.items.push(item);
                    }
                }
            }
            else if (iterator.type === dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch) {
                let dryContactOfLog = finalDryContactToReturn.find((f) => f.deviceId == iterator.log.ci);
                let item = {
                    terminal: null,
                    accessControlPoint: null,
                    input: null,
                    lastAction: null,
                };
                if (dryContactOfLog != null) {
                    let dryContactInfo = dryContactInfoList.find((dcil) => dcil.id === dryContactOfLog.id);
                    if (dryContactInfo) {
                        item.terminal = dryContactInfo.item.terminal;
                        item.accessControlPoint = dryContactInfo.item.accessControlPoint;
                        item.input = dryContactInfo.item.input;
                    }
                    item.lastAction = {
                        accessLog: null,
                        actionDateTime: iterator.actionUtc,
                        state: iterator.log.s,
                        reason: null,
                        stateBeforeAction: iterator.log.s === dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Secure
                            ? dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Tampered
                            : dal_constants_1.DalConstants.libEnumsV2.TamperSwitchState.Secure,
                    };
                    if (item != null) {
                        result.items.push(item);
                    }
                }
            }
            else if (iterator.type === dal_constants_1.DalConstants.DryContactTypeV2.CounterSensor) {
                let dryContactOfLog = finalDryContactToReturn.find((f) => f.id == iterator.log.i);
                let item = {
                    terminal: null,
                    accessControlPoint: null,
                    input: null,
                    lastAction: null,
                };
                if (dryContactOfLog != null) {
                    let dryContactInfo = dryContactInfoList.find((dcil) => dcil.id === dryContactOfLog.id);
                    if (dryContactInfo) {
                        item.terminal = dryContactInfo.item.terminal;
                        item.accessControlPoint = dryContactInfo.item.accessControlPoint;
                        item.input = dryContactInfo.item.input;
                    }
                    item.lastAction = {
                        accessLog: null,
                        actionDateTime: iterator.actionUtc,
                        state: null,
                        reason: iterator.log.r,
                        stateBeforeAction: null,
                        direction: dryContactOfLog.settings.direction,
                    };
                    if (item != null) {
                        result.items.push(item);
                    }
                }
            }
        }
        result.paginationResponse.total = countResult;
        return Promise.resolve(result);
    }
    async createLastActionForSensorReport(accessLog, sensorLog, organizationId) {
        let userCaptions = null;
        if (accessLog && accessLog.o && accessLog.o !== dal_db_armon_schema_1.ArmonSchema.unknownCredentialOwnerId) {
            userCaptions = (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId, userId: accessLog.o })).caption;
        }
        let _accessLog = null;
        let actionDateTime = null;
        if (accessLog && accessLog.u) {
            actionDateTime = new Date(accessLog.u);
        }
        if (accessLog) {
            _accessLog = {
                id: accessLog.id,
                user: userCaptions,
                reason: accessLog && accessLog.r != null ? accessLog.r : null,
                actionDateTime: actionDateTime,
            };
        }
        let state = null;
        let stateBeforeAction = null;
        if (sensorLog != null) {
            if (sensorLog.s != null) {
                state = sensorLog.s;
            }
            if (sensorLog.ps != null) {
                stateBeforeAction = sensorLog.ps;
            }
        }
        return {
            accessLog: _accessLog,
            actionDateTime: sensorLog != null && sensorLog.u != null ? new Date(sensorLog.u) : null,
            reason: sensorLog != null && sensorLog.r != null ? sensorLog.r : null,
            stateBeforeAction: stateBeforeAction,
            state: state,
        };
    }
    async getDryContactsInfo(organizationId, dryContactInputs, trx) {
        const trxx = trx ?? this._pgPool;
        const result = [];
        const dryContactInputDevicesRaw = (await trxx.query(`
			SELECT id, name, brand, model, "serialNumber" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
			WHERE id = ANY ($1::UUID[])
				AND "deletedAt" IS NULL
		`, [dryContactInputs.map((dci) => dci.deviceId)])).rows;
        const dryContactInputExtensions = dryContactInputDevicesRaw.filter((dcid) => !dal_constants_1.DalConstants.terminalModels.includes(dcid.model));
        let mainDeviceQ = `
			SELECT T.id, T.name, T.brand, T.model, T."serialNumber", T.number, T."extensionId"
			FROM (
				(
					SELECT d.id, d.name, d.brand, d.model, d."serialNumber", cpe.number, cpe."deviceId" AS "extensionId"
					FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
					INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}" AS cpe
						ON cpe."mainControlPanelId" = d.id
					WHERE d."deletedAt" IS NULL AND
						cpe."deviceId" = ANY($1::UUID[])						
				)
				UNION ALL
				(
					SELECT d.id, d.name, d.brand, d.model, d."serialNumber", NULL AS number, l."lockDeviceId" AS "extensionId"
					FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
					INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}" AS l
						ON l."hubDeviceId" = d.id
					WHERE d."deletedAt" IS NULL AND
						l."lockDeviceId" = ANY($1::UUID[])	
				)
				UNION ALL
				(
					SELECT d.id, d.name, d.brand, d.model, d."serialNumber", NULL AS number, di."integratingDeviceId" AS "extensionId"
					FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
					INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations}" AS di
						ON di."integratedDeviceId" = d.id
					WHERE d."deletedAt" IS NULL AND
						di."integratingDeviceId" = ANY($1::UUID[])	
				)
			) AS T `;
        let mainDevicesOfExtensions = [];
        if (dryContactInputExtensions.length) {
            mainDevicesOfExtensions = (await trxx.query(mainDeviceQ, [
                dryContactInputExtensions.map((dcie) => dcie.id),
            ])).rows;
        }
        const dryContactInputDevices = [];
        for (const dcidr of dryContactInputDevicesRaw) {
            if (dal_constants_1.DalConstants.terminalModels.includes(dcidr.model)) {
                dryContactInputDevices.push(dcidr);
            }
            else {
                const mainDevice = mainDevicesOfExtensions.find((mdoe) => mdoe.extensionId === dcidr.id);
                if (!mainDevice) {
                    continue;
                }
                dryContactInputDevices.push({
                    id: mainDevice.id,
                    name: mainDevice.name,
                    brand: mainDevice.brand,
                    model: mainDevice.model,
                    serialNumber: mainDevice.serialNumber,
                    extension: {
                        id: dcidr.id,
                        name: dcidr.name,
                        brand: dcidr.brand,
                        model: dcidr.model,
                        serialNumber: dcidr.serialNumber,
                        number: mainDevice.number,
                    },
                });
            }
        }
        const acpIds = dryContactInputs.filter((dci) => dci.accessControlPointId !== null && dci.accessControlPointId !== undefined).map((dci) => dci.accessControlPointId);
        let accessControlPoints = [];
        if (acpIds.length) {
            accessControlPoints = (await trxx.query(`
			SELECT id, name, "accessControlPointType", "remoteAvailable" 
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
			WHERE id = ANY ($1::UUID[]);
		`, [acpIds])).rows;
        }
        const dryContactInputSettings = dryContactInputs
            .filter((dci) => dci.type !== dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch && dci.settings !== null && dci.settings !== undefined && dci.settings.relayId)
            .map((dci) => dci.settings);
        const dryContactRelatedRelayIds = dryContactInputSettings.filter((dcis) => dcis.relayId !== null && dcis.relayId !== undefined).map((dcis) => dcis.relayId);
        let dryContactRelays = [];
        if (dryContactRelatedRelayIds.length) {
            dryContactRelays = (await trxx.query(`
				SELECT id, name, "deviceId", number
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays}"
				WHERE id = ANY ($1::UUID[])
		`, [dryContactRelatedRelayIds])).rows;
        }
        let dryContactReaders = [];
        if (dryContactRelatedRelayIds.length) {
            dryContactReaders = (await trxx.query(`
			SELECT id, name, "deviceId", number, "relayId"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders}"
			WHERE "relayId" = ANY ($1::UUID[])
	`, [dryContactRelatedRelayIds])).rows;
        }
        const latestSensorLogs = await dal_manager_1.dbManager.accessLog.getLatestSensorLogs({
            organizationId: organizationId,
            sensors: dryContactInputs.map((dci) => {
                return {
                    type: dci.type,
                    id: dci.id,
                };
            }),
        });
        for (const dci of dryContactInputs) {
            let item = {
                terminal: null,
                accessControlPoint: null,
                input: null,
            };
            const deviceOfDryContact = dryContactInputDevices.find((d) => d.id === dci.deviceId || dci.deviceId === d.extension?.id);
            if (!deviceOfDryContact) {
                continue;
            }
            item.terminal = deviceOfDryContact;
            const accessControlPoint = accessControlPoints.find((acp) => dci.accessControlPointId === acp.id);
            if (accessControlPoint) {
                item.accessControlPoint = {
                    id: accessControlPoint.id,
                    name: accessControlPoint.name,
                    remoteAvailable: accessControlPoint.remoteAvailable,
                    type: accessControlPoint.accessControlPointType,
                    states: null,
                };
            }
            const mappedRelay = dryContactRelays.find((dcr) => dcr.id === dci.settings?.relayId);
            const mappedReader = mappedRelay ? dryContactReaders.find((dcr) => dcr.relayId === dci.settings?.relayId) : null;
            if (mappedReader) {
                delete mappedReader["relayId"];
            }
            const lastLog = latestSensorLogs.find((ll) => ll.id === dci.id)?.log;
            item.input = {
                id: dci.id,
                mappedRelay: mappedRelay,
                mappedReader: mappedReader,
                type: dci.type,
                nc: dci.nc,
                state: lastLog ? lastLog.s : null,
                number: dci.number,
                timeOut: dci.settings?.timeOut,
                name: dci.name ? dci.name : deviceOfDryContact.name + "#" + dci.number,
            };
            result.push({
                id: dci.id,
                item,
                lastLog,
            });
        }
        return Promise.resolve(result);
    }
    async upsertOrganizationAdapters(organizationId, adapters, trx) {
        let result = {
            added: [],
            removed: [],
        };
        let existingIds = (await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("organizationId", organizationId).select("id")).map((m) => m.id);
        let removedIds = existingIds.filter((m) => !adapters.some((a) => a.id === m));
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).whereIn("id", removedIds).delete();
        result.removed = removedIds;
        let now = new Date();
        for (const adapter of adapters) {
            if (existingIds.some((e) => e == adapter.id)) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("id", adapter.id).update({
                    updatedAt: now,
                    number: adapter.number,
                    type: adapter.type,
                    publicKey: adapter.publicKey,
                });
            }
            else {
                await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).insert({
                    id: adapter.id,
                    organizationId: organizationId,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).insert({
                    id: adapter.id,
                    createdAt: now,
                    updatedAt: now,
                    number: adapter.number,
                    type: adapter.type,
                    organizationId: organizationId,
                    publicKey: adapter.publicKey,
                });
                result.added.push(adapter.id);
            }
        }
        return result;
    }
    async upsertOrganizationDevices(organizationId, devices, trx) {
        let result = {
            added: [],
            removed: [],
        };
        let deviceIds = devices.map((d) => d.id);
        let now = new Date();
        let tabletDeviceIds = await trx
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.visitorRegistrationPoints)
            .where("organizationId", organizationId)
            .whereNotNull("tabletDeviceId")
            .select();
        let integrations = await trx
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations)
            .whereIn("integratedDeviceId", deviceIds)
            .select("integratingDeviceId");
        let currentDeviceIds = await trx
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("organizationId", organizationId)
            .whereNotIn("id", tabletDeviceIds.map((t) => t.tabletDeviceId))
            .whereNotIn("id", integrations.map((i) => i.integratingDeviceId))
            .update({
            updatedAt: now,
            deletedAt: now,
        }, "id");
        let removedDeviceIds = currentDeviceIds.filter((d) => !deviceIds.some((dd) => dd === d)).filter((c) => !integrations.some((i) => i.integratingDeviceId == c));
        result.removed = removedDeviceIds;
        await this.removeDeviceActions(organizationId, removedDeviceIds, trx);
        await this.setNullDeviceActions(organizationId, removedDeviceIds, trx);
        const defaultDeviceHealth = {
            version: {
                backendApiVersion: "v3",
            },
        };
        for (const device of devices) {
            let existingDevice = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", device.id).first();
            if (existingDevice) {
                await trx
                    .withSchema(organizationId)
                    .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                    .where("id", device.id)
                    .update({
                    updatedAt: now,
                    deletedAt: null,
                    organizationId: organizationId,
                    adapterId: device.adapterId,
                    brand: device.brand,
                    serialNumber: device.serialNumber,
                    model: device.model,
                    publicKey: device.publicKey,
                    privateKey: device.privateKey,
                    health: dal_constants_1.DalConstants.terminalModels.includes(device.model) ? (existingDevice.health ? existingDevice.health : defaultDeviceHealth) : existingDevice.health,
                });
            }
            else {
                await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).insert({
                    id: device.id,
                    organizationId: organizationId,
                });
                await trx
                    .withSchema(organizationId)
                    .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                    .insert({
                    id: device.id,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    adapterId: device.adapterId,
                    brand: device.brand,
                    serialNumber: device.serialNumber,
                    name: device.model + "/" + device.serialNumber,
                    model: device.model,
                    publicKey: device.publicKey,
                    privateKey: device.privateKey,
                    health: dal_constants_1.DalConstants.terminalModels.includes(device.model) ? defaultDeviceHealth : null,
                });
            }
            result.added.push(device.id);
            switch (device.brand) {
                case dal_constants_1.DalConstants.DeviceBrand.Armon:
                    await this.upsertArmonDevice(organizationId, device, trx);
                    break;
                case dal_constants_1.DalConstants.DeviceBrand.AssaAbloy:
                    await this.upsertAssaAbloyDevice(organizationId, device, trx);
                    break;
            }
        }
        return result;
    }
    async setNullDeviceActions(organizationId, deviceIds, trx) {
        let now = new Date();
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).whereIn("deviceId", deviceIds).update({
            updatedAt: now,
            deletedAt: now,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereIn("deviceId", deviceIds).update({
            updatedAt: now,
            deletedAt: now,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).whereIn("deviceId", deviceIds).update({
            updatedAt: now,
            deletedAt: now,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).whereIn("deviceId", deviceIds).update({
            updatedAt: now,
            deletedAt: now,
        });
    }
    async removeDeviceActions(organizationId, removedDeviceIds, trx) {
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).whereIn("deviceId", removedDeviceIds).update({
            deviceId: null,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).whereIn("deviceId", removedDeviceIds).update({
            accessControlPointId: null,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).whereIn("deviceId", removedDeviceIds).update({
            accessControlPointId: null,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).whereIn("deviceId", removedDeviceIds).update({
            accessControlPointId: null,
        });
        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereIn("deviceId", removedDeviceIds).update({
            accessControlPointId: null,
        });
    }
    async upsertAssaAbloyDevice(organizationId, device, trx) {
        if (device.model === "H100" || device.model === "KS100" || device.model === "C100" || device.model === "L100") {
            const relayIds = await this.upsertGenericRelaysForDevice(organizationId, device.id, 1, trx);
            await this.upsertReaderForAssaAbloyDeviceWithRelayId(organizationId, device.id, 1, relayIds[0], device.serialNumber, trx);
            let dryContactsStatus = await this.upsertGenericDryContactsForDevice(organizationId, device.id, 1, trx);
            await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereIn("id", dryContactsStatus)
                .where("number", 1)
                .update({
                type: dal_constants_1.DalConstants.DryContactType.StatusSensor,
                settings: {
                    relayId: relayIds[0],
                    timeOut: 20,
                },
            });
            if (device.model === "KS100") {
                let dryContactsTamper = await this.upsertGenericDryContactsForDevice(organizationId, device.id, 2, trx);
                await trx
                    .withSchema(organizationId)
                    .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                    .whereIn("id", dryContactsTamper)
                    .where("number", 2)
                    .update({
                    type: dal_constants_1.DalConstants.DryContactType.TamperSwitch,
                    settings: {
                        relayId: relayIds[0],
                    },
                });
            }
        }
    }
    getIOCountsByDeviceModel(model) {
        const result = {
            relayCount: 0,
            readerCount: 0,
            dryContactInputCount: 0,
        };
        switch (model) {
            case "M3":
                result.relayCount = 3;
                result.dryContactInputCount = 7;
                result.readerCount = 3;
                break;
            case "M5":
                result.relayCount = 2;
                result.dryContactInputCount = 6;
                result.readerCount = 0;
                break;
            case "E3":
                result.relayCount = 4;
                result.dryContactInputCount = 7;
                result.readerCount = 4;
                break;
            case "W4R4IO8V1":
                result.relayCount = 4;
                result.dryContactInputCount = 8;
                result.readerCount = 4;
                break;
            case "W8R8IO16V1":
                result.relayCount = 8;
                result.dryContactInputCount = 16;
                result.readerCount = 8;
                break;
            case "R1IO2V1":
                result.relayCount = 1;
                result.dryContactInputCount = 2;
                result.readerCount = 0;
                break;
            case "R12IO24V1":
                result.relayCount = 12;
                result.dryContactInputCount = 24;
                result.readerCount = 0;
                break;
            case "V10":
                result.relayCount = 1;
                result.dryContactInputCount = 2;
                result.readerCount = 0;
                break;
            case "V6":
                result.relayCount = 1;
                result.dryContactInputCount = 2;
                result.readerCount = 0;
                break;
            case "VPass":
                result.relayCount = 1;
                result.dryContactInputCount = 2;
                result.readerCount = 0;
                break;
            case "V7":
                result.relayCount = 6;
                result.dryContactInputCount = 0;
                result.readerCount = 6;
                break;
            default:
                break;
        }
        return result;
    }
    async upsertArmonDevice(organizationId, device, trx) {
        const ioCounts = this.getIOCountsByDeviceModel(device.model);
        if (device.model == "V10" || device.model == "V6" || device.model === "VPass") {
            let relayIds = await this.upsertGenericRelaysForDevice(organizationId, device.id, ioCounts.relayCount, trx);
            await this.upsertArmonV10OnBoardReaders(organizationId, device.id, device.subModel, relayIds[0], trx);
            await this.upsertGenericDryContactsForDevice(organizationId, device.id, ioCounts.dryContactInputCount, trx);
        }
        else if (device.model == "M3" || device.model == "M5") {
            let existingDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings).where("deviceId", device.id).first();
            if (!existingDevice) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings).insert({
                    deviceId: device.id,
                    batteryPlugged: false,
                    emergencyPlugged: false,
                    armonCpServerVersion: "1.1.4",
                    onBoardComputerFreeStorage: 6,
                    onBoardComputerModel: "NanoPi Neo Core",
                    onBoardComputerOs: "Debian9.5",
                    onBoardComputerTotalStorage: 8,
                    onBoardComputerVersion: "v1.0",
                    extensions: "[]",
                    caption: "",
                });
            }
        }
        else if (device.model === "S1") {
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings).insert({
                deviceId: device.id,
                batteryPlugged: false,
                emergencyPlugged: false,
                armonCpServerVersion: "unknown",
                onBoardComputerFreeStorage: 8,
                onBoardComputerModel: "unknown",
                onBoardComputerOs: "Linux",
                onBoardComputerTotalStorage: 8,
                onBoardComputerVersion: "v1.0",
                extensions: "[]",
                caption: "",
            });
        }
        else if (device.model === "V7") {
            const existingRelays = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("deviceId", device.id).where("deletedAt", null).select();
            const existingReaders = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("deviceId", device.id).where("deletedAt", null).select();
            let now = new Date();
            for (let number = 1; number <= ioCounts.relayCount; number++) {
                let relayId = uuid.v4();
                let readerId = uuid.v4();
                if (!existingRelays.some((t) => t.number === number)) {
                    await trx
                        .withSchema(organizationId)
                        .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                        .insert({
                        id: relayId,
                        createdAt: now,
                        updatedAt: now,
                        deviceId: device.id,
                        number: number,
                        driveDuration: 5,
                        direction: number % 2 ? dal_constants_1.DalConstants.AccessDirection.Entrance : dal_constants_1.DalConstants.AccessDirection.Exit,
                        name: "Relay " + number,
                    });
                }
                else {
                    relayId = existingRelays.find((f) => f.number === number).id;
                }
                if (!existingReaders.some((t) => t.number === number)) {
                    await trx
                        .withSchema(organizationId)
                        .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                        .insert({
                        id: readerId,
                        createdAt: now,
                        updatedAt: now,
                        deviceId: device.id,
                        number: number,
                        dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                        direction: number % 2 ? dal_constants_1.DalConstants.AccessDirection.Entrance : dal_constants_1.DalConstants.AccessDirection.Exit,
                        model: "",
                        recurrentAttemptTimeout: 1,
                        name: "Bluetooth Reader " + number,
                        credentialType: dal_constants_1.DalConstants.CredentialType.BLE,
                        readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                        relayId: relayId,
                    });
                }
            }
        }
    }
    async upsertArmonV10OnBoardReaders(organizationId, deviceId, submodel, relayId, trx) {
        let existingReaders = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("deviceId", deviceId).select();
        let now = new Date();
        submodel = submodel || "";
        let readers = [];
        if (!existingReaders.some((e) => e.credentialType == dal_constants_1.DalConstants.CredentialType.NFC)) {
            readers.push({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: 1,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                name: "NFC",
                credentialType: dal_constants_1.DalConstants.CredentialType.NFC,
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
        if (!existingReaders.some((e) => e.credentialType == dal_constants_1.DalConstants.CredentialType.BLE)) {
            readers.push({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: 1,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                name: "Bluetooth",
                credentialType: dal_constants_1.DalConstants.CredentialType.BLE,
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
        if (!existingReaders.some((e) => e.credentialType == dal_constants_1.DalConstants.CredentialType.MiFare)) {
            readers.push({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: 1,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                name: "Mifare",
                credentialType: dal_constants_1.DalConstants.CredentialType.MiFare,
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
        if (!existingReaders.some((e) => e.credentialType == dal_constants_1.DalConstants.CredentialType.FingerPrintISO19794) && submodel?.indexOf("F") > -1) {
            readers.push({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: 1,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                name: "Finger Print",
                credentialType: dal_constants_1.DalConstants.CredentialType.FingerPrintISO19794,
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
        if (!existingReaders.some((e) => e.credentialType == dal_constants_1.DalConstants.CredentialType.QrCode) && submodel?.indexOf("Q") > -1) {
            readers.push({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: 1,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                name: "QR Code",
                credentialType: dal_constants_1.DalConstants.CredentialType.QrCode,
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
        if (readers.length > 0) {
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).insert(readers);
        }
    }
    async upsertGenericRelaysForDevice(organizationId, deviceId, relayCount, trx) {
        let existingRelays = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("deviceId", deviceId).select();
        let now = new Date();
        let ids = existingRelays.map((m) => m.id);
        for (let number = 1; number <= relayCount; number++) {
            if (existingRelays.some((t) => t.number === number)) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("deviceId", deviceId).where("number", number).update({
                    updatedAt: now,
                    deletedAt: null,
                });
            }
            else {
                let id = uuid.v4();
                ids.push(id);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).insert({
                    id: id,
                    createdAt: now,
                    updatedAt: now,
                    deviceId: deviceId,
                    number: number,
                    driveDuration: 5,
                    direction: dal_constants_1.DalConstants.AccessDirection.All,
                    name: "",
                });
            }
        }
        return ids;
    }
    async upsertGenericDryContactsForDevice(organizationId, deviceId, dryContactCount, trx) {
        let existingDryContactInputs = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("deviceId", deviceId).select();
        let now = new Date();
        let ids = existingDryContactInputs.map((m) => m.id);
        for (let number = 1; number <= dryContactCount; number++) {
            if (existingDryContactInputs.some((t) => t.number === number)) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("deviceId", deviceId).where("number", number).update({
                    updatedAt: now,
                    deletedAt: null,
                });
            }
            else {
                let id = uuid.v4();
                ids.push(id);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).insert({
                    id: id,
                    createdAt: now,
                    updatedAt: now,
                    deviceId: deviceId,
                    number: number,
                    type: dal_constants_1.DalConstants.DryContactType.Generic,
                    nc: true,
                    name: "",
                });
            }
        }
        return ids;
    }
    async upsertReaderForAssaAbloyDeviceWithRelayId(organizationId, deviceId, readerNumber, relayId, deviceSerialNumber, trx) {
        let existingReaders = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("deviceId", deviceId).select();
        let now = new Date();
        if (existingReaders.some((t) => t.number === readerNumber)) {
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("deviceId", deviceId).where("number", readerNumber).update({
                updatedAt: now,
                deletedAt: null,
            });
        }
        else {
            await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .insert({
                id: uuid.v4(),
                createdAt: now,
                updatedAt: now,
                deviceId: deviceId,
                number: readerNumber,
                dataFormat: dal_constants_1.DalConstants.CardDataFormat.Raw,
                direction: dal_constants_1.DalConstants.AccessDirection.All,
                model: "",
                recurrentAttemptTimeout: 1,
                credentialType: dal_constants_1.DalConstants.CredentialType.MiFare,
                name: deviceSerialNumber + " Reader",
                readerOutputType: libModels.V2.Enums.ReaderOutputType.OnBoard,
                relayId: relayId,
            });
        }
    }
    async getArmonControlPanelDetailes(organizationId, deviceId) {
        let result = {
            deviceId: deviceId,
            accessControlPoints: [],
            configuration: null,
            extensionControlPanels: [],
            integrations: [],
            io: null,
            settings: null,
        };
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(deviceId);
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            deviceIds.push(...extensionDevicesIds);
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let wiegandReaders = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "authenticationFactor"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let analogInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "deviceId", "threshold", "description"));
            let integrations = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as i")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "i.integratingDeviceId", "d.id")
                .where("i.integratedDeviceId", deviceId)
                .select("i.integratingDeviceId", "i.type", "i.extensionFields", "d.serialNumber", "d.name", "d.model", "d.location"));
            for (let integration of integrations) {
                if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader) {
                    integration.settings = {
                        lanes: await trx
                            .withSchema(organizationId)
                            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes + " as h")
                            .leftOuterJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays + " as r", "h.relayId", "r.id")
                            .where("h.deviceId", integration.integratingDeviceId)
                            .select("h.id", "h.name", "h.number", "h.direction", "r.id as relayId", "h.recurrentAttemptTimeout", "h.accessControlPointId"),
                    };
                }
                else if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485) {
                    integration.settings = {
                        antennas: await trx
                            .withSchema(organizationId)
                            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas + " as h")
                            .leftOuterJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays + " as r", "h.relayId", "r.id")
                            .where("h.deviceId", integration.integratingDeviceId)
                            .select("h.id", "h.name", "h.number", "h.direction", "r.id as relayId", "h.recurrentAttemptTimeout", "h.accessControlPointId"),
                    };
                }
            }
            let extensionDevices = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings + " as e")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "e.deviceId")
                .where("e.mainControlPanelId", deviceId)
                .select("d.*", "e.number"));
            let extensionControlPanels = [];
            for (const extensionDeviceId of extensionDevicesIds) {
                let deviceInfo = extensionDevices.find((d) => d.id == extensionDeviceId);
                const ioCounts = this.getIOCountsByDeviceModel(deviceInfo.model);
                let extension = {
                    number: deviceInfo.number,
                    configuration: {
                        serialNumber: deviceInfo.serialNumber,
                        boardHwVersion: deviceInfo.hwVersion,
                        boardModel: deviceInfo.model,
                        boardSwVersion: deviceInfo.swVersion,
                        dryContactInputCount: ioCounts.dryContactInputCount,
                        wiegandReaderCount: ioCounts.readerCount,
                        relayCount: ioCounts.relayCount,
                        operatingFreeAirTemperatureCriticalHigh: 40,
                        operatingFreeAirTemperatureCriticalLow: -10,
                        operatingFreeAirTemperatureLimitHigh: 50,
                        operatingFreeAirTemperatureLimitLow: -20,
                    },
                    io: {
                        dryContactInputs: dryContactInputs.filter((d) => d.deviceId == extensionDeviceId),
                        relays: relays.filter((r) => r.deviceId == extensionDeviceId),
                        wiegandReaders: wiegandReaders.filter((w) => w.deviceId == extensionDeviceId),
                    },
                };
                extensionControlPanels.push(extension);
            }
            result.extensionControlPanels = extensionControlPanels;
            result.integrations = integrations;
            result.accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .whereIn("deviceId", deviceIds)
                .whereNull("deletedAt")
                .select("id", "name"));
            result.io = {
                analogInputs: analogInputs.filter((a) => a.deviceId == deviceId),
                dryContactInputs: dryContactInputs.filter((d) => d.deviceId == deviceId),
                relays: relays.filter((r) => r.deviceId == deviceId),
                wiegandReaders: wiegandReaders.filter((w) => w.deviceId == deviceId),
                batteryPlugged: mainDevice.batteryPlugged,
                emergencyInputPlugged: mainDevice.emergencyPlugged,
            };
            result.settings = {
                name: mainDevice.name,
                location: mainDevice.location,
            };
            const ioCounts = this.getIOCountsByDeviceModel(mainDevice.model);
            result.configuration = {
                serialNumber: mainDevice.serialNumber,
                boardHwVersion: mainDevice.hwVersion,
                boardModel: mainDevice.model,
                boardSwVersion: mainDevice.swVersion,
                dryContactInputCount: ioCounts.dryContactInputCount,
                wiegandReaderCount: ioCounts.readerCount,
                relayCount: ioCounts.relayCount,
                operatingFreeAirTemperatureCriticalHigh: 40,
                operatingFreeAirTemperatureCriticalLow: -10,
                operatingFreeAirTemperatureLimitHigh: 50,
                operatingFreeAirTemperatureLimitLow: -20,
                onBoardComputerModel: mainDevice.onBoardComputerModel,
                onBoardComputerVersion: mainDevice.onBoardComputerVersion,
                onBoardComputerOs: mainDevice.onBoardComputerOs,
                onBoardComputerTotalStorage: mainDevice.onBoardComputerTotalStorage,
                armonCpServerVersion: mainDevice.armonCpServerVersion,
                analogInputCount: 0,
                isolatedInputCount: 0,
                hasBatteryInput: true,
                hasEmergencyInput: true,
                ip: mainDevice.ip,
                caption: mainDevice.caption,
            };
        });
        return Promise.resolve(result);
    }
    async getArmonControlPanelDetailesV2(organizationId, deviceId) {
        let result = {
            deviceId: deviceId,
            accessControlPoints: [],
            configuration: null,
            extensionControlPanels: [],
            integrations: [],
            io: null,
            settings: null,
        };
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(deviceId);
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            deviceIds.push(...extensionDevicesIds);
            let integrations = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as i")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "i.integratingDeviceId", "d.id")
                .where("i.integratedDeviceId", deviceId)
                .select("i.integratingDeviceId", "i.type", "i.extensionFields", "d.serialNumber", "d.name", "d.model", "d.location"));
            for (let integration of integrations) {
                integration.extensionFields = integration.extensionFields ? JSON.parse(integration.extensionFields) : "";
            }
            deviceIds.push(...integrations.map((i) => i.integratingDeviceId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let readers = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let analogInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "deviceId", "threshold", "description"));
            let extensionDevices = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings + " as e")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "e.deviceId")
                .where("e.mainControlPanelId", deviceId)
                .select("d.*", "e.number"));
            let extensionControlPanels = [];
            for (const extensionDeviceId of extensionDevicesIds) {
                let deviceInfo = extensionDevices.find((d) => d.id == extensionDeviceId);
                const ioCounts = this.getIOCountsByDeviceModel(deviceInfo.model);
                let deviceVersion = deviceInfo.health && deviceInfo.health.version ? deviceInfo.health.version : {};
                let deviceHealth = deviceInfo.health ? deviceInfo.health : {};
                let extension = {
                    number: deviceInfo.number,
                    configuration: {
                        serialNumber: deviceInfo.serialNumber,
                        model: deviceInfo.model,
                        serviceVersion: deviceVersion.serviceVersion,
                        hardwareVersion: deviceVersion.hardwareHwVersion,
                        softwareVersion: deviceVersion.hardwareSwVersion,
                        libAccessVersion: deviceVersion.libAccessVersion,
                        onBoardComputerModel: deviceHealth.onBoardComputerModel,
                        onBoardComputerVersion: deviceVersion.onBoardComputerVersion,
                        onBoardComputerOs: deviceVersion.operatingSystem,
                        onBoardComputerTotalStorage: deviceHealth.onBoardComputerTotalStorage,
                        onBoardComputerFreeStorage: deviceHealth.onBoardComputerFreeStorage,
                        dryContactInputCount: ioCounts.dryContactInputCount,
                        readerCount: ioCounts.readerCount,
                        relayCount: ioCounts.relayCount,
                        operatingFreeAirTemperatureCriticalHigh: 40,
                        operatingFreeAirTemperatureCriticalLow: -10,
                        operatingFreeAirTemperatureLimitHigh: 50,
                        operatingFreeAirTemperatureLimitLow: -20,
                        ip: deviceInfo.health ? deviceInfo.health.ip : "",
                        caption: deviceInfo.caption,
                        analogInputCount: 0,
                        isolatedInputCount: 0,
                        hasBatteryInput: mainDevice.batteryPlugged,
                        hasEmergencyInput: mainDevice.hasEmergencyInput,
                        backendApiVersion: deviceVersion.backendApiVersion,
                        isConnected: deviceHealth.isConnected,
                    },
                    io: {
                        dryContactInputs: dryContactInputs.filter((d) => d.deviceId == extensionDeviceId),
                        relays: relays.filter((r) => r.deviceId == extensionDeviceId),
                        readers: readers.filter((w) => w.deviceId == extensionDeviceId),
                    },
                };
                extensionControlPanels.push(extension);
            }
            result.extensionControlPanels = extensionControlPanels;
            result.integrations = integrations;
            result.accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .whereIn("deviceId", deviceIds)
                .whereNull("deletedAt")
                .select("id", "name"));
            result.io = {
                analogInputs: analogInputs.filter((a) => !extensionDevicesIds.some((e) => e == a.deviceId)),
                dryContactInputs: dryContactInputs.filter((d) => !extensionDevicesIds.some((e) => e == d.deviceId)),
                relays: relays.filter((r) => !extensionDevicesIds.some((e) => e == r.deviceId)),
                readers: readers.filter((w) => !extensionDevicesIds.some((e) => e == w.deviceId)),
                batteryPlugged: mainDevice.batteryPlugged,
                emergencyInputPlugged: mainDevice.emergencyPlugged,
            };
            result.settings = {
                name: mainDevice.name,
                location: mainDevice.location,
            };
            let deviceVersion = mainDevice.health && mainDevice.health.version ? mainDevice.health.version : {};
            let deviceHealth = mainDevice.health ? mainDevice.health : {};
            const ioCounts = this.getIOCountsByDeviceModel(mainDevice.model);
            result.configuration = {
                serialNumber: mainDevice.serialNumber,
                libAccessVersion: deviceVersion.libAccessVersion,
                model: mainDevice.model,
                dryContactInputCount: ioCounts.dryContactInputCount,
                readerCount: ioCounts.readerCount,
                relayCount: ioCounts.relayCount,
                operatingFreeAirTemperatureCriticalHigh: 40,
                operatingFreeAirTemperatureCriticalLow: -10,
                operatingFreeAirTemperatureLimitHigh: 50,
                operatingFreeAirTemperatureLimitLow: -20,
                serviceVersion: deviceVersion.serviceVersion,
                hardwareVersion: deviceVersion.hardwareHwVersion,
                softwareVersion: deviceVersion.hardwareSwVersion,
                onBoardComputerModel: deviceHealth.onBoardComputerModel,
                onBoardComputerVersion: deviceVersion.onBoardComputerVersion,
                onBoardComputerOs: deviceVersion.operatingSystem,
                onBoardComputerTotalStorage: deviceHealth.onBoardComputerTotalStorage,
                onBoardComputerFreeStorage: deviceHealth.onBoardComputerFreeStorage,
                analogInputCount: 0,
                isolatedInputCount: 0,
                hasBatteryInput: mainDevice.batteryPlugged,
                hasEmergencyInput: mainDevice.hasEmergencyInput,
                ip: mainDevice.health ? mainDevice.health.ip : "",
                caption: mainDevice.caption,
                backendApiVersion: deviceVersion.backendApiVersion,
            };
        });
        return Promise.resolve(result);
    }
    async getAperioAdapterConfigurationAndSettingsV2(organizationId, adapterId, trx) {
        let qb = this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("adapterId", adapterId)
            .whereNull("deletedAt")
            .select("id", "serialNumber", "ip", "model");
        if (trx)
            qb.transacting(trx);
        let hubs = await qb;
        return Promise.resolve({ hubs: hubs });
    }
    async getDevicesOfAdapter(organizationId, adapterId, trx) {
        let qb = this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("adapterId", adapterId)
            .whereNull("deletedAt")
            .select("id", "organizationId", "brand", "serialNumber", "model", "name", "location", "ip", "port", "lastSyncISO", "isBeta", "amqpUsername", "amqpPassword");
        if (trx)
            qb.transacting(trx);
        let devices = await qb;
        return Promise.resolve(devices);
    }
    async uploadDeviceAccessLogs(organizationId, accessLogs) {
        const transformLogs = [];
        for (const deviceLog of accessLogs) {
            transformLogs.push(await (0, business_device_1.updateLogFromDevice)({ organizationId, deviceLog, logReceiveMethod: app_enums_1.enums.LogReceiveMethod.OfflineLog }));
        }
        let needsToFindNames = transformLogs.filter((t) => t.o === dal_db_armon_schema_1.ArmonSchema.unknownCredentialOwnerId && t.c);
        if (needsToFindNames.length > 0) {
            let namedLogs = await this.dbClient
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.viewNames.vW_CredentialUserProfiles)
                .where("organizationId", organizationId)
                .whereIn("data", needsToFindNames.map((m) => m.c))
                .select();
            if (namedLogs && namedLogs.length > 0) {
                for (let index = 0; index < namedLogs.length; index++) {
                    let namedLog = namedLogs[index];
                    let rlog = transformLogs.find((l) => l.c === namedLog.data);
                    if (rlog) {
                        rlog.on = namedLog.fullName;
                        rlog.o = namedLog.userId;
                    }
                }
            }
        }
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const antiPassbackStateChanges = transformLogs
                .filter((f) => f.s && f.o && f.rg && f.rg.length > 0)
                .map((m) => {
                const result = [];
                for (const regionLog of m.rg) {
                    result.push({
                        accessControlPointId: m.a,
                        log: {
                            i: regionLog.i,
                            s: regionLog.s.valueOf(),
                            ee: regionLog.ee,
                            xe: regionLog.xe,
                            o: m.o,
                            t: m.u,
                        },
                    });
                }
                return result;
            })
                .flat(1);
            await (0, cli_queries_1.upsertRegionStates)(organizationId, antiPassbackStateChanges, trx);
            for (const rlog of transformLogs) {
                if (rlog.s && rlog.o && rlog.rg && rlog.rg.length > 0) {
                    for (const regionLog of rlog.rg) {
                        if (regionLog.ru && regionLog.ru.c) {
                            await (0, cli_queries_1.upsertAccessRuleHistory)(organizationId, {
                                date: new Date(),
                                accessRuleId: regionLog.ru.i,
                                userId: rlog.o,
                                count: regionLog.ru.c,
                                accessControlPointId: rlog.a,
                                actionDateISO: rlog.u,
                            }, trx);
                        }
                        if (regionLog.rti) {
                            await (0, cli_queries_1.updateUserRegionTicketUnits)(organizationId, { userId: rlog.o, accessControlPointId: rlog.a, decrementUnit: regionLog.rti.c, regionTicketId: regionLog.rti.i }, trx);
                        }
                    }
                }
            }
            await dal_manager_1.dbManager.accessLog.uploadControlPanelAccessLogs(organizationId, transformLogs);
        });
    }
    async syncTerminal(terminalId, organizationId, trx) {
        await this.removeAllChangesForTerminal(organizationId, terminalId, trx);
        await trx.query(`
			INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
			("id", "transactionId", "actionT", "type", "sessionId", "data", "deviceId", "sessionExpirationT")
			VALUES ($1, txid_current(), now(), $2, $3, $4, $5, $6)
		`, [uuid.v4(), dal_constants_1.DalConstants.DeviceChangeItemType.SyncError, null, {}, terminalId, null]);
    }
    async startGetChangesSession(deviceId, sessionId, organizationId) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let count = 0;
            let alreadyStartedSessionItems = await trx.query(`
                SELECT * FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "deviceId" = $1 AND "sessionId" IS NOT NULL
				FOR UPDATE
            `, [deviceId]);
            if (alreadyStartedSessionItems.rowCount > 0) {
                await this.syncTerminal(deviceId, organizationId, trx);
            }
            else {
                const { rows, rowCount } = await trx.query(`
                    UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                    SET "sessionId" = $1, "sessionExpirationT" = now() + interval '10 minutes'
                    WHERE "id" IN
                        (SELECT "id" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                        WHERE "deviceId" = $2
                        AND "sessionId" IS NULL
                        ORDER BY "actionT" ASC)
                `, [sessionId, deviceId]);
                count = rowCount;
            }
            return count;
        });
    }
    async completeGetChangesSession(deviceId, sessionId, organizationId) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            const selectTidResult = await trx.query(`
                SELECT DISTINCT("transactionId", "actionT") "identifier", "transactionId", "actionT"::text
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "deviceId" = $1 AND "sessionId" = $2;
            `, [deviceId, sessionId]);
            if (selectTidResult.rowCount > 0) {
                for (let row of selectTidResult.rows) {
                    let transactionId = row.transactionId;
                    let actionT = row.actionT;
                    await trx.query(`
                        DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                        WHERE "transactionId" = $1 AND "deviceId" = $2 AND "actionT" = $3;
                    `, [transactionId, deviceId, actionT]);
                    await trx.query(`
                        DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChangeTransactions}"
                        WHERE "transactionId" = $1 AND "deviceId" = $2 AND "actionT" = $3;
                    `, [transactionId, deviceId, actionT]);
                }
            }
            const { rows } = await trx.query(`
                SELECT COUNT(*) AS "count" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "deviceId" = $1 AND "sessionId" IS NULL
            `, [deviceId]);
            return parseInt(rows[0].count);
        });
    }
    async getWholeChanges(deviceId, sessionId, organizationId) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            await trx.query(`
                 UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                 SET "sessionId" = $1
                 WHERE "deviceId" = $2
             `, [sessionId, deviceId]);
            const { rows } = await trx.query(`
                SELECT "actionT"::text as "actionDateISO", "type", "data" FROM
                "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "sessionId" = $1
                ORDER BY "actionT"
            `, [sessionId]);
            return rows;
        });
    }
    async getChanges(deviceId, sessionId, organizationId, pagination) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            const paginationResult = pagination
                ? {
                    total: 0,
                    skip: pagination.skip || 0,
                    take: pagination.take || 100,
                }
                : undefined;
            const countResult = await trx.query(`
                SELECT COUNT(*) AS "count" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "sessionId" = $1 AND "deviceId" = $2
            `, [sessionId, deviceId]);
            paginationResult.total = parseInt(countResult.rows[0].count);
            const itemsResult = await trx.query(`
                SELECT "actionT"::text as "actionDateISO", "type", "data" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "sessionId" = $1 AND "deviceId" = $2
                ORDER BY ("actionT","id")
                OFFSET $3 LIMIT $4
            `, [sessionId, deviceId, paginationResult.skip || 0, paginationResult.take || 100]);
            let result = {
                pagination: paginationResult,
                items: itemsResult.rows,
            };
            return result;
        });
    }
    async getChangeCountForTerminal(deviceId, organizationId, trx) {
        const { rows } = await trx.query(`
                SELECT count(*)::integer as c 
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
                WHERE "deviceId" = $1
             `, [deviceId]);
        return rows[0].c;
    }
    async getConnectedDeviceInfo(connectionName) {
        if (!(0, dal_utils_1.isUUID)(connectionName)) {
            return Promise.resolve(null);
        }
        const organizationId = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let organizationIdResult = (await trx.query(`
                SELECT "organizationId" FROM public."things"
                WHERE "id" = $1
            `, [connectionName])).rows;
            if (!organizationIdResult || organizationIdResult.length < 1)
                return null;
            return organizationIdResult[0].organizationId;
        });
        if (!organizationId) {
            return Promise.resolve(null);
        }
        let device = await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("id", connectionName)
            .whereNull("deletedAt")
            .first("id", "name", "model", "organizationId");
        if (!device) {
            device = await this.dbClient
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                .where("adapterId", connectionName)
                .whereIn("model", ["AH40"])
                .whereNull("deletedAt")
                .first("id", "name", "model", "organizationId");
            return Promise.resolve(device);
        }
        return Promise.resolve({
            id: device.id,
            name: device.name,
            model: device.model,
            organizationId: device.organizationId,
        });
    }
    async listOrganizationDevices(organizationId, trx) {
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereNull("deletedAt").where("organizationId", organizationId);
        if (trx)
            qb.transacting(trx);
        return qb.select();
    }
    async listOrganizationDevicesThatUserCanSee(params) {
        const dbResult = await params.trx.query(`
			SELECT d.* FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
			LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" AS ta
				ON ta."terminalId" = d.id
			WHERE d."deletedAt" IS NULL
			 	AND (ta."terminalId" IS NULL OR ta."userId" = $1)
			GROUP BY d.id
		`, [params.userId]);
        return dbResult.rows;
    }
    async updateDeviceInfo(organizationId, deviceId, name, location) {
        let device = await this.getDeviceBasic(organizationId, deviceId);
        if (!device) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("device not found");
        }
        await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("id", deviceId)
            .update({
            name: name,
            location: location ? location : device.location,
            updatedAt: new Date(),
        });
    }
    async getDeviceBasic(organizationId, deviceId, trx) {
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereNull("deletedAt").where("id", deviceId);
        if (trx)
            qb.transacting(trx);
        return qb.first();
    }
    async getDeviceBasics(organizationId, deviceIds, trx) {
        const { rows } = await this._pgPool.query(`SELECT * FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}
        WHERE "deletedAt" IS NULL
        AND id = ANY($1::uuid[])`, [deviceIds]);
        return rows;
    }
    async getDeviceDetailedById(organizationId, deviceId) {
        return await this.dbClient.transaction(async (trx) => {
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereNull("deletedAt").where("id", deviceId).first();
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .whereNull("deletedAt")
                .select("id", "name", "authenticationFactors")
                .where("deviceId", deviceId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name"));
            let wiegandReaders = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "name", "accessControlPointId", "location", "model", "type", "direction", "dataFormat", "number", "relayId"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "name", "accessControlPointId", "number", "nc", "type", "settings"));
            let result = {
                id: deviceInfo.id,
                adapterId: deviceInfo.adapterId,
                brand: deviceInfo.brand,
                brandName: dal_constants_1.DalConstants.DeviceBrand[deviceInfo.brand],
                ip: deviceInfo.ip,
                location: deviceInfo.location,
                model: deviceInfo.model,
                name: deviceInfo.name,
                port: deviceInfo.port,
                serialNumber: deviceInfo.serialNumber,
                accessControlPoints: accessControlPoints,
                dryContactInputs: dryContactInputs,
                organizationId: organizationId,
                relays: relays,
                wiegandReaders: wiegandReaders,
            };
            return Promise.resolve(result);
        });
    }
    async getRemoteAccessCommandStructure(organizationId, userId, accessControlPointId, qrCode) {
        let q = `
			SELECT uar.id, acp."deviceId", acp.name, acp.location
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" AS uar
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON acp.id = uar."accessControlPointId"
			WHERE uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND
				uar."userId" = $1 AND
				uar."accessControlPointId" = $2 
		`;
        if (qrCode) {
            q += ` AND uar."access" = TRUE`;
        }
        else {
            q += ` AND uar."remoteAccess" = TRUE AND acp."remoteAvailable" = TRUE`;
        }
        const accessRights = await this._pgPool.query(q, [userId, accessControlPointId]);
        if (!accessRights || !accessRights.rowCount) {
            return Promise.resolve(null);
        }
        let user = await dal_manager_1.dbManager.accessUser.getBasicUserInfo(organizationId, userId);
        if (!user || !user.id) {
            return Promise.resolve(null);
        }
        const accessRight = accessRights.rows[0];
        return Promise.resolve({
            userAccessRightId: accessRight.id,
            userId: userId,
            deviceId: accessRight.deviceId,
            accessControlPointName: accessRight.name,
            accessControlPointId: accessControlPointId,
            userFullname: user.fullname,
        });
    }
    async getRemoteRelayDriveCommandStructure(organizationId, relayId) {
        const deviceId = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const dbRes = await trx.query(`
				SELECT al."hubDeviceId", cpess."mainControlPanelId", dr."deviceId" 
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays}" AS dr
				LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks}" AS al
					ON al."lockDeviceId" = dr."deviceId"
				LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings}" AS cpess
					ON cpess."deviceId" = dr."deviceId"
				WHERE dr.id = $1
			`, [relayId]);
            if (dbRes.rowCount) {
                const result = dbRes.rows[0];
                return Promise.resolve(result.hubDeviceId || result.mainControlPanelId || result.deviceId);
            }
            else {
                return Promise.resolve(null);
            }
        });
        if (deviceId) {
            return Promise.resolve({
                deviceId: deviceId,
                relayId: relayId,
            });
        }
        else {
            return Promise.resolve(null);
        }
    }
    async updateControlPanelMSeriesDeviceConfigurationAndSettings(deviceId, organizationId, config) {
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let mainAndExtensionDeviceIds = [];
            mainAndExtensionDeviceIds.push(mainDevice.id);
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings)
                .where("mainControlPanelId", deviceId)
                .whereNotIn("deviceId", config.mainDeviceInfo.extensions?.map((e) => e.id) ?? [])
                .delete();
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            mainAndExtensionDeviceIds.push(...extensionDevicesIds);
            if (config.mainDeviceInfo.extensions?.length) {
                for (const extension of config.mainDeviceInfo.extensions) {
                    if (!extensionDevicesIds.some((e) => e == extension.id)) {
                        mainAndExtensionDeviceIds.push(extension.id);
                        await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).insert({
                            deviceId: extension.id,
                            mainControlPanelId: mainDevice.id,
                            number: extension.number,
                        });
                    }
                }
            }
            let now = new Date();
            let deleter = async (tableName, deviceIds, ids) => {
                let compactIds = lodash_1.default.compact(ids);
                let qb = trx.withSchema(organizationId).from(tableName).whereIn("deviceId", deviceIds).delete();
                if (ids.length > 0) {
                    qb.whereNotIn("id", compactIds);
                }
                return qb;
            };
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs, mainAndExtensionDeviceIds, config.dryContactInputs.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays, mainAndExtensionDeviceIds, config.relays.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders, mainAndExtensionDeviceIds, config.wiegandReaders.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs, mainAndExtensionDeviceIds, config.analogInputs.map((d) => d.id));
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).where("integratedDeviceId", deviceId).delete();
            let hikVisionLicencePlateReaders = [];
            let impinjSpeedWayGateWays = [];
            let lanes = [];
            let antennas = [];
            let existingLaneIds = [];
            let existingAntennaIds = [];
            let integratingDeviceIds = [];
            let existingLanes = [];
            let existingAntennas = [];
            if (config.integrations && config.integrations.length > 0) {
                for (let integration of config.integrations) {
                    integratingDeviceIds.push(integration.integratingDeviceId);
                    if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader) {
                        hikVisionLicencePlateReaders.push(integration);
                        if (integration.settings && integration.settings.lanes)
                            lanes.push({
                                integratingDeviceId: integration.integratingDeviceId,
                                laneSettings: integration.settings.lanes,
                            });
                    }
                    else if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485) {
                        impinjSpeedWayGateWays.push(integration);
                        if (integration.settings && integration.settings.antennas)
                            antennas.push({
                                integratingDeviceId: integration.integratingDeviceId,
                                antennaSettings: integration.settings.antennas,
                            });
                    }
                }
                existingLaneIds = [];
                for (const laneSetting of lanes.map((l) => l.laneSettings)) {
                    for (const lane of laneSetting) {
                        if (lane.id)
                            existingLaneIds.push(lane.id);
                    }
                }
                existingAntennaIds = [];
                for (const antennaSetting of antennas.map((l) => l.antennaSettings)) {
                    for (const antenna of antennaSetting) {
                        if (antenna.id)
                            existingAntennaIds.push(antenna.id);
                    }
                }
                if (existingLaneIds && existingLaneIds.length > 0) {
                    existingLanes = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes).whereIn("id", existingLaneIds).select();
                    existingLaneIds = existingLanes.map((m) => m.id);
                }
                if (existingAntennaIds && existingAntennaIds.length > 0) {
                    existingAntennas = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas).whereIn("id", existingAntennaIds).select();
                    existingAntennaIds = existingAntennas.map((m) => m.id);
                }
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereIn("id", integratingDeviceIds).delete();
            }
            let deviceRelays = [];
            for (const relay of config.relays) {
                let existingRelay = relay.id ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereNull("deletedAt").where("id", relay.id).first() : null;
                if (existingRelay) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("id", relay.id).update({
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    });
                    deviceRelays.push(existingRelay);
                }
                else {
                    let newRelay = {
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    };
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).insert(newRelay);
                    deviceRelays.push(newRelay);
                }
            }
            for (const dryContactInput of config.dryContactInputs) {
                let relay = deviceRelays.find((r) => dryContactInput.settings && r.deviceId == dryContactInput.settings.relayDeviceId && r.number == dryContactInput.settings.relayNumber);
                let accessControlPointIdOfDryContactInput = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let settings = {};
                switch (dryContactInput.type) {
                    case dal_constants_1.DalConstants.DryContactType.ExitButton:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                        };
                        break;
                    case dal_constants_1.DalConstants.DryContactType.StatusSensor:
                        settings = {
                            relayId: relayId,
                            timeOut: dryContactInput.settings.timeOut,
                        };
                        break;
                    case dal_constants_1.DalConstants.DryContactType.Counter:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                        };
                        break;
                    default:
                        settings = {
                            relayId: relayId,
                        };
                        break;
                }
                let existingDryContactInput = dryContactInput.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).first()
                    : null;
                if (existingDryContactInput) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
            }
            for (const wiegandReader of config.wiegandReaders) {
                let relay = deviceRelays.find((r) => r.deviceId == wiegandReader.relayDeviceId && r.number == wiegandReader.relayNumber);
                let accessControlPointIdOfWiegandReader = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let existingWiegandReader = wiegandReader.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).where("id", wiegandReader.id).first()
                    : null;
                if (existingWiegandReader) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).where("id", existingWiegandReader.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: wiegandReader.deviceId,
                        number: wiegandReader.number,
                        location: wiegandReader.location,
                        relayId: relayId,
                        direction: wiegandReader.direction,
                        model: wiegandReader.model,
                        dataFormat: wiegandReader.dataFormat,
                        recurrentAttemptTimeout: wiegandReader.recurrentAttemptTimeout,
                        authenticationFactor: wiegandReader.authenticationFactor,
                        name: wiegandReader.name,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: wiegandReader.deviceId,
                        number: wiegandReader.number,
                        location: wiegandReader.location,
                        relayId: relayId,
                        direction: wiegandReader.direction,
                        model: wiegandReader.model,
                        dataFormat: wiegandReader.dataFormat,
                        recurrentAttemptTimeout: wiegandReader.recurrentAttemptTimeout,
                        authenticationFactor: wiegandReader.authenticationFactor,
                        name: wiegandReader.name,
                    });
                }
            }
            for (let hikVisionLicencePlateReader of hikVisionLicencePlateReaders) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: hikVisionLicencePlateReader.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.HikVision,
                    serialNumber: hikVisionLicencePlateReader.serialNumber,
                    model: hikVisionLicencePlateReader.model,
                    name: hikVisionLicencePlateReader.name,
                    location: hikVisionLicencePlateReader.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: hikVisionLicencePlateReader.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader,
                    extensionFields: hikVisionLicencePlateReader.extensionFields,
                });
            }
            for (let laneSetting of lanes) {
                let laneIntegratingDevice = laneSetting.integratingDeviceId;
                for (const lane of laneSetting.laneSettings) {
                    let relayId = null;
                    let accessControlPointIdOfLane = null;
                    if (lane.relayDeviceId && lane.relayNumber) {
                        let relayIdQbResult = await trx
                            .withSchema(organizationId)
                            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                            .where("deviceId", lane.relayDeviceId)
                            .where("number", lane.relayNumber)
                            .first("id", "accessControlPointId");
                        if (relayIdQbResult) {
                            relayId = relayIdQbResult.id;
                            accessControlPointIdOfLane = relayIdQbResult.accessControlPointId;
                        }
                    }
                    if (lane.id && existingLaneIds.indexOf(lane.id) >= 0) {
                        let existingLane = existingLanes.find((t) => t.id === lane.id);
                        existingLane.deviceId = laneIntegratingDevice;
                        existingLane.accessControlPointId = accessControlPointIdOfLane;
                        existingLane.number = lane.number;
                        existingLane.name = lane.name;
                        existingLane.direction = lane.direction;
                        existingLane.relayId = relayId;
                        existingLane.recurrentAttemptTimeout = lane.recurrentAttemptTimeout;
                        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes).insert(existingLane);
                    }
                    else {
                        await trx
                            .withSchema(organizationId)
                            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes)
                            .insert({
                            id: lane.id || uuid.v4(),
                            accessControlPointId: accessControlPointIdOfLane,
                            deviceId: laneIntegratingDevice,
                            number: lane.number,
                            name: lane.name,
                            direction: lane.direction,
                            relayId: relayId,
                            recurrentAttemptTimeout: lane.recurrentAttemptTimeout,
                        });
                    }
                }
            }
            for (let impinjSpeedWayGateWay of impinjSpeedWayGateWays) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: impinjSpeedWayGateWay.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.Impinj,
                    serialNumber: impinjSpeedWayGateWay.serialNumber,
                    model: impinjSpeedWayGateWay.model,
                    name: impinjSpeedWayGateWay.name,
                    location: impinjSpeedWayGateWay.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: impinjSpeedWayGateWay.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485,
                    extensionFields: impinjSpeedWayGateWay.extensionFields,
                });
            }
            for (let antennaSetting of antennas) {
                let antennaIntegratingDevice = antennaSetting.integratingDeviceId;
                for (const antenna of antennaSetting.antennaSettings) {
                    let relayId = null;
                    let accessControlPointIdOfAntenna = null;
                    if (antenna.relayDeviceId && antenna.relayNumber) {
                        let relayIdQbResult = await trx
                            .withSchema(organizationId)
                            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                            .where("deviceId", antenna.relayDeviceId)
                            .where("number", antenna.relayNumber)
                            .first("id", "accessControlPointId");
                        if (relayIdQbResult) {
                            relayId = relayIdQbResult.id;
                            accessControlPointIdOfAntenna = relayIdQbResult.accessControlPointId;
                        }
                    }
                    if (antenna.id && existingAntennaIds.indexOf(antenna.id) >= 0) {
                        let existingAntenna = existingAntennas.find((t) => t.id === antenna.id);
                        existingAntenna.deviceId = antennaIntegratingDevice;
                        existingAntenna.accessControlPointId = accessControlPointIdOfAntenna;
                        existingAntenna.number = antenna.number;
                        existingAntenna.name = antenna.name;
                        existingAntenna.direction = antenna.direction;
                        existingAntenna.relayId = relayId;
                        existingAntenna.recurrentAttemptTimeout = antenna.recurrentAttemptTimeout;
                        await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas).insert(existingAntenna);
                    }
                    else {
                        await trx
                            .withSchema(organizationId)
                            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas)
                            .insert({
                            id: antenna.id || uuid.v4(),
                            deviceId: antennaIntegratingDevice,
                            accessControlPointId: accessControlPointIdOfAntenna,
                            number: antenna.number,
                            name: antenna.name,
                            direction: antenna.direction,
                            relayId: relayId,
                            recurrentAttemptTimeout: antenna.recurrentAttemptTimeout,
                        });
                    }
                }
            }
            for (const analogInput of config.analogInputs) {
                let existingAnalogInput = analogInput.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).where("id", analogInput.id).first()
                    : null;
                if (existingAnalogInput) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).where("id", analogInput.id).update({
                        updatedAt: now,
                        deviceId: analogInput.deviceId,
                        description: analogInput.description,
                        threshold: analogInput.threshold,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deviceId: analogInput.deviceId,
                        description: analogInput.description,
                        threshold: analogInput.threshold,
                    });
                }
            }
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
                updatedAt: now,
                name: config.mainDeviceInfo.name,
                location: config.mainDeviceInfo.location,
                timezone: config.mainDeviceInfo.timezone,
                swVersion: config.mainDeviceInfo.swVersion,
            });
            if (config.mainDeviceInfo.extensions?.length) {
                for (const relatedDevice of config.mainDeviceInfo.extensions) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", relatedDevice.id).update({
                        updatedAt: now,
                        name: relatedDevice.name,
                        location: relatedDevice.location,
                        swVersion: relatedDevice.swVersion,
                    });
                }
            }
            await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings)
                .where("deviceId", deviceId)
                .update({
                batteryPlugged: config.mainDeviceInfo.batteryPlugged,
                emergencyPlugged: config.mainDeviceInfo.emergencyPlugged,
                extensions: JSON.stringify(config.mainDeviceInfo.extensions),
                onBoardComputerModel: config.mainDeviceInfo.onBoardComputerModel,
                onBoardComputerVersion: config.mainDeviceInfo.onBoardComputerVersion,
                onBoardComputerOs: config.mainDeviceInfo.onBoardComputerOs,
                onBoardComputerTotalStorage: config.mainDeviceInfo.onBoardComputerTotalStorage,
                onBoardComputerFreeStorage: config.mainDeviceInfo.onBoardComputerFreeStorage,
                armonCpServerVersion: config.mainDeviceInfo.armonCpServerVersion,
            });
        });
        return this.getControlPanelMSeriesDeviceConfigurationAndSettings(organizationId, deviceId);
    }
    async updateControlPanelMSeriesDeviceConfigurationAndSettingsV2(deviceId, organizationId, config) {
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let mainAndExtensionDeviceIds = [];
            mainAndExtensionDeviceIds.push(mainDevice.id);
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings)
                .where("mainControlPanelId", deviceId)
                .whereNotIn("deviceId", config.mainDeviceInfo.extensions?.map((e) => e.id) ?? [])
                .delete();
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            mainAndExtensionDeviceIds.push(...extensionDevicesIds);
            if (config.mainDeviceInfo.extensions?.length) {
                for (const extension of config.mainDeviceInfo.extensions) {
                    if (!extensionDevicesIds.some((e) => e == extension.id)) {
                        let existingExtensionMapping = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("deviceId", extension.id).first();
                        if (existingExtensionMapping) {
                            app_logs_1.logger.debug("Updating mainControlPanelid of extension " + extension.id);
                            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("deviceId", extension.id).update({
                                mainControlPanelId: mainDevice.id,
                                number: extension.number,
                            });
                        }
                        else {
                            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).insert({
                                deviceId: extension.id,
                                mainControlPanelId: mainDevice.id,
                                number: extension.number,
                            });
                        }
                        mainAndExtensionDeviceIds.push(extension.id);
                    }
                }
            }
            let now = new Date();
            let deleter = async (tableName, deviceIds, ids) => {
                let compactIds = lodash_1.default.compact(ids);
                let qb = trx.withSchema(organizationId).from(tableName).whereIn("deviceId", deviceIds).delete();
                if (ids.length > 0) {
                    qb.whereNotIn("id", compactIds);
                }
                return qb;
            };
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs, mainAndExtensionDeviceIds, config.dryContactInputs.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays, mainAndExtensionDeviceIds, config.relays.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders, mainAndExtensionDeviceIds, config.readers.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs, mainAndExtensionDeviceIds, config.analogInputs.map((d) => d.id));
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).where("integratedDeviceId", deviceId).delete();
            let hikVisionLicencePlateReaders = [];
            let impinjSpeedWayGateWays = [];
            let hikVisionPeopleCountingSensors = [];
            let axisLicencePlateReaders = [];
            let integratingDeviceIds = [];
            if (config.integrations && config.integrations.length > 0) {
                for (let integration of config.integrations) {
                    integratingDeviceIds.push(integration.integratingDeviceId);
                    switch (integration.type) {
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader:
                            hikVisionLicencePlateReaders.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485:
                            impinjSpeedWayGateWays.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionPeopleCounting:
                            hikVisionPeopleCountingSensors.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.AxisLicencePlateReader:
                            axisLicencePlateReaders.push(integration);
                            break;
                        default:
                            app_logs_1.logger.error("Unsupport integration type from device! " + integration.type);
                            break;
                    }
                }
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereIn("id", integratingDeviceIds).delete();
            }
            let deviceRelays = [];
            for (const relay of config.relays) {
                let existingRelay = relay.id ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereNull("deletedAt").where("id", relay.id).first() : null;
                if (existingRelay) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("id", relay.id).update({
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    });
                    deviceRelays.push(existingRelay);
                }
                else {
                    let newRelay = {
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    };
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).insert(newRelay);
                    deviceRelays.push(newRelay);
                }
            }
            for (let hikVisionLicencePlateReader of hikVisionLicencePlateReaders) {
                await trx.raw(`
                    INSERT INTO public."things"
                    (id, "organizationId", token)
                    VALUES (?, ?, NULL)
                    ON CONFLICT DO NOTHING;
                `, [hikVisionLicencePlateReader.integratingDeviceId, organizationId]);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: hikVisionLicencePlateReader.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.HikVision,
                    serialNumber: hikVisionLicencePlateReader.serialNumber,
                    model: hikVisionLicencePlateReader.model,
                    name: hikVisionLicencePlateReader.name,
                    location: hikVisionLicencePlateReader.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: hikVisionLicencePlateReader.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader,
                    extensionFields: hikVisionLicencePlateReader.extensionFields,
                });
            }
            for (let impinjSpeedWayGateWay of impinjSpeedWayGateWays) {
                await trx.raw(`
                    INSERT INTO public."things"
                    (id, "organizationId", token)
                    VALUES (?, ?, NULL)
                    ON CONFLICT DO NOTHING;
                `, [impinjSpeedWayGateWay.integratingDeviceId, organizationId]);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: impinjSpeedWayGateWay.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.Impinj,
                    serialNumber: impinjSpeedWayGateWay.serialNumber,
                    model: impinjSpeedWayGateWay.model,
                    name: impinjSpeedWayGateWay.name,
                    location: impinjSpeedWayGateWay.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: impinjSpeedWayGateWay.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485,
                    extensionFields: impinjSpeedWayGateWay.extensionFields,
                });
            }
            for (let peopleCountingSensor of hikVisionPeopleCountingSensors) {
                await trx.raw(`
                    INSERT INTO public."things"
                    (id, "organizationId", token)
                    VALUES (?, ?, NULL)
                    ON CONFLICT DO NOTHING;
                `, [peopleCountingSensor.integratingDeviceId, organizationId]);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: peopleCountingSensor.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.HikVision,
                    serialNumber: peopleCountingSensor.serialNumber,
                    model: peopleCountingSensor.model,
                    name: peopleCountingSensor.name,
                    location: peopleCountingSensor.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: peopleCountingSensor.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionPeopleCounting,
                    extensionFields: peopleCountingSensor.extensionFields,
                });
            }
            for (let axisLicencePlateReader of axisLicencePlateReaders) {
                await trx.raw(`
                    INSERT INTO public."things"
                    (id, "organizationId", token)
                    VALUES (?, ?, NULL)
                    ON CONFLICT DO NOTHING;
                `, [axisLicencePlateReader.integratingDeviceId, organizationId]);
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: axisLicencePlateReader.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.Axis,
                    serialNumber: axisLicencePlateReader.serialNumber,
                    model: axisLicencePlateReader.model,
                    name: axisLicencePlateReader.name,
                    location: axisLicencePlateReader.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: axisLicencePlateReader.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.AxisLicencePlateReader,
                    extensionFields: axisLicencePlateReader.extensionFields,
                });
            }
            for (const dryContactInput of config.dryContactInputs) {
                let relay = deviceRelays.find((r) => dryContactInput.settings && r.deviceId == dryContactInput.settings.relayDeviceId && r.number == dryContactInput.settings.relayNumber);
                let accessControlPointIdOfDryContactInput = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let settings = {};
                switch (dryContactInput.type) {
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.ExitButton:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                        };
                        break;
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.StatusSensor:
                        settings = {
                            relayId: relayId,
                            timeOut: dryContactInput.settings.timeOut,
                        };
                        break;
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.CounterSensor:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                            timeOut: dryContactInput.settings.timeOut
                                ? dryContactInput.settings.timeOut
                                : 0,
                        };
                        break;
                    default:
                        settings = {
                            relayId: relayId,
                        };
                        break;
                }
                let existingDryContactInput = dryContactInput.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).first()
                    : null;
                if (existingDryContactInput) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
            }
            for (const reader of config.readers) {
                let relay = deviceRelays.find((r) => r.deviceId == reader.relayDeviceId && r.number == reader.relayNumber);
                let accessControlPointIdOfWiegandReader = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let existingReader = reader.id ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("id", reader.id).first() : null;
                if (existingReader) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("id", existingReader.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: reader.deviceId,
                        number: reader.number,
                        location: reader.location,
                        relayId: relayId,
                        direction: reader.direction,
                        model: reader.model,
                        dataFormat: reader.dataFormat,
                        recurrentAttemptTimeout: reader.recurrentAttemptTimeout,
                        credentialType: reader.credentialType,
                        name: reader.name,
                        readerOutputType: reader.readerOutputType,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: reader.deviceId,
                        number: reader.number,
                        location: reader.location,
                        relayId: relayId,
                        direction: reader.direction,
                        model: reader.model,
                        dataFormat: reader.dataFormat,
                        credentialType: reader.credentialType,
                        recurrentAttemptTimeout: reader.recurrentAttemptTimeout,
                        name: reader.name,
                        readerOutputType: reader.readerOutputType,
                    });
                }
            }
            for (const analogInput of config.analogInputs) {
                let existingAnalogInput = analogInput.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).where("id", analogInput.id).first()
                    : null;
                if (existingAnalogInput) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).where("id", analogInput.id).update({
                        updatedAt: now,
                        deviceId: analogInput.deviceId,
                        description: analogInput.description,
                        threshold: analogInput.threshold,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deviceId: analogInput.deviceId,
                        description: analogInput.description,
                        threshold: analogInput.threshold,
                    });
                }
            }
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
                updatedAt: now,
                name: config.mainDeviceInfo.name,
                location: config.mainDeviceInfo.location,
                timezone: config.mainDeviceInfo.timezone,
            });
            if (config.mainDeviceInfo.extensions?.length) {
                for (const relatedDevice of config.mainDeviceInfo.extensions) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", relatedDevice.id).update({
                        updatedAt: now,
                        name: relatedDevice.name,
                        location: relatedDevice.location,
                    });
                }
            }
            await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings)
                .where("deviceId", deviceId)
                .update({
                batteryPlugged: config.mainDeviceInfo.batteryPlugged ?? null,
                emergencyPlugged: config.mainDeviceInfo.emergencyPlugged ?? null,
                extensions: JSON.stringify(config.mainDeviceInfo.extensions) ?? null,
            });
        });
        return this.getControlPanelMSeriesDeviceConfigurationAndSettingsV2(organizationId, deviceId);
    }
    async getControlPanelMSeriesDeviceConfigurationAndSettings(organizationId, deviceId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(deviceId);
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            deviceIds.push(...extensionDevicesIds);
            let deviceInfo = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                .first("name", "location", "lastSyncISO", "organizationId")
                .whereNull("deletedAt")
                .where("id", deviceId);
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .select("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let wiegandReaders = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "authenticationFactor"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let cameras = [];
            await this.dbClient
                .withSchema(organizationId)
                .table("cameras as c")
                .innerJoin("accessControlPoints as acp", "acp.id", "c.accessControlPointId")
                .whereNull("c.deletedAt")
                .whereNull("acp.deletedAt")
                .whereIn("acp.deviceId", deviceIds)
                .select("c.id", "c.name", "c.streamUrl", "c.snapshotUrl", "c.userName", "c.password", "c.accessControlPointId", "c.wiegandReaderIds", "c.remoteAccess", "c.exitButtonIds", "c.impinjSpeedWayGateWayAntennaIds", "c.hikVisionLicensePlateCameraLaneIds")
                .then(async (rows) => {
                for (let row of rows) {
                    cameras.push({
                        id: row.id,
                        name: row.name,
                        streamUrl: row.streamUrl,
                        snapshotUrl: row.snapshotUrl,
                        remoteAccess: row.remoteAccess,
                        userName: row.userName,
                        password: row.password,
                        accessControlPointId: row.accessControlPointId,
                        wiegandReaderIds: row.wiegandReaderIds ? row.wiegandReaderIds : [],
                        exitButtonIds: row.exitButtonIds ? row.exitButtonIds : [],
                        dryContactInputIds: row.exitButtonIds ? row.exitButtonIds : [],
                        hikVisionLicensePlateCameraLaneIds: row.hikVisionLicensePlateCameraLaneIds ? row.hikVisionLicensePlateCameraLaneIds : [],
                        impinjSpeedWayGateWayAntennaIds: row.impinjSpeedWayGateWayAntennaIds ? row.impinjSpeedWayGateWayAntennaIds : [],
                    });
                }
            });
            let integrations = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as i")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "i.integratingDeviceId", "d.id")
                .where("i.integratedDeviceId", deviceId)
                .select("i.integratingDeviceId", "i.type", "i.extensionFields", "d.serialNumber", "d.name", "d.model", "d.location"));
            for (let integration of integrations) {
                if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader) {
                    integration.settings = {
                        lanes: await trx
                            .withSchema(organizationId)
                            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes + " as h")
                            .leftOuterJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays + " as r", "h.relayId", "r.id")
                            .where("h.deviceId", integration.integratingDeviceId)
                            .select("h.id", "h.name", "h.number", "h.direction", "r.id as relayId", "r.accessControlPointId as accessControlPointId", "h.recurrentAttemptTimeout", "h.accessControlPointId"),
                    };
                }
                else if (integration.type === dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485) {
                    integration.settings = {
                        antennas: await trx
                            .withSchema(organizationId)
                            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas + " as h")
                            .leftOuterJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays + " as r", "h.relayId", "r.id")
                            .where("h.deviceId", integration.integratingDeviceId)
                            .select("h.id", "h.name", "h.number", "h.direction", "r.id as relayId", "r.accessControlPointId as accessControlPointId", "h.recurrentAttemptTimeout", "h.accessControlPointId"),
                    };
                }
                if (integration.extensionFields)
                    integration.extensionFields = JSON.parse(integration.extensionFields);
            }
            let extensionDevices = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings + " as e")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "e.deviceId")
                .where("e.mainControlPanelId", deviceId)
                .select("d.*", "e.number"));
            let analogInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "deviceId", "description", "threshold"));
            let regions = [];
            for (const device of deviceIds) {
                regions = regions.concat(await this.getDeviceRegions(organizationId, device, trx));
            }
            result = {
                cameras: cameras,
                wiegandReaders: wiegandReaders,
                dryContactInputs: dryContactInputs,
                relays: relays,
                organizationId: deviceInfo.organizationId,
                configuration: {
                    location: deviceInfo.location,
                    name: deviceInfo.name,
                },
                integrations: integrations,
                analogInputSettings: analogInputs,
                mainDeviceInfo: {
                    deviceId: deviceId,
                    timezone: mainDevice.timezone,
                    batteryPlugged: mainDevice.batteryPlugged,
                    extensions: extensionDevices.map((d) => {
                        return {
                            swVersion: d.swVersion,
                            id: d.id,
                            location: d.location,
                            name: d.name,
                            number: d.number,
                        };
                    }),
                    emergencyPlugged: mainDevice.emergencyPlugged,
                    name: deviceInfo.name,
                    location: deviceInfo.location,
                    armonCpServerVersion: mainDevice.armonCpServerVersion,
                    onBoardComputerFreeStorage: mainDevice.onBoardComputerFreeStorage,
                    onBoardComputerModel: mainDevice.onBoardComputerModel,
                    onBoardComputerOs: mainDevice.onBoardComputerOs,
                    onBoardComputerTotalStorage: mainDevice.onBoardComputerTotalStorage,
                    onBoardComputerVersion: mainDevice.onBoardComputerVersion,
                    swVersion: mainDevice.swVersion,
                },
                accessControlPoints: accessControlPoints,
                accessRuleSets: await this.getAccessRuleSetsForDevice(organizationId, deviceIds, trx),
                regions: regions,
                sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, deviceId, trx),
                timezoneOffset: new Date().getTimezoneOffset(),
            };
        });
        return Promise.resolve(result);
    }
    async getControlPanelMSeriesDeviceConfigurationAndSettingsV2(organizationId, deviceId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings + " as m")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "m.deviceId", "d.id")
                .where("m.deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(deviceId);
            let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((e) => e.deviceId);
            deviceIds.push(...extensionDevicesIds);
            let integrations = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as i")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "i.integratingDeviceId", "d.id")
                .where("i.integratedDeviceId", deviceId)
                .select("i.integratingDeviceId", "i.type", "i.extensionFields", "d.serialNumber", "d.name", "d.model", "d.location"));
            for (let integration of integrations) {
                integration.extensionFields = integration.extensionFields ? JSON.parse(integration.extensionFields) : "";
            }
            deviceIds.push(...integrations.map((i) => i.integratingDeviceId));
            let deviceInfo = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                .first("name", "location", "lastSyncISO", "organizationId")
                .whereNull("deletedAt")
                .where("id", deviceId);
            let { accessControlPoints, relays, readers, dryContactInputs, cameras, regions } = await this.getMainDeviceConfigs(organizationId, deviceIds, trx);
            let extensionDevices = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings + " as e")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "e.deviceId")
                .where("e.mainControlPanelId", deviceId)
                .select("d.*", "e.number"));
            let analogInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesAnalogInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "deviceId", "description", "threshold"));
            let webRtc = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                .whereNull("deletedAt")
                .where("id", organizationId)
                .first(this.dbClient.raw(`"settings"->'webRtc' as "webRtc"`));
            result = {
                cameras: cameras,
                readers: readers,
                dryContactInputs: dryContactInputs,
                relays: relays,
                organizationId: deviceInfo.organizationId,
                integrations: integrations,
                analogInputSettings: analogInputs,
                webRtc: webRtc.webRtc,
                mainDeviceInfo: {
                    deviceId: deviceId,
                    timezone: mainDevice.timezone,
                    batteryPlugged: mainDevice.batteryPlugged,
                    port: mainDevice.port,
                    extensions: extensionDevices.map((d) => {
                        return {
                            swVersion: d.swVersion,
                            id: d.id,
                            location: d.location,
                            name: d.name,
                            number: d.number,
                            privateKey: d.privateKey,
                        };
                    }),
                    emergencyPlugged: mainDevice.emergencyPlugged,
                    name: deviceInfo.name,
                    location: deviceInfo.location,
                },
                accessControlPoints: accessControlPoints,
                accessRuleSets: await this.getAccessRuleSetsForDeviceV2({ organizationId, deviceIds: [deviceId] }),
                regions: regions,
                sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, deviceId, trx),
                timezoneOffset: new Date().getTimezoneOffset(),
            };
        });
        return Promise.resolve(result);
    }
    async getArmonOneSeriesDeviceConfigurationAndSettings(organizationId, deviceId, trx) {
        let transactionScope = async (trx) => {
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("name", "location", "lastSyncISO", "organizationId").where("id", deviceId);
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .select("id", "name", "authenticationFactors", "deviceId", "states")
                .where("deviceId", deviceId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let regions = await this.getDeviceRegions(organizationId, deviceId, trx);
            let result = {
                dryContactInputs: dryContactInputs,
                relays: relays,
                organizationId: deviceInfo.organizationId,
                configuration: {
                    location: deviceInfo.location,
                    name: deviceInfo.name,
                },
                timezoneOffset: new Date().getTimezoneOffset(),
                accessControlPoints: accessControlPoints,
                accessRuleSets: await this.getAccessRuleSetsForDevice(organizationId, [deviceId], trx),
                regions: regions,
            };
            return result;
        };
        if (trx) {
            return transactionScope(trx);
        }
        else {
            return this.dbClient.transaction(transactionScope);
        }
    }
    async getDeviceRegions(organizationId, deviceId, trx) {
        let regionIdsQuery = this.dbClient
            .withSchema(organizationId)
            .from("regionAccessControlPoints as racp")
            .innerJoin("regions as r", "racp.regionId", "r.id")
            .innerJoin("accessControlPoints as acp", "racp.accessControlPointId", "acp.id")
            .where("acp.deviceId", deviceId);
        if (trx)
            regionIdsQuery = regionIdsQuery.transacting(trx);
        let regionIds = await regionIdsQuery.distinct("r.id").then((rr) => {
            return !rr ? [] : rr.map((rrr) => rrr.id);
        });
        if (regionIds.length === 0) {
            return Promise.resolve([]);
        }
        let regionACPMappingsQb = this.dbClient
            .withSchema(organizationId)
            .from("regionAccessControlPoints as racp")
            .innerJoin("regions as r", "racp.regionId", "r.id")
            .innerJoin("accessControlPoints as acp", "racp.accessControlPointId", "acp.id")
            .whereIn("r.id", regionIds);
        if (trx)
            regionACPMappingsQb = regionACPMappingsQb.transacting(trx);
        let regionACPMappings = await regionACPMappingsQb.select("r.id", "r.name", "r.antiPassback", "r.antiPassbackLockDuration", "acp.id as accessControlPointId", "acp.deviceId", "r.capacity");
        let result = [];
        for (const regionId of regionIds) {
            let filteredMappings = regionACPMappings.filter((m) => m.id === regionId && deviceId == m.deviceId);
            if (filteredMappings && filteredMappings.length > 0) {
                let region = filteredMappings[0];
                let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.regionTickets).where("regionId", region.id).whereNull("deletedAt");
                if (trx)
                    qb.transacting(trx);
                let regionTicket = await qb.first("id", "name", "requiredUnits");
                let resultItem = {
                    id: region.id,
                    name: region.name,
                    antiPassback: region.antiPassback,
                    antiPassbackLockDuration: region.antiPassbackLockDuration,
                    accessControlPointIds: [],
                    relatedOtherDeviceIds: [],
                    regionTicket: regionTicket ? regionTicket : null,
                    capacity: region.capacity,
                };
                resultItem.accessControlPointIds = filteredMappings.map((m) => m.accessControlPointId);
                let relatedPanelIds = regionACPMappings.filter((m) => m.id === regionId && m.deviceId !== deviceId && m.deviceId).map((m) => m.deviceId);
                resultItem.relatedOtherDeviceIds = relatedPanelIds.filter((item, i, ar) => {
                    return ar.indexOf(item) === i;
                });
                result.push(resultItem);
            }
        }
        return Promise.resolve(result);
    }
    async getAccessRuleSetsForDevice(organizationId, deviceIds, trx) {
        let regionIdsQuery = this.dbClient
            .withSchema(organizationId)
            .from("regionAccessControlPoints as racp")
            .innerJoin("regions as r", "racp.regionId", "r.id")
            .innerJoin("accessControlPoints as acp", "racp.accessControlPointId", "acp.id")
            .whereIn("acp.deviceId", deviceIds);
        if (trx)
            regionIdsQuery = regionIdsQuery.transacting(trx);
        let regionIds = await regionIdsQuery.distinct("r.id").then((rr) => {
            return !rr ? [] : rr.map((rrr) => rrr.id);
        });
        let result = [];
        let accessRuleSetIds = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessRuleSets).whereNull("deletedAt").whereIn("regionId", regionIds).select("id");
        for (let accessRuleSet of accessRuleSetIds) {
            let ruleSet = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.accessRuleSets).where("id", accessRuleSet.id).first();
            let rules = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessRules).where("accessRuleSetId", ruleSet.id).whereNull("deletedAt").select();
            let userGroups = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupAccessRuleSets).where("accessRuleSetId", ruleSet.id).select();
            let item = {
                id: ruleSet.id,
                isActive: ruleSet.isActive,
                name: ruleSet.name,
                userGroupIds: userGroups.map((u) => u.userGroupId),
                regionId: ruleSet.regionId,
                uncoveredAccessStatus: ruleSet.uncoveredAccessStatus,
                rules: rules,
            };
            result.push(item);
        }
        return Promise.resolve(result);
    }
    async getAccessRuleSetsForDeviceV2(params) {
        const qFunction = async (trx) => {
            const regionIds = (await trx.query(`
				SELECT DISTINCT (r.id) FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regions}" AS r
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp
					ON racp."regionId" = r.id
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp
					ON acp."id" = racp."accessControlPointId"
				WHERE acp."deviceId" = ANY ($1::UUID[]);
			`, [params.deviceIds])).rows.map((r) => r.id);
            const result = [];
            const accessRuleSets = (await trx.query(`
					SELECT * FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessRuleSets}"
					WHERE "deletedAt" IS NULL AND
						"regionId" = ANY($1::UUID[]);
				`, [regionIds])).rows;
            for (const accessRuleSet of accessRuleSets) {
                const rules = (await trx.query(`
					SELECT * FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessRules}"
					WHERE "deletedAt" IS NULL AND
						"accessRuleSetId" = $1
					`, [accessRuleSet.id])).rows;
                const userGroupAccessRuleSets = (await trx.query(`
					SELECT * FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupAccessRuleSets}"
					WHERE "accessRuleSetId" = $1
				`, [accessRuleSet.id])).rows;
                const finalRules = rules.map((r) => {
                    if (r.type === dal_constants_1.DalConstants.AccessRuleType.CapacityBased) {
                        const userGroupCapacityItems = r.parameters;
                        const accessRuleParameters = [];
                        for (const userGroupCapacityInfo of userGroupCapacityItems) {
                            if (userGroupCapacityInfo.current === null || userGroupCapacityInfo.current === undefined) {
                                accessRuleParameters.push({
                                    capacity: userGroupCapacityInfo.capacity,
                                    current: userGroupAccessRuleSets.find((ugars) => ugars.accessRuleSetId === r.accessRuleSetId && ugars.userGroupId === userGroupCapacityInfo.groupId)
                                        ?.currentCapacityUsage,
                                    groupId: userGroupCapacityInfo.groupId,
                                });
                            }
                        }
                        r.parameters = accessRuleParameters;
                    }
                    return r;
                });
                for (const fr of finalRules) {
                    if (fr.type === dal_constants_1.DalConstants.AccessRuleType.CapacityBased) {
                        for (const capacityBasedRule of fr.parameters) {
                            if (capacityBasedRule.current === -1) {
                                capacityBasedRule.current = (await dal_manager_1.dbManager.accessRegion.getRegionStateReportNew(params.organizationId, {
                                    pagination: {
                                        take: 10000,
                                        skip: 0,
                                    },
                                    regionId: accessRuleSet.regionId,
                                    status: app_enums_1.enums.IdentityStatusType.Enabled,
                                    userGroupIds: [capacityBasedRule.groupId],
                                    state: [app_enums_1.enums.AntiPassbackState.In],
                                    organizationUnitIds: [],
                                    userIds: [],
                                    applyOrganizationUnitFilterHierarchically: true,
                                    includeUserCaptions: false,
                                }, dal_constants_1.DalConstants.SystemUserId)).pagination.total;
                            }
                        }
                    }
                }
                let item = {
                    id: accessRuleSet.id,
                    isActive: accessRuleSet.isActive,
                    name: accessRuleSet.name,
                    userGroupIds: userGroupAccessRuleSets.map((u) => u.userGroupId),
                    regionId: accessRuleSet.regionId,
                    uncoveredAccessStatus: accessRuleSet.uncoveredAccessStatus,
                    rules: finalRules,
                };
                result.push(item);
            }
            return Promise.resolve(result);
        };
        if (params.trx) {
            return await qFunction(params.trx);
        }
        else {
            return await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                return await qFunction(trx);
            });
        }
    }
    async getDataWithUsersForControlPanelMSeriesV2(organizationId, deviceId, configurationAndSettings) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: null,
                lastSyncISO: null,
                systemDateISO: null,
            };
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings)
                .where("deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            app_logs_1.logger.info("config started");
            let deviceIds = [];
            deviceIds.push(mainDevice.deviceId);
            if (mainDevice.extensions?.length) {
                for (const relatedDevice of mainDevice.extensions) {
                    deviceIds.push(relatedDevice.id);
                }
            }
            result.configurationAndSettings = null;
            if (configurationAndSettings) {
                result.configurationAndSettings = await this.getControlPanelMSeriesDeviceConfigurationAndSettingsV2(organizationId, deviceId);
            }
            app_logs_1.logger.info("config finished");
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("name", "location", "lastSyncISO", "organizationId").where("id", deviceId);
            result.lastSyncISO = deviceInfo.lastSyncISO;
            result.systemDateISO = new Date().toISOString();
            return Promise.resolve(result);
        });
    }
    async addTerminalChange(deviceId, organizationId, changeItem) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            await trx.query(`
                INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
				("id", "transactionId", "actionT", "type", "sessionId", "data", "deviceId", "sessionExpirationT")
                VALUES ($1, txid_current(), now(), $2, $3, $4, $5, $6)
            `, [uuid.v4(), changeItem.type, null, changeItem.data, deviceId, null]);
        });
    }
    async addTerminalChangesBatch(organizationId, params, trx) {
        await trx.query(`
		INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
		("id", "transactionId", "actionT", "type", "sessionId", "data", "deviceId", "sessionExpirationT")
		SELECT gen_random_uuid(), txid_current(), now(), (u->>'type')::INTEGER, null, (u->>'data')::JSON, $1, null
		FROM UNNEST ($2::JSONB[]) AS u
		`, [params.deviceId, params.changeItems]);
        return;
    }
    async removeAllChangesForTerminal(organizationId, deviceId, trx) {
        await trx.query(`
			DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}"
			WHERE "deviceId" = $1
			`, [deviceId]);
        await trx.query(`
			DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChangeTransactions}"
			WHERE "deviceId" = $1
			`, [deviceId]);
    }
    async getDataWithUsersForControlPanelMSeries(deviceId, organizationId, configurationAndSettings, users, accessNotificationEvents) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: null,
                users: null,
                lastSyncISO: null,
            };
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings)
                .where("deviceId", deviceId)
                .first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            app_logs_1.logger.info("config started");
            let deviceIds = [];
            deviceIds.push(mainDevice.deviceId);
            for (const relatedDevice of mainDevice.extensions) {
                deviceIds.push(relatedDevice.id);
            }
            result.configurationAndSettings = null;
            if (configurationAndSettings)
                result.configurationAndSettings = await this.getControlPanelMSeriesDeviceConfigurationAndSettings(organizationId, deviceId);
            app_logs_1.logger.info("config finished");
            result.users = [];
            if (users) {
                await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                    const userIds = await this.getUserIdsOfTerminal(organizationId, deviceId, trx);
                    result.users = await this.getUsersOfTerminalPg(deviceId, userIds, organizationId, trx);
                });
            }
            app_logs_1.logger.info("users finished");
            if (accessNotificationEvents) {
                result.accessNotificationEvents = await dal_manager_1.dbManager.accessNotifications.getAccessNotificationEvents(organizationId, deviceId, trx);
            }
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("name", "location", "lastSyncISO", "organizationId").where("id", deviceId);
            result.lastSyncISO = deviceInfo.lastSyncISO;
            return Promise.resolve(result);
        });
    }
    async getDataWithUsersForArmonOneSeries(deviceId, organizationId, configurationAndSettings, users, credentialTypes, swVersion) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: configurationAndSettings ? await this.getArmonOneSeriesDeviceConfigurationAndSettings(organizationId, deviceId, trx) : undefined,
                users: [],
                lastSyncISO: null,
            };
            if (users) {
                await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                    const userIds = await this.getUserIdsOfTerminal(organizationId, deviceId, trx);
                    result.users = await this.getUsersOfTerminalPg(deviceId, userIds, organizationId, trx);
                });
            }
            if (swVersion) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
                    updatedAt: new Date(),
                    swVersion: swVersion,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceUpdateStatus).where("deviceId", deviceId).where("version", swVersion).delete();
            }
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("name", "location", "lastSyncISO", "organizationId").where("id", deviceId);
            result.lastSyncISO = deviceInfo.lastSyncISO;
            return Promise.resolve(result);
        });
    }
    collectCredentialTypes(authFactors) {
        let credentialTypes = [];
        for (const authFactor of authFactors) {
            switch (authFactor) {
                case dal_constants_1.DalConstants.AuthenticationFactor.AccessToken:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.AccessToken);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.Bluetooth:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.BLE);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.FingerPrint:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.FingerPrintISO19794);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.MiFare:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.MiFare);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.NFC:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.NFC);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.ProximityCard:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.ProximityCard);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.QR_BarCode:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.QrCode);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.UHFRfid:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.UHFRfid);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.VehiclePlate:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.VehiclePlate);
                    break;
                case dal_constants_1.DalConstants.AuthenticationFactor.MRZ:
                    credentialTypes.push(dal_constants_1.DalConstants.CredentialType.MRZ);
                    break;
                default:
                    break;
            }
        }
        return credentialTypes;
    }
    async getUsersOfTerminalPg(deviceId, userIds, organizationId, trx) {
        const authFactorsOfACPsDbResult = await trx.query(`
			SELECT "id", "authenticationFactors" 
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
			WHERE "deletedAt" IS NULL 
				AND "authenticationFactors" IS NOT NULL
				AND "deviceId" = $1
			`, [deviceId]);
        if (authFactorsOfACPsDbResult.rowCount === 0) {
            return [];
        }
        const userAccessRightsDbResult = await trx.query(`
			SELECT "uar"."userId", 
				JSONB_AGG(
					JSONB_BUILD_OBJECT (
						'id', "uar"."id", 
						'accessControlPointId', "uar"."accessControlPointId"
					)	
				) AS "accessRights"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" AS "uar"
			WHERE "uar"."deletedAt" IS NULL
				AND "uar"."access" = TRUE
				AND "uar"."userId" = ANY($1::UUID[])
				AND "uar"."accessControlPointId" = ANY($2::UUID[])
			GROUP BY "uar"."userId"
			`, [userIds, authFactorsOfACPsDbResult.rows.map((m) => m.id)]);
        if (userAccessRightsDbResult.rowCount === 0) {
            return [];
        }
        const userCredentialsToSendToDevice = userAccessRightsDbResult.rows.map((m) => {
            const authFactorsOfUser = authFactorsOfACPsDbResult.rows.filter((f) => m.accessRights.map((mm) => mm.accessControlPointId).includes(f.id)).map((mm) => mm.authenticationFactors);
            let authFactorAnds = lodash_1.default.flatten([].concat.apply([], authFactorsOfUser).map((a) => a.and));
            let availableAuthFactors = lodash_1.default.uniq(authFactorAnds.map((a) => a.factor));
            return {
                userId: m.userId,
                availableCredentials: this.collectCredentialTypes(availableAuthFactors),
            };
        });
        const userCredentialsDbResult = await trx.query(`
			SELECT "id", "userId", "type", "data", "specialData", "expiresOn", "specialDataSecondary", "extensionFields", "groupNumber"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationCredentials}" uoc
			INNER JOIN LATERAL jsonb_array_elements($1::JSONB) AS x(elem)
				ON uoc."userId" = (x.elem->>'userId')::UUID
			INNER JOIN LATERAL jsonb_array_elements_text(x.elem->'availableCredentials') AS "credentialType"
				ON uoc."type" = "credentialType"::integer
			WHERE uoc."deletedAt" IS NULL
				-- This part is added in order to reduce previous lateral joins' result set
				AND uoc."userId" IN (
					SELECT (elem->>'userId')::UUID
					FROM jsonb_array_elements($1::JSONB) AS x(elem)
				)
			`, [JSON.stringify(userCredentialsToSendToDevice)]);
        const userOrganizationInfoDbResult = await trx.query(`
			SELECT "uo"."userId", "uo"."roleId", "u"."publicKey", "uo"."isDisabled", "r"."typeId"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.users}" AS "u"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS "uo"
				ON "u"."id" = "uo"."userId"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" AS "r"
				ON "r"."id" = "uo"."roleId"
			WHERE "uo"."deletedAt" IS NULL
				AND "u"."deletedAt" IS NULL
				AND "uo"."userId" = ANY($1::UUID[])
			`, [userIds]);
        const userCoinBalancesDbResult = await trx.query(`
			SELECT "id", "userId", "remainingUnits"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userRegionTicketUnits}"
			WHERE "userId" = ANY($1::UUID[])
			`, [userIds]);
        const userGroupsDbResult = await trx.query(`
			SELECT "uo"."userId", "uguo"."userGroupId"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}" AS "uguo"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS "uo"
				ON "uo"."id" = "uguo"."userOrganizationId"
			WHERE uo."deletedAt" IS NULL
				AND uguo."deletedAt" IS NULL
				AND "uo"."userId" = ANY($1::UUID[])
			`, [userIds]);
        const userForbiddancesDbResult = await trx.query(`
			SELECT "id", "regionId", "startUtc", "endUtc", "userId", "credentialIds"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationForbiddances}"
			WHERE "deletedAt" IS NULL
				AND "userId" = ANY($1::UUID[])
			`, [userIds]);
        let accessRuleHistories = await dal_manager_1.dbManager.accessLog.listAccessRuleHistory(organizationId, trx, userIds);
        let regionStates = await dal_manager_1.dbManager.accessRegion.listUserRegionStatesForTerminalUsers(organizationId, { userIds, deviceIds: [deviceId] }, trx);
        let items = [];
        for (const userId of userIds) {
            let captionItem = userOrganizationInfoDbResult.rows.find((c) => c.userId === userId);
            if (!captionItem) {
                continue;
            }
            let coinBalancesOfUser = userCoinBalancesDbResult.rows.filter((c) => c.userId === userId) || [];
            let forbiddancesOfUser = userForbiddancesDbResult.rows.filter((c) => c.userId === userId) || [];
            let groups = userGroupsDbResult.rows.filter((c) => c.userId === userId) || [];
            let accessRuleHistoryOfUser = accessRuleHistories.find((c) => c.userId == userId);
            let regionStatesOfUser = regionStates.filter((c) => c.userId == userId);
            items.push({
                id: userId,
                roleId: captionItem ? captionItem.roleId : null,
                publicKey: captionItem.publicKey,
                isDisabled: captionItem.isDisabled,
                userGroupIds: lodash_1.default.uniq(groups.map((u) => u.userGroupId)),
                organizationUnitIds: [],
                accessRights: (userAccessRightsDbResult.rows.filter((a) => a.userId == userId) || []).flatMap((u) => {
                    return u.accessRights;
                }),
                credentials: (userCredentialsDbResult.rows.filter((a) => a.userId == userId) || []).flatMap((c) => {
                    return {
                        id: c.id,
                        type: c.type,
                        data: c.data,
                        expiresOnISO: c.expiresOn?.toISOString(),
                        specialData: c.specialData,
                        specialDataSecondary: c.specialDataSecondary,
                        extensionFields: c.extensionFields,
                        groupNumber: c.groupNumber,
                    };
                }),
                coinBalances: coinBalancesOfUser.map((c) => {
                    return {
                        id: c.id,
                        balance: c.remainingUnits,
                    };
                }),
                forbiddances: forbiddancesOfUser.map((f) => {
                    return {
                        id: f.id,
                        regionId: f.regionId,
                        startDateISO: new Date(f.startUtc).toISOString(),
                        endDateISO: new Date(f.endUtc).toISOString(),
                        credentialIds: f.credentialIds,
                    };
                }),
                accessRuleHistories: accessRuleHistoryOfUser ? accessRuleHistoryOfUser.history : [],
                isVisitor: captionItem && (captionItem.typeId === predefined_roles_1.PredefinedRoles.OrganizationVisitor.id || captionItem.typeId === predefined_roles_1.PredefinedRoles.OrganizationUnitVisitor.id) ? true : false,
                regionStates: regionStatesOfUser?.length
                    ? regionStatesOfUser.map((rsou) => {
                        return {
                            actionDateISO: rsou.actionUtc.toISOString(),
                            regionId: rsou.regionId,
                            state: rsou.state,
                            entranceLockExpirationDateISO: rsou.entranceLockExpirationUtc?.toISOString(),
                            exitLockExpirationDateISO: rsou.exitLockExpirationUtc?.toISOString(),
                            id: null,
                        };
                    })
                    : [],
            });
        }
        return Promise.resolve(items);
    }
    async getUserIdsOfTerminal(organizationId, deviceId, trx) {
        const userIdsOfTerminalDbResult = await trx.query(`
			SELECT DISTINCT("uar"."userId")
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" AS "uar"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS "acp"
				ON "uar"."accessControlPointId" = "acp"."id"
			WHERE "uar"."deletedAt" IS NULL
				AND "acp"."deletedAt" IS NULL
				AND "uar"."access" = TRUE
				AND "acp"."deviceId" = $1
			`, [deviceId]);
        return userIdsOfTerminalDbResult.rows.map((r) => r.userId);
    }
    async upsertUpdateFile(organizationId, deviceCurrentVersion) {
        return this.dbClient.transaction(async (trx) => {
            let existingItem = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceCurrentVersions)
                .where("brand", deviceCurrentVersion.brand)
                .where("model", deviceCurrentVersion.model)
                .first();
            if (existingItem) {
                await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceCurrentVersions)
                    .where("brand", deviceCurrentVersion.brand)
                    .where("model", deviceCurrentVersion.model)
                    .update(deviceCurrentVersion);
            }
            else {
                await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceCurrentVersions).insert(deviceCurrentVersion);
            }
            return Promise.resolve();
        });
    }
    async getUpdateFile(organizationId, brand, model, deviceId) {
        return this.dbClient.transaction(async (trx) => {
            let result = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceCurrentVersions).where("brand", brand).where("model", model).first();
            if (deviceId) {
                let existingDeviceUpdateStatus = await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceUpdateStatus)
                    .where("deviceId", deviceId)
                    .where("version", result.version)
                    .first();
                if (existingDeviceUpdateStatus) {
                    existingDeviceUpdateStatus.attempt = existingDeviceUpdateStatus.attempt + 1;
                    existingDeviceUpdateStatus.updatedAt = new Date();
                    await trx
                        .withSchema(organizationId)
                        .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceUpdateStatus)
                        .where("deviceId", deviceId)
                        .where("version", result.version)
                        .update(existingDeviceUpdateStatus);
                }
                else {
                    let now = new Date();
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceUpdateStatus).where("deviceId", deviceId).where("version", result.version).insert({
                        attempt: 1,
                        createdAt: now,
                        updatedAt: now,
                        deviceId: deviceId,
                        version: result.version,
                    });
                }
            }
            return result;
        });
    }
    async getTerminalIdFosUserTerminalRightId(organizationId, userTerminalId) {
        let result = undefined;
        let dbResult = await this.pgPool.query(`
        SELECT "terminalId" FROM "${organizationId}"."terminalAdministrators" WHERE id = $1;`, [userTerminalId]);
        if (dbResult.rows.length > 0) {
            result = dbResult.rows[0].terminalId;
        }
        return result;
    }
    async getUserTerminalRights(organizationId, requestingUserId, terminalId, trx) {
        let query = `
        SELECT ta."terminalId", array_agg(ta."userId") FILTER (WHERE ta."userId" IS NOT NULL) "userIds",
        jsonb_agg(jsonb_build_object('userId', ta."userId",
                                     'userRights', jsonb_build_object('read', ta.read, 'write', ta.write, 'notify', ta.notify)))
                                    FILTER (WHERE ta."userId" IS NOT NULL AND ta."userId" = $1) as "userTerminalRights"
        FROM "${organizationId}"."terminalAdministrators" ta
        INNER JOIN "${organizationId}"."users" u ON u.id = ta."userId" AND u."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."userOrganizations" uo ON uo."deletedAt" IS NULL AND uo."isDisabled" = false AND uo."organizationId" = $2 AND uo."userId" = u.id
        WHERE ta."terminalId" = $3
        GROUP BY ta."terminalId";
        `;
        let dbResult = await (trx ? trx : this.pgPool).query(query, [requestingUserId, organizationId, terminalId]);
        let result = { read: true, write: true, notify: true };
        let row = dbResult.rows[0];
        if (row) {
            if (row.userIds.length === 0 || row.userIds.includes(requestingUserId)) {
                result = row.userTerminalRights.find((utr) => utr.userId === requestingUserId).userRights;
            }
            else {
                result = { read: false, write: false, notify: false };
            }
        }
        return result;
    }
    async listTerminals(organizationId, filter, requestingUserId) {
        const result = {
            pagination: {
                take: filter.pagination.take,
                skip: filter.pagination.skip,
                total: 0,
            },
            items: [],
        };
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let qx = 1;
            const qb = [];
            let q = `
            SELECT d.*, a.id as "adapterId", a.name as "adapterName", ta.*, count(tc.*)::INTEGER as "changeCount"
            FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
            LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.adapters}" AS a ON a.id = d."adapterId"
			LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}" AS tc ON tc."deviceId" = d.id`;
            if (requestingUserId) {
                q += `
            LEFT JOIN
            (
                SELECT ta."terminalId", array_agg(ta."userId") FILTER (WHERE ta."userId" IS NOT NULL) "userIds",
                jsonb_agg(jsonb_build_object('userId', ta."userId",
                                                'userRights', jsonb_build_object('read', ta.read, 'write', ta.write, 'notify', ta.notify)))
                                            FILTER (WHERE ta."userId" IS NOT NULL AND ta."userId" = $${qx++}) as "userTerminalRights"
                FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" ta
                INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.users}" u ON u.id = ta."userId" AND u."deletedAt" IS NULL
                INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo ON uo."deletedAt" IS NULL AND uo."isDisabled" = false AND uo."organizationId" = $${qx++} AND uo."userId" = u.id
                GROUP BY ta."terminalId"
            ) ta ON ta."terminalId" = d.id
                `;
                qb.push(requestingUserId, organizationId);
            }
            q += `WHERE d."organizationId" = $${qx++} AND d."deletedAt" IS NULL
            AND d.brand = ANY($${qx++}::integer[]) AND d.model = ANY($${qx++}::text[])`;
            qb.push(organizationId, [dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision], dal_constants_1.DalConstants.terminalModels);
            if (requestingUserId) {
                q += `
                AND ($${qx++} = ANY("userIds") OR "userIds" IS NULL)
                `;
                qb.push(requestingUserId);
            }
            if (filter.name) {
                q += `
                AND d.name ilike $${qx++}`;
                qb.push("%" + filter.name + "%");
            }
            if (filter.brand) {
                q += `
                AND d.brand = $${qx++}`;
                qb.push(filter.brand);
            }
            if (filter.model) {
                q += `
                AND d.model ilike $${qx++}`;
                qb.push("%" + filter.model + "%");
            }
            if (filter.deviceIds && filter.deviceIds.length > 0) {
                q += `
                AND d.id = ANY( $${qx++} )`;
                qb.push(filter.deviceIds);
            }
            if (filter.warningLevel) {
                q += `
                AND d.health::text ilike $${qx++}`;
                qb.push('%"level":' + filter.warningLevel + "%");
            }
            if (filter.connectionStatus && filter.connectionStatus != dal_constants_1.DalConstants.TerminalConnectionStatus.All) {
                if (filter.connectionStatus == dal_constants_1.DalConstants.TerminalConnectionStatus.Connected) {
                    q += `
                AND "health" ->> 'isConnected' = $${qx++} `;
                    qb.push(true);
                }
                else {
                    q += `
                AND "health" ->> 'isConnected' = $${qx++} `;
                    qb.push(false);
                }
            }
            q += ` GROUP BY d.id, a.id, a.name, ta."terminalId", ta."userIds", ta."userTerminalRights" `;
            result.pagination.total = parseInt((await trx.query("SELECT COUNT(*) FROM (" + q + ")q1", qb)).rows[0].count);
            q += `
            ORDER BY d.name`;
            q += `
                OFFSET $${qx++} `;
            qb.push(filter.pagination.skip);
            q += `
                LIMIT $${qx++}`;
            qb.push(filter.pagination.take);
            const devices = (await trx.query(q, qb)).rows;
            const deviceReaders = (await trx.query(`SELECT "deviceId", "credentialType" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders}"
                WHERE "deletedAt" IS NULL
                AND "deviceId" = ANY($1:: uuid[])
                    `, [devices.map((d) => d.id)])).rows;
            for (const device of devices) {
                let terminalHealth = device.health ? device.health : null;
                let terminalInfo = {
                    id: device.id,
                    adapterId: device.adapterId,
                    adapterName: device.adapterName,
                    temperature: terminalHealth ? terminalHealth.temperature : 0,
                    availableStorage: terminalHealth ? terminalHealth.availableStorage : 0,
                    usedStorage: terminalHealth ? terminalHealth.usedStorage : 0,
                    power: terminalHealth ? terminalHealth.power : dal_constants_1.DalConstants.DevicePowerState.NoInfo,
                    isConnected: terminalHealth ? terminalHealth.isConnected : false,
                    lastUpdateUtc: terminalHealth ? terminalHealth.lastUpdateUtc : null,
                    warnings: terminalHealth ? terminalHealth.warnings : [],
                    brand: device.brand,
                    ip: terminalHealth ? terminalHealth.ip : "",
                    mac: terminalHealth && terminalHealth?.mac?.length > 0 ? terminalHealth?.mac : null,
                    location: device.location,
                    model: device.model,
                    name: device.name,
                    serialNumber: device.serialNumber,
                    backendApiVersion: terminalHealth && terminalHealth.version && terminalHealth.version.backendApiVersion ? terminalHealth.version.backendApiVersion : "v2",
                    userRights: {
                        read: true,
                        write: true,
                        notify: true,
                    },
                    emergencyStatus: terminalHealth ? terminalHealth.emergencyStatus : app_enums_1.enums.EmergencyState.Normal,
                    softwareUpdateInterfaceState: device.softwareUpdateInterfaceState ?? dal_constants_1.DalConstants.SoftwareUpdateInterfaceState.NotSupported,
                    serverConnectionState: device.serverConnectionState ?? dal_constants_1.DalConstants.ServerConnectionCommand.Disconnect,
                    changeCount: device.changeCount,
                };
                if (requestingUserId) {
                    let userTerminalRights = null;
                    if (device.userTerminalRights) {
                        userTerminalRights = device.userTerminalRights.find((utr) => utr.userId === requestingUserId).userRights;
                    }
                    if (!userTerminalRights) {
                        userTerminalRights = {
                            read: true,
                            write: true,
                            notify: true,
                        };
                    }
                    terminalInfo.userRights = userTerminalRights;
                }
                switch (terminalInfo.brand) {
                    case dal_constants_1.DalConstants.DeviceBrand.Armon:
                        {
                            terminalInfo.availableActions = [
                                { type: dal_constants_1.DalConstants.TerminalAction.Restart, settings: null },
                                { type: dal_constants_1.DalConstants.TerminalAction.Emergency, settings: null },
                            ];
                            if (terminalInfo.model == "V10") {
                                const readers = deviceReaders.filter((d) => d.deviceId == terminalInfo.id);
                                if (readers.some((r) => [dal_constants_1.DalConstants.CredentialType.FingerPrintISO19794].some((c) => c == r.credentialType))) {
                                    terminalInfo.availableActions.push({ type: dal_constants_1.DalConstants.TerminalAction.FingerPrintCapture, settings: null });
                                }
                            }
                            if (terminalInfo.model === "VPass" && terminalHealth.version?.serviceVersion > "0.0.30") {
                                terminalInfo.availableActions.push({ type: dal_constants_1.DalConstants.TerminalAction.SoftwareUpdateInterface, settings: null }, { type: dal_constants_1.DalConstants.TerminalAction.ServerConnection, settings: null });
                                if (terminalInfo.softwareUpdateInterfaceState === dal_constants_1.DalConstants.SoftwareUpdateInterfaceState.NotSupported) {
                                    terminalInfo.softwareUpdateInterfaceState = dal_constants_1.DalConstants.SoftwareUpdateInterfaceState.Disable;
                                }
                            }
                        }
                        break;
                    case dal_constants_1.DalConstants.DeviceBrand.AssaAbloy:
                        {
                            terminalInfo.availableActions = [{ type: dal_constants_1.DalConstants.TerminalAction.Restart, settings: null }];
                        }
                        break;
                    default:
                        terminalInfo.availableActions = [];
                }
                result.items.push(terminalInfo);
            }
            return result;
        });
    }
    async listAdapters(organizationId, filter) {
        let result = {
            pagination: {
                take: filter.pagination.take,
                skip: filter.pagination.skip,
                total: 0,
            },
            items: [],
        };
        let qb = this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("organizationId", organizationId);
        if (filter.type)
            qb.where("type", filter.type);
        if (filter.number)
            qb.where("number", filter.number);
        result.pagination.total = parseInt((await qb.clone().count().first()).count);
        qb.limit(filter.pagination.take);
        qb.offset(filter.pagination.skip);
        let adapters = await qb.select();
        let deviceInfo = await this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("organizationId", organizationId)
            .whereIn("adapterId", adapters.map((a) => a.id))
            .groupBy("model", "brand", "adapterId")
            .count()
            .select("adapterId", "model", "brand");
        for (const adapter of adapters) {
            let deviceInfoList = deviceInfo.filter((d) => d.adapterId == adapter.id);
            let adapterHealth = {
                id: adapter.id,
                adaptedDevices: deviceInfoList.map((d) => {
                    return {
                        brand: d.brand,
                        model: d.model,
                        count: parseInt(d.count),
                    };
                }),
                ip: adapter.ip,
                number: adapter.number,
                type: adapter.type,
            };
            result.items.push(adapterHealth);
        }
        return Promise.resolve(result);
    }
    async getDeviceStatus(organizationId) {
        const result = {
            connected: 0,
            disconnected: 0,
            warning: {
                critical: 0,
                medium: 0,
                high: 0,
            },
        };
        let terminalCount = parseInt((await this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d")
            .leftJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters + " as ad", "ad.id", "d.adapterId")
            .where("d.organizationId", organizationId)
            .whereNull("d.deletedAt")
            .whereIn("d.brand", [dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision])
            .whereIn("d.model", dal_constants_1.DalConstants.terminalModels)
            .count()
            .first()).count);
        let deviceHealthList = (await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
            .where("organizationId", organizationId)
            .whereNull("deletedAt")
            .whereIn("brand", [dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision])
            .whereIn("model", dal_constants_1.DalConstants.terminalModels)
            .select("health")).map((r) => (r.health ? r.health : null));
        result.disconnected = terminalCount;
        deviceHealthList = lodash_1.default.compact(deviceHealthList);
        for (const deviceHealth of deviceHealthList) {
            if (deviceHealth.isConnected) {
                result.connected++;
                result.disconnected--;
            }
            if (deviceHealth.warnings) {
                if (deviceHealth.warnings.find((d) => d.level == dal_constants_1.DalConstants.TerminalWarningLevel.Critical)) {
                    result.warning.critical++;
                }
                if (deviceHealth.warnings.find((d) => d.level == dal_constants_1.DalConstants.TerminalWarningLevel.High)) {
                    result.warning.high++;
                }
                if (deviceHealth.warnings.find((d) => d.level == dal_constants_1.DalConstants.TerminalWarningLevel.Medium)) {
                    result.warning.medium++;
                }
            }
        }
        return Promise.resolve(result);
    }
    async updateDeviceHealth(organizationId, deviceId, health) {
        await this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
            updatedAt: new Date(),
            health: health,
        });
    }
    async getDeviceHealth(organizationId, deviceId) {
        const { rows } = await this._pgPool.query(`
            SELECT health FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}
            WHERE id = $1`, [deviceId]);
        return rows[0]?.health ? rows[0].health : null;
    }
    async getDeviceHealths(params) {
        const { rows } = await (params.trx ?? this._pgPool).query(`
            SELECT id as "deviceId", health as "deviceHealth" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
            WHERE id = ANY($1::uuid[])`, [params.deviceIds]);
        return rows;
    }
    async genericSearchSensors(organizationId, options) {
        let result = {
            total: 0,
            items: [],
        };
        let qb = this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs + " as dci")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "dci.deviceId")
            .where("d.organizationId", organizationId)
            .whereNull("d.deletedAt")
            .whereNull("dci.deletedAt")
            .whereIn("dci.type", [dal_constants_1.DalConstants.DryContactType.Counter, dal_constants_1.DalConstants.DryContactType.StatusSensor, dal_constants_1.DalConstants.DryContactType.TamperSwitch]);
        let filterExists = options.filter && options.filter.trim().length > 0;
        let regexList = [];
        if (filterExists) {
            qb.whereWrapped((q) => {
                let filterTokens = options.filter.split(" ");
                for (const filterToken of filterTokens) {
                    let token = filterToken.trim();
                    regexList.push(new RegExp(options.filter.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "ig"));
                    if (token.length > 0) {
                        token = "%" + token + "%";
                        q.orWhereRaw("dci.name ilike ?", token);
                    }
                }
            });
        }
        let columns = ["dci.id", "dci.name", "d.name as deviceName", "dci.number"];
        let qbCount = qb.clone();
        result.total = await qbCount.count("d.id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        qb.orderByRaw("dci.name").column(columns).select().offset(options.skip).limit(options.take);
        result.items = await qb.then((rows) => {
            return rows.map((t) => {
                let sensorName = t["name"];
                let caption = sensorName && !lodash_1.default.isEmpty(sensorName) ? sensorName : t["deviceName"] + " #" + t["number"];
                return {
                    id: t["id"],
                    captionLines: [caption],
                    matchItem: sensorName,
                };
            });
        });
        return Promise.resolve(result);
    }
    async genericSearchTerminals(organizationId, options) {
        let result = {
            total: 0,
            items: [],
        };
        let qb = this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d")
            .where("d.organizationId", organizationId)
            .whereNull("d.deletedAt")
            .whereIn("d.brand", [dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision])
            .whereIn("d.model", dal_constants_1.DalConstants.terminalModels)
            .whereIn("d.id", options.deviceIds);
        let filterExists = options.filter && options.filter.trim().length > 0;
        let regexList = [];
        if (filterExists) {
            qb.whereWrapped((q) => {
                let filterTokens = options.filter.split(" ");
                for (const filterToken of filterTokens) {
                    let token = filterToken.trim();
                    regexList.push(new RegExp(options.filter.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "ig"));
                    if (token.length > 0) {
                        token = "%" + token + "%";
                        q.orWhereRaw("d.name ilike ?", token);
                    }
                }
            });
        }
        let columns = ["d.id", "d.name"];
        let qbCount = qb.clone();
        result.total = await qbCount.count("d.id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        qb.orderByRaw("d.name").column(columns).select().offset(options.skip).limit(options.take);
        result.items = await qb.then((rows) => {
            return rows.map((t) => {
                return {
                    id: t["id"],
                    captionLines: [t["name"], t["location"]],
                    matchItem: t["name"],
                };
            });
        });
        return Promise.resolve(result);
    }
    async listSensorDetails(organizationId, deviceIds, numbers) {
        let results = [];
        let qb = this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs + " as dci")
            .leftJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints + " as acp", "acp.id", "dci.accessControlPointId")
            .whereNull("dci.deletedAt")
            .whereIn("dci.deviceId", deviceIds);
        if (numbers) {
            qb.whereIn("dci.number", numbers);
        }
        results = await qb.select("dci.name", "dci.number", "dci.id", "dci.deviceId", "dci.type", "acp.id as accessControlPointId", "acp.name as accessControlPointName");
        return Promise.resolve(results);
    }
    async listArmonControlPanelExtensions(organizationId, deviceIds) {
        let results = [];
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings);
        if (deviceIds) {
            qb.whereIn("deviceId", deviceIds);
        }
        results = await qb.select();
        return Promise.resolve(results);
    }
    async getACPRemoteRelayDriveMappings(organizationId, accessControlPointIds, trx) {
        if (!accessControlPointIds || !accessControlPointIds.length) {
            return Promise.resolve([]);
        }
        const dbResult = await trx.raw(`
			SELECT "accessPointId", "remoteRelayId", "config"->'d' AS direction 
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}"
			WHERE "accessPointId" = ANY (?::UUID[]) AND "remoteRelayId" IS NOT NULL;
		`, [accessControlPointIds]);
        if (dbResult.rowCount) {
            return Promise.resolve(dbResult.rows);
        }
        else {
            return Promise.resolve([]);
        }
    }
    async getMainDeviceConfigs(organizationId, deviceIds, trx) {
        let accessControlPoints = (await trx
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
            .select("id", "name", "authenticationFactors", "deviceId", "states")
            .whereNull("deletedAt")
            .whereIn("deviceId", deviceIds));
        let relays = (await trx
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
            .whereNull("deletedAt")
            .whereIn("deviceId", deviceIds)
            .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
        let readers = (await trx
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
            .whereNull("deletedAt")
            .whereIn("deviceId", deviceIds)
            .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
        let dryContactInputs = (await trx
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
            .whereNull("deletedAt")
            .whereIn("deviceId", deviceIds)
            .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
        let cameras = await dal_manager_1.dbManager.accessCamera.listCamerasForDeviceV2(organizationId, deviceIds, trx);
        let regions = [];
        for (const device of deviceIds) {
            regions = regions.concat(await this.getDeviceRegions(organizationId, device, trx));
        }
        return Promise.resolve({
            accessControlPoints: accessControlPoints,
            relays: relays,
            readers: readers,
            dryContactInputs: dryContactInputs,
            cameras: cameras,
            regions: regions,
        });
    }
    async getAperioHubConfigurationAndSettings(organizationId, hubId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", hubId).first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(hubId);
            let lockDeviceIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks).where("hubDeviceId", hubId).select("lockDeviceId")).map((e) => e.lockDeviceId);
            deviceIds.push(...lockDeviceIds);
            let deviceInfo = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                .first("name", "location", "lastSyncISO", "organizationId")
                .whereNull("deletedAt")
                .where("id", hubId);
            let { accessControlPoints, relays, readers, dryContactInputs, cameras, regions } = await this.getMainDeviceConfigs(organizationId, deviceIds, trx);
            let locks = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks + " as e")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "d.id", "e.lockDeviceId")
                .where("e.hubDeviceId", hubId)
                .select("d.*"));
            result = {
                hub: deviceInfo,
                locks: locks,
                cameras: cameras,
                readers: readers,
                dryContactInputs: dryContactInputs,
                relays: relays,
                organizationId: deviceInfo.organizationId,
                accessControlPoints: accessControlPoints,
                accessRuleSets: await this.getAccessRuleSetsForDeviceV2({ organizationId, deviceIds }),
                regions: regions,
                sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, hubId, trx),
                timezoneOffset: new Date().getTimezoneOffset(),
                integrations: [],
                mainDeviceInfo: {
                    deviceId: deviceInfo.id,
                    location: deviceInfo.location,
                    name: deviceInfo.name,
                    timezone: deviceInfo.timezone,
                },
            };
        });
        return Promise.resolve(result);
    }
    async updateAperioHubConfigurationAndSettings(organizationId, hubId, lockIds) {
        await this.dbClient.transaction(async (trx) => {
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks).where("hubDeviceId", hubId).delete();
            await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks)
                .insert(lockIds.map((lockId) => {
                return {
                    hubDeviceId: hubId,
                    lockDeviceId: lockId,
                };
            }));
        });
        return this.getAperioHubConfigurationAndSettings(organizationId, hubId);
    }
    async getArmonOneDetails(organizationId, deviceId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first();
            const ioCounts = this.getIOCountsByDeviceModel(mainDevice.model);
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .select("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .where("deviceId", deviceId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let readers = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .where("deviceId", deviceId)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let cameraActions = await dal_manager_1.dbManager.accessCamera.listCameraActionsForDevice(organizationId, [deviceId], trx);
            let deviceVersion = mainDevice.health && mainDevice.health.version ? mainDevice.health.version : {};
            let deviceHealth = mainDevice.health ? mainDevice.health : {};
            result = {
                deviceId: deviceId,
                settings: {
                    name: mainDevice.name,
                    location: mainDevice.location,
                },
                accessControlPoints: accessControlPoints.map((a) => {
                    return {
                        id: a.id,
                        name: a.name,
                    };
                }),
                io: {
                    dryContactInputs: dryContactInputs,
                    relays: relays,
                    readers: readers,
                },
                configuration: {
                    serialNumber: mainDevice.serialNumber,
                    model: mainDevice.model,
                    libAccessVersion: deviceVersion.libAccessVersion,
                    serviceVersion: deviceVersion.serviceVersion,
                    hardwareVersion: deviceVersion.hardwareHwVersion,
                    softwareVersion: deviceVersion.hardwareSwVersion,
                    onBoardComputerModel: deviceHealth.onBoardComputerModel,
                    onBoardComputerVersion: deviceVersion.onBoardComputerVersion,
                    onBoardComputerOs: deviceVersion.operatingSystem,
                    onBoardComputerTotalStorage: deviceHealth.onBoardComputerTotalStorage,
                    onBoardComputerFreeStorage: deviceHealth.onBoardComputerFreeStorage,
                    relayCount: relays.length || ioCounts.relayCount,
                    readerCount: readers.length || ioCounts.readerCount,
                    dryContactInputCount: dryContactInputs.length || ioCounts.dryContactInputCount,
                    operatingFreeAirTemperatureCriticalHigh: 90,
                    operatingFreeAirTemperatureCriticalLow: -20,
                    operatingFreeAirTemperatureLimitHigh: 100,
                    operatingFreeAirTemperatureLimitLow: -40,
                    caption: mainDevice.caption,
                    analogInputCount: 0,
                    hasEmergencyInput: false,
                    isolatedInputCount: 0,
                    hasBatteryInput: true,
                    ip: mainDevice.health ? mainDevice.health.ip : "",
                    backendApiVersion: deviceVersion.backendApiVersion,
                },
                integrations: cameraActions.length > 0
                    ? [
                        {
                            cameraActions: cameraActions,
                        },
                    ]
                    : [],
            };
        });
        return Promise.resolve(result);
    }
    async getAperioAH40Details(organizationId, hubId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", hubId).first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(hubId);
            let lockDeviceIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks).where("hubDeviceId", hubId).select("lockDeviceId")).map((e) => e.lockDeviceId);
            deviceIds.push(...lockDeviceIds);
            let devices = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).select().whereNull("deletedAt").whereIn("id", deviceIds);
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .select("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let readers = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let cameraActions = await dal_manager_1.dbManager.accessCamera.listCameraActionsForDevice(organizationId, deviceIds, trx);
            let deviceVersion = mainDevice.health && mainDevice.health.version ? mainDevice.health.version : {};
            let deviceHealth = mainDevice.health ? mainDevice.health : {};
            result = {
                deviceId: hubId,
                settings: {
                    name: mainDevice.name,
                    location: mainDevice.location,
                },
                locks: lockDeviceIds.map((l) => {
                    let lock = devices.find((d) => d.id == l);
                    let lockDeviceVersion = mainDevice.health && mainDevice.health.version ? mainDevice.health.version : {};
                    let lockDeviceHealth = mainDevice.health ? mainDevice.health : {};
                    return {
                        deviceId: l,
                        configuration: {
                            serialNumber: lock.serialNumber,
                            model: lock.model,
                            serviceVersion: lockDeviceVersion.serviceVersion,
                            libAccessVersion: lockDeviceVersion.libAccessVersion,
                            hardwareVersion: lockDeviceVersion.hardwareHwVersion,
                            softwareVersion: lockDeviceVersion.hardwareSwVersion,
                            onBoardComputerModel: lockDeviceHealth.onBoardComputerModel,
                            onBoardComputerVersion: lockDeviceVersion.onBoardComputerVersion,
                            onBoardComputerOs: lockDeviceVersion.operatingSystem,
                            onBoardComputerTotalStorage: lockDeviceHealth.onBoardComputerTotalStorage,
                            onBoardComputerFreeStorage: lockDeviceHealth.onBoardComputerFreeStorage,
                            relayCount: 1,
                            readerCount: 1,
                            dryContactInputCount: 2,
                            operatingFreeAirTemperatureLimitLow: 5,
                            operatingFreeAirTemperatureLimitHigh: 35,
                            operatingFreeAirTemperatureCriticalLow: 5,
                            operatingFreeAirTemperatureCriticalHigh: 35,
                            caption: lock.caption,
                            analogInputCount: 0,
                            hasEmergencyInput: false,
                            isolatedInputCount: 0,
                            hasBatteryInput: true,
                            ip: lock.health ? lock.health.ip : "",
                            backendApiVersion: lockDeviceVersion.backendApiVersion,
                            isConnected: lockDeviceHealth.isConnected,
                            batteryLevel: lockDeviceHealth.batteryLevel,
                        },
                        io: {
                            dryContactInputs: dryContactInputs.filter((d) => d.deviceId == l),
                            relays: relays.filter((r) => r.deviceId == l),
                            readers: readers.filter((r) => r.deviceId == l),
                        },
                    };
                }),
                accessControlPoints: accessControlPoints.map((a) => {
                    return {
                        id: a.id,
                        name: a.name,
                    };
                }),
                io: {
                    dryContactInputs: dryContactInputs,
                    relays: relays,
                    readers: readers,
                },
                configuration: {
                    serialNumber: mainDevice.serialNumber,
                    model: mainDevice.model,
                    serviceVersion: deviceVersion.serviceVersion,
                    libAccessVersion: deviceVersion.libAccessVersion,
                    hardwareVersion: deviceVersion.hardwareHwVersion,
                    softwareVersion: deviceVersion.hardwareSwVersion,
                    onBoardComputerModel: deviceHealth.onBoardComputerModel,
                    onBoardComputerVersion: deviceVersion.onBoardComputerVersion,
                    onBoardComputerOs: deviceVersion.operatingSystem,
                    onBoardComputerTotalStorage: deviceHealth.onBoardComputerTotalStorage,
                    onBoardComputerFreeStorage: deviceHealth.onBoardComputerFreeStorage,
                    relayCount: 0,
                    readerCount: 0,
                    maxLockCount: 16,
                    needsAdapterService: true,
                    dryContactInputCount: 0,
                    operatingFreeAirTemperatureLimitLow: 0,
                    operatingFreeAirTemperatureLimitHigh: 50,
                    operatingFreeAirTemperatureCriticalLow: 0,
                    operatingFreeAirTemperatureCriticalHigh: 50,
                    caption: mainDevice.caption,
                    analogInputCount: 0,
                    hasEmergencyInput: false,
                    isolatedInputCount: 0,
                    hasBatteryInput: true,
                    ip: mainDevice.health ? mainDevice.health.ip : "",
                    backendApiVersion: deviceVersion.backendApiVersion,
                    isConnected: deviceHealth.isConnected,
                    batteryLevel: deviceHealth.batteryLevel,
                },
                integrations: cameraActions.length > 0
                    ? [
                        {
                            cameraActions: cameraActions,
                        },
                    ]
                    : [],
            };
        });
        return Promise.resolve(result);
    }
    async getHikVisionDetails(organizationId, deviceId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [deviceId];
            let accessControlPoints = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .select("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let readers = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("deviceId", deviceIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let cameraActions = await dal_manager_1.dbManager.accessCamera.listCameraActionsForDevice(organizationId, deviceIds, trx);
            let deviceVersion = mainDevice.health && mainDevice.health.version ? mainDevice.health.version : {};
            let deviceHealth = mainDevice.health ? mainDevice.health : {};
            result = {
                deviceId: deviceId,
                settings: {
                    name: mainDevice.name,
                    location: mainDevice.location,
                },
                accessControlPoints: accessControlPoints.map((a) => {
                    return {
                        id: a.id,
                        name: a.name,
                    };
                }),
                io: {
                    dryContactInputs: dryContactInputs,
                    relays: relays,
                    readers: readers,
                },
                configuration: {
                    serialNumber: mainDevice.serialNumber,
                    model: mainDevice.model,
                    serviceVersion: deviceVersion.serviceVersion,
                    libAccessVersion: deviceVersion.libAccessVersion,
                    hardwareVersion: deviceVersion.hardwareHwVersion,
                    softwareVersion: deviceVersion.hardwareSwVersion,
                    onBoardComputerModel: deviceHealth.onBoardComputerModel,
                    onBoardComputerVersion: deviceVersion.onBoardComputerVersion,
                    onBoardComputerOs: deviceVersion.operatingSystem,
                    onBoardComputerTotalStorage: deviceHealth.onBoardComputerTotalStorage,
                    onBoardComputerFreeStorage: deviceHealth.onBoardComputerFreeStorage,
                    relayCount: 0,
                    readerCount: 0,
                    needsAdapterService: true,
                    dryContactInputCount: 0,
                    operatingFreeAirTemperatureLimitLow: 0,
                    operatingFreeAirTemperatureLimitHigh: 50,
                    operatingFreeAirTemperatureCriticalLow: 0,
                    operatingFreeAirTemperatureCriticalHigh: 50,
                    caption: mainDevice.caption,
                    analogInputCount: 0,
                    hasEmergencyInput: false,
                    isolatedInputCount: 0,
                    hasBatteryInput: true,
                    ip: mainDevice.health ? mainDevice.health.ip : "",
                    backendApiVersion: deviceVersion.backendApiVersion,
                    isConnected: deviceHealth.isConnected,
                    batteryLevel: deviceHealth.batteryLevel,
                },
                integrations: cameraActions.length > 0
                    ? [
                        {
                            cameraActions: cameraActions,
                        },
                    ]
                    : [],
            };
        });
        return Promise.resolve(result);
    }
    async getDataWithUsersForArmonOneSeriesV2(organizationId, deviceId, configurationAndSettings) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: null,
                lastSyncISO: null,
                systemDateISO: null,
                openVpnConfig: null,
            };
            if (configurationAndSettings) {
                result.configurationAndSettings = await this.getArmonOneSeriesConfigurationAndSettingsV2(organizationId, deviceId);
            }
            let deviceInfo = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("name", "location", "lastSyncISO", "organizationId").where("id", deviceId);
            result.lastSyncISO = deviceInfo.lastSyncISO;
            result.systemDateISO = new Date().toISOString();
            return Promise.resolve(result);
        });
    }
    async getArmonOneSeriesConfigurationAndSettingsV2(organizationId, deviceId) {
        let result;
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(deviceId);
            let integrations = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as i")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d", "i.integratingDeviceId", "d.id")
                .where("i.integratedDeviceId", deviceId)
                .select("i.integratingDeviceId", "i.type", "i.extensionFields", "d.serialNumber", "d.name", "d.model", "d.location"));
            for (let integration of integrations) {
                integration.extensionFields = integration.extensionFields ? JSON.parse(integration.extensionFields) : "";
            }
            deviceIds.push(...integrations.map((i) => i.integratingDeviceId));
            let { accessControlPoints, relays, readers, dryContactInputs, cameras, regions } = await this.getMainDeviceConfigs(organizationId, deviceIds, trx);
            const remoteRelayAccessControlPointMappings = await this.getACPRemoteRelayDriveMappings(organizationId, accessControlPoints.map((acp) => acp.id), trx);
            for (const remoteRelayMapping of remoteRelayAccessControlPointMappings) {
                const relaysOfAccessPoint = relays.filter((r) => r.accessControlPointId === remoteRelayMapping.accessPointId);
                for (const fr of relaysOfAccessPoint) {
                    if (fr.direction === dal_constants_1.DalConstants.AccessDirection.All) {
                        fr["remoteRelayId"] = remoteRelayMapping.remoteRelayId;
                    }
                    else if (fr.direction === remoteRelayMapping.direction) {
                        fr["remoteRelayId"] = remoteRelayMapping.remoteRelayId;
                    }
                }
            }
            const organizationInfo = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                .whereNull("deletedAt")
                .where("id", organizationId)
                .first(this.dbClient.raw(`"settings"->'webRtc' as "webRtc", "publicKey"`));
            result = {
                cameras: cameras,
                readers: readers,
                dryContactInputs: dryContactInputs,
                relays: relays,
                organizationId: mainDevice.organizationId,
                integrations: integrations,
                webRtc: organizationInfo.webRtc,
                mainDeviceInfo: {
                    deviceId: deviceId,
                    timezone: mainDevice.timezone,
                    name: mainDevice.name,
                    location: mainDevice.location,
                    port: mainDevice.port,
                },
                accessControlPoints: accessControlPoints,
                accessRuleSets: await this.getAccessRuleSetsForDeviceV2({ organizationId, deviceIds }),
                regions: regions,
                sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, deviceId, trx),
                timezoneOffset: new Date().getTimezoneOffset(),
                organizationPublicKey: organizationInfo.publicKey,
            };
        });
        return Promise.resolve(result);
    }
    async updateArmonOneDeviceConfigurationAndSettingsV2(deviceId, organizationId, config) {
        await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first();
            if (!mainDevice) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "main device not found" });
            }
            let now = new Date();
            let deleter = async (tableName, deviceIds, ids) => {
                let compactIds = lodash_1.default.compact(ids);
                let qb = trx.withSchema(organizationId).from(tableName).whereIn("deviceId", deviceIds).delete();
                if (ids.length > 0) {
                    qb.whereNotIn("id", compactIds);
                }
                return qb;
            };
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs, [deviceId], config.dryContactInputs.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays, [deviceId], config.relays.map((d) => d.id));
            await deleter(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders, [deviceId], config.readers.map((d) => d.id));
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).where("integratedDeviceId", deviceId).delete();
            let hikVisionLicencePlateReaders = [];
            let impinjSpeedWayGateWays = [];
            let hikVisionPeopleCountingSensors = [];
            let axisLicencePlateReaders = [];
            let integratingDeviceIds = [];
            if (config.integrations && config.integrations.length > 0) {
                for (let integration of config.integrations) {
                    integratingDeviceIds.push(integration.integratingDeviceId);
                    switch (integration.type) {
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader:
                            hikVisionLicencePlateReaders.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485:
                            impinjSpeedWayGateWays.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionPeopleCounting:
                            hikVisionPeopleCountingSensors.push(integration);
                            break;
                        case dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.AxisLicencePlateReader:
                            axisLicencePlateReaders.push(integration);
                            break;
                        default:
                            app_logs_1.logger.error(`Unsupported integration type from V10 ${deviceId} type: ${integration.type}`);
                            break;
                    }
                }
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereIn("id", integratingDeviceIds).delete();
            }
            let deviceRelays = [];
            for (const relay of config.relays) {
                let existingRelay = relay.id ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereNull("deletedAt").where("id", relay.id).first() : null;
                if (existingRelay) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("id", relay.id).update({
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    });
                    deviceRelays.push(existingRelay);
                }
                else {
                    let newRelay = {
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deviceId: relay.deviceId,
                        number: relay.number,
                        driveDuration: relay.driveDuration,
                        direction: relay.direction,
                        name: relay.name,
                    };
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).insert(newRelay);
                    deviceRelays.push(newRelay);
                }
            }
            for (const dryContactInput of config.dryContactInputs) {
                let relay = deviceRelays.find((r) => dryContactInput.settings && r.deviceId == dryContactInput.settings.relayDeviceId && r.number == dryContactInput.settings.relayNumber);
                let accessControlPointIdOfDryContactInput = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let settings = {};
                switch (dryContactInput.type) {
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.ExitButton:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                        };
                        break;
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.StatusSensor:
                        settings = {
                            relayId: relayId,
                            timeOut: dryContactInput.settings.timeOut,
                        };
                        break;
                    case dal_constants_1.DalConstants.libEnumsV2.DryContactType.CounterSensor:
                        settings = {
                            relayId: relayId,
                            direction: dryContactInput.settings.direction,
                        };
                        break;
                    default:
                        settings = {
                            relayId: relayId,
                        };
                        break;
                }
                let existingDryContactInput = dryContactInput.id
                    ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).first()
                    : null;
                if (existingDryContactInput) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("id", dryContactInput.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfDryContactInput,
                        deviceId: dryContactInput.deviceId,
                        number: dryContactInput.number,
                        type: dryContactInput.type,
                        nc: dryContactInput.nc,
                        settings: settings,
                        name: dryContactInput.name,
                    });
                }
            }
            for (let hikVisionLicencePlateReader of hikVisionLicencePlateReaders) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: hikVisionLicencePlateReader.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.HikVision,
                    serialNumber: hikVisionLicencePlateReader.serialNumber,
                    model: hikVisionLicencePlateReader.model,
                    name: hikVisionLicencePlateReader.name,
                    location: hikVisionLicencePlateReader.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: hikVisionLicencePlateReader.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader,
                    extensionFields: hikVisionLicencePlateReader.extensionFields,
                });
            }
            for (let impinjSpeedWayGateWay of impinjSpeedWayGateWays) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: impinjSpeedWayGateWay.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.Impinj,
                    serialNumber: impinjSpeedWayGateWay.serialNumber,
                    model: impinjSpeedWayGateWay.model,
                    name: impinjSpeedWayGateWay.name,
                    location: impinjSpeedWayGateWay.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: impinjSpeedWayGateWay.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485,
                    extensionFields: impinjSpeedWayGateWay.extensionFields,
                });
            }
            for (let hikVisionPeopleCountingSensor of hikVisionPeopleCountingSensors) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: hikVisionPeopleCountingSensor.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.HikVision,
                    serialNumber: hikVisionPeopleCountingSensor.serialNumber,
                    model: hikVisionPeopleCountingSensor.model,
                    name: hikVisionPeopleCountingSensor.name,
                    location: hikVisionPeopleCountingSensor.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: hikVisionPeopleCountingSensor.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionPeopleCounting,
                    extensionFields: hikVisionPeopleCountingSensor.extensionFields,
                });
            }
            for (let axisLicencePlateReader of axisLicencePlateReaders) {
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).insert({
                    id: axisLicencePlateReader.integratingDeviceId,
                    createdAt: now,
                    updatedAt: now,
                    organizationId: organizationId,
                    brand: dal_constants_1.DalConstants.DeviceBrand.Axis,
                    serialNumber: axisLicencePlateReader.serialNumber,
                    model: axisLicencePlateReader.model,
                    name: axisLicencePlateReader.name,
                    location: axisLicencePlateReader.location,
                });
                await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations).insert({
                    integratedDeviceId: deviceId,
                    integratingDeviceId: axisLicencePlateReader.integratingDeviceId,
                    type: dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.AxisLicencePlateReader,
                    extensionFields: axisLicencePlateReader.extensionFields,
                });
            }
            for (const reader of config.readers) {
                let relay = deviceRelays.find((r) => r.deviceId == reader.relayDeviceId && r.number == reader.relayNumber);
                let accessControlPointIdOfWiegandReader = relay ? relay.accessControlPointId : null;
                let relayId = relay ? relay.id : null;
                let existingReader = reader.id ? await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("id", reader.id).first() : null;
                if (existingReader) {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("id", existingReader.id).update({
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: reader.deviceId,
                        number: reader.number,
                        location: reader.location,
                        relayId: relayId,
                        direction: reader.direction,
                        model: reader.model,
                        dataFormat: reader.dataFormat,
                        recurrentAttemptTimeout: reader.recurrentAttemptTimeout,
                        credentialType: reader.credentialType,
                        name: reader.name,
                        readerOutputType: reader.readerOutputType,
                    });
                }
                else {
                    await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).insert({
                        id: uuid.v4(),
                        createdAt: now,
                        updatedAt: now,
                        accessControlPointId: accessControlPointIdOfWiegandReader,
                        deviceId: reader.deviceId,
                        number: reader.number,
                        location: reader.location,
                        relayId: relayId,
                        direction: reader.direction,
                        model: reader.model,
                        dataFormat: reader.dataFormat,
                        credentialType: reader.credentialType,
                        recurrentAttemptTimeout: reader.recurrentAttemptTimeout,
                        name: reader.name,
                        readerOutputType: reader.readerOutputType,
                    });
                }
            }
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
                updatedAt: now,
                name: config.mainDeviceInfo.name,
                location: config.mainDeviceInfo.location,
                timezone: config.mainDeviceInfo.timezone,
            });
        });
        return Promise.resolve(this.getArmonOneSeriesConfigurationAndSettingsV2(organizationId, deviceId));
    }
    async genericListTerminals(organizationId, terminalIds, args) {
        let result = {
            total: 0,
            items: [],
        };
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).whereNull("deletedAt").whereIn("id", terminalIds);
        let columns = [];
        let qbCount = qb.clone();
        result.total = await qbCount.count("id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        if (args.take)
            qb.limit(args.take);
        if (args.skip)
            qb.offset(args.skip);
        result.items = await qb
            .orderByRaw("name")
            .select("id", "name")
            .then((rows) => {
            return rows.map((t) => {
                return {
                    id: t.id,
                    captionLines: [t.name],
                };
            });
        });
        return Promise.resolve(result);
    }
    async genericListSensors(organizationId, sensorIds, args) {
        let result = {
            total: 0,
            items: [],
        };
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).whereNull("deletedAt").whereIn("id", sensorIds);
        let columns = [];
        let qbCount = qb.clone();
        result.total = await qbCount.count("id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        if (args.take)
            qb.limit(args.take);
        if (args.skip)
            qb.offset(args.skip);
        result.items = await qb
            .orderByRaw("name")
            .select("id", "name")
            .then((rows) => {
            return rows.map((t) => {
                return {
                    id: t.id,
                    captionLines: [t.name],
                };
            });
        });
        return Promise.resolve(result);
    }
    async listTerminalDryContactInputsById(organizationId, dryContactInputIds, paginationRequest) {
        let result = {
            pagination: {
                take: paginationRequest.take,
                skip: paginationRequest.skip,
                total: 0,
            },
            items: [],
        };
        if (!dryContactInputIds || dryContactInputIds.length < 1) {
            return Promise.resolve(result);
        }
        await this.dbClient.transaction(async (trx) => {
            let qb = trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).whereIn("id", dryContactInputIds);
            result.pagination.total = parseInt((await qb.clone().count().first()).count);
            if (paginationRequest.skip) {
                qb.offset(paginationRequest.skip);
            }
            if (paginationRequest.take) {
                qb.limit(paginationRequest.take);
            }
            let rows = await qb.select("id", "name", "deviceId", "type").orderBy("name", "desc");
            for (const row of rows) {
                result.items.push({
                    terminalId: row.deviceId,
                    dryContactInputId: row.id,
                    name: row.name,
                    type: row.type,
                });
            }
        });
        return Promise.resolve(result);
    }
    async listTerminalDryContactInputs(organizationId, deviceId, paginationRequest) {
        let result = {
            pagination: {
                take: paginationRequest.take,
                skip: paginationRequest.skip,
                total: 0,
            },
            items: [],
        };
        await this.dbClient.transaction(async (trx) => {
            let deviceIds = [deviceId];
            let extensionDeviceIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", deviceId).select("deviceId")).map((d) => d.deviceId);
            let lockDeviceIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks).where("hubDeviceId", deviceId).select("lockDeviceId")).map((d) => d.lockDeviceId);
            deviceIds.push(...extensionDeviceIds);
            deviceIds.push(...lockDeviceIds);
            deviceIds = lodash_1.default.uniq(deviceIds);
            if (deviceIds.length < 1) {
                result.pagination.total = 0;
                return Promise.resolve(result);
            }
            let qb = trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .where("type", dal_constants_1.DalConstants.DryContactTypeV2.TamperSwitch)
                .whereIn("deviceId", deviceIds);
            result.pagination.total = parseInt((await qb.clone().count().first()).count);
            if (paginationRequest.skip) {
                qb.offset(paginationRequest.skip);
            }
            if (paginationRequest.take) {
                qb.limit(paginationRequest.take);
            }
            let rows = await qb.select("id", "name", "deviceId", "type").orderBy("name", "desc");
            for (const row of rows) {
                result.items.push({
                    terminalId: row.deviceId,
                    dryContactInputId: row.id,
                    name: row.name,
                    type: row.type,
                });
            }
        });
        return Promise.resolve(result);
    }
    async getAperioHubConfigurationAndSettingsV2(organizationId, hubId, configurationAndSettings) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: null,
                lastSyncISO: null,
                systemDateISO: new Date().toISOString(),
            };
            let mainDevice = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", hubId).first();
            if (!mainDevice) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
            }
            let deviceIds = [];
            deviceIds.push(hubId);
            let lockDeviceIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.aperioLocks).where("hubDeviceId", hubId).select("lockDeviceId")).map((e) => e.lockDeviceId);
            deviceIds.push(...lockDeviceIds);
            if (configurationAndSettings) {
                let devices = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).select().whereNull("deletedAt").whereIn("id", deviceIds);
                let { accessControlPoints, relays, readers, dryContactInputs, cameras, regions } = await this.getMainDeviceConfigs(organizationId, deviceIds, trx);
                const webRtcSettings = await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                    .whereNull("deletedAt")
                    .where("id", organizationId)
                    .first(this.dbClient.raw(`"settings"->'webRtc' as "webRtc"`));
                result.configurationAndSettings = {
                    locks: lockDeviceIds.map((l) => {
                        let lock = devices.find((d) => d.id == l);
                        return {
                            id: lock.id,
                            serialNumber: lock.serialNumber,
                            model: lock.model,
                        };
                    }),
                    organizationId: organizationId,
                    cameras: cameras,
                    readers: readers,
                    dryContactInputs: dryContactInputs,
                    relays: relays,
                    integrations: [],
                    mainDeviceInfo: {
                        deviceId: hubId,
                        timezone: mainDevice.timezone,
                        name: mainDevice.name,
                        location: mainDevice.location,
                        port: mainDevice.port,
                    },
                    accessControlPoints: accessControlPoints,
                    accessRuleSets: await this.getAccessRuleSetsForDeviceV2({ organizationId, deviceIds }),
                    regions: regions,
                    sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, hubId, trx),
                    timezoneOffset: new Date().getTimezoneOffset(),
                    webRtc: {
                        iceServers: webRtcSettings.webRtc?.iceServers,
                    },
                };
            }
            result.lastSyncISO = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).first("lastSyncISO").where("id", hubId)).lastSyncISO;
            return Promise.resolve(result);
        });
    }
    async getGenericDeviceConfigurationAndSettings(organizationId, deviceId, trx) {
        let result;
        let device = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first();
        if (!deviceId) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("Main device not found");
        }
        let deviceIds = [deviceId];
        let { accessControlPoints, relays, readers, dryContactInputs, cameras, regions } = await this.getMainDeviceConfigs(organizationId, deviceIds, trx);
        result = {
            cameras: cameras,
            readers: readers,
            dryContactInputs: dryContactInputs,
            relays: relays,
            organizationId: device.organizationId,
            accessControlPoints: accessControlPoints,
            accessRuleSets: await this.getAccessRuleSetsForDeviceV2({ organizationId, deviceIds }),
            regions: regions,
            sensorNotifications: await dal_manager_1.dbManager.accessNotifications.listDeviceSensorNotifications(organizationId, deviceId, trx),
            timezoneOffset: new Date().getTimezoneOffset(),
            integrations: [],
            mainDeviceInfo: {
                deviceId: device.id,
                location: device.location,
                name: device.name,
                timezone: device.timezone,
            },
        };
        return Promise.resolve(result);
    }
    async getHikVisionAdapterConfigurationAndSettings(organizationId, adapterId) {
        let terminals = await this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters + " as ad", "ad.id", "d.adapterId")
            .where("d.organizationId", organizationId)
            .where("ad.id", adapterId)
            .whereNull("d.deletedAt")
            .select("d.id", "d.model", "d.serialNumber", "d.amqpUsername as username", "d.amqpPassword as password", "d.ip", "d.port");
        return Promise.resolve({ terminals: terminals });
    }
    async updateHikVisionAdapterConfigurationAndSettings(organizationId, adapterId, configuration) {
        await this.dbClient.transaction(async (trx) => {
            for (const terminal of configuration.terminals) {
                await trx
                    .withSchema(organizationId)
                    .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices + " as d")
                    .update({
                    amqpUsername: terminal.username,
                    amqpPassword: terminal.password,
                    ip: terminal.ip,
                    port: terminal.port,
                });
            }
        });
        return this.getHikVisionAdapterConfigurationAndSettings(organizationId, adapterId);
    }
    async getHikVisionTerminalConfigurationAndSettings(organizationId, terminalId, configurationAndSettings) {
        return this.dbClient.transaction(async (trx) => {
            let result = {
                configurationAndSettings: null,
                lastSyncISO: null,
                systemDateISO: null,
            };
            let terminal = await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", terminalId).first();
            if (!terminal) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("terminal device not found");
            }
            result.configurationAndSettings = null;
            if (configurationAndSettings) {
                result.configurationAndSettings = await this.getGenericDeviceConfigurationAndSettings(organizationId, terminalId, trx);
            }
            result.lastSyncISO = terminal.lastSyncISO.toISOString();
            result.systemDateISO = new Date().toISOString();
            return Promise.resolve(result);
        });
    }
    async getTerminalCertFiles(organizationId, terminalId, date) {
        let certs = await this.dbClient.transaction(async (trx) => {
            let check = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                .where("id", terminalId)
                .whereNull("deletedAt")
                .where("certBeginDate", "<=", date)
                .where("certExpDate", ">=", date)
                .first("certFiles");
            if (!check) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("cert files not found");
            }
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", terminalId).update({
                token: null,
            });
            return check;
        });
        if (!certs) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("cert files not found");
        }
        return Promise.resolve(certs.certFiles);
    }
    async getAdapterCertFiles(organizationId, adapterId, date) {
        let certs = await this.dbClient.transaction(async (trx) => {
            let check = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters)
                .where("id", adapterId)
                .whereNull("deletedAt")
                .where("certBeginDate", "<=", date)
                .where("certExpDate", ">=", date)
                .first("certFiles");
            if (!check) {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("cert files not found");
            }
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("id", adapterId).update({
                token: null,
            });
            return check;
        });
        if (!certs) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("cert files not found");
        }
        return Promise.resolve(certs.certFiles);
    }
    async getTerminalDeviceIdList(trx, organizationId) {
        const transactionFunction = async (trx) => {
            let varNumber = 1;
            let vars = [...dal_constants_1.DalConstants.terminalBrands];
            let brands = [];
            for (let i = 0; i < dal_constants_1.DalConstants.terminalBrands.length; i++) {
                brands.push("$" + varNumber++);
            }
            vars.push(...dal_constants_1.DalConstants.terminalModels);
            let models = [];
            for (let i = 0; i < dal_constants_1.DalConstants.terminalModels.length; i++) {
                models.push("$" + varNumber++);
            }
            let deviceListResult = [];
            const organizationIdList = [];
            if (organizationId) {
                organizationIdList.push(organizationId);
            }
            else {
                organizationIdList.push(...(await dal_manager_1.dbManager.accessOrganization.listOrganizations(trx)));
            }
            for (const schemaId of organizationIdList) {
                const devices = (await trx.query(`
                SELECT "id", "organizationId" FROM "${schemaId}"."devices"
                WHERE "deletedAt" IS NULL
                AND ("brand" IN (${brands.join(",")}))
                AND ("model" IN (${models.join(",")}))
            `, vars)).rows;
                deviceListResult.push(...devices);
            }
            return deviceListResult;
        };
        if (trx) {
            return await transactionFunction(trx);
        }
        else {
            return await dal_manager_1.dbManager.systemTransaction(async (trxx) => {
                return await transactionFunction(trxx);
            });
        }
    }
    async getTerminalByToken(token) {
        const organizationId = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let organizationIdResult = (await trx.query(`
                SELECT "organizationId" FROM public."things"
                WHERE "token" = $1
            `, [token])).rows;
            if (!organizationIdResult || organizationIdResult.length < 1)
                return null;
            return organizationIdResult[0].organizationId;
        });
        return organizationId ? this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("token", token).whereNull("deletedAt").first() : null;
    }
    async getAdapterByToken(token) {
        const organizationId = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let organizationIdResult = (await trx.query(`
                SELECT "organizationId" FROM public."things"
                WHERE "token" = $1
            `, [token])).rows;
            if (!organizationIdResult || organizationIdResult.length < 1)
                return null;
            return organizationIdResult[0].organizationId;
        });
        return this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("token", token).whereNull("deletedAt").first();
    }
    async generateTerminalChallenge(terminalId) {
        return this.dbClient.transaction(async (trx) => {
            let organizationId = await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", terminalId).first("organizationId");
            let device = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", terminalId).first("id", "publicKey", "organizationId");
            if (!device) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "device not found" });
            }
            let organization = await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                .where("id", device.organizationId)
                .first("id", "privateKey", "publicKey");
            if (!organization) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "organization not found" });
            }
            let ecdh = crypto_1.default.createECDH("prime256v1");
            ecdh.setPrivateKey(dal_constants_1.DalConstants.armonPrivateKey, "base64");
            let sharedSecret = ecdh.computeSecret(organization.publicKey, "base64");
            let challenge = uuid.v4();
            let token = crypto_1.default
                .createHmac("sha256", sharedSecret)
                .update(sharedSecret.toString("base64") + challenge)
                .digest("base64");
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", terminalId).update({
                token: token,
            });
            await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", terminalId).update({
                token: token,
            });
            return challenge;
        });
    }
    async generateAdapterChallenge(adapterId) {
        return this.dbClient.transaction(async (trx) => {
            let organizationId = await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", adapterId).first("organizationId");
            let adapter = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("id", adapterId).first("id", "publicKey", "organizationId");
            if (!adapter) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "device not found" });
            }
            let organization = await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                .where("id", adapter.organizationId)
                .first("id", "privateKey", "publicKey");
            if (!organization) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "organization not found" });
            }
            let ecdh = crypto_1.default.createECDH("prime256v1");
            ecdh.setPrivateKey(dal_constants_1.DalConstants.armonPrivateKey, "base64");
            let sharedSecret = ecdh.computeSecret(organization.publicKey, "base64");
            let challenge = uuid.v4();
            let token = crypto_1.default
                .createHmac("sha256", sharedSecret)
                .update(sharedSecret.toString("base64") + challenge)
                .digest("base64");
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("id", adapterId).update({
                token: token,
            });
            await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", adapterId).update({
                token: token,
            });
            return challenge;
        });
    }
    async generateVisitorTabletChallenge(deviceId) {
        return this.dbClient.transaction(async (trx) => {
            let organizationId = (await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", deviceId).first("organizationId")).organizationId;
            let device = await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).first("id", "publicKey", "organizationId");
            if (!device) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "device not found" });
            }
            let organization = await trx
                .withSchema(organizationId)
                .table(dal_db_armon_schema_1.ArmonSchema.tableNames.organizations)
                .where("id", device.organizationId)
                .first("id", "privateKey", "publicKey");
            if (!organization) {
                throw (0, api_error_1.generateNotFoundApiError)({ message: "organization not found" });
            }
            let ecdh = crypto_1.default.createECDH("prime256v1");
            ecdh.setPrivateKey(organization.privateKey, "base64");
            let challenge = crypto_1.default.randomBytes(32);
            let iv = crypto_1.default.createHash("sha256").update(challenge).digest().slice(0, 16);
            let sharedSecret = ecdh.computeSecret(device.publicKey, "base64");
            let password = crypto_1.default.createHash("sha256").update(sharedSecret).digest();
            let cipher = crypto_1.default.createCipheriv("aes-256-cbc", password, iv);
            let token = Buffer.concat([cipher.update(challenge), cipher.final()]).toString("base64");
            await trx.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", deviceId).update({
                token: token,
            });
            await trx.withSchema("public").table(dal_db_armon_schema_1.ArmonSchema.tableNames.things).where("id", deviceId).update({
                token: token,
            });
            return {
                orgPublicKey: organization.publicKey,
                challenge: challenge.toString("base64"),
                iv: iv.toString("base64"),
            };
        });
    }
    async updateTerminalCerts(organizationId, terminalId, certBeginDate, certEndDate, certFiles, trx) {
        let qb = this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices).where("id", terminalId).update({
            certBeginDate: certBeginDate,
            certEndDate: certEndDate,
            certFiles: certFiles,
        });
        if (trx) {
            qb.transacting(trx);
        }
        await qb;
    }
    async updateAdapterCerts(organizationId, adapterId, certBeginDate, certEndDate, certFiles, trx) {
        let qb = this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.adapters).where("id", adapterId).update({
            certBeginDate: certBeginDate,
            certEndDate: certEndDate,
            certFiles: certFiles,
        });
        if (trx) {
            qb.transacting(trx);
        }
        await qb;
    }
    async fetchTerminalData(organizationId, requesterUserId, options, onData) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `
                SELECT json_agg(
                    json_build_object(
                    'id', null,
                    'brand', null,
                    'name', (dev."name"):: text,
                    'location', (dev."location"):: text,
                    'isConnected', null,
                    'adapterId', null,
                    'adapterName', null,
                    'warnings', null,
                    'lastUpdateUtc', (dev."updatedAt"):: timestamp,
                    'serialNumber', (dev."serialNumber"):: text,
                    'ip', (dev."ip"):: text,
                    'temperature', (dev.health ->> 'temperature'):: float,
                    'power', (dev.health ->> 'power'):: float,
                    'usedStorage', (dev.health ->> 'usedStorage'):: float,
                    'availableStorage', (dev.health ->> 'availableStorage'):: float,
                    'model', (dev."model"):: text,
                    'hwVersion', (dev."hwVersion"):: text,
                    'swVersion', (dev."swVersion"):: text,
                    'serviceVersion', (dev.health -> 'version' ->> 'serviceVersion'):: text,
                    'libAccessVersion', (dev.health -> 'version' ->> 'libAccessVersion'):: text,
                    'onBoardComputerModel', (dev.health ->> 'onBoardComputerModel'):: text,
                    'onBoardComputerVersion', (dev.health -> 'version' ->> 'onBoardComputerVersion'):: text
                )) as "data"
        FROM "${organizationId}"."devices" dev
        LEFT JOIN "${organizationId}"."adapters" as ad on ad."id" = dev."adapterId"
           
        LEFT JOIN
        (
            SELECT ta."terminalId", array_agg(ta."userId") FILTER (WHERE ta."userId" IS NOT NULL) "userIds",
            jsonb_agg(jsonb_build_object('userId', ta."userId",
                                            'userRights', jsonb_build_object('read', ta.read, 'write', ta.write, 'notify', ta.notify)))
                                        FILTER (WHERE ta."userId" IS NOT NULL AND ta."userId" = $${queryParamIndex++}) as "userTerminalRights"
            FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" ta
            INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.users}" u ON u.id = ta."userId" AND u."deletedAt" IS NULL
            INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo ON uo."deletedAt" IS NULL AND uo."isDisabled" = false AND uo."organizationId" = $${queryParamIndex++} AND uo."userId" = u.id
            GROUP BY ta."terminalId"
        ) ta ON ta."terminalId" = dev.id
        WHERE dev."deletedAt" IS NULL
        `;
        queryParams.push(requesterUserId, organizationId);
        query += `
        AND ($${queryParamIndex++} = ANY("userIds") OR "userIds" IS NULL) AND
        `;
        queryParams.push(requesterUserId);
        query += `
        dev."organizationId" = $${queryParamIndex++} and
        dev."brand" = ANY ($${queryParamIndex++}::int[]) and
        dev."model"  = ANY ($${queryParamIndex++}::text[])
        `;
        queryParams.push(organizationId);
        queryParams.push([dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision]);
        queryParams.push(dal_constants_1.DalConstants.terminalModels);
        if (options.name) {
            query += `
        and dev."name" ilike $${queryParamIndex++}
        `;
            queryParams.push("%" + options.name.toUpperCase() + "%");
        }
        if (options.brand) {
            query += `
        and dev."brand" = $${queryParamIndex++}
        `;
            queryParams.push(options.brand);
        }
        if (options.model) {
            query += `
        and dev."model" = $${queryParamIndex++}
        `;
            queryParams.push(options.model);
        }
        if (options.deviceIds && options.deviceIds.length > 0) {
            query += `
        and dev."id" in ($${queryParamIndex++})
        `;
            queryParams.push(options.deviceIds.join(","));
        }
        if (options.warningLevel) {
            query += `
        and dev."health":: text ilike '%"level":${options.warningLevel}%'
            `;
        }
        if (options.connectionStatus && options.connectionStatus != dal_constants_1.DalConstants.TerminalConnectionStatus.All) {
            if (options.connectionStatus == dal_constants_1.DalConstants.TerminalConnectionStatus.Connected) {
                query += `
        and dev."health" ->> 'isConnected' = 'true'
            `;
            }
            else {
                query += `
        and dev."health" ->> 'isConnected' = 'false'
            `;
            }
        }
        const client = await this._pgPool.connect();
        const cursor = client.query(new Cursor(query, queryParams));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(1000, (err, rows) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(rows);
                        }
                    });
                });
                await onData(rows[0].data);
            }
            catch (error) {
                app_logs_1.logger.error(error);
            }
            if (rows.length < 1000) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            client.release();
        }
        catch (error) {
            client?.release(error);
            app_logs_1.logger.error(error);
        }
    }
    async fetchDryContactData(organizationId, requesterUserId, options, onData) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `
        SELECT json_agg(
            json_build_object(
                'id', null,
                'nc', null,
                'dryContactInputId', null,
                'name', (dry."name"):: text,
            'type', null,
            'lastUpdateUtc', (dry."updatedAt"):: timestamp,
                'deviceName', (dev."name"):: text,
                    'accessControlPointName', (accessPoints."name"):: text,
                        'relayName', (rel."name"):: text,
                            'timeout', (dry.settings ->> 'timeOut'):: float,
                                'direction', (dry.settings ->> 'direction'):: integer,
                                    'number', (dry."number"):: integer
                )) as "data"
        FROM "${organizationId}"."deviceDryContactInputs" dry
        INNER JOIN "${organizationId}"."devices" dev ON dry."deviceId" = dev."id" AND dev."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."accessControlPoints" accessPoints ON dry."accessControlPointId" = accessPoints."id" AND accessPoints."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."deviceRelays" rel ON dry.settings ->> 'relayId' = rel."id":: text AND rel."deletedAt" IS NULL
        WHERE dry."deletedAt" IS NULL and
            `;
        query += `
        dev."organizationId" = $${queryParamIndex++} and
        dev."brand" = ANY ($${queryParamIndex++}::int[]) and
        dev."model"  = ANY ($${queryParamIndex++}::text[])
        `;
        queryParams.push(organizationId);
        queryParams.push([dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision]);
        queryParams.push(dal_constants_1.DalConstants.terminalModels);
        if (options.name) {
            query += `
        and dev."name" ilike $${queryParamIndex++}
        `;
            queryParams.push("%" + options.name.toUpperCase() + "%");
        }
        if (options.brand) {
            query += `
        and dev."brand" = $${queryParamIndex++}
        `;
            queryParams.push(options.brand);
        }
        if (options.model) {
            query += `
        and dev."model" = $${queryParamIndex++}
        `;
            queryParams.push(options.model);
        }
        if (options.deviceIds && options.deviceIds.length > 0) {
            query += `
        and dev."id" in ($${queryParamIndex++})
        `;
            queryParams.push(options.deviceIds.join(","));
        }
        if (options.warningLevel) {
            query += `
        and dev."health":: text ilike '%"level":${options.warningLevel}%'
            `;
        }
        if (options.connectionStatus && options.connectionStatus != dal_constants_1.DalConstants.TerminalConnectionStatus.All) {
            if (options.connectionStatus == dal_constants_1.DalConstants.TerminalConnectionStatus.Connected) {
                query += `
        and dev."health" ->> 'isConnected' = 'true'
            `;
            }
            else {
                query += `
        and dev."health" ->> 'isConnected' = 'false'
            `;
            }
        }
        const client = await this._pgPool.connect();
        const cursor = client.query(new Cursor(query, queryParams));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, (err, rows) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(rows);
                        }
                    });
                });
                await onData(rows[0].data);
            }
            catch (error) {
                app_logs_1.logger.error(error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            client.release();
        }
        catch (error) {
            client?.release(error);
            app_logs_1.logger.error(error);
        }
    }
    async fetchReaderData(organizationId, requesterUserId, options, onData) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `
        SELECT json_agg(
            json_build_object(
                'id', null,
                'name', (reader."name"):: text,
            'location', (reader."location"):: text,
                'lastUpdateUtc', (reader."updatedAt"):: timestamp,
                    'deviceName', (dev."name"):: text,
                        'accessControlPointName', (accessPoints."name"):: text,
                            'relayName', (rel."name"):: text,
                                'recurrentAttemptTimeout', (reader."recurrentAttemptTimeout"):: text,
                                    'direction', (reader."direction"):: integer,
                                        'number', (reader."number"):: integer,
                                            'readerOutputType', (reader."readerOutputType"):: integer,
                                                'dataFormat', (reader."dataFormat"):: integer,
                                                    'credentialType', (reader."credentialType"):: integer
                )) as "data"
        FROM "${organizationId}"."deviceReaders" reader
        INNER JOIN "${organizationId}"."devices" dev ON reader."deviceId" = dev."id" AND dev."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."accessControlPoints" accessPoints ON reader."accessControlPointId" = accessPoints."id" AND accessPoints."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."deviceRelays" rel ON reader."relayId" = rel."id" AND rel."deletedAt" IS NULL
        WHERE reader."deletedAt" IS NULL and
            `;
        query += `
        dev."organizationId" = $${queryParamIndex++} and
        dev."brand" = ANY ($${queryParamIndex++}::int[]) and
        dev."model"  = ANY ($${queryParamIndex++}::text[])
        `;
        queryParams.push(organizationId);
        queryParams.push([dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision]);
        queryParams.push(dal_constants_1.DalConstants.terminalModels);
        if (options.name) {
            query += `
        and dev."name" ilike $${queryParamIndex++}
        `;
            queryParams.push("%" + options.name.toUpperCase() + "%");
        }
        if (options.brand) {
            query += `
        and dev."brand" = $${queryParamIndex++}
        `;
            queryParams.push(options.brand);
        }
        if (options.model) {
            query += `
        and dev."model" = $${queryParamIndex++}
        `;
            queryParams.push(options.model);
        }
        if (options.deviceIds && options.deviceIds.length > 0) {
            query += `
        and dev."id" in ($${queryParamIndex++})
        `;
            queryParams.push(options.deviceIds.join(","));
        }
        if (options.warningLevel) {
            query += `
        and dev."health":: text ilike '%"level":${options.warningLevel}%'
            `;
        }
        if (options.connectionStatus && options.connectionStatus != dal_constants_1.DalConstants.TerminalConnectionStatus.All) {
            if (options.connectionStatus == dal_constants_1.DalConstants.TerminalConnectionStatus.Connected) {
                query += `
        and dev."health" ->> 'isConnected' = 'true'
            `;
            }
            else {
                query += `
        and dev."health" ->> 'isConnected' = 'false'
            `;
            }
        }
        const client = await this._pgPool.connect();
        const cursor = client.query(new Cursor(query, queryParams));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, (err, rows) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(rows);
                        }
                    });
                });
                await onData(rows[0].data);
            }
            catch (error) {
                app_logs_1.logger.error(error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            client.release();
        }
        catch (error) {
            client?.release(error);
            app_logs_1.logger.error(error);
        }
    }
    async fetchRelayData(organizationId, requesterUserId, options, onData) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `
        SELECT json_agg(
            json_build_object(
                'id', null,
                'name', (rel."name"):: text,
            'location', (rel."location"):: text,
                'lastUpdateUtc', (rel."updatedAt"):: text,
                    'deviceName', (dev."name"):: text,
                        'accessControlPointName', (accessPoints."name"):: text,
                            'driveDuration', (rel."driveDuration"):: text,
                                'direction', (rel."direction"):: integer,
                                    'number', (rel."number"):: integer
                )) as "data"
        FROM "${organizationId}"."deviceRelays" rel
        INNER JOIN "${organizationId}"."devices" dev ON rel."deviceId" = dev."id" AND dev."deletedAt" IS NULL
        INNER JOIN "${organizationId}"."accessControlPoints" accessPoints ON rel."accessControlPointId" = accessPoints."id" AND accessPoints."deletedAt" IS NULL
        WHERE rel."deletedAt" IS NULL and
            `;
        query += `
        dev."organizationId" = $${queryParamIndex++} and
        dev."brand" = ANY ($${queryParamIndex++}::int[]) and
        dev."model"  = ANY ($${queryParamIndex++}::text[])
        `;
        queryParams.push(organizationId);
        queryParams.push([dal_constants_1.DalConstants.DeviceBrand.Armon, dal_constants_1.DalConstants.DeviceBrand.AssaAbloy, dal_constants_1.DalConstants.DeviceBrand.HikVision]);
        queryParams.push(dal_constants_1.DalConstants.terminalModels);
        if (options.name) {
            query += `
        and dev."name" ilike $${queryParamIndex++}
        `;
            queryParams.push("%" + options.name.toUpperCase() + "%");
        }
        if (options.brand) {
            query += `
        and dev."brand" = $${queryParamIndex++}
        `;
            queryParams.push(options.brand);
        }
        if (options.model) {
            query += `
        and dev."model" = $${queryParamIndex++}
        `;
            queryParams.push(options.model);
        }
        if (options.deviceIds && options.deviceIds.length > 0) {
            query += `
        and dev."id" in ($${queryParamIndex++})
        `;
            queryParams.push(options.deviceIds.join(","));
        }
        if (options.warningLevel) {
            query += `
        and dev."health":: text ilike '%"level":${options.warningLevel}%'
            `;
        }
        if (options.connectionStatus && options.connectionStatus != dal_constants_1.DalConstants.TerminalConnectionStatus.All) {
            if (options.connectionStatus == dal_constants_1.DalConstants.TerminalConnectionStatus.Connected) {
                query += `
        and dev."health" ->> 'isConnected' = 'true'
            `;
            }
            else {
                query += `
        and dev."health" ->> 'isConnected' = 'false'
            `;
            }
        }
        const client = await this._pgPool.connect();
        const cursor = client.query(new Cursor(query, queryParams));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, (err, rows) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(rows);
                        }
                    });
                });
                await onData(rows[0].data);
            }
            catch (error) {
                app_logs_1.logger.error(error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            client.release();
        }
        catch (error) {
            client?.release(error);
            app_logs_1.logger.error(error);
        }
    }
    async getAdministratorsOfTerminals(organizationId, terminalIds) {
        let queryParams = [];
        let queryParamsIndex = 1;
        let query = ` 
            SELECT id, "userId", read, write, notify FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}"
            WHERE "terminalId" = ANY($${queryParamsIndex++}::uuid[])
        `;
        queryParams.push(terminalIds);
        const { rows, rowCount } = await this._pgPool.query(query, queryParams);
        if (rowCount == 0) {
            return [];
        }
        return rows.map((item) => item.userId);
    }
    async getTerminalAdministrators(organizationId, terminalId, pagination) {
        let queryParams = [];
        let queryParamsIndex = 1;
        let query = ` 
            SELECT id, "userId", read, write, notify FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}"
            WHERE "terminalId" = $${queryParamsIndex++}
        `;
        queryParams.push(terminalId);
        const total = parseInt((await this._pgPool.query("SELECT COUNT(*) FROM (" + query + ")q1", queryParams)).rows[0].count);
        if (pagination) {
            query += `
            OFFSET $${queryParamsIndex++}
            LIMIT $${queryParamsIndex++}`;
            queryParams.push(pagination.skip, pagination.take);
        }
        const { rows, rowCount } = await this._pgPool.query(query, queryParams);
        if (rowCount == 0) {
            return {
                pagination: {
                    total: total,
                    skip: pagination ? pagination.skip : undefined,
                    take: pagination ? pagination.take : undefined,
                },
                items: [],
            };
        }
        const userCaptionList = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(organizationId, rows.map((r) => r.userId));
        return {
            pagination: {
                total: total,
                skip: pagination ? pagination.skip : undefined,
                take: pagination ? pagination.take : undefined,
            },
            items: rows.map((item) => {
                return {
                    userTerminalRightId: item.id,
                    userId: item.userId,
                    userCaptions: userCaptionList.find((uc) => uc.id === item.userId)?.captionLines,
                    userRights: {
                        read: item.read,
                        write: item.write,
                        notify: item.notify,
                    },
                };
            }),
        };
    }
    async upsertTerminalAdministrator(organizationId, requestUserId, terminalId, upsertUserRights) {
        const userTerminalRightId = uuid.v4();
        try {
            return await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
                let writeUsers = (await trx.query(`
                SELECT array_agg("userId") as users FROM "${organizationId}"."terminalAdministrators" WHERE "terminalId" = $1 AND write`, [terminalId])).rows[0].users;
                if (!writeUsers || writeUsers.length === 0) {
                    if (requestUserId !== upsertUserRights.userId) {
                        await trx.query(` 
                        INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" as ta
                        ("id", "terminalId", "userId", read, write, notify)
                        VALUES ($1, $2, $3, $4, $5, $6)
                        ON CONFLICT ON CONSTRAINT "terminalAdministrators_terminalId_userId_key" DO UPDATE
                        SET read = $4, write = $5, notify = $6
                        WHERE ta."terminalId" = $2
                        AND ta."userId" = $3
                        `, [uuid.v4(), terminalId, requestUserId, true, true, true]);
                    }
                    else {
                        upsertUserRights.userRights.write = true;
                    }
                }
                if (writeUsers && writeUsers.length === 1 && writeUsers.includes(upsertUserRights.userId) && !upsertUserRights.userRights.write) {
                    (0, dal_access_error_1.throwDbAccessBadRequestError)(`Cannot remove write privilege from the last user with write privilege`);
                }
                const { rows } = await trx.query(` 
                INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}" as ta
                ("id", "terminalId", "userId", read, write, notify)
                VALUES ($1, $2, $3, $4, $5, $6)
                ON CONFLICT ON CONSTRAINT "terminalAdministrators_terminalId_userId_key" DO UPDATE
                SET read = $4, write = $5, notify = $6
                WHERE ta."terminalId" = $2
                AND ta."userId" = $3
                `, [userTerminalRightId, terminalId, upsertUserRights.userId, upsertUserRights.userRights.read, upsertUserRights.userRights.write, upsertUserRights.userRights.notify]);
                return {
                    userTerminalRightId: userTerminalRightId,
                    userId: upsertUserRights.userId,
                    userRights: upsertUserRights.userRights,
                    userCaptions: await dal_manager_1.dbManager.accessUser.getSingleUserOrganizationCaptionLines(organizationId, upsertUserRights.userId),
                };
            });
        }
        catch (error) {
            throw error;
        }
    }
    async removeTerminalAdministrator(organizationId, userTerminalRightId) {
        try {
            return await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
                let users = (await trx.query(`
                SELECT 
                array_agg("userId") FILTER (WHERE write) as writers,
                array_agg("userId") FILTER (WHERE NOT write) as readers
                FROM "${organizationId}"."terminalAdministrators" WHERE "terminalId" = (
                    SELECT "terminalId" FROM "${organizationId}"."terminalAdministrators" WHERE id = $1
                ) GROUP BY "terminalId"
                `, [userTerminalRightId])).rows[0];
                let deletingRow = (await trx.query(`SELECT "userId" FROM "${organizationId}"."terminalAdministrators" WHERE id = $1`, [userTerminalRightId])).rows[0];
                if (users && users.writers && users.readers && deletingRow && users.writers.length === 1 && users.writers[0] === deletingRow.userId && users.readers.length > 0) {
                    (0, dal_access_error_1.throwDbAccessBadRequestError)(`Cannot delete this user because remaining users only have read rights.`);
                }
                await trx.query(`
                    DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalAdministrators}"
                    WHERE id = $1
                `, [userTerminalRightId]);
            });
        }
        catch (error) {
            throw error;
        }
    }
    async setEmergencyForDevices(params) {
        const trxx = params.trx ?? this._pgPool;
        const deviceHealts = await this.getDeviceHealths({ organizationId: params.organizationId, deviceIds: params.deviceIds, trx: params.trx });
        deviceHealts.forEach((device) => {
            device.deviceHealth.emergencyStatus = params.emergency;
        });
        let qb = "";
        for (const deviceId of params.deviceIds) {
            qb += `
                WHEN '${deviceId}' THEN CAST('${JSON.stringify(deviceHealts.find((i) => i.deviceId === deviceId).deviceHealth)}' AS JSON)`;
        }
        const query = `UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.devices} 
        	SET health = CASE id
			${qb}
			END
			WHERE id = ANY($1::uuid[])`;
        await trxx.query(query, [params.deviceIds]);
    }
    async insertDeadLetterOfflineLog(params) {
        await params.trx.query(`INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.unhandledDeviceLogs}"
		(id, "deviceId", "createdT", type, log)
		VALUES ($1, $2, $3, $4, $5)`, [uuid.v4(), params.deviceId, new Date(), null, params.data]);
    }
    async deleteDeadLetterOfflineLog(params) {
        await params.trx.query(`
			DELETE FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.unhandledDeviceLogs}"
			WHERE id = $1`, [params.logId]);
    }
    async listTerminalCameras(params) {
        const { rows } = await (params.trx ?? this._pgPool).query(`
			SELECT c.id as "cameraId", c."proxyTerminalId" as "terminalId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}" c
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d
			ON d.id = c."proxyTerminalId"
			WHERE (d.health->>'isConnected')::boolean = TRUE
		`);
        return rows;
    }
    async getProxyTerminalIdCamera(params) {
        const { rows } = await (params.trx ?? this._pgPool).query(`
			SELECT "proxyTerminalId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}"
			WHERE id = $1
		`, [params.cameraId]);
        return rows.map((row) => row.id);
    }
    async getDeviceStatePersistentData(params) {
        const { rows, rowCount } = await (params.trx ?? this._pgPool).query(`
			SELECT health->'isConnected' as i, health->'warnings' as w, array_agg(ca.id) as "c"
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d
			LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}" ca
			ON ca."proxyTerminalId" = d.id
			WHERE d.id = $1
			AND d."deletedAt" IS NULL
			GROUP BY d.id, d.health->>'isConnected', d.health->>'warnings'`, [params.deviceId]);
        return rowCount > 0 ? rows[0] : null;
    }
    async getDeviceNotificationInfoPersistentData(params) {
        const { rows, rowCount } = await (params.trx ?? this._pgPool).query(`
			SELECT brand as b, model as m, name as n, location as l FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
			WHERE id = $1
			AND "deletedAt" IS NULL`, [params.deviceId]);
        return rowCount > 0 ? rows[0] : null;
    }
    async getAllDeviceStateRedisPersistentData(params) {
        const query = `SELECT d.id, d.health->'isConnected' as i, d.health->'warnings' as w, array_agg(c.id) as "cameraId"
		FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d
		LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}" c
		ON c."proxyTerminalId" = d.id
		AND d."deletedAt" IS NULL
		GROUP BY d.id, d.health->>'isConnected', d.health->>'warnings'
		`;
        const trxx = params.trx ?? (await this._pgPool.connect());
        const cursor = trxx.query(new Cursor(query));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, r) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(r);
                        }
                    });
                });
                await params.onData(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetching device state cache data with cursor!", error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            if (!params.trx) {
                trxx.release();
            }
        }
        catch (error) {
            if (!params.trx) {
                trxx?.release(error);
            }
            app_logs_1.logger.error(error);
        }
    }
    async getAllDeviceNotificationInfoRedisPersistentData(params) {
        const query = `SELECT brand as b, model as m FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
		WHERE "deletedAt" IS NULL`;
        const trxx = params.trx ?? (await this._pgPool.connect());
        const cursor = trxx.query(new Cursor(query));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, r) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(r);
                        }
                    });
                });
                await params.onData(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetching device notification cache data with cursor!", error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            if (!params.trx) {
                trxx.release();
            }
        }
        catch (error) {
            if (!params.trx) {
                trxx?.release(error);
            }
            app_logs_1.logger.error(error);
        }
    }
    async getAllCameraProxyTerminalsRedisPersistentData(params) {
        const query = `
		SELECT c.id as "c", c."proxyTerminalId" as "t" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}" c
		INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d
		ON d.id = c."proxyTerminalId"
		WHERE (d.health->>'isConnected')::boolean = TRUE
		AND d."deletedAt" IS NULL
		AND c."deletedAt" IS NULL
	`;
        const trxx = params.trx ?? (await this._pgPool.connect());
        const cursor = trxx.query(new Cursor(query));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, r) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(r);
                        }
                    });
                });
                await params.onData(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetching cameraproxyterminal cache data with cursor!", error);
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            if (!params.trx) {
                trxx.release();
            }
        }
        catch (error) {
            if (!params.trx) {
                trxx?.release(error);
            }
            app_logs_1.logger.error(error);
        }
    }
    async getRegionIdNamePairsForDeviceEmergency(params) {
        const dbResult = (await params.trx.query(`
			SELECT r.id, r.name
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regions}" AS r
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp
				ON r.id = racp."regionId"
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp
				ON acp.id = racp."accessControlPointId"
			WHERE acp."deletedAt" IS NULL
				AND acp."deviceId" = $1
				AND r."deliverDeviceEmergencyToRegionDevices" = TRUE
			GROUP BY r.id, r.name
		`, [params.deviceId])).rows;
        return dbResult.map((r) => {
            return {
                regionId: r.id,
                regionName: r.name,
            };
        });
    }
    async listTerminalChanges(params) {
        let qb = [];
        let queryParamIndex = 1;
        const userFilter = (0, dal_access_psql_common_1.getReportUserFilterForPgClient)({
            organizationId: params.organizationId,
            requesterUserId: params.requesterUserId,
            idBasedUserFilter: {
                userIds: null,
                applyOrganizationUnitFilterHierarchically: true,
                userOrganizationStatus: dal_constants_1.DalConstants.IdentityStatusType.All,
            },
            requiredOrganizationUnitWidePermissions: ["i:b"],
            requiredOrganizationWidePermissions: ["i:b"],
            bindingKeys: [],
            specificSelectItems: ["userId"],
        });
        queryParamIndex += userFilter.bindingKeys.length;
        const qfrom = `
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}" tc
			LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationCredentials}" uoc
				ON tc."type" = 2 
				AND uoc."id" = CAST(tc."data"->>'id' AS uuid)
			LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
				ON tc."type" = 8
				AND uar."id" = CAST(tc."data"->>'id' AS uuid)
			INNER JOIN (${userFilter.query}) uf
				ON (
					(tc."type" = 2 AND uf."userId" = uoc."userId") OR
					(tc."type" = 8 AND uf."userId" = uar."userId") OR
					(tc."type" = 5 AND uf."userId" = CAST(tc."data"->>'user.id' AS uuid)) OR
					(tc."type" IN (1, 7, 10, 13) AND uf."userId" = CAST(tc."data"->>'userId' AS uuid)) OR
					(tc."type" IN (6, 9, 17, 18) AND uf."userId" = CAST(tc."data"->>'id' AS uuid))
				)
			WHERE tc."deviceId" = $${queryParamIndex}
		`;
        qb = [...qb, ...userFilter.bindingKeys];
        qb.push(params.terminalId);
        const totalCount = await params.trx.query(`
				SELECT count(*)::SMALLINT as c 
				FROM (
					(SELECT 1
					FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}" tc
					WHERE tc."type" NOT IN (1, 2, 5, 6, 7, 8, 9, 10, 13, 17, 18)
					AND tc."deviceId" = $${queryParamIndex})

					UNION ALL

					(SELECT 1
					${qfrom})
				) AS count_union
			`, qb);
        const result = {
            pagination: {
                total: totalCount.rowCount > 0 ? totalCount.rows[0].c : 0,
                skip: params.pagination?.skip ?? 0,
                take: params.pagination?.take ?? 200,
            },
            items: [],
        };
        let q = `
			(SELECT tc.id, tc."actionT"::text as "actionDate", tc.type, tc.data 
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}" tc
			WHERE tc."type" NOT IN (1, 2, 5, 6, 7, 8, 9, 10, 13, 17, 18)
			AND tc."deviceId" = $${queryParamIndex++})

			UNION ALL	

			(SELECT tc.id, tc."actionT"::text as "actionDate", tc.type, tc.data ${qfrom})
			ORDER BY "actionDate" DESC
			OFFSET $${queryParamIndex++}
			LIMIT $${queryParamIndex}
		`;
        qb.push(params.pagination?.skip ?? 0, params.pagination?.take ?? 200);
        const { rows } = await params.trx.query(q, qb);
        for (const row of rows) {
            switch (row.type) {
                case enums_1.EnumsV2.DeviceChangeItemType.AddCredential: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.userId, trx: params.trx })).caption,
                            data: data.data,
                            type: data.type,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RemoveCredential: {
                    const data = row.data;
                    delete row.data;
                    const credentialDetails = await dal_manager_1.dbManager.accessIdentity.getCredentialDetails({ organizationId: params.organizationId, credentialId: data.id, trx: params.trx });
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: credentialDetails.userId, trx: params.trx })).caption,
                            data: credentialDetails.data,
                            type: credentialDetails.type,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.AddUser: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.user.id, trx: params.trx })).caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RemoveUser: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.id, trx: params.trx })).caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.AddAccessRight: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            accessPointName: (await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointBasic(params.organizationId, data.accessControlPointId)).name,
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.userId, trx: params.trx })).caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RemoveAccessRight: {
                    const data = row.data;
                    delete row.data;
                    const accessRight = await dal_manager_1.dbManager.accessIdentity.getUserAccessRight({ organizationId: params.organizationId, accessRightId: data.id, trx: params.trx });
                    const [accessPoint, userBadge] = await Promise.all([
                        dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: accessRight.accessPointId, trx: params.trx }),
                        dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: accessRight.userId, trx: params.trx }),
                    ]);
                    result.items.push({
                        ...row,
                        data: {
                            accessPointName: accessPoint.n,
                            user: userBadge.caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.UserInfo: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.id, trx: params.trx })).caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RegionState: {
                    const data = row.data;
                    delete row.data;
                    const [userBadge, region] = await Promise.all([
                        dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.userId, trx: params.trx }),
                        dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: data.regionId, trx: params.trx }),
                    ]);
                    result.items.push({
                        ...row,
                        data: {
                            user: userBadge.caption,
                            regionName: region.n,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.UserGroupUsers: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            groupName: (await dal_manager_1.dbManager.accessUserGroup.getIdNamePairsOfUserGroups(params.organizationId, [data.userGroupId]))[0]?.name,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RegionTicketUsed: {
                    const data = row.data;
                    delete row.data;
                    result.items.push({
                        ...row,
                        data: {
                            user: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.userId, trx: params.trx })).caption,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.UserForbiddenAdd: {
                    const data = row.data;
                    delete row.data;
                    const [userBadge, region] = await Promise.all([
                        dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.id, trx: params.trx }),
                        dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: data.regionId, trx: params.trx }),
                    ]);
                    result.items.push({
                        ...row,
                        data: {
                            user: userBadge.caption,
                            regionName: region.n,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.UserForbiddenRemoved: {
                    const data = row.data;
                    delete row.data;
                    const forbidden = await dal_manager_1.dbManager.accessIdentity.getForbiddenStatusFromHistory({
                        organizationId: params.organizationId,
                        forbidId: data.id,
                        includeDeleted: true,
                        trx: params.trx,
                    });
                    const [userBadge, region] = await Promise.all([
                        dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: params.organizationId, userId: data.id, trx: params.trx }),
                        dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: forbidden.regionId, trx: params.trx }),
                    ]);
                    result.items.push({
                        ...row,
                        data: {
                            user: userBadge.caption,
                            regionName: region.n,
                        },
                    });
                    break;
                }
                case enums_1.EnumsV2.DeviceChangeItemType.RegionMaxEntranceCountRuleState:
                case enums_1.EnumsV2.DeviceChangeItemType.RegionTicketBalance:
                case enums_1.EnumsV2.DeviceChangeItemType.ConfigChanged:
                case enums_1.EnumsV2.DeviceChangeItemType.SettingChanged:
                case enums_1.EnumsV2.DeviceChangeItemType.UpsertAccessNotification:
                case enums_1.EnumsV2.DeviceChangeItemType.RemoveAccessNotification:
                case enums_1.EnumsV2.DeviceChangeItemType.UpdateCredential:
                case enums_1.EnumsV2.DeviceChangeItemType.AccessCapacityBasedRuleApplied:
                default:
                    const { data, ...rest } = row;
                    result.items.push(rest);
                    break;
            }
        }
        return result;
    }
    async getOfflineTerminals(params) {
        const { rows, rowCount } = await params.trx.query(`
			SELECT DISTINCT(d.id), d.name
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.terminalChanges}" tc
			JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d
				ON tc."deviceId" = d.id
			WHERE tc."transactionId" = $1
			AND tc."actionT" = $2
		`, [params.transaction.id, params.transaction.actionT]);
        return rowCount > 0 ? rows : [];
    }
    async checkDeviceOrganizationMappings(organizationId, deviceIds, trx) {
        const result = [];
        const conflictingDeviceRows = await trx
            .withSchema("public")
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.things)
            .whereNot("organizationId", organizationId)
            .whereIn("id", deviceIds)
            .select("id", "organizationId");
        if (conflictingDeviceRows.length) {
            const uniqueOrganizationIds = lodash_1.default.uniq(conflictingDeviceRows.map((m) => m.organizationId));
            for (const oid of uniqueOrganizationIds) {
                const conflictingOrganizationDeviceIds = conflictingDeviceRows.filter((f) => f.organizationId === oid).map((m) => m.id);
                const organizationName = (await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(oid)).name;
                const conflictingDeviceInfoRows = await trx
                    .withSchema(oid)
                    .table(dal_db_armon_schema_1.ArmonSchema.tableNames.devices)
                    .whereIn("id", conflictingOrganizationDeviceIds)
                    .whereNull("deletedAt")
                    .select("id", "name", "serialNumber");
                for (const d of conflictingDeviceInfoRows) {
                    result.push({
                        deviceId: d.id,
                        deviceName: d.name,
                        deviceSerialNumber: d.serialNumber,
                        organizationName,
                    });
                }
            }
        }
        return result;
    }
    async updateDeviceSoftwareUpdateInterfaceState(organizationId, params, trx) {
        await trx.query(`
			UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
				SET "softwareUpdateInterfaceState" = $2
				WHERE id = $1
		`, [params.deviceId, params.state]);
    }
    async updateServerConnectionState(organizationId, params, trx) {
        await trx.query(`
			UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}"
				SET "serverConnectionState" = $2
				WHERE id = $1
		`, [params.deviceId, params.command]);
    }
    async listPendingTabletApprovements(organizaitonId, params, trx) {
        const qParams = [];
        let fromQ = `
			FROM "${organizaitonId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.CheckInTablet}"
			WHERE ${params.status === restapi_1.TabletApprovementStatus.All ? " TRUE " : params.status === restapi_1.TabletApprovementStatus.Approved ? ` "isApproved" IS TRUE ` : ` "isApproved" IS FALSE `}
		`;
        if (params.filter) {
            qParams.push("%" + params.filter + "%");
            fromQ += `
			AND "referenceCode" ILIKE $${qParams.length}
			`;
        }
        const total = (await trx.query(`
			SELECT count(*)::integer AS c
			${fromQ}
			`, qParams)).rows[0].c;
        let q = `
			SELECT id, "referenceCode", "creationT", name, "publicKey", "isApproved"
			${fromQ}
			ORDER BY "referenceCode" ASC
		`;
        qParams.push(params.pagination.skip);
        q += `
			OFFSET $${qParams.length}`;
        qParams.push(params.pagination.take);
        q += `
			LIMIT $${qParams.length}`;
        const dbResult = await trx.query(q, qParams);
        return {
            total,
            items: dbResult.rows,
        };
    }
    async approveTablet(organizationId, params, trx) {
        const checkTabletDbResult = await trx.query(`
			SELECT "approvementCode", "isApproved"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.CheckInTablet}"
			WHERE id = $1
				AND "referenceCode" = $2
			`, [params.id, params.referenceCode]);
        if (checkTabletDbResult.rowCount) {
            if (checkTabletDbResult.rows[0].approvementCode === params.approvementCode) {
                await trx.query(`
					UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.CheckInTablet}"
					SET "isApproved" = TRUE
					WHERE id = $1
					`, [params.id]);
                return {
                    success: true,
                };
            }
            else {
                return {
                    success: false,
                    errorCode: dal_access_error_1.DbAccessErrorCode.CONFLICT,
                    errorReason: "ERRORS.DEVICE.TABLET_APPROVEMENT_CODE_MISMATCH",
                };
            }
        }
        else {
            return {
                success: false,
                errorCode: dal_access_error_1.DbAccessErrorCode.NOT_FOUND,
                errorReason: "ERRORS.DEVICE.TABLET_NOT_FOUND",
            };
        }
    }
}
exports.PSQLDalAccessDevice = PSQLDalAccessDevice;
