"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const joi_1 = __importDefault(require("joi"));
const app_logs_1 = require("../../app.logs");
const utils_1 = require("../../lib/v8/utils");
const tabletConfigFileSchema = joi_1.default.object({
    ...utils_1.baseConfigJoi,
    ...{
        TABLET_HTTP_PORT: joi_1.default.number().integer().default(8444),
        HTTP_PROTOCOL: joi_1.default.string().optional().default("http").valid("http", "https"),
    },
});
class TabletConfig {
    constructor() {
        if (process.env.PGPASSWORD && process.env.PGHOST && process.env.PGPORT && process.env.PGPASSWORD && process.env.PGUSER && process.env.PGDATABASE) {
            app_logs_1.logger.info("PG Environments variables are all set including PGPASSWORD. Ignore PGPASSFILE");
        }
        else {
            app_logs_1.logger.info("PG Environments variables does not contain PGPASSWORD. Seek for PGPASSFILE");
            (0, utils_1.validatePgPassFile)(process.env.PGPASSFILE);
        }
        const validation = tabletConfigFileSchema.validate(process.env, {
            allowUnknown: true,
        });
        if (validation.error) {
            throw validation.error;
        }
        const data = validation.value;
        Object.assign(this, data);
    }
}
const tabletServiceConfig = new TabletConfig();
exports.default = tabletServiceConfig;
