"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorCodes = exports.TabletCardReadRequestJoiValidation = exports.TabletACPListRequestJoiValidation = exports.TabletCheckApprovementRequestJoiValidation = exports.TabletRegisterRequestJoiValidation = void 0;
const app_enums_1 = require("../../app.enums");
const joi_1 = __importDefault(require("joi"));
exports.TabletRegisterRequestJoiValidation = joi_1.default.object({
    approvementCode: joi_1.default.string().required().length(6),
    id: joi_1.default.string().uuid().required(),
    orgShortCode: joi_1.default.string().required(),
    publicKey: joi_1.default.string().base64().required(),
    referenceCode: joi_1.default.string().alphanum().length(5),
});
exports.TabletCheckApprovementRequestJoiValidation = joi_1.default.object({
    id: joi_1.default.string().uuid().required(),
    orgShortCode: joi_1.default.string().required(),
});
exports.TabletACPListRequestJoiValidation = joi_1.default.object({
    pagination: joi_1.default.object({
        skip: joi_1.default.number().min(0).required(),
        take: joi_1.default.number().min(0).required(),
    }).required(),
});
exports.TabletCardReadRequestJoiValidation = joi_1.default.object({
    cardData: joi_1.default.string().required(),
    accessControlPointId: joi_1.default.string().uuid().required(),
    direction: joi_1.default.number().valid(app_enums_1.enums.AccessDirection.All, app_enums_1.enums.AccessDirection.Entrance, app_enums_1.enums.AccessDirection.Exit).required(),
    location: joi_1.default.object({
        isReliable: joi_1.default.boolean().required(),
        latitude: joi_1.default.number().required(),
        longitude: joi_1.default.number().required(),
    }).optional(),
});
var ErrorCodes;
(function (ErrorCodes) {
    ErrorCodes[ErrorCodes["ORGANIZATION_NOT_FOUND"] = 8888] = "ORGANIZATION_NOT_FOUND";
    ErrorCodes[ErrorCodes["TABLET_INFO_DUPLICATE"] = 8887] = "TABLET_INFO_DUPLICATE";
    ErrorCodes[ErrorCodes["TABLET_NOT_FOUND"] = 8886] = "TABLET_NOT_FOUND";
    ErrorCodes[ErrorCodes["TABLET_NOT_APPROVED_YET"] = 8885] = "TABLET_NOT_APPROVED_YET";
    ErrorCodes[ErrorCodes["TABLET_SIGNATURE_MISMATCH"] = 8884] = "TABLET_SIGNATURE_MISMATCH";
    ErrorCodes[ErrorCodes["USER_NOT_FOUND"] = 8883] = "USER_NOT_FOUND";
    ErrorCodes[ErrorCodes["REQUEST_TIME_MISMATCH"] = 8882] = "REQUEST_TIME_MISMATCH";
})(ErrorCodes = exports.ErrorCodes || (exports.ErrorCodes = {}));
